/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.camel.CamelContext;
import org.apache.camel.DelegateEndpoint;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.Route;
import org.apache.camel.spi.BrowsableEndpoint;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.JsonSchemaHelper;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EndpointHelper {
    private static final Logger LOG = LoggerFactory.getLogger(EndpointHelper.class);
    private static final AtomicLong ENDPOINT_COUNTER = new AtomicLong(0L);
    private static final Pattern SYNTAX_PATTERN = Pattern.compile("(\\w+)");

    private EndpointHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pollEndpoint(Endpoint endpoint, Processor processor, long timeout) throws Exception {
        PollingConsumer consumer = endpoint.createPollingConsumer();
        try {
            Exchange exchange;
            consumer.start();
            while ((exchange = consumer.receive(timeout)) != null) {
                processor.process(exchange);
            }
        }
        finally {
            try {
                consumer.stop();
            }
            catch (Exception e) {
                LOG.warn("Failed to stop PollingConsumer: " + e, (Throwable)e);
            }
        }
    }

    public static void pollEndpoint(Endpoint endpoint, Processor processor) throws Exception {
        EndpointHelper.pollEndpoint(endpoint, processor, 1000L);
    }

    public static boolean matchEndpoint(CamelContext context, String uri, String pattern) {
        if (context != null) {
            try {
                uri = context.resolvePropertyPlaceholders(uri);
            }
            catch (Exception e) {
                throw new ResolveEndpointFailedException(uri, e);
            }
        }
        try {
            uri = URISupport.normalizeUri(uri);
        }
        catch (Exception e) {
            throw new ResolveEndpointFailedException(uri, e);
        }
        if (uri.contains("://")) {
            String scheme = ObjectHelper.before(uri, "://");
            String path = ObjectHelper.after(uri, "://");
            if (EndpointHelper.matchPattern(scheme + ":" + path, pattern)) {
                return true;
            }
        } else {
            String scheme = ObjectHelper.before(uri, ":");
            String path = ObjectHelper.after(uri, ":");
            if (EndpointHelper.matchPattern(scheme + "://" + path, pattern)) {
                return true;
            }
        }
        return EndpointHelper.matchPattern(uri, pattern);
    }

    @Deprecated
    public static boolean matchEndpoint(String uri, String pattern) {
        return EndpointHelper.matchEndpoint(null, uri, pattern);
    }

    public static boolean matchPattern(String name, String pattern) {
        if (name == null || pattern == null) {
            return false;
        }
        if (name.equals(pattern)) {
            return true;
        }
        if (EndpointHelper.matchWildcard(name, pattern)) {
            return true;
        }
        return EndpointHelper.matchRegex(name, pattern);
    }

    private static boolean matchWildcard(String name, String pattern) {
        return pattern.endsWith("*") && name.startsWith(pattern.substring(0, pattern.length() - 1));
    }

    private static boolean matchRegex(String name, String pattern) {
        try {
            if (name.matches(pattern)) {
                return true;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return false;
    }

    public static void setProperties(CamelContext context, Object bean, Map<String, Object> parameters) throws Exception {
        IntrospectionSupport.setProperties(context.getTypeConverter(), bean, parameters);
    }

    public static void setReferenceProperties(CamelContext context, Object bean, Map<String, Object> parameters) throws Exception {
        Iterator<Map.Entry<String, Object>> it = parameters.entrySet().iterator();
        while (it.hasNext()) {
            boolean hit;
            Map.Entry<String, Object> entry = it.next();
            String name = entry.getKey();
            Object v = entry.getValue();
            String value = v != null ? v.toString() : null;
            if (value == null || !EndpointHelper.isReferenceParameter(value) || !(hit = IntrospectionSupport.setProperty(context, context.getTypeConverter(), bean, name, null, value, true))) continue;
            it.remove();
        }
    }

    public static boolean isReferenceParameter(String parameter) {
        return parameter != null && parameter.trim().startsWith("#");
    }

    public static <T> T resolveReferenceParameter(CamelContext context, String value, Class<T> type) {
        return EndpointHelper.resolveReferenceParameter(context, value, type, true);
    }

    public static <T> T resolveReferenceParameter(CamelContext context, String value, Class<T> type, boolean mandatory) {
        String valueNoHash = StringHelper.replaceAll(value, "#", "");
        if (mandatory) {
            return CamelContextHelper.mandatoryLookup(context, valueNoHash, type);
        }
        return CamelContextHelper.lookup(context, valueNoHash, type);
    }

    public static <T> List<T> resolveReferenceListParameter(CamelContext context, String value, Class<T> elementType) {
        if (value == null) {
            return Collections.emptyList();
        }
        List<String> elements = Arrays.asList(value.split(","));
        if (elements.size() == 1) {
            Object bean = EndpointHelper.resolveReferenceParameter(context, elements.get(0).trim(), Object.class);
            if (bean instanceof List) {
                return (List)bean;
            }
            return Arrays.asList(elementType.cast(bean));
        }
        ArrayList<T> result = new ArrayList<T>(elements.size());
        for (String element : elements) {
            result.add(EndpointHelper.resolveReferenceParameter(context, element.trim(), elementType));
        }
        return result;
    }

    public static <T> T resolveParameter(CamelContext context, String value, Class<T> type) {
        T result = EndpointHelper.isReferenceParameter(value) ? EndpointHelper.resolveReferenceParameter(context, value, type) : context.getTypeConverter().convertTo(type, value);
        return result;
    }

    @Deprecated
    public static <T> T resloveStringParameter(CamelContext context, String value, Class<T> type) {
        return EndpointHelper.resolveParameter(context, value, type);
    }

    public static String getRouteIdFromEndpoint(Endpoint endpoint) {
        if (endpoint == null || endpoint.getCamelContext() == null) {
            return null;
        }
        List<Route> routes = endpoint.getCamelContext().getRoutes();
        for (Route route : routes) {
            if (!route.getEndpoint().equals(endpoint) && !route.getEndpoint().getEndpointKey().equals(endpoint.getEndpointKey())) continue;
            return route.getId();
        }
        return null;
    }

    public static String createEndpointId() {
        return "endpoint" + ENDPOINT_COUNTER.incrementAndGet();
    }

    public static String lookupEndpointRegistryId(Endpoint endpoint) {
        if (endpoint == null || endpoint.getCamelContext() == null) {
            return null;
        }
        Endpoint delegate = null;
        if (endpoint instanceof DelegateEndpoint) {
            delegate = ((DelegateEndpoint)endpoint).getEndpoint();
        }
        Map<String, Endpoint> map = endpoint.getCamelContext().getRegistry().findByTypeWithName(Endpoint.class);
        for (Map.Entry<String, Endpoint> entry : map.entrySet()) {
            if (!entry.getValue().equals(endpoint) && !entry.getValue().equals(delegate)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static String browseRangeMessagesAsXml(BrowsableEndpoint endpoint, Integer fromIndex, Integer toIndex, Boolean includeBody) {
        if (fromIndex == null) {
            fromIndex = 0;
        }
        if (toIndex == null) {
            toIndex = Integer.MAX_VALUE;
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("From index cannot be larger than to index, was: " + fromIndex + " > " + toIndex);
        }
        List<Exchange> exchanges = endpoint.getExchanges();
        if (exchanges.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<messages>");
        for (int i = fromIndex.intValue(); i < exchanges.size() && i <= toIndex; ++i) {
            Exchange exchange = exchanges.get(i);
            Message msg = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
            String xml = MessageHelper.dumpAsXml(msg, includeBody);
            sb.append("\n").append(xml);
        }
        sb.append("\n</messages>");
        return sb.toString();
    }

    public static ExchangePattern resolveExchangePatternFromUrl(String url) throws URISyntaxException {
        Map<String, Object> parameters;
        String pattern;
        int idx = url.indexOf("?");
        if (idx > 0) {
            url = url.substring(idx + 1);
        }
        if ((pattern = (String)(parameters = URISupport.parseQuery(url, true)).get("exchangePattern")) != null) {
            return ExchangePattern.asEnum(pattern);
        }
        return null;
    }

    public static Map<String, Object> endpointProperties(CamelContext camelContext, String uri) throws Exception {
        URI u = new URI(uri);
        String scheme = u.getScheme();
        String json = camelContext.getComponentParameterJsonSchema(u.getScheme());
        if (json == null) {
            throw new IllegalArgumentException("Cannot find endpoint with scheme " + scheme);
        }
        String syntax = null;
        List<Map<String, String>> rows = JsonSchemaHelper.parseJsonSchema("component", json, false);
        for (Map<String, String> row : rows) {
            if (!row.containsKey("syntax")) continue;
            syntax = row.get("syntax");
            break;
        }
        if (syntax == null) {
            throw new IllegalArgumentException("Endpoint with scheme " + scheme + " has no syntax defined in the json schema");
        }
        Matcher matcher = SYNTAX_PATTERN.matcher(syntax);
        ArrayList<String> word = new ArrayList<String>();
        while (matcher.find()) {
            String s = matcher.group(1);
            if (scheme.equals(s)) continue;
            word.add(s);
        }
        String uriPath = EndpointHelper.stripQuery(uri);
        ArrayList<String> word2 = new ArrayList<String>();
        if (word.size() == 1) {
            String s = uriPath;
            s = URISupport.stripPrefix(s, scheme);
            while (s.startsWith(":") || s.startsWith("/")) {
                s = s.substring(1);
            }
            word2.add(s);
        } else {
            Matcher matcher2 = SYNTAX_PATTERN.matcher(uriPath);
            while (matcher2.find()) {
                String s = matcher2.group(1);
                if (scheme.equals(s)) continue;
                word2.add(s);
            }
        }
        rows = JsonSchemaHelper.parseJsonSchema("properties", json, true);
        boolean defaultValueAdded = false;
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        Iterator it = word2.iterator();
        for (int i = 0; i < word.size(); ++i) {
            String value;
            String key = (String)word.get(i);
            boolean allOptions = word.size() == word2.size();
            boolean required = JsonSchemaHelper.isPropertyRequired(rows, key);
            String defaultValue = JsonSchemaHelper.getPropertyDefaultValue(rows, key);
            if (allOptions) {
                value = (String)it.next();
                options.put(key, value);
                continue;
            }
            if (!required) {
                value = defaultValue;
                options.put(key, value);
                defaultValueAdded = true;
                continue;
            }
            value = (String)it.next();
            options.put(key, value);
        }
        LinkedHashMap<String, Object> answer = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : options.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (defaultValueAdded) {
                boolean required = JsonSchemaHelper.isPropertyRequired(rows, key);
                String defaultValue = JsonSchemaHelper.getPropertyDefaultValue(rows, key);
                if (!required && defaultValue != null && defaultValue.equals(value)) continue;
            }
            answer.put(key, value);
        }
        Map<String, Object> parameters = URISupport.parseParameters(u);
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue() != null ? entry.getValue().toString() : "";
            answer.put(key, value);
        }
        return answer;
    }

    private static String stripQuery(String uri) {
        int idx = uri.indexOf(63);
        if (idx > -1) {
            uri = uri.substring(0, idx);
        }
        return uri;
    }
}

