/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.qpid.proton.codec.Data;
import org.apache.qpid.proton.codec.impl.AbstractElement;
import org.apache.qpid.proton.codec.impl.ArrayElement;
import org.apache.qpid.proton.codec.impl.Element;

class ListElement
extends AbstractElement<List<Object>> {
    private Element _first;

    ListElement(Element parent, Element prev) {
        super(parent, prev);
    }

    public int count() {
        int count = 0;
        for (Element elt = this._first; elt != null; elt = elt.next()) {
            ++count;
        }
        return count;
    }

    @Override
    public int size() {
        int count = 0;
        int size = 0;
        for (Element elt = this._first; elt != null; elt = elt.next()) {
            ++count;
            size += elt.size();
        }
        if (this.isElementOfArray()) {
            ArrayElement parent = (ArrayElement)this.parent();
            if (parent.constructorType() == ArrayElement.TINY) {
                if (count != 0) {
                    parent.setConstructorType(ArrayElement.ConstructorType.SMALL);
                    size += 2;
                }
            } else if (parent.constructorType() == ArrayElement.SMALL) {
                if (count > 255 || size > 254) {
                    parent.setConstructorType(ArrayElement.ConstructorType.LARGE);
                    size += 8;
                } else {
                    size += 2;
                }
            }
            size += 8;
        } else {
            size = count == 0 ? 1 : (count <= 255 && size <= 254 ? (size += 3) : (size += 9));
        }
        return size;
    }

    @Override
    public List<Object> getValue() {
        ArrayList list = new ArrayList();
        for (Element elt = this._first; elt != null; elt = elt.next()) {
            list.add(elt.getValue());
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public Data.DataType getDataType() {
        return Data.DataType.LIST;
    }

    @Override
    public int encode(ByteBuffer b) {
        Element elt;
        int encodedSize = this.size();
        int count = 0;
        int size = 0;
        for (elt = this._first; elt != null; elt = elt.next()) {
            ++count;
            size += elt.size();
        }
        if (encodedSize > b.remaining()) {
            return 0;
        }
        if (this.isElementOfArray()) {
            switch (((ArrayElement)this.parent()).constructorType()) {
                case TINY: {
                    break;
                }
                case SMALL: {
                    b.put((byte)(size + 1));
                    b.put((byte)count);
                    break;
                }
                case LARGE: {
                    b.putInt(size + 4);
                    b.putInt(count);
                }
            }
        } else if (count == 0) {
            b.put((byte)69);
        } else if (size <= 254 && count <= 255) {
            b.put((byte)-64);
            b.put((byte)(size + 1));
            b.put((byte)count);
        } else {
            b.put((byte)-48);
            b.putInt(size + 4);
            b.putInt(count);
        }
        for (elt = this._first; elt != null; elt = elt.next()) {
            elt.encode(b);
        }
        return encodedSize;
    }

    @Override
    public boolean canEnter() {
        return true;
    }

    @Override
    public Element child() {
        return this._first;
    }

    @Override
    public void setChild(Element elt) {
        this._first = elt;
    }

    @Override
    public Element checkChild(Element element) {
        return element;
    }

    @Override
    public Element addChild(Element element) {
        this._first = element;
        return element;
    }

    @Override
    String startSymbol() {
        return "[";
    }

    @Override
    String stopSymbol() {
        return "]";
    }
}

