/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.util.Arrays;
import java.util.Collection;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.codec.AbstractPrimitiveType;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.LargeFloatingSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.PrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.SmallFloatingSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.TypeEncoding;

public class BinaryType
extends AbstractPrimitiveType<Binary> {
    private final BinaryEncoding _binaryEncoding;
    private final BinaryEncoding _shortBinaryEncoding;

    BinaryType(EncoderImpl encoder, DecoderImpl decoder) {
        this._binaryEncoding = new LongBinaryEncoding(encoder, decoder);
        this._shortBinaryEncoding = new ShortBinaryEncoding(encoder, decoder);
        encoder.register(Binary.class, this);
        decoder.register(this);
    }

    @Override
    public Class<Binary> getTypeClass() {
        return Binary.class;
    }

    public BinaryEncoding getEncoding(Binary val) {
        return val.getLength() <= 255 ? this._shortBinaryEncoding : this._binaryEncoding;
    }

    public BinaryEncoding getCanonicalEncoding() {
        return this._binaryEncoding;
    }

    @Override
    public Collection<BinaryEncoding> getAllEncodings() {
        return Arrays.asList(this._shortBinaryEncoding, this._binaryEncoding);
    }

    private class ShortBinaryEncoding
    extends SmallFloatingSizePrimitiveTypeEncoding<Binary>
    implements BinaryEncoding {
        public ShortBinaryEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        protected void writeEncodedValue(Binary val) {
            this.getEncoder().writeRaw(val.getArray(), val.getArrayOffset(), val.getLength());
        }

        @Override
        protected int getEncodedValueSize(Binary val) {
            return val.getLength();
        }

        @Override
        public byte getEncodingCode() {
            return -96;
        }

        public BinaryType getType() {
            return BinaryType.this;
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<Binary> encoder) {
            return encoder == this;
        }

        @Override
        public Binary readValue() {
            int size = this.getDecoder().readRawByte() & 0xFF;
            byte[] data = new byte[size];
            this.getDecoder().readRaw(data, 0, size);
            return new Binary(data);
        }
    }

    private class LongBinaryEncoding
    extends LargeFloatingSizePrimitiveTypeEncoding<Binary>
    implements BinaryEncoding {
        public LongBinaryEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        protected void writeEncodedValue(Binary val) {
            this.getEncoder().writeRaw(val.getArray(), val.getArrayOffset(), val.getLength());
        }

        @Override
        protected int getEncodedValueSize(Binary val) {
            return val.getLength();
        }

        @Override
        public byte getEncodingCode() {
            return -80;
        }

        public BinaryType getType() {
            return BinaryType.this;
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<Binary> encoding) {
            return this.getType() == encoding.getType();
        }

        @Override
        public Binary readValue() {
            int size = this.getDecoder().readRawInt();
            byte[] data = new byte[size];
            this.getDecoder().readRaw(data, 0, size);
            return new Binary(data);
        }
    }

    private static interface BinaryEncoding
    extends PrimitiveTypeEncoding<Binary> {
    }
}

