/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.connection;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.NamedThreadLocal;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class UserCredentialsConnectionFactoryAdapter
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
InitializingBean {
    private ConnectionFactory targetConnectionFactory;
    private String username;
    private String password;
    private final ThreadLocal<JmsUserCredentials> threadBoundCredentials = new NamedThreadLocal<JmsUserCredentials>("Current JMS user credentials");

    public void setTargetConnectionFactory(ConnectionFactory targetConnectionFactory) {
        Assert.notNull(targetConnectionFactory, "'targetConnectionFactory' must not be null");
        this.targetConnectionFactory = targetConnectionFactory;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.targetConnectionFactory == null) {
            throw new IllegalArgumentException("Property 'targetConnectionFactory' is required");
        }
    }

    public void setCredentialsForCurrentThread(String username, String password) {
        this.threadBoundCredentials.set(new JmsUserCredentials(username, password));
    }

    public void removeCredentialsFromCurrentThread() {
        this.threadBoundCredentials.remove();
    }

    @Override
    public final Connection createConnection() throws JMSException {
        JmsUserCredentials threadCredentials = this.threadBoundCredentials.get();
        if (threadCredentials != null) {
            return this.doCreateConnection(threadCredentials.username, threadCredentials.password);
        }
        return this.doCreateConnection(this.username, this.password);
    }

    @Override
    public Connection createConnection(String username, String password) throws JMSException {
        return this.doCreateConnection(username, password);
    }

    protected Connection doCreateConnection(String username, String password) throws JMSException {
        Assert.state(this.targetConnectionFactory != null, "'targetConnectionFactory' is required");
        if (StringUtils.hasLength(username)) {
            return this.targetConnectionFactory.createConnection(username, password);
        }
        return this.targetConnectionFactory.createConnection();
    }

    @Override
    public final QueueConnection createQueueConnection() throws JMSException {
        JmsUserCredentials threadCredentials = this.threadBoundCredentials.get();
        if (threadCredentials != null) {
            return this.doCreateQueueConnection(threadCredentials.username, threadCredentials.password);
        }
        return this.doCreateQueueConnection(this.username, this.password);
    }

    @Override
    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        return this.doCreateQueueConnection(username, password);
    }

    protected QueueConnection doCreateQueueConnection(String username, String password) throws JMSException {
        Assert.state(this.targetConnectionFactory != null, "'targetConnectionFactory' is required");
        if (!(this.targetConnectionFactory instanceof QueueConnectionFactory)) {
            throw new IllegalStateException("'targetConnectionFactory' is not a QueueConnectionFactory");
        }
        QueueConnectionFactory queueFactory = (QueueConnectionFactory)this.targetConnectionFactory;
        if (StringUtils.hasLength(username)) {
            return queueFactory.createQueueConnection(username, password);
        }
        return queueFactory.createQueueConnection();
    }

    @Override
    public final TopicConnection createTopicConnection() throws JMSException {
        JmsUserCredentials threadCredentials = this.threadBoundCredentials.get();
        if (threadCredentials != null) {
            return this.doCreateTopicConnection(threadCredentials.username, threadCredentials.password);
        }
        return this.doCreateTopicConnection(this.username, this.password);
    }

    @Override
    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        return this.doCreateTopicConnection(username, password);
    }

    protected TopicConnection doCreateTopicConnection(String username, String password) throws JMSException {
        Assert.state(this.targetConnectionFactory != null, "'targetConnectionFactory' is required");
        if (!(this.targetConnectionFactory instanceof TopicConnectionFactory)) {
            throw new IllegalStateException("'targetConnectionFactory' is not a TopicConnectionFactory");
        }
        TopicConnectionFactory queueFactory = (TopicConnectionFactory)this.targetConnectionFactory;
        if (StringUtils.hasLength(username)) {
            return queueFactory.createTopicConnection(username, password);
        }
        return queueFactory.createTopicConnection();
    }

    private static class JmsUserCredentials {
        public final String username;
        public final String password;

        private JmsUserCredentials(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String toString() {
            return "JmsUserCredentials[username='" + this.username + "',password='" + this.password + "']";
        }
    }
}

