/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.ws.jetty9;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.activemq.transport.TransportAcceptListener;
import org.apache.activemq.transport.TransportSupport;
import org.apache.activemq.transport.util.HttpTransportUtils;
import org.apache.activemq.transport.ws.AbstractMQTTSocket;
import org.apache.activemq.transport.ws.jetty9.MQTTSocket;
import org.apache.activemq.transport.ws.jetty9.StompSocket;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public class WSServlet
extends WebSocketServlet {
    private static final long serialVersionUID = -4716657876092884139L;
    private TransportAcceptListener listener;

    public void init() throws ServletException {
        super.init();
        this.listener = (TransportAcceptListener)this.getServletContext().getAttribute("acceptListener");
        if (this.listener == null) {
            throw new ServletException("No such attribute 'acceptListener' available in the ServletContext");
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.getServletContext().getNamedDispatcher("default").forward((ServletRequest)request, (ServletResponse)response);
    }

    public void configure(WebSocketServletFactory factory) {
        factory.setCreator(new WebSocketCreator(){

            public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
                TransportSupport socket;
                boolean isMqtt = false;
                for (String subProtocol : req.getSubProtocols()) {
                    if (!subProtocol.startsWith("mqtt")) continue;
                    isMqtt = true;
                }
                if (isMqtt) {
                    socket = new MQTTSocket(HttpTransportUtils.generateWsRemoteAddress(req.getHttpServletRequest()));
                    resp.setAcceptedSubProtocol("mqtt");
                    ((AbstractMQTTSocket)socket).setPeerCertificates(req.getCertificates());
                } else {
                    socket = new StompSocket(HttpTransportUtils.generateWsRemoteAddress(req.getHttpServletRequest()));
                    ((StompSocket)socket).setCertificates(req.getCertificates());
                    resp.setAcceptedSubProtocol("stomp");
                }
                WSServlet.this.listener.onAccept(socket);
                return socket;
            }
        });
    }
}

