# Volatility
# Copyright (c) 2008-2013 Volatility Foundation
# Copyright (c) 2011 Michael Hale Ligh <michael.hale@gmail.com>
#
# This file is part of Volatility.
#
# Volatility is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Volatility is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Volatility.  If not, see <http://www.gnu.org/licenses/>.
#

syscalls = [
    [
    'NtAcceptConnectPort', # 0x0
    'NtAccessCheck', # 0x1
    'NtAccessCheckAndAuditAlarm', # 0x2
    'NtAccessCheckByType', # 0x3
    'NtAccessCheckByTypeAndAuditAlarm', # 0x4
    'NtAccessCheckByTypeResultList', # 0x5
    'NtAccessCheckByTypeResultListAndAuditAlarm', # 0x6
    'NtAccessCheckByTypeResultListAndAuditAlarmByHandle', # 0x7
    'NtAddAtom', # 0x8
    'NtAddBootEntry', # 0x9
    'NtAdjustGroupsToken', # 0xa
    'NtAdjustPrivilegesToken', # 0xb
    'NtAlertResumeThread', # 0xc
    'NtAlertThread', # 0xd
    'NtAllocateLocallyUniqueId', # 0xe
    'NtAllocateUserPhysicalPages', # 0xf
    'NtAllocateUuids', # 0x10
    'NtAllocateVirtualMemory', # 0x11
    'NtAreMappedFilesTheSame', # 0x12
    'NtAssignProcessToJobObject', # 0x13
    'NtCallbackReturn', # 0x14
    'NtCancelDeviceWakeupRequest', # 0x15
    'NtCancelIoFile', # 0x16
    'NtCancelTimer', # 0x17
    'NtClearEvent', # 0x18
    'NtClose', # 0x19
    'NtCloseObjectAuditAlarm', # 0x1a
    'NtCompactKeys', # 0x1b
    'NtCompareTokens', # 0x1c
    'NtCompleteConnectPort', # 0x1d
    'NtCompressKey', # 0x1e
    'NtConnectPort', # 0x1f
    'NtContinue', # 0x20
    'NtCreateDebugObject', # 0x21
    'NtCreateDirectoryObject', # 0x22
    'NtCreateEvent', # 0x23
    'NtCreateEventPair', # 0x24
    'NtCreateFile', # 0x25
    'NtCreateIoCompletion', # 0x26
    'NtCreateJobObject', # 0x27
    'NtCreateJobSet', # 0x28
    'NtCreateKey', # 0x29
    'NtCreateMailslotFile', # 0x2a
    'NtCreateMutant', # 0x2b
    'NtCreateNamedPipeFile', # 0x2c
    'NtCreatePagingFile', # 0x2d
    'NtCreatePort', # 0x2e
    'NtCreateProcess', # 0x2f
    'NtCreateProcessEx', # 0x30
    'NtCreateProfile', # 0x31
    'NtCreateSection', # 0x32
    'NtCreateSemaphore', # 0x33
    'NtCreateSymbolicLinkObject', # 0x34
    'NtCreateThread', # 0x35
    'NtCreateTimer', # 0x36
    'NtCreateToken', # 0x37
    'NtCreateWaitablePort', # 0x38
    'NtDebugActiveProcess', # 0x39
    'NtDebugContinue', # 0x3a
    'NtDelayExecution', # 0x3b
    'NtDeleteAtom', # 0x3c
    'NtDeleteBootEntry', # 0x3d
    'NtDeleteFile', # 0x3e
    'NtDeleteKey', # 0x3f
    'NtDeleteObjectAuditAlarm', # 0x40
    'NtDeleteValueKey', # 0x41
    'NtDeviceIoControlFile', # 0x42
    'NtDisplayString', # 0x43
    'NtDuplicateObject', # 0x44
    'NtDuplicateToken', # 0x45
    'NtEnumerateBootEntries', # 0x46
    'NtEnumerateKey', # 0x47
    'NtEnumerateSystemEnvironmentValuesEx', # 0x48
    'NtEnumerateValueKey', # 0x49
    'NtExtendSection', # 0x4a
    'NtFilterToken', # 0x4b
    'NtFindAtom', # 0x4c
    'NtFlushBuffersFile', # 0x4d
    'NtFlushInstructionCache', # 0x4e
    'NtFlushKey', # 0x4f
    'NtFlushVirtualMemory', # 0x50
    'NtFlushWriteBuffer', # 0x51
    'NtFreeUserPhysicalPages', # 0x52
    'NtFreeVirtualMemory', # 0x53
    'NtFsControlFile', # 0x54
    'NtGetContextThread', # 0x55
    'NtGetDevicePowerState', # 0x56
    'NtGetPlugPlayEvent', # 0x57
    'NtGetWriteWatch', # 0x58
    'NtImpersonateAnonymousToken', # 0x59
    'NtImpersonateClientOfPort', # 0x5a
    'NtImpersonateThread', # 0x5b
    'NtInitializeRegistry', # 0x5c
    'NtInitiatePowerAction', # 0x5d
    'NtIsProcessInJob', # 0x5e
    'NtIsSystemResumeAutomatic', # 0x5f
    'NtListenPort', # 0x60
    'NtLoadDriver', # 0x61
    'NtLoadKey', # 0x62
    'NtLoadKey2', # 0x63
    'NtLockFile', # 0x64
    'NtLockProductActivationKeys', # 0x65
    'NtLockRegistryKey', # 0x66
    'NtLockVirtualMemory', # 0x67
    'NtMakePermanentObject', # 0x68
    'NtMakeTemporaryObject', # 0x69
    'NtMapUserPhysicalPages', # 0x6a
    'NtMapUserPhysicalPagesScatter', # 0x6b
    'NtMapViewOfSection', # 0x6c
    'NtModifyBootEntry', # 0x6d
    'NtNotifyChangeDirectoryFile', # 0x6e
    'NtNotifyChangeKey', # 0x6f
    'NtNotifyChangeMultipleKeys', # 0x70
    'NtOpenDirectoryObject', # 0x71
    'NtOpenEvent', # 0x72
    'NtOpenEventPair', # 0x73
    'NtOpenFile', # 0x74
    'NtOpenIoCompletion', # 0x75
    'NtOpenJobObject', # 0x76
    'NtOpenKey', # 0x77
    'NtOpenMutant', # 0x78
    'NtOpenObjectAuditAlarm', # 0x79
    'NtOpenProcess', # 0x7a
    'NtOpenProcessToken', # 0x7b
    'NtOpenProcessTokenEx', # 0x7c
    'NtOpenSection', # 0x7d
    'NtOpenSemaphore', # 0x7e
    'NtOpenSymbolicLinkObject', # 0x7f
    'NtOpenThread', # 0x80
    'NtOpenThreadToken', # 0x81
    'NtOpenThreadTokenEx', # 0x82
    'NtOpenTimer', # 0x83
    'NtPlugPlayControl', # 0x84
    'NtPowerInformation', # 0x85
    'NtPrivilegeCheck', # 0x86
    'NtPrivilegeObjectAuditAlarm', # 0x87
    'NtPrivilegedServiceAuditAlarm', # 0x88
    'NtProtectVirtualMemory', # 0x89
    'NtPulseEvent', # 0x8a
    'NtQueryAttributesFile', # 0x8b
    'NtQueryBootEntryOrder', # 0x8c
    'NtQueryBootOptions', # 0x8d
    'NtQueryDebugFilterState', # 0x8e
    'NtQueryDefaultLocale', # 0x8f
    'NtQueryDefaultUILanguage', # 0x90
    'NtQueryDirectoryFile', # 0x91
    'NtQueryDirectoryObject', # 0x92
    'NtQueryEaFile', # 0x93
    'NtQueryEvent', # 0x94
    'NtQueryFullAttributesFile', # 0x95
    'NtQueryInformationAtom', # 0x96
    'NtQueryInformationFile', # 0x97
    'NtQueryInformationJobObject', # 0x98
    'NtQueryInformationPort', # 0x99
    'NtQueryInformationProcess', # 0x9a
    'NtQueryInformationThread', # 0x9b
    'NtQueryInformationToken', # 0x9c
    'NtQueryInstallUILanguage', # 0x9d
    'NtQueryIntervalProfile', # 0x9e
    'NtQueryIoCompletion', # 0x9f
    'NtQueryKey', # 0xa0
    'NtQueryMultipleValueKey', # 0xa1
    'NtQueryMutant', # 0xa2
    'NtQueryObject', # 0xa3
    'NtQueryOpenSubKeys', # 0xa4
    'NtQueryPerformanceCounter', # 0xa5
    'NtQueryQuotaInformationFile', # 0xa6
    'NtQuerySection', # 0xa7
    'NtQuerySecurityObject', # 0xa8
    'NtQuerySemaphore', # 0xa9
    'NtQuerySymbolicLinkObject', # 0xaa
    'NtQuerySystemEnvironmentValue', # 0xab
    'NtQuerySystemEnvironmentValueEx', # 0xac
    'NtQuerySystemInformation', # 0xad
    'NtQuerySystemTime', # 0xae
    'NtQueryTimer', # 0xaf
    'NtQueryTimerResolution', # 0xb0
    'NtQueryValueKey', # 0xb1
    'NtQueryVirtualMemory', # 0xb2
    'NtQueryVolumeInformationFile', # 0xb3
    'NtQueueApcThread', # 0xb4
    'NtRaiseException', # 0xb5
    'NtRaiseHardError', # 0xb6
    'NtReadFile', # 0xb7
    'NtReadFileScatter', # 0xb8
    'NtReadRequestData', # 0xb9
    'NtReadVirtualMemory', # 0xba
    'NtRegisterThreadTerminatePort', # 0xbb
    'NtReleaseMutant', # 0xbc
    'NtReleaseSemaphore', # 0xbd
    'NtRemoveIoCompletion', # 0xbe
    'NtRemoveProcessDebug', # 0xbf
    'NtRenameKey', # 0xc0
    'NtReplaceKey', # 0xc1
    'NtReplyPort', # 0xc2
    'NtReplyWaitReceivePort', # 0xc3
    'NtReplyWaitReceivePortEx', # 0xc4
    'NtReplyWaitReplyPort', # 0xc5
    'NtRequestDeviceWakeup', # 0xc6
    'NtRequestPort', # 0xc7
    'NtRequestWaitReplyPort', # 0xc8
    'NtRequestWakeupLatency', # 0xc9
    'NtResetEvent', # 0xca
    'NtResetWriteWatch', # 0xcb
    'NtRestoreKey', # 0xcc
    'NtResumeProcess', # 0xcd
    'NtResumeThread', # 0xce
    'NtSaveKey', # 0xcf
    'NtSaveKeyEx', # 0xd0
    'NtSaveMergedKeys', # 0xd1
    'NtSecureConnectPort', # 0xd2
    'NtSetBootEntryOrder', # 0xd3
    'NtSetBootOptions', # 0xd4
    'NtSetContextThread', # 0xd5
    'NtSetDebugFilterState', # 0xd6
    'NtSetDefaultHardErrorPort', # 0xd7
    'NtSetDefaultLocale', # 0xd8
    'NtSetDefaultUILanguage', # 0xd9
    'NtSetEaFile', # 0xda
    'NtSetEvent', # 0xdb
    'NtSetEventBoostPriority', # 0xdc
    'NtSetHighEventPair', # 0xdd
    'NtSetHighWaitLowEventPair', # 0xde
    'NtSetInformationDebugObject', # 0xdf
    'NtSetInformationFile', # 0xe0
    'NtSetInformationJobObject', # 0xe1
    'NtSetInformationKey', # 0xe2
    'NtSetInformationObject', # 0xe3
    'NtSetInformationProcess', # 0xe4
    'NtSetInformationThread', # 0xe5
    'NtSetInformationToken', # 0xe6
    'NtSetIntervalProfile', # 0xe7
    'NtSetIoCompletion', # 0xe8
    'NtSetLdtEntries', # 0xe9
    'NtSetLowEventPair', # 0xea
    'NtSetLowWaitHighEventPair', # 0xeb
    'NtSetQuotaInformationFile', # 0xec
    'NtSetSecurityObject', # 0xed
    'NtSetSystemEnvironmentValue', # 0xee
    'NtSetSystemEnvironmentValueEx', # 0xef
    'NtSetSystemInformation', # 0xf0
    'NtSetSystemPowerState', # 0xf1
    'NtSetSystemTime', # 0xf2
    'NtSetThreadExecutionState', # 0xf3
    'NtSetTimer', # 0xf4
    'NtSetTimerResolution', # 0xf5
    'NtSetUuidSeed', # 0xf6
    'NtSetValueKey', # 0xf7
    'NtSetVolumeInformationFile', # 0xf8
    'NtShutdownSystem', # 0xf9
    'NtSignalAndWaitForSingleObject', # 0xfa
    'NtStartProfile', # 0xfb
    'NtStopProfile', # 0xfc
    'NtSuspendProcess', # 0xfd
    'NtSuspendThread', # 0xfe
    'NtSystemDebugControl', # 0xff
    'NtTerminateJobObject', # 0x100
    'NtTerminateProcess', # 0x101
    'NtTerminateThread', # 0x102
    'NtTestAlert', # 0x103
    'NtTraceEvent', # 0x104
    'NtTranslateFilePath', # 0x105
    'NtUnloadDriver', # 0x106
    'NtUnloadKey', # 0x107
    'NtUnloadKeyEx', # 0x108
    'NtUnlockFile', # 0x109
    'NtUnlockVirtualMemory', # 0x10a
    'NtUnmapViewOfSection', # 0x10b
    'NtVdmControl', # 0x10c
    'NtWaitForDebugEvent', # 0x10d
    'NtWaitForMultipleObjects', # 0x10e
    'NtWaitForSingleObject', # 0x10f
    'NtWaitHighEventPair', # 0x110
    'NtWaitLowEventPair', # 0x111
    'NtWriteFile', # 0x112
    'NtWriteFileGather', # 0x113
    'NtWriteRequestData', # 0x114
    'NtWriteVirtualMemory', # 0x115
    'NtYieldExecution', # 0x116
    'NtCreateKeyedEvent', # 0x117
    'NtOpenKeyedEvent', # 0x118
    'NtReleaseKeyedEvent', # 0x119
    'NtWaitForKeyedEvent', # 0x11a
    'NtQueryPortInformationProcess', # 0x11b
    ],
    [
    'NtGdiAbortDoc', # 0x0
    'NtGdiAbortPath', # 0x1
    'NtGdiAddFontResourceW', # 0x2
    'NtGdiAddRemoteFontToDC', # 0x3
    'NtGdiAddFontMemResourceEx', # 0x4
    'NtGdiRemoveMergeFont', # 0x5
    'NtGdiAddRemoteMMInstanceToDC', # 0x6
    'NtGdiAlphaBlend', # 0x7
    'NtGdiAngleArc', # 0x8
    'NtGdiAnyLinkedFonts', # 0x9
    'NtGdiFontIsLinked', # 0xa
    'NtGdiArcInternal', # 0xb
    'NtGdiBeginPath', # 0xc
    'NtGdiBitBlt', # 0xd
    'NtGdiCancelDC', # 0xe
    'NtGdiCheckBitmapBits', # 0xf
    'NtGdiCloseFigure', # 0x10
    'NtGdiClearBitmapAttributes', # 0x11
    'NtGdiClearBrushAttributes', # 0x12
    'NtGdiColorCorrectPalette', # 0x13
    'NtGdiCombineRgn', # 0x14
    'NtGdiCombineTransform', # 0x15
    'NtGdiComputeXformCoefficients', # 0x16
    'NtGdiConsoleTextOut', # 0x17
    'NtGdiConvertMetafileRect', # 0x18
    'NtGdiCreateBitmap', # 0x19
    'NtGdiCreateClientObj', # 0x1a
    'NtGdiCreateColorSpace', # 0x1b
    'NtGdiCreateColorTransform', # 0x1c
    'NtGdiCreateCompatibleBitmap', # 0x1d
    'NtGdiCreateCompatibleDC', # 0x1e
    'NtGdiCreateDIBBrush', # 0x1f
    'NtGdiCreateDIBitmapInternal', # 0x20
    'NtGdiCreateDIBSection', # 0x21
    'NtGdiCreateEllipticRgn', # 0x22
    'NtGdiCreateHalftonePalette', # 0x23
    'NtGdiCreateHatchBrushInternal', # 0x24
    'NtGdiCreateMetafileDC', # 0x25
    'NtGdiCreatePaletteInternal', # 0x26
    'NtGdiCreatePatternBrushInternal', # 0x27
    'NtGdiCreatePen', # 0x28
    'NtGdiCreateRectRgn', # 0x29
    'NtGdiCreateRoundRectRgn', # 0x2a
    'NtGdiCreateServerMetaFile', # 0x2b
    'NtGdiCreateSolidBrush', # 0x2c
    'NtGdiD3dContextCreate', # 0x2d
    'NtGdiD3dContextDestroy', # 0x2e
    'NtGdiD3dContextDestroyAll', # 0x2f
    'NtGdiD3dValidateTextureStageState', # 0x30
    'NtGdiD3dDrawPrimitives2', # 0x31
    'NtGdiDdGetDriverState', # 0x32
    'NtGdiDdAddAttachedSurface', # 0x33
    'NtGdiDdAlphaBlt', # 0x34
    'NtGdiDdAttachSurface', # 0x35
    'NtGdiDdBeginMoCompFrame', # 0x36
    'NtGdiDdBlt', # 0x37
    'NtGdiDdCanCreateSurface', # 0x38
    'NtGdiDdCanCreateD3DBuffer', # 0x39
    'NtGdiDdColorControl', # 0x3a
    'NtGdiDdCreateDirectDrawObject', # 0x3b
    'NtGdiDdCreateSurface', # 0x3c
    'NtGdiDdCreateD3DBuffer', # 0x3d
    'NtGdiDdCreateMoComp', # 0x3e
    'NtGdiDdCreateSurfaceObject', # 0x3f
    'NtGdiDdDeleteDirectDrawObject', # 0x40
    'NtGdiDdDeleteSurfaceObject', # 0x41
    'NtGdiDdDestroyMoComp', # 0x42
    'NtGdiDdDestroySurface', # 0x43
    'NtGdiDdDestroyD3DBuffer', # 0x44
    'NtGdiDdEndMoCompFrame', # 0x45
    'NtGdiDdFlip', # 0x46
    'NtGdiDdFlipToGDISurface', # 0x47
    'NtGdiDdGetAvailDriverMemory', # 0x48
    'NtGdiDdGetBltStatus', # 0x49
    'NtGdiDdGetDC', # 0x4a
    'NtGdiDdGetDriverInfo', # 0x4b
    'NtGdiDdGetDxHandle', # 0x4c
    'NtGdiDdGetFlipStatus', # 0x4d
    'NtGdiDdGetInternalMoCompInfo', # 0x4e
    'NtGdiDdGetMoCompBuffInfo', # 0x4f
    'NtGdiDdGetMoCompGuids', # 0x50
    'NtGdiDdGetMoCompFormats', # 0x51
    'NtGdiDdGetScanLine', # 0x52
    'NtGdiDdLock', # 0x53
    'NtGdiDdLockD3D', # 0x54
    'NtGdiDdQueryDirectDrawObject', # 0x55
    'NtGdiDdQueryMoCompStatus', # 0x56
    'NtGdiDdReenableDirectDrawObject', # 0x57
    'NtGdiDdReleaseDC', # 0x58
    'NtGdiDdRenderMoComp', # 0x59
    'NtGdiDdResetVisrgn', # 0x5a
    'NtGdiDdSetColorKey', # 0x5b
    'NtGdiDdSetExclusiveMode', # 0x5c
    'NtGdiDdSetGammaRamp', # 0x5d
    'NtGdiDdCreateSurfaceEx', # 0x5e
    'NtGdiDdSetOverlayPosition', # 0x5f
    'NtGdiDdUnattachSurface', # 0x60
    'NtGdiDdUnlock', # 0x61
    'NtGdiDdUnlockD3D', # 0x62
    'NtGdiDdUpdateOverlay', # 0x63
    'NtGdiDdWaitForVerticalBlank', # 0x64
    'NtGdiDvpCanCreateVideoPort', # 0x65
    'NtGdiDvpColorControl', # 0x66
    'NtGdiDvpCreateVideoPort', # 0x67
    'NtGdiDvpDestroyVideoPort', # 0x68
    'NtGdiDvpFlipVideoPort', # 0x69
    'NtGdiDvpGetVideoPortBandwidth', # 0x6a
    'NtGdiDvpGetVideoPortField', # 0x6b
    'NtGdiDvpGetVideoPortFlipStatus', # 0x6c
    'NtGdiDvpGetVideoPortInputFormats', # 0x6d
    'NtGdiDvpGetVideoPortLine', # 0x6e
    'NtGdiDvpGetVideoPortOutputFormats', # 0x6f
    'NtGdiDvpGetVideoPortConnectInfo', # 0x70
    'NtGdiDvpGetVideoSignalStatus', # 0x71
    'NtGdiDvpUpdateVideoPort', # 0x72
    'NtGdiDvpWaitForVideoPortSync', # 0x73
    'NtGdiDvpAcquireNotification', # 0x74
    'NtGdiDvpReleaseNotification', # 0x75
    'NtGdiDxgGenericThunk', # 0x76
    'NtGdiDeleteClientObj', # 0x77
    'NtGdiDeleteColorSpace', # 0x78
    'NtGdiDeleteColorTransform', # 0x79
    'NtGdiDeleteObjectApp', # 0x7a
    'NtGdiDescribePixelFormat', # 0x7b
    'NtGdiGetPerBandInfo', # 0x7c
    'NtGdiDoBanding', # 0x7d
    'NtGdiDoPalette', # 0x7e
    'NtGdiDrawEscape', # 0x7f
    'NtGdiEllipse', # 0x80
    'NtGdiEnableEudc', # 0x81
    'NtGdiEndDoc', # 0x82
    'NtGdiEndPage', # 0x83
    'NtGdiEndPath', # 0x84
    'NtGdiEnumFontChunk', # 0x85
    'NtGdiEnumFontClose', # 0x86
    'NtGdiEnumFontOpen', # 0x87
    'NtGdiEnumObjects', # 0x88
    'NtGdiEqualRgn', # 0x89
    'NtGdiEudcLoadUnloadLink', # 0x8a
    'NtGdiExcludeClipRect', # 0x8b
    'NtGdiExtCreatePen', # 0x8c
    'NtGdiExtCreateRegion', # 0x8d
    'NtGdiExtEscape', # 0x8e
    'NtGdiExtFloodFill', # 0x8f
    'NtGdiExtGetObjectW', # 0x90
    'NtGdiExtSelectClipRgn', # 0x91
    'NtGdiExtTextOutW', # 0x92
    'NtGdiFillPath', # 0x93
    'NtGdiFillRgn', # 0x94
    'NtGdiFlattenPath', # 0x95
    'NtGdiFlushUserBatch', # 0x96
    'NtGdiFlush', # 0x97
    'NtGdiForceUFIMapping', # 0x98
    'NtGdiFrameRgn', # 0x99
    'NtGdiFullscreenControl', # 0x9a
    'NtGdiGetAndSetDCDword', # 0x9b
    'NtGdiGetAppClipBox', # 0x9c
    'NtGdiGetBitmapBits', # 0x9d
    'NtGdiGetBitmapDimension', # 0x9e
    'NtGdiGetBoundsRect', # 0x9f
    'NtGdiGetCharABCWidthsW', # 0xa0
    'NtGdiGetCharacterPlacementW', # 0xa1
    'NtGdiGetCharSet', # 0xa2
    'NtGdiGetCharWidthW', # 0xa3
    'NtGdiGetCharWidthInfo', # 0xa4
    'NtGdiGetColorAdjustment', # 0xa5
    'NtGdiGetColorSpaceforBitmap', # 0xa6
    'NtGdiGetDCDword', # 0xa7
    'NtGdiGetDCforBitmap', # 0xa8
    'NtGdiGetDCObject', # 0xa9
    'NtGdiGetDCPoint', # 0xaa
    'NtGdiGetDeviceCaps', # 0xab
    'NtGdiGetDeviceGammaRamp', # 0xac
    'NtGdiGetDeviceCapsAll', # 0xad
    'NtGdiGetDIBitsInternal', # 0xae
    'NtGdiGetETM', # 0xaf
    'NtGdiGetEudcTimeStampEx', # 0xb0
    'NtGdiGetFontData', # 0xb1
    'NtGdiGetFontResourceInfoInternalW', # 0xb2
    'NtGdiGetGlyphIndicesW', # 0xb3
    'NtGdiGetGlyphIndicesWInternal', # 0xb4
    'NtGdiGetGlyphOutline', # 0xb5
    'NtGdiGetKerningPairs', # 0xb6
    'NtGdiGetLinkedUFIs', # 0xb7
    'NtGdiGetMiterLimit', # 0xb8
    'NtGdiGetMonitorID', # 0xb9
    'NtGdiGetNearestColor', # 0xba
    'NtGdiGetNearestPaletteIndex', # 0xbb
    'NtGdiGetObjectBitmapHandle', # 0xbc
    'NtGdiGetOutlineTextMetricsInternalW', # 0xbd
    'NtGdiGetPath', # 0xbe
    'NtGdiGetPixel', # 0xbf
    'NtGdiGetRandomRgn', # 0xc0
    'NtGdiGetRasterizerCaps', # 0xc1
    'NtGdiGetRealizationInfo', # 0xc2
    'NtGdiGetRegionData', # 0xc3
    'NtGdiGetRgnBox', # 0xc4
    'NtGdiGetServerMetaFileBits', # 0xc5
    'NtGdiGetSpoolMessage', # 0xc6
    'NtGdiGetStats', # 0xc7
    'NtGdiGetStockObject', # 0xc8
    'NtGdiGetStringBitmapW', # 0xc9
    'NtGdiGetSystemPaletteUse', # 0xca
    'NtGdiGetTextCharsetInfo', # 0xcb
    'NtGdiGetTextExtent', # 0xcc
    'NtGdiGetTextExtentExW', # 0xcd
    'NtGdiGetTextFaceW', # 0xce
    'NtGdiGetTextMetricsW', # 0xcf
    'NtGdiGetTransform', # 0xd0
    'NtGdiGetUFI', # 0xd1
    'NtGdiGetEmbUFI', # 0xd2
    'NtGdiGetUFIPathname', # 0xd3
    'NtGdiGetEmbedFonts', # 0xd4
    'NtGdiChangeGhostFont', # 0xd5
    'NtGdiAddEmbFontToDC', # 0xd6
    'NtGdiGetFontUnicodeRanges', # 0xd7
    'NtGdiGetWidthTable', # 0xd8
    'NtGdiGradientFill', # 0xd9
    'NtGdiHfontCreate', # 0xda
    'NtGdiIcmBrushInfo', # 0xdb
    'NtGdiInit', # 0xdc
    'NtGdiInitSpool', # 0xdd
    'NtGdiIntersectClipRect', # 0xde
    'NtGdiInvertRgn', # 0xdf
    'NtGdiLineTo', # 0xe0
    'NtGdiMakeFontDir', # 0xe1
    'NtGdiMakeInfoDC', # 0xe2
    'NtGdiMaskBlt', # 0xe3
    'NtGdiModifyWorldTransform', # 0xe4
    'NtGdiMonoBitmap', # 0xe5
    'NtGdiMoveTo', # 0xe6
    'NtGdiOffsetClipRgn', # 0xe7
    'NtGdiOffsetRgn', # 0xe8
    'NtGdiOpenDCW', # 0xe9
    'NtGdiPatBlt', # 0xea
    'NtGdiPolyPatBlt', # 0xeb
    'NtGdiPathToRegion', # 0xec
    'NtGdiPlgBlt', # 0xed
    'NtGdiPolyDraw', # 0xee
    'NtGdiPolyPolyDraw', # 0xef
    'NtGdiPolyTextOutW', # 0xf0
    'NtGdiPtInRegion', # 0xf1
    'NtGdiPtVisible', # 0xf2
    'NtGdiQueryFonts', # 0xf3
    'NtGdiQueryFontAssocInfo', # 0xf4
    'NtGdiRectangle', # 0xf5
    'NtGdiRectInRegion', # 0xf6
    'NtGdiRectVisible', # 0xf7
    'NtGdiRemoveFontResourceW', # 0xf8
    'NtGdiRemoveFontMemResourceEx', # 0xf9
    'NtGdiResetDC', # 0xfa
    'NtGdiResizePalette', # 0xfb
    'NtGdiRestoreDC', # 0xfc
    'NtGdiRoundRect', # 0xfd
    'NtGdiSaveDC', # 0xfe
    'NtGdiScaleViewportExtEx', # 0xff
    'NtGdiScaleWindowExtEx', # 0x100
    'NtGdiSelectBitmap', # 0x101
    'NtGdiSelectBrush', # 0x102
    'NtGdiSelectClipPath', # 0x103
    'NtGdiSelectFont', # 0x104
    'NtGdiSelectPen', # 0x105
    'NtGdiSetBitmapAttributes', # 0x106
    'NtGdiSetBitmapBits', # 0x107
    'NtGdiSetBitmapDimension', # 0x108
    'NtGdiSetBoundsRect', # 0x109
    'NtGdiSetBrushAttributes', # 0x10a
    'NtGdiSetBrushOrg', # 0x10b
    'NtGdiSetColorAdjustment', # 0x10c
    'NtGdiSetColorSpace', # 0x10d
    'NtGdiSetDeviceGammaRamp', # 0x10e
    'NtGdiSetDIBitsToDeviceInternal', # 0x10f
    'NtGdiSetFontEnumeration', # 0x110
    'NtGdiSetFontXform', # 0x111
    'NtGdiSetIcmMode', # 0x112
    'NtGdiSetLinkedUFIs', # 0x113
    'NtGdiSetMagicColors', # 0x114
    'NtGdiSetMetaRgn', # 0x115
    'NtGdiSetMiterLimit', # 0x116
    'NtGdiGetDeviceWidth', # 0x117
    'NtGdiMirrorWindowOrg', # 0x118
    'NtGdiSetLayout', # 0x119
    'NtGdiSetPixel', # 0x11a
    'NtGdiSetPixelFormat', # 0x11b
    'NtGdiSetRectRgn', # 0x11c
    'NtGdiSetSystemPaletteUse', # 0x11d
    'NtGdiSetTextJustification', # 0x11e
    'NtGdiSetupPublicCFONT', # 0x11f
    'NtGdiSetVirtualResolution', # 0x120
    'NtGdiSetSizeDevice', # 0x121
    'NtGdiStartDoc', # 0x122
    'NtGdiStartPage', # 0x123
    'NtGdiStretchBlt', # 0x124
    'NtGdiStretchDIBitsInternal', # 0x125
    'NtGdiStrokeAndFillPath', # 0x126
    'NtGdiStrokePath', # 0x127
    'NtGdiSwapBuffers', # 0x128
    'NtGdiTransformPoints', # 0x129
    'NtGdiTransparentBlt', # 0x12a
    'NtGdiUnloadPrinterDriver', # 0x12b
    'NtGdiUnmapMemFont', # 0x12c
    'NtGdiUnrealizeObject', # 0x12d
    'NtGdiUpdateColors', # 0x12e
    'NtGdiWidenPath', # 0x12f
    'NtUserActivateKeyboardLayout', # 0x130
    'NtUserAlterWindowStyle', # 0x131
    'NtUserAssociateInputContext', # 0x132
    'NtUserAttachThreadInput', # 0x133
    'NtUserBeginPaint', # 0x134
    'NtUserBitBltSysBmp', # 0x135
    'NtUserBlockInput', # 0x136
    'NtUserBuildHimcList', # 0x137
    'NtUserBuildHwndList', # 0x138
    'NtUserBuildNameList', # 0x139
    'NtUserBuildPropList', # 0x13a
    'NtUserCallHwnd', # 0x13b
    'NtUserCallHwndLock', # 0x13c
    'NtUserCallHwndOpt', # 0x13d
    'NtUserCallHwndParam', # 0x13e
    'NtUserCallHwndParamLock', # 0x13f
    'NtUserCallMsgFilter', # 0x140
    'NtUserCallNextHookEx', # 0x141
    'NtUserCallNoParam', # 0x142
    'NtUserCallOneParam', # 0x143
    'NtUserCallTwoParam', # 0x144
    'NtUserChangeClipboardChain', # 0x145
    'NtUserChangeDisplaySettings', # 0x146
    'NtUserCheckImeHotKey', # 0x147
    'NtUserCheckMenuItem', # 0x148
    'NtUserChildWindowFromPointEx', # 0x149
    'NtUserClipCursor', # 0x14a
    'NtUserCloseClipboard', # 0x14b
    'NtUserCloseDesktop', # 0x14c
    'NtUserCloseWindowStation', # 0x14d
    'NtUserConsoleControl', # 0x14e
    'NtUserConvertMemHandle', # 0x14f
    'NtUserCopyAcceleratorTable', # 0x150
    'NtUserCountClipboardFormats', # 0x151
    'NtUserCreateAcceleratorTable', # 0x152
    'NtUserCreateCaret', # 0x153
    'NtUserCreateDesktop', # 0x154
    'NtUserCreateInputContext', # 0x155
    'NtUserCreateLocalMemHandle', # 0x156
    'NtUserCreateWindowEx', # 0x157
    'NtUserCreateWindowStation', # 0x158
    'NtUserDdeGetQualityOfService', # 0x159
    'NtUserDdeInitialize', # 0x15a
    'NtUserDdeSetQualityOfService', # 0x15b
    'NtUserDeferWindowPos', # 0x15c
    'NtUserDefSetText', # 0x15d
    'NtUserDeleteMenu', # 0x15e
    'NtUserDestroyAcceleratorTable', # 0x15f
    'NtUserDestroyCursor', # 0x160
    'NtUserDestroyInputContext', # 0x161
    'NtUserDestroyMenu', # 0x162
    'NtUserDestroyWindow', # 0x163
    'NtUserDisableThreadIme', # 0x164
    'NtUserDispatchMessage', # 0x165
    'NtUserDragDetect', # 0x166
    'NtUserDragObject', # 0x167
    'NtUserDrawAnimatedRects', # 0x168
    'NtUserDrawCaption', # 0x169
    'NtUserDrawCaptionTemp', # 0x16a
    'NtUserDrawIconEx', # 0x16b
    'NtUserDrawMenuBarTemp', # 0x16c
    'NtUserEmptyClipboard', # 0x16d
    'NtUserEnableMenuItem', # 0x16e
    'NtUserEnableScrollBar', # 0x16f
    'NtUserEndDeferWindowPosEx', # 0x170
    'NtUserEndMenu', # 0x171
    'NtUserEndPaint', # 0x172
    'NtUserEnumDisplayDevices', # 0x173
    'NtUserEnumDisplayMonitors', # 0x174
    'NtUserEnumDisplaySettings', # 0x175
    'NtUserEvent', # 0x176
    'NtUserExcludeUpdateRgn', # 0x177
    'NtUserFillWindow', # 0x178
    'NtUserFindExistingCursorIcon', # 0x179
    'NtUserFindWindowEx', # 0x17a
    'NtUserFlashWindowEx', # 0x17b
    'NtUserGetAltTabInfo', # 0x17c
    'NtUserGetAncestor', # 0x17d
    'NtUserGetAppImeLevel', # 0x17e
    'NtUserGetAsyncKeyState', # 0x17f
    'NtUserGetAtomName', # 0x180
    'NtUserGetCaretBlinkTime', # 0x181
    'NtUserGetCaretPos', # 0x182
    'NtUserGetClassInfo', # 0x183
    'NtUserGetClassName', # 0x184
    'NtUserGetClipboardData', # 0x185
    'NtUserGetClipboardFormatName', # 0x186
    'NtUserGetClipboardOwner', # 0x187
    'NtUserGetClipboardSequenceNumber', # 0x188
    'NtUserGetClipboardViewer', # 0x189
    'NtUserGetClipCursor', # 0x18a
    'NtUserGetComboBoxInfo', # 0x18b
    'NtUserGetControlBrush', # 0x18c
    'NtUserGetControlColor', # 0x18d
    'NtUserGetCPD', # 0x18e
    'NtUserGetCursorFrameInfo', # 0x18f
    'NtUserGetCursorInfo', # 0x190
    'NtUserGetDC', # 0x191
    'NtUserGetDCEx', # 0x192
    'NtUserGetDoubleClickTime', # 0x193
    'NtUserGetForegroundWindow', # 0x194
    'NtUserGetGuiResources', # 0x195
    'NtUserGetGUIThreadInfo', # 0x196
    'NtUserGetIconInfo', # 0x197
    'NtUserGetIconSize', # 0x198
    'NtUserGetImeHotKey', # 0x199
    'NtUserGetImeInfoEx', # 0x19a
    'NtUserGetInternalWindowPos', # 0x19b
    'NtUserGetKeyboardLayoutList', # 0x19c
    'NtUserGetKeyboardLayoutName', # 0x19d
    'NtUserGetKeyboardState', # 0x19e
    'NtUserGetKeyNameText', # 0x19f
    'NtUserGetKeyState', # 0x1a0
    'NtUserGetListBoxInfo', # 0x1a1
    'NtUserGetMenuBarInfo', # 0x1a2
    'NtUserGetMenuIndex', # 0x1a3
    'NtUserGetMenuItemRect', # 0x1a4
    'NtUserGetMessage', # 0x1a5
    'NtUserGetMouseMovePointsEx', # 0x1a6
    'NtUserGetObjectInformation', # 0x1a7
    'NtUserGetOpenClipboardWindow', # 0x1a8
    'NtUserGetPriorityClipboardFormat', # 0x1a9
    'NtUserGetProcessWindowStation', # 0x1aa
    'NtUserGetRawInputBuffer', # 0x1ab
    'NtUserGetRawInputData', # 0x1ac
    'NtUserGetRawInputDeviceInfo', # 0x1ad
    'NtUserGetRawInputDeviceList', # 0x1ae
    'NtUserGetRegisteredRawInputDevices', # 0x1af
    'NtUserGetScrollBarInfo', # 0x1b0
    'NtUserGetSystemMenu', # 0x1b1
    'NtUserGetThreadDesktop', # 0x1b2
    'NtUserGetThreadState', # 0x1b3
    'NtUserGetTitleBarInfo', # 0x1b4
    'NtUserGetUpdateRect', # 0x1b5
    'NtUserGetUpdateRgn', # 0x1b6
    'NtUserGetWindowDC', # 0x1b7
    'NtUserGetWindowPlacement', # 0x1b8
    'NtUserGetWOWClass', # 0x1b9
    'NtUserHardErrorControl', # 0x1ba
    'NtUserHideCaret', # 0x1bb
    'NtUserHiliteMenuItem', # 0x1bc
    'NtUserImpersonateDdeClientWindow', # 0x1bd
    'NtUserInitialize', # 0x1be
    'NtUserInitializeClientPfnArrays', # 0x1bf
    'NtUserInitTask', # 0x1c0
    'NtUserInternalGetWindowText', # 0x1c1
    'NtUserInvalidateRect', # 0x1c2
    'NtUserInvalidateRgn', # 0x1c3
    'NtUserIsClipboardFormatAvailable', # 0x1c4
    'NtUserKillTimer', # 0x1c5
    'NtUserLoadKeyboardLayoutEx', # 0x1c6
    'NtUserLockWindowStation', # 0x1c7
    'NtUserLockWindowUpdate', # 0x1c8
    'NtUserLockWorkStation', # 0x1c9
    'NtUserMapVirtualKeyEx', # 0x1ca
    'NtUserMenuItemFromPoint', # 0x1cb
    'NtUserMessageCall', # 0x1cc
    'NtUserMinMaximize', # 0x1cd
    'NtUserMNDragLeave', # 0x1ce
    'NtUserMNDragOver', # 0x1cf
    'NtUserModifyUserStartupInfoFlags', # 0x1d0
    'NtUserMoveWindow', # 0x1d1
    'NtUserNotifyIMEStatus', # 0x1d2
    'NtUserNotifyProcessCreate', # 0x1d3
    'NtUserNotifyWinEvent', # 0x1d4
    'NtUserOpenClipboard', # 0x1d5
    'NtUserOpenDesktop', # 0x1d6
    'NtUserOpenInputDesktop', # 0x1d7
    'NtUserOpenWindowStation', # 0x1d8
    'NtUserPaintDesktop', # 0x1d9
    'NtUserPeekMessage', # 0x1da
    'NtUserPostMessage', # 0x1db
    'NtUserPostThreadMessage', # 0x1dc
    'NtUserPrintWindow', # 0x1dd
    'NtUserProcessConnect', # 0x1de
    'NtUserQueryInformationThread', # 0x1df
    'NtUserQueryInputContext', # 0x1e0
    'NtUserQuerySendMessage', # 0x1e1
    'NtUserQueryUserCounters', # 0x1e2
    'NtUserQueryWindow', # 0x1e3
    'NtUserRealChildWindowFromPoint', # 0x1e4
    'NtUserRealInternalGetMessage', # 0x1e5
    'NtUserRealWaitMessageEx', # 0x1e6
    'NtUserRedrawWindow', # 0x1e7
    'NtUserRegisterClassExWOW', # 0x1e8
    'NtUserRegisterUserApiHook', # 0x1e9
    'NtUserRegisterHotKey', # 0x1ea
    'NtUserRegisterRawInputDevices', # 0x1eb
    'NtUserRegisterTasklist', # 0x1ec
    'NtUserRegisterWindowMessage', # 0x1ed
    'NtUserRemoveMenu', # 0x1ee
    'NtUserRemoveProp', # 0x1ef
    'NtUserResolveDesktop', # 0x1f0
    'NtUserResolveDesktopForWOW', # 0x1f1
    'NtUserSBGetParms', # 0x1f2
    'NtUserScrollDC', # 0x1f3
    'NtUserScrollWindowEx', # 0x1f4
    'NtUserSelectPalette', # 0x1f5
    'NtUserSendInput', # 0x1f6
    'NtUserSetActiveWindow', # 0x1f7
    'NtUserSetAppImeLevel', # 0x1f8
    'NtUserSetCapture', # 0x1f9
    'NtUserSetClassLong', # 0x1fa
    'NtUserSetClassWord', # 0x1fb
    'NtUserSetClipboardData', # 0x1fc
    'NtUserSetClipboardViewer', # 0x1fd
    'NtUserSetConsoleReserveKeys', # 0x1fe
    'NtUserSetCursor', # 0x1ff
    'NtUserSetCursorContents', # 0x200
    'NtUserSetCursorIconData', # 0x201
    'NtUserSetDbgTag', # 0x202
    'NtUserSetFocus', # 0x203
    'NtUserSetImeHotKey', # 0x204
    'NtUserSetImeInfoEx', # 0x205
    'NtUserSetImeOwnerWindow', # 0x206
    'NtUserSetInformationProcess', # 0x207
    'NtUserSetInformationThread', # 0x208
    'NtUserSetInternalWindowPos', # 0x209
    'NtUserSetKeyboardState', # 0x20a
    'NtUserSetLogonNotifyWindow', # 0x20b
    'NtUserSetMenu', # 0x20c
    'NtUserSetMenuContextHelpId', # 0x20d
    'NtUserSetMenuDefaultItem', # 0x20e
    'NtUserSetMenuFlagRtoL', # 0x20f
    'NtUserSetObjectInformation', # 0x210
    'NtUserSetParent', # 0x211
    'NtUserSetProcessWindowStation', # 0x212
    'NtUserSetProp', # 0x213
    'NtUserSetRipFlags', # 0x214
    'NtUserSetScrollInfo', # 0x215
    'NtUserSetShellWindowEx', # 0x216
    'NtUserSetSysColors', # 0x217
    'NtUserSetSystemCursor', # 0x218
    'NtUserSetSystemMenu', # 0x219
    'NtUserSetSystemTimer', # 0x21a
    'NtUserSetThreadDesktop', # 0x21b
    'NtUserSetThreadLayoutHandles', # 0x21c
    'NtUserSetThreadState', # 0x21d
    'NtUserSetTimer', # 0x21e
    'NtUserSetWindowFNID', # 0x21f
    'NtUserSetWindowLong', # 0x220
    'NtUserSetWindowPlacement', # 0x221
    'NtUserSetWindowPos', # 0x222
    'NtUserSetWindowRgn', # 0x223
    'NtUserSetWindowsHookAW', # 0x224
    'NtUserSetWindowsHookEx', # 0x225
    'NtUserSetWindowStationUser', # 0x226
    'NtUserSetWindowWord', # 0x227
    'NtUserSetWinEventHook', # 0x228
    'NtUserShowCaret', # 0x229
    'NtUserShowScrollBar', # 0x22a
    'NtUserShowWindow', # 0x22b
    'NtUserShowWindowAsync', # 0x22c
    'NtUserSoundSentry', # 0x22d
    'NtUserSwitchDesktop', # 0x22e
    'NtUserSystemParametersInfo', # 0x22f
    'NtUserTestForInteractiveUser', # 0x230
    'NtUserThunkedMenuInfo', # 0x231
    'NtUserThunkedMenuItemInfo', # 0x232
    'NtUserToUnicodeEx', # 0x233
    'NtUserTrackMouseEvent', # 0x234
    'NtUserTrackPopupMenuEx', # 0x235
    'NtUserCalcMenuBar', # 0x236
    'NtUserPaintMenuBar', # 0x237
    'NtUserTranslateAccelerator', # 0x238
    'NtUserTranslateMessage', # 0x239
    'NtUserUnhookWindowsHookEx', # 0x23a
    'NtUserUnhookWinEvent', # 0x23b
    'NtUserUnloadKeyboardLayout', # 0x23c
    'NtUserUnlockWindowStation', # 0x23d
    'NtUserUnregisterClass', # 0x23e
    'NtUserUnregisterUserApiHook', # 0x23f
    'NtUserUnregisterHotKey', # 0x240
    'NtUserUpdateInputContext', # 0x241
    'NtUserUpdateInstance', # 0x242
    'NtUserUpdateLayeredWindow', # 0x243
    'NtUserGetLayeredWindowAttributes', # 0x244
    'NtUserSetLayeredWindowAttributes', # 0x245
    'NtUserUpdatePerUserSystemParameters', # 0x246
    'NtUserUserHandleGrantAccess', # 0x247
    'NtUserValidateHandleSecure', # 0x248
    'NtUserValidateRect', # 0x249
    'NtUserValidateTimerCallback', # 0x24a
    'NtUserVkKeyScanEx', # 0x24b
    'NtUserWaitForInputIdle', # 0x24c
    'NtUserWaitForMsgAndEvent', # 0x24d
    'NtUserWaitMessage', # 0x24e
    'NtUserWin32PoolAllocationStats', # 0x24f
    'NtUserWindowFromPoint', # 0x250
    'NtUserYieldTask', # 0x251
    'NtUserRemoteConnect', # 0x252
    'NtUserRemoteRedrawRectangle', # 0x253
    'NtUserRemoteRedrawScreen', # 0x254
    'NtUserRemoteStopScreenUpdates', # 0x255
    'NtUserCtxDisplayIOCtl', # 0x256
    'NtGdiEngAssociateSurface', # 0x257
    'NtGdiEngCreateBitmap', # 0x258
    'NtGdiEngCreateDeviceSurface', # 0x259
    'NtGdiEngCreateDeviceBitmap', # 0x25a
    'NtGdiEngCreatePalette', # 0x25b
    'NtGdiEngComputeGlyphSet', # 0x25c
    'NtGdiEngCopyBits', # 0x25d
    'NtGdiEngDeletePalette', # 0x25e
    'NtGdiEngDeleteSurface', # 0x25f
    'NtGdiEngEraseSurface', # 0x260
    'NtGdiEngUnlockSurface', # 0x261
    'NtGdiEngLockSurface', # 0x262
    'NtGdiEngBitBlt', # 0x263
    'NtGdiEngStretchBlt', # 0x264
    'NtGdiEngPlgBlt', # 0x265
    'NtGdiEngMarkBandingSurface', # 0x266
    'NtGdiEngStrokePath', # 0x267
    'NtGdiEngFillPath', # 0x268
    'NtGdiEngStrokeAndFillPath', # 0x269
    'NtGdiEngPaint', # 0x26a
    'NtGdiEngLineTo', # 0x26b
    'NtGdiEngAlphaBlend', # 0x26c
    'NtGdiEngGradientFill', # 0x26d
    'NtGdiEngTransparentBlt', # 0x26e
    'NtGdiEngTextOut', # 0x26f
    'NtGdiEngStretchBltROP', # 0x270
    'NtGdiXLATEOBJ_cGetPalette', # 0x271
    'NtGdiXLATEOBJ_iXlate', # 0x272
    'NtGdiXLATEOBJ_hGetColorTransform', # 0x273
    'NtGdiCLIPOBJ_bEnum', # 0x274
    'NtGdiCLIPOBJ_cEnumStart', # 0x275
    'NtGdiCLIPOBJ_ppoGetPath', # 0x276
    'NtGdiEngDeletePath', # 0x277
    'NtGdiEngCreateClip', # 0x278
    'NtGdiEngDeleteClip', # 0x279
    'NtGdiBRUSHOBJ_ulGetBrushColor', # 0x27a
    'NtGdiBRUSHOBJ_pvAllocRbrush', # 0x27b
    'NtGdiBRUSHOBJ_pvGetRbrush', # 0x27c
    'NtGdiBRUSHOBJ_hGetColorTransform', # 0x27d
    'NtGdiXFORMOBJ_bApplyXform', # 0x27e
    'NtGdiXFORMOBJ_iGetXform', # 0x27f
    'NtGdiFONTOBJ_vGetInfo', # 0x280
    'NtGdiFONTOBJ_pxoGetXform', # 0x281
    'NtGdiFONTOBJ_cGetGlyphs', # 0x282
    'NtGdiFONTOBJ_pifi', # 0x283
    'NtGdiFONTOBJ_pfdg', # 0x284
    'NtGdiFONTOBJ_pQueryGlyphAttrs', # 0x285
    'NtGdiFONTOBJ_pvTrueTypeFontFile', # 0x286
    'NtGdiFONTOBJ_cGetAllGlyphHandles', # 0x287
    'NtGdiSTROBJ_bEnum', # 0x288
    'NtGdiSTROBJ_bEnumPositionsOnly', # 0x289
    'NtGdiSTROBJ_bGetAdvanceWidths', # 0x28a
    'NtGdiSTROBJ_vEnumStart', # 0x28b
    'NtGdiSTROBJ_dwGetCodePage', # 0x28c
    'NtGdiPATHOBJ_vGetBounds', # 0x28d
    'NtGdiPATHOBJ_bEnum', # 0x28e
    'NtGdiPATHOBJ_vEnumStart', # 0x28f
    'NtGdiPATHOBJ_vEnumStartClipLines', # 0x290
    'NtGdiPATHOBJ_bEnumClipLines', # 0x291
    'NtGdiGetDhpdev', # 0x292
    'NtGdiEngCheckAbort', # 0x293
    'NtGdiHT_Get8BPPFormatPalette', # 0x294
    'NtGdiHT_Get8BPPMaskPalette', # 0x295
    'NtGdiUpdateTransform', # 0x296
    'NtGdiSetPUMPDOBJ', # 0x297
    'NtGdiBRUSHOBJ_DeleteRbrush', # 0x298
    'NtGdiUMPDEngFreeUserMem', # 0x299
    'NtGdiDrawStream', # 0x29a
    ],
]
