/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.sesame3.driver;

import info.aduna.io.GZipUtil;
import info.aduna.io.ZipUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.openrdf.cursor.CollectionCursor;
import org.openrdf.cursor.Cursor;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.LiteralFactory;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.URIFactory;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.NamespaceImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.Dataset;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.Query;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.result.ContextResult;
import org.openrdf.result.GraphResult;
import org.openrdf.result.ModelResult;
import org.openrdf.result.NamespaceResult;
import org.openrdf.result.TupleResult;
import org.openrdf.result.impl.ContextResultImpl;
import org.openrdf.result.impl.GraphResultImpl;
import org.openrdf.result.impl.ModelResultImpl;
import org.openrdf.result.impl.NamespaceResultImpl;
import org.openrdf.result.impl.TupleResultImpl;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;
import org.openrdf.rio.helpers.RDFHandlerBase;
import org.openrdf.store.Isolation;
import org.openrdf.store.StoreException;
import virtuoso.sesame3.driver.VirtuosoBooleanQuery;
import virtuoso.sesame3.driver.VirtuosoGraphQuery;
import virtuoso.sesame3.driver.VirtuosoQuery;
import virtuoso.sesame3.driver.VirtuosoRepository;
import virtuoso.sesame3.driver.VirtuosoTupleQuery;
import virtuoso.sql.ExtendedString;
import virtuoso.sql.RdfBox;

public class VirtuosoRepositoryConnection
implements RepositoryConnection {
    private ValueFactoryImpl vf;
    private static Resource nilContext;
    private Connection quadStoreConnection;
    protected VirtuosoRepository repository;
    static final String S_INSERT = "sparql insert into graph iri(??) { `iri(??)` `iri(??)` `bif:__rdf_long_from_batch_params(??,??,??)` }";
    static final String S_DELETE = "sparql delete from graph iri(??) {`iri(??)` `iri(??)` `bif:__rdf_long_from_batch_params(??,??,??)`}";
    static final int BATCH_SIZE = 5000;
    private PreparedStatement psInsert;
    private int psInsertCount = 0;
    private boolean useLazyAdd = false;
    private int prefetchSize = 200;

    protected VirtuosoRepositoryConnection(VirtuosoRepository virtuosoRepository, Connection connection) throws StoreException {
        this.quadStoreConnection = connection;
        this.repository = virtuosoRepository;
        this.useLazyAdd = virtuosoRepository.useLazyAdd;
        this.prefetchSize = virtuosoRepository.prefetchSize;
        URIFactory uRIFactory = virtuosoRepository.getURIFactory();
        LiteralFactory literalFactory = virtuosoRepository.getLiteralFactory();
        this.vf = new ValueFactoryImpl(uRIFactory, literalFactory);
        nilContext = this.getValueFactory().createURI(virtuosoRepository.defGraph);
        this.repository.initialize();
    }

    protected void verifyNotReadOnly() throws StoreException {
        if (this.isReadOnly()) {
            throw new StoreException("Connection is in read-only mode");
        }
    }

    protected void verifyTxnActive() throws StoreException {
        if (this.isAutoCommit()) {
            throw new StoreException("Connection does not have an active transaction");
        }
    }

    protected void verifyNotTxnActive(String string) throws StoreException {
        if (!this.isAutoCommit()) {
            throw new StoreException(string);
        }
    }

    public Repository getRepository() {
        return this.repository;
    }

    public ValueFactory getValueFactory() {
        return this.vf;
    }

    public boolean isOpen() throws StoreException {
        try {
            return !this.getQuadStoreConnection().isClosed();
        }
        catch (SQLException sQLException) {
            throw new StoreException("Problem inspecting connection", (Throwable)sQLException);
        }
    }

    public void close() throws StoreException {
        this.dropDelayAdd();
        try {
            if (!this.getQuadStoreConnection().isClosed()) {
                this.getQuadStoreConnection().close();
            }
        }
        catch (SQLException sQLException) {
            throw new StoreException((Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.isOpen()) {
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public Isolation getTransactionIsolation() throws StoreException {
        this.verifyIsOpen();
        try {
            int n = this.getQuadStoreConnection().getTransactionIsolation();
            switch (n) {
                case 0: {
                    return Isolation.NONE;
                }
                case 1: {
                    return Isolation.READ_UNCOMMITTED;
                }
                case 2: {
                    return Isolation.READ_COMMITTED;
                }
                case 4: {
                    return Isolation.REPEATABLE_READ;
                }
                case 8: {
                    return Isolation.SERIALIZABLE;
                }
            }
            return Isolation.NONE;
        }
        catch (SQLException sQLException) {
            throw new StoreException((Throwable)sQLException);
        }
    }

    public void setTransactionIsolation(Isolation isolation) throws StoreException {
        this.verifyIsOpen();
        try {
            switch (isolation) {
                case NONE: {
                    this.getQuadStoreConnection().setTransactionIsolation(0);
                    break;
                }
                case READ_UNCOMMITTED: {
                    this.getQuadStoreConnection().setTransactionIsolation(1);
                    break;
                }
                case READ_COMMITTED: {
                    this.getQuadStoreConnection().setTransactionIsolation(2);
                    break;
                }
                case REPEATABLE_READ: {
                    this.getQuadStoreConnection().setTransactionIsolation(4);
                    break;
                }
                case SERIALIZABLE: {
                    this.getQuadStoreConnection().setTransactionIsolation(8);
                    break;
                }
                default: {
                    throw new SQLException("Unsupported isolation level " + isolation);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new StoreException((Throwable)sQLException);
        }
    }

    public boolean isReadOnly() throws StoreException {
        this.verifyIsOpen();
        try {
            return this.getQuadStoreConnection().isReadOnly();
        }
        catch (SQLException sQLException) {
            throw new StoreException((Throwable)sQLException);
        }
    }

    public void setReadOnly(boolean bl) throws StoreException {
        this.verifyIsOpen();
        try {
            this.getQuadStoreConnection().setReadOnly(bl);
        }
        catch (SQLException sQLException) {
            throw new StoreException((Throwable)sQLException);
        }
    }

    public Query prepareQuery(QueryLanguage queryLanguage, String string) throws StoreException, MalformedQueryException {
        return this.prepareQuery(queryLanguage, string, null);
    }

    public Query prepareQuery(QueryLanguage queryLanguage, String string, String string2) throws StoreException, MalformedQueryException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string3 = null;
        while (!(!stringTokenizer.hasMoreTokens() || (string3 = stringTokenizer.nextToken().toLowerCase()).equals("select") || string3.equals("construct") || string3.equals("describe") || string3.equals("ask"))) {
        }
        this.flushDelayAdd();
        if (string3.equals("select")) {
            return this.prepareTupleQuery(queryLanguage, string, string2);
        }
        if (string3.equals("construct") || string3.equals("describe")) {
            return this.prepareGraphQuery(queryLanguage, string, string2);
        }
        if (string3.equals("ask")) {
            return this.prepareBooleanQuery(queryLanguage, string, string2);
        }
        return new VirtuosoQuery();
    }

    public TupleQuery prepareTupleQuery(QueryLanguage queryLanguage, String string) throws StoreException, MalformedQueryException {
        return this.prepareTupleQuery(queryLanguage, string, null);
    }

    public TupleQuery prepareTupleQuery(QueryLanguage queryLanguage, final String string, String string2) throws StoreException, MalformedQueryException {
        VirtuosoTupleQuery virtuosoTupleQuery = new VirtuosoTupleQuery(){

            @Override
            public TupleResult evaluate() throws StoreException {
                return VirtuosoRepositoryConnection.this.executeSPARQLForTupleResult(string, this.getDataset(), this.getIncludeInferred(), this.getBindings());
            }
        };
        return virtuosoTupleQuery;
    }

    public GraphQuery prepareGraphQuery(QueryLanguage queryLanguage, String string) throws StoreException, MalformedQueryException {
        return this.prepareGraphQuery(queryLanguage, string, null);
    }

    public GraphQuery prepareGraphQuery(QueryLanguage queryLanguage, final String string, String string2) throws StoreException, MalformedQueryException {
        VirtuosoGraphQuery virtuosoGraphQuery = new VirtuosoGraphQuery(){

            @Override
            public GraphResult evaluate() throws StoreException {
                return VirtuosoRepositoryConnection.this.executeSPARQLForGraphResult(string, this.getDataset(), this.getIncludeInferred(), this.getBindings());
            }
        };
        return virtuosoGraphQuery;
    }

    public BooleanQuery prepareBooleanQuery(QueryLanguage queryLanguage, String string) throws StoreException, MalformedQueryException {
        return this.prepareBooleanQuery(queryLanguage, string, null);
    }

    public BooleanQuery prepareBooleanQuery(QueryLanguage queryLanguage, final String string, String string2) throws StoreException, MalformedQueryException {
        VirtuosoBooleanQuery virtuosoBooleanQuery = new VirtuosoBooleanQuery(){

            @Override
            public boolean ask() throws StoreException {
                return VirtuosoRepositoryConnection.this.executeSPARQLForBooleanResult(string, this.getDataset(), this.getIncludeInferred(), this.getBindings());
            }
        };
        return virtuosoBooleanQuery;
    }

    public ContextResult getContextIDs() throws StoreException {
        this.verifyIsOpen();
        this.flushDelayAdd();
        LinkedList<Resource> linkedList = new LinkedList<Resource>();
        String string = "DB.DBA.SPARQL_SELECT_KNOWN_GRAPHS()";
        try {
            java.sql.Statement statement = this.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                Object object = resultSet.getObject(1);
                try {
                    Value value = this.castValue(object);
                    linkedList.add((Resource)value);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new StoreException("VirtuosoRepositoryConnection.getContextIDs() Non-URI context encountered: " + object, (Throwable)illegalArgumentException);
                }
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            throw new StoreException(": SPARQL execute failed.\n" + string.toString(), (Throwable)sQLException);
        }
        return new ContextResultImpl((Cursor)new CollectionCursor(linkedList));
    }

    @Deprecated
    public ModelResult getStatements(Resource resource, URI uRI, Value value, boolean bl, Resource ... resourceArray) throws StoreException {
        return this.match(resource, uRI, value, bl, resourceArray);
    }

    public ModelResult match(Resource resource, URI uRI, Value value, boolean bl, Resource ... resourceArray) throws StoreException {
        resourceArray = this.checkContext(resourceArray);
        return new ModelResultImpl(this.selectFromQuadStore(resource, uRI, value, bl, false, resourceArray));
    }

    @Deprecated
    public boolean hasStatement(Resource resource, URI uRI, Value value, boolean bl, Resource ... resourceArray) throws StoreException {
        return this.hasMatch(resource, uRI, value, bl, resourceArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMatch(Resource resource, URI uRI, Value value, boolean bl, Resource ... resourceArray) throws StoreException {
        resourceArray = this.checkContext(resourceArray);
        Cursor<Statement> cursor = this.selectFromQuadStore(resource, uRI, value, bl, true, resourceArray);
        try {
            boolean bl2 = cursor.next() != null;
            return bl2;
        }
        finally {
            cursor.close();
        }
    }

    public boolean hasStatement(Statement statement, boolean bl, Resource ... resourceArray) throws StoreException {
        return this.hasStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), bl, resourceArray);
    }

    @Deprecated
    public void exportStatements(Resource resource, URI uRI, Value value, boolean bl, RDFHandler rDFHandler, Resource ... resourceArray) throws StoreException, RDFHandlerException {
        this.exportMatch(resource, uRI, value, bl, rDFHandler, resourceArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <H extends RDFHandler> H exportMatch(Resource resource, URI uRI, Value value, boolean bl, H h, Resource ... resourceArray) throws StoreException, RDFHandlerException {
        Namespace namespace;
        h.startRDF();
        NamespaceResult namespaceResult = this.getNamespaces();
        try {
            while (namespaceResult.hasNext()) {
                namespace = (Namespace)namespaceResult.next();
                h.handleNamespace(namespace.getPrefix(), namespace.getName());
            }
        }
        finally {
            namespaceResult.close();
        }
        namespace = this.match(resource, uRI, value, bl, resourceArray);
        try {
            while (namespace.hasNext()) {
                h.handleStatement((Statement)namespace.next());
            }
        }
        finally {
            namespace.close();
        }
        h.endRDF();
        return h;
    }

    public <H extends RDFHandler> H export(H h, Resource ... resourceArray) throws StoreException, RDFHandlerException {
        return this.exportMatch(null, null, null, false, h, resourceArray);
    }

    public void verifyContextNotNull(Resource ... resourceArray) throws StoreException {
        if (resourceArray == null) {
            throw new StoreException("Illegal value null array for contexts argument; either the value should be cast to Resource or an empty array should be supplied");
        }
    }

    private Resource[] checkDMLContext(Resource ... resourceArray) throws StoreException {
        this.verifyContextNotNull(resourceArray);
        if (resourceArray != null && resourceArray.length == 1 && resourceArray[0] == null) {
            resourceArray = new Resource[]{nilContext};
        } else if (resourceArray == null || resourceArray.length == 0) {
            resourceArray = new Resource[]{nilContext};
        }
        return resourceArray;
    }

    private Resource[] checkContext(Resource ... resourceArray) throws StoreException {
        this.verifyContextNotNull(resourceArray);
        if (resourceArray != null && resourceArray.length == 1 && resourceArray[0] == null) {
            resourceArray = new Resource[]{nilContext};
        } else if (resourceArray == null || resourceArray.length == 0) {
            resourceArray = new Resource[]{};
        }
        return resourceArray;
    }

    public long size(Resource ... resourceArray) throws StoreException {
        return this.sizeMatch(null, null, null, false, resourceArray);
    }

    @Deprecated
    public long size(Resource resource, URI uRI, Value value, boolean bl, Resource ... resourceArray) throws StoreException {
        return this.sizeMatch(resource, uRI, value, bl, resourceArray);
    }

    public long sizeMatch(Resource resource, URI uRI, Value value, boolean bl, Resource ... resourceArray) throws StoreException {
        return this.selectCountFromQuadStore(resource, uRI, value, bl, resourceArray);
    }

    public boolean isEmpty() throws StoreException {
        this.verifyIsOpen();
        this.flushDelayAdd();
        boolean bl = false;
        String string = "sparql define input:storage \"\" select * where {?s ?o ?p} limit 1";
        try {
            java.sql.Statement statement = this.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            bl = !resultSet.next();
            resultSet.close();
            return bl;
        }
        catch (SQLException sQLException) {
            throw new StoreException("Problem executing query: " + string, (Throwable)sQLException);
        }
    }

    public boolean isAutoCommit() throws StoreException {
        this.verifyIsOpen();
        try {
            return this.getQuadStoreConnection().getAutoCommit();
        }
        catch (SQLException sQLException) {
            throw new StoreException((Throwable)sQLException);
        }
    }

    public void begin() throws StoreException {
        this.verifyIsOpen();
        this.verifyNotTxnActive("Connection already has an active transaction");
        this.flushDelayAdd();
        try {
            this.getQuadStoreConnection().setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            throw new StoreException((Throwable)sQLException);
        }
    }

    public void commit() throws StoreException {
        this.verifyIsOpen();
        this.flushDelayAdd();
        try {
            this.getQuadStoreConnection().commit();
            this.getQuadStoreConnection().setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            throw new StoreException((Throwable)sQLException);
        }
    }

    public void rollback() throws StoreException {
        this.verifyIsOpen();
        this.dropDelayAdd();
        try {
            this.getQuadStoreConnection().rollback();
            this.getQuadStoreConnection().setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            throw new StoreException("Problem with rollback", (Throwable)sQLException);
        }
    }

    public void add(InputStream inputStream, String string, RDFFormat rDFFormat, Resource ... resourceArray) throws IOException, RDFParseException, StoreException {
        this.verifyIsOpen();
        this.verifyNotReadOnly();
        if (this.repository.isReadOnly()) {
            throw new StoreException("Repository is ReadOnly");
        }
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream, 1024);
        }
        if (ZipUtil.isZipStream((InputStream)inputStream)) {
            this.addZip(inputStream, string, rDFFormat, resourceArray);
        } else if (GZipUtil.isGZipStream((InputStream)inputStream)) {
            this.add(new InputStreamReader(new GZIPInputStream(inputStream)), string, rDFFormat, resourceArray);
        } else {
            this.add(new InputStreamReader(inputStream), string, rDFFormat, resourceArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addZip(InputStream inputStream, String string, RDFFormat rDFFormat, Resource ... resourceArray) throws IOException, RDFParseException, StoreException {
        boolean bl = this.isAutoCommit();
        if (bl) {
            this.begin();
        }
        try {
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            try {
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                while (zipEntry != null) {
                    if (!zipEntry.isDirectory()) {
                        RDFFormat rDFFormat2 = Rio.getParserFormatForFileName((String)zipEntry.getName(), (RDFFormat)rDFFormat);
                        try {
                            FilterInputStream filterInputStream = new FilterInputStream(zipInputStream){

                                @Override
                                public void close() {
                                }
                            };
                            this.add(new InputStreamReader(filterInputStream), string, rDFFormat2, resourceArray);
                        }
                        catch (RDFParseException rDFParseException) {
                            String string2 = rDFParseException.getMessage() + " in " + zipEntry.getName();
                            RDFParseException rDFParseException2 = new RDFParseException(string2, rDFParseException.getLineNumber(), rDFParseException.getColumnNumber());
                            rDFParseException2.initCause((Throwable)rDFParseException);
                            throw rDFParseException2;
                        }
                        finally {
                            zipInputStream.closeEntry();
                        }
                    }
                    zipEntry = zipInputStream.getNextEntry();
                }
            }
            finally {
                zipInputStream.close();
            }
            if (bl) {
                this.commit();
            }
        }
        finally {
            if (bl && !this.isAutoCommit()) {
                this.rollback();
            }
        }
    }

    public void add(Reader reader, String string, RDFFormat rDFFormat, Resource ... resourceArray) throws IOException, RDFParseException, StoreException {
        this.verifyIsOpen();
        this.verifyNotReadOnly();
        if (this.repository.isReadOnly()) {
            throw new StoreException("Repository is ReadOnly");
        }
        this.sendDelayAdd();
        final boolean bl = resourceArray != null && resourceArray.length == 0;
        boolean bl2 = this.isAutoCommit();
        if (bl2) {
            this.begin();
        }
        try {
            RDFParser rDFParser = Rio.createParser((RDFFormat)rDFFormat, (ValueFactory)this.getValueFactory());
            rDFParser.setVerifyData(true);
            rDFParser.setStopAtFirstError(true);
            rDFParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
            final PreparedStatement preparedStatement = this.prepareStatement(S_INSERT);
            final Resource[] resourceArray2 = this.checkDMLContext(resourceArray);
            RDFHandlerBase rDFHandlerBase = new RDFHandlerBase(){
                int count = 0;

                public void startRDF() {
                }

                public void endRDF() throws RDFHandlerException {
                    try {
                        if (this.count > 0) {
                            preparedStatement.executeBatch();
                            preparedStatement.clearBatch();
                            this.count = 0;
                        }
                    }
                    catch (SQLException sQLException) {
                        throw new RDFHandlerException("Problem executing query: ", (Throwable)sQLException);
                    }
                }

                public void handleNamespace(String string, String string2) throws RDFHandlerException {
                    String string3 = "DB.DBA.XML_SET_NS_DECL(?, ?, 1)";
                    try {
                        PreparedStatement preparedStatement2 = VirtuosoRepositoryConnection.this.prepareStatement(string3);
                        preparedStatement2.setString(1, string);
                        preparedStatement2.setString(2, string2);
                        preparedStatement2.execute();
                    }
                    catch (SQLException sQLException) {
                        throw new RDFHandlerException("Problem executing query: " + string3, (Throwable)sQLException);
                    }
                }

                public void handleStatement(Statement statement) throws RDFHandlerException {
                    try {
                        Resource[] resourceArray = statement.getContext() != null && bl ? new Resource[]{statement.getContext()} : resourceArray2;
                        for (int i = 0; i < resourceArray.length; ++i) {
                            preparedStatement.setString(1, resourceArray[i].stringValue());
                            VirtuosoRepositoryConnection.this.bindResource(preparedStatement, 2, statement.getSubject());
                            VirtuosoRepositoryConnection.this.bindURI(preparedStatement, 3, statement.getPredicate());
                            VirtuosoRepositoryConnection.this.bindValue(preparedStatement, 4, statement.getObject());
                            preparedStatement.addBatch();
                            ++this.count;
                        }
                        if (this.count > 5000) {
                            preparedStatement.executeBatch();
                            preparedStatement.clearBatch();
                            this.count = 0;
                        }
                    }
                    catch (Exception exception) {
                        throw new RDFHandlerException((Throwable)exception);
                    }
                }
            };
            rDFParser.setRDFHandler((RDFHandler)rDFHandlerBase);
            rDFParser.parse(reader, string);
            if (bl2) {
                this.commit();
            }
        }
        catch (Exception exception) {
            if (bl2) {
                this.rollback();
            }
            throw new StoreException("Problem parsing triples", (Throwable)exception);
        }
        finally {
            if (bl2 && !this.isAutoCommit()) {
                this.rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(URL uRL, String string, RDFFormat rDFFormat, Resource ... resourceArray) throws IOException, RDFParseException, StoreException {
        if (string == null) {
            string = uRL.toExternalForm();
        }
        if (rDFFormat == null) {
            rDFFormat = Rio.getParserFormatForFileName((String)uRL.getPath());
        }
        InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
        try {
            this.add(inputStreamReader, string, rDFFormat, resourceArray);
        }
        finally {
            ((Reader)inputStreamReader).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(File file, String string, RDFFormat rDFFormat, Resource ... resourceArray) throws IOException, RDFParseException, StoreException {
        if (string == null) {
            string = file.toURI().toString();
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            this.add(fileInputStream, string, rDFFormat, resourceArray);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    public void add(Resource resource, URI uRI, Value value, Resource ... resourceArray) throws StoreException {
        resourceArray = this.checkDMLContext(resourceArray);
        this.addToQuadStore(resource, uRI, value, resourceArray);
    }

    public void add(Statement statement, Resource ... resourceArray) throws StoreException {
        if (resourceArray != null && resourceArray.length == 0 && statement.getContext() != null) {
            resourceArray = new Resource[]{statement.getContext()};
        }
        this.add(statement.getSubject(), statement.getPredicate(), statement.getObject(), resourceArray);
    }

    public void add(Iterable<? extends Statement> iterable, Resource ... resourceArray) throws StoreException {
        this.verifyIsOpen();
        this.verifyNotReadOnly();
        if (this.repository.isReadOnly()) {
            throw new StoreException("Repository is ReadOnly");
        }
        this.sendDelayAdd();
        Iterator<? extends Statement> iterator = iterable.iterator();
        boolean bl = resourceArray != null && resourceArray.length == 0;
        Resource[] resourceArray2 = this.checkDMLContext(resourceArray);
        boolean bl2 = this.isAutoCommit();
        if (bl2) {
            this.begin();
        }
        try {
            PreparedStatement preparedStatement = this.prepareStatement(S_INSERT);
            int n = 0;
            while (iterator.hasNext()) {
                Statement statement = iterator.next();
                resourceArray = statement.getContext() != null && bl ? new Resource[]{statement.getContext()} : resourceArray2;
                for (int i = 0; i < resourceArray.length; ++i) {
                    preparedStatement.setString(1, resourceArray[i].stringValue());
                    this.bindResource(preparedStatement, 2, statement.getSubject());
                    this.bindURI(preparedStatement, 3, statement.getPredicate());
                    this.bindValue(preparedStatement, 4, statement.getObject());
                    preparedStatement.addBatch();
                    ++n;
                }
                if (n <= 5000) continue;
                preparedStatement.executeBatch();
                preparedStatement.clearBatch();
                n = 0;
            }
            if (n > 0) {
                preparedStatement.executeBatch();
                preparedStatement.clearBatch();
            }
            if (bl2) {
                this.commit();
            }
        }
        catch (SQLException sQLException) {
            if (bl2) {
                this.rollback();
            }
            throw new StoreException((Throwable)sQLException);
        }
        finally {
            if (bl2 && !this.isAutoCommit()) {
                this.rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Cursor<? extends Statement> cursor, Resource ... resourceArray) throws StoreException {
        this.verifyIsOpen();
        this.verifyNotReadOnly();
        if (this.repository.isReadOnly()) {
            throw new StoreException("Repository is ReadOnly");
        }
        this.sendDelayAdd();
        boolean bl = resourceArray != null && resourceArray.length == 0;
        Resource[] resourceArray2 = this.checkDMLContext(resourceArray);
        boolean bl2 = this.isAutoCommit();
        if (bl2) {
            this.begin();
        }
        try {
            Statement statement;
            PreparedStatement preparedStatement = this.prepareStatement(S_INSERT);
            int n = 0;
            while ((statement = (Statement)cursor.next()) != null) {
                resourceArray = statement.getContext() != null && bl ? new Resource[]{statement.getContext()} : resourceArray2;
                for (int i = 0; i < resourceArray.length; ++i) {
                    preparedStatement.setString(1, resourceArray[i].stringValue());
                    this.bindResource(preparedStatement, 2, statement.getSubject());
                    this.bindURI(preparedStatement, 3, statement.getPredicate());
                    this.bindValue(preparedStatement, 4, statement.getObject());
                    preparedStatement.addBatch();
                    ++n;
                }
                if (n <= 5000) continue;
                preparedStatement.executeBatch();
                preparedStatement.clearBatch();
                n = 0;
            }
            if (n > 0) {
                preparedStatement.executeBatch();
                preparedStatement.clearBatch();
            }
            if (bl2) {
                this.commit();
            }
        }
        catch (SQLException sQLException) {
            if (bl2) {
                this.rollback();
            }
            throw new StoreException((Throwable)sQLException);
        }
        finally {
            try {
                if (bl2 && !this.isAutoCommit()) {
                    this.rollback();
                }
            }
            finally {
                cursor.close();
            }
        }
    }

    @Deprecated
    public void remove(Resource resource, URI uRI, Value value, Resource ... resourceArray) throws StoreException {
        this.removeMatch(resource, uRI, value, resourceArray);
    }

    public void removeMatch(Resource resource, URI uRI, Value value, Resource ... resourceArray) throws StoreException {
        this.verifyContextNotNull(resourceArray);
        this.verifyIsOpen();
        this.verifyNotReadOnly();
        if (this.repository.isReadOnly()) {
            throw new StoreException("Repository is ReadOnly");
        }
        this.flushDelayAdd();
        resourceArray = this.checkDMLContext(resourceArray);
        boolean bl = this.isAutoCommit();
        if (bl) {
            this.begin();
        }
        try {
            for (int i = 0; i < resourceArray.length; ++i) {
                this.removeContext(resource, uRI, value, resourceArray[i]);
            }
            if (bl) {
                this.commit();
            }
        }
        catch (StoreException storeException) {
            if (bl) {
                this.rollback();
            }
            throw storeException;
        }
        finally {
            if (bl && !this.isAutoCommit()) {
                this.rollback();
            }
        }
    }

    public void remove(Statement statement, Resource ... resourceArray) throws StoreException {
        if (resourceArray != null && resourceArray.length == 0 && statement.getContext() != null) {
            resourceArray = new Resource[]{statement.getContext()};
        }
        this.remove(statement.getSubject(), statement.getPredicate(), statement.getObject(), resourceArray);
    }

    public void remove(Iterable<? extends Statement> iterable, Resource ... resourceArray) throws StoreException {
        this.verifyContextNotNull(resourceArray);
        this.verifyIsOpen();
        this.verifyNotReadOnly();
        if (this.repository.isReadOnly()) {
            throw new StoreException("Repository is ReadOnly");
        }
        this.flushDelayAdd();
        Iterator<? extends Statement> iterator = iterable.iterator();
        boolean bl = this.isAutoCommit();
        if (bl) {
            this.begin();
        }
        try {
            while (iterator.hasNext()) {
                Statement statement = iterator.next();
                Resource[] resourceArray2 = resourceArray != null && resourceArray.length == 0 && statement.getContext() != null ? new Resource[]{statement.getContext()} : resourceArray;
                resourceArray2 = this.checkDMLContext(resourceArray2);
                for (int i = 0; i < resourceArray2.length; ++i) {
                    this.removeContext(statement.getSubject(), statement.getPredicate(), statement.getObject(), resourceArray2[i]);
                }
            }
            if (bl) {
                this.commit();
            }
        }
        catch (StoreException storeException) {
            if (bl) {
                this.rollback();
            }
            throw storeException;
        }
        catch (RuntimeException runtimeException) {
            if (bl) {
                this.rollback();
            }
            throw runtimeException;
        }
        finally {
            if (bl && !this.isAutoCommit()) {
                this.rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Cursor<? extends Statement> cursor, Resource ... resourceArray) throws StoreException {
        this.verifyContextNotNull(resourceArray);
        this.verifyIsOpen();
        this.verifyNotReadOnly();
        if (this.repository.isReadOnly()) {
            throw new StoreException("Repository is ReadOnly");
        }
        this.flushDelayAdd();
        boolean bl = this.isAutoCommit();
        if (bl) {
            this.begin();
        }
        try {
            Statement statement;
            while ((statement = (Statement)cursor.next()) != null) {
                this.remove(statement, resourceArray);
            }
            if (bl) {
                this.commit();
            }
        }
        catch (StoreException storeException) {
            if (bl) {
                this.rollback();
            }
            throw storeException;
        }
        catch (RuntimeException runtimeException) {
            if (bl) {
                this.rollback();
            }
            throw runtimeException;
        }
        finally {
            try {
                if (bl && !this.isAutoCommit()) {
                    this.rollback();
                }
            }
            finally {
                cursor.close();
            }
        }
    }

    public void clear(Resource ... resourceArray) throws StoreException {
        this.verifyContextNotNull(resourceArray);
        this.verifyIsOpen();
        this.verifyNotReadOnly();
        if (this.repository.isReadOnly()) {
            throw new StoreException("Repository is ReadOnly");
        }
        this.flushDelayAdd();
        resourceArray = this.checkDMLContext(resourceArray);
        boolean bl = this.isAutoCommit();
        if (bl) {
            this.begin();
        }
        try {
            this.clearQuadStore(resourceArray);
            if (bl) {
                this.commit();
            }
        }
        catch (StoreException storeException) {
            if (bl) {
                this.rollback();
            }
            throw storeException;
        }
        catch (RuntimeException runtimeException) {
            if (bl) {
                this.rollback();
            }
            throw runtimeException;
        }
        finally {
            if (bl && !this.isAutoCommit()) {
                this.rollback();
            }
        }
    }

    public NamespaceResult getNamespaces() throws StoreException {
        this.verifyIsOpen();
        this.flushDelayAdd();
        LinkedList<NamespaceImpl> linkedList = new LinkedList<NamespaceImpl>();
        String string = "DB.DBA.XML_SELECT_ALL_NS_DECLS (3)";
        try {
            java.sql.Statement statement = this.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                if (string3 == null || string2 == null) continue;
                NamespaceImpl namespaceImpl = new NamespaceImpl(string2, string3);
                linkedList.add(namespaceImpl);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            throw new StoreException((Throwable)sQLException);
        }
        return new NamespaceResultImpl((Cursor)new CollectionCursor(linkedList));
    }

    public String getNamespace(String string) throws StoreException {
        this.verifyIsOpen();
        this.flushDelayAdd();
        String string2 = null;
        String string3 = "SELECT __xml_get_ns_uri (?, 3)";
        try {
            PreparedStatement preparedStatement = this.prepareStatement(string3);
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string2 = resultSet.getString(1);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            throw new StoreException((Throwable)sQLException);
        }
        return string2;
    }

    public void setNamespace(String string, String string2) throws StoreException {
        this.verifyIsOpen();
        this.flushDelayAdd();
        if (this.repository.isReadOnly()) {
            throw new StoreException("Repository is ReadOnly");
        }
        String string3 = "DB.DBA.XML_SET_NS_DECL(?, ?, 1)";
        try {
            PreparedStatement preparedStatement = this.prepareStatement(string3);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            throw new StoreException("Problem executing query: " + string3, (Throwable)sQLException);
        }
    }

    public void removeNamespace(String string) throws StoreException {
        this.verifyIsOpen();
        this.verifyNotReadOnly();
        if (this.repository.isReadOnly()) {
            throw new StoreException("Repository is ReadOnly");
        }
        this.flushDelayAdd();
        String string2 = "DB.DBA.XML_REMOVE_NS_BY_PREFIX(?, 1)";
        try {
            PreparedStatement preparedStatement = this.prepareStatement(string2);
            preparedStatement.setString(1, string);
            preparedStatement.execute(string2);
        }
        catch (SQLException sQLException) {
            throw new StoreException("Problem executing query: " + string2, (Throwable)sQLException);
        }
    }

    public void clearNamespaces() throws StoreException {
        this.verifyIsOpen();
        this.verifyNotReadOnly();
        if (this.repository.isReadOnly()) {
            throw new StoreException("Repository is ReadOnly");
        }
        this.flushDelayAdd();
        String string = "DB.DBA.XML_CLEAR_ALL_NS_DECLS()";
        try {
            java.sql.Statement statement = this.createStatement();
            statement.execute(string);
        }
        catch (SQLException sQLException) {
            throw new StoreException("Problem executing query: " + string, (Throwable)sQLException);
        }
    }

    protected TupleResult executeSPARQLForTupleResult(String string, Dataset dataset, boolean bl, BindingSet bindingSet) throws StoreException {
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            this.verifyIsOpen();
            this.flushDelayAdd();
            java.sql.Statement statement = this.createStatement();
            ResultSet resultSet = statement.executeQuery(this.fixQuery(string, dataset, bl, bindingSet));
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                String string2 = resultSetMetaData.getColumnName(i);
                if (linkedList.indexOf(string2) >= 0) continue;
                linkedList.add(string2);
            }
            return new TupleResultImpl(linkedList, (Cursor)new CursorBindingSet(resultSet));
        }
        catch (SQLException sQLException) {
            throw new StoreException(": SPARQL execute failed:[" + string + "] \n Exception:" + sQLException);
        }
    }

    protected GraphResult executeSPARQLForGraphResult(String string, Dataset dataset, boolean bl, BindingSet bindingSet) throws StoreException {
        try {
            this.verifyIsOpen();
            this.flushDelayAdd();
            java.sql.Statement statement = this.createStatement();
            ResultSet resultSet = statement.executeQuery(this.fixQuery(string, dataset, bl, bindingSet));
            return new GraphResultImpl(new HashMap(), (Cursor)new CursorGraphResult(resultSet));
        }
        catch (SQLException sQLException) {
            throw new StoreException(": SPARQL execute failed:[" + string + "] \n Exception:" + sQLException);
        }
    }

    protected boolean executeSPARQLForBooleanResult(String string, Dataset dataset, boolean bl, BindingSet bindingSet) throws StoreException {
        boolean bl2 = false;
        try {
            this.verifyIsOpen();
            this.flushDelayAdd();
            java.sql.Statement statement = this.createStatement();
            ResultSet resultSet = statement.executeQuery(this.fixQuery(string, dataset, bl, bindingSet));
            while (resultSet.next()) {
                if (resultSet.getInt(1) != 1) continue;
                bl2 = true;
            }
            statement.close();
            return bl2;
        }
        catch (SQLException sQLException) {
            throw new StoreException(": SPARQL execute failed:[" + string + "] \n Exception:" + sQLException);
        }
    }

    public int executeSPARUL(String string) throws StoreException {
        this.verifyIsOpen();
        this.verifyNotReadOnly();
        if (this.repository.isReadOnly()) {
            throw new StoreException("Repository is ReadOnly");
        }
        try {
            this.flushDelayAdd();
            java.sql.Statement statement = this.createStatement();
            statement.execute("sparql\n " + string);
            return statement.getUpdateCount();
        }
        catch (SQLException sQLException) {
            throw new StoreException((Throwable)sQLException);
        }
    }

    public Connection getQuadStoreConnection() {
        return this.quadStoreConnection;
    }

    public void setQuadStoreConnection(Connection connection) {
        this.quadStoreConnection = connection;
    }

    private java.sql.Statement createStatement() throws SQLException {
        java.sql.Statement statement = this.quadStoreConnection.createStatement();
        int n = this.repository.getQueryTimeout();
        if (n > 0) {
            statement.setQueryTimeout(n);
        }
        statement.setFetchSize(this.prefetchSize);
        return statement;
    }

    private PreparedStatement prepareStatement(String string) throws SQLException {
        PreparedStatement preparedStatement = this.quadStoreConnection.prepareStatement(string);
        int n = this.repository.getQueryTimeout();
        if (n > 0) {
            preparedStatement.setQueryTimeout(n);
        }
        preparedStatement.setFetchSize(this.prefetchSize);
        return preparedStatement;
    }

    private String substBindings(String string, BindingSet bindingSet) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = " ,)(;.";
        int n = 0;
        int n2 = string.length();
        block0: while (n < n2) {
            char c;
            if ((c = string.charAt(n++)) == '\\') {
                stringBuffer.append(c);
                if (n >= n2) continue;
                stringBuffer.append(string.charAt(n++));
                continue;
            }
            if (c == '\"' || c == '\'') {
                char c2 = c;
                stringBuffer.append(c);
                while (n < n2) {
                    c = string.charAt(n++);
                    stringBuffer.append(c);
                    if (c != c2) continue;
                    continue block0;
                }
                continue;
            }
            if (c == '?') {
                String string3;
                Value value;
                int n3;
                String string4 = null;
                for (n3 = n; n3 < n2 && string2.indexOf(string.charAt(n3)) < 0; ++n3) {
                }
                if (n3 != n && (value = bindingSet.getValue(string3 = string.substring(n, n3))) != null) {
                    string4 = this.stringForValue(value);
                    n = n3;
                }
                if (string4 != null) {
                    stringBuffer.append(string4);
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private String fixQuery(String string, Dataset dataset, boolean bl, BindingSet bindingSet) {
        StringBuffer stringBuffer = new StringBuffer("sparql\n ");
        if (bl && this.repository.ruleSet != null && this.repository.ruleSet.length() > 0) {
            stringBuffer.append("define input:inference '" + this.repository.ruleSet + "'\n ");
        }
        if (dataset != null) {
            Set set = dataset.getDefaultGraphs();
            if (set != null) {
                for (URI uRI : set) {
                    stringBuffer.append(" define input:default-graph-uri <" + uRI.stringValue() + "> \n");
                }
            }
            if ((set = dataset.getNamedGraphs()) != null) {
                for (URI uRI : set) {
                    stringBuffer.append(" define input:named-graph-uri <" + uRI.stringValue() + "> \n");
                }
            }
        }
        stringBuffer.append(this.substBindings(string, bindingSet));
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToQuadStore(Resource resource, URI uRI, Value value, Resource ... resourceArray) throws StoreException {
        block11: {
            this.verifyIsOpen();
            this.verifyNotReadOnly();
            if (this.repository.isReadOnly()) {
                throw new StoreException("Repository is ReadOnly");
            }
            try {
                boolean bl = this.getQuadStoreConnection().getAutoCommit();
                if (!bl && this.useLazyAdd) {
                    VirtuosoRepositoryConnection virtuosoRepositoryConnection = this;
                    synchronized (virtuosoRepositoryConnection) {
                        if (this.psInsert == null) {
                            this.psInsert = this.prepareStatement(S_INSERT);
                        }
                        for (int i = 0; i < resourceArray.length; ++i) {
                            this.psInsert.setString(1, resourceArray[i].stringValue());
                            this.bindResource(this.psInsert, 2, resource);
                            this.bindURI(this.psInsert, 3, uRI);
                            this.bindValue(this.psInsert, 4, value);
                            this.psInsert.addBatch();
                            ++this.psInsertCount;
                        }
                        if (this.psInsertCount >= 5000) {
                            this.psInsert.executeBatch();
                            this.psInsert.clearBatch();
                            this.psInsertCount = 0;
                        }
                        break block11;
                    }
                }
                PreparedStatement preparedStatement = this.prepareStatement(S_INSERT);
                for (int i = 0; i < resourceArray.length; ++i) {
                    preparedStatement.setString(1, resourceArray[i].stringValue());
                    this.bindResource(preparedStatement, 2, resource);
                    this.bindURI(preparedStatement, 3, uRI);
                    this.bindValue(preparedStatement, 4, value);
                    preparedStatement.addBatch();
                }
                preparedStatement.executeBatch();
                preparedStatement.clearBatch();
            }
            catch (SQLException sQLException) {
                throw new StoreException((Throwable)sQLException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDelayAdd() throws StoreException {
        VirtuosoRepositoryConnection virtuosoRepositoryConnection = this;
        synchronized (virtuosoRepositoryConnection) {
            try {
                if (this.psInsertCount >= 5000 && this.psInsert != null) {
                    this.psInsert.executeBatch();
                    this.psInsert.clearBatch();
                    this.psInsertCount = 0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushDelayAdd() throws StoreException {
        VirtuosoRepositoryConnection virtuosoRepositoryConnection = this;
        synchronized (virtuosoRepositoryConnection) {
            try {
                if (this.psInsertCount > 0 && this.psInsert != null) {
                    this.psInsert.executeBatch();
                    this.psInsert.clearBatch();
                    this.psInsertCount = 0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropDelayAdd() throws StoreException {
        VirtuosoRepositoryConnection virtuosoRepositoryConnection = this;
        synchronized (virtuosoRepositoryConnection) {
            try {
                if (this.psInsertCount >= 5000 && this.psInsert != null) {
                    this.psInsert.clearBatch();
                    this.psInsertCount = 0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void clearQuadStore(Resource[] resourceArray) throws StoreException {
        String string = "sparql clear graph iri(??)";
        if (resourceArray != null && resourceArray.length > 0) {
            try {
                PreparedStatement preparedStatement = this.prepareStatement(string);
                for (int i = 0; i < resourceArray.length; ++i) {
                    preparedStatement.setString(1, resourceArray[i].stringValue());
                    preparedStatement.execute();
                }
            }
            catch (SQLException sQLException) {
                throw new StoreException((Throwable)sQLException);
            }
        }
    }

    private long selectCountFromQuadStore(Resource resource, URI uRI, Value value, boolean bl, Resource ... resourceArray) throws StoreException {
        this.verifyIsOpen();
        this.flushDelayAdd();
        String string = "?s";
        String string2 = "?p";
        String string3 = "?o";
        long l = 0L;
        if (resource != null) {
            string = this.stringForResource(resource);
        }
        if (uRI != null) {
            string2 = this.stringForURI(uRI);
        }
        if (value != null) {
            string3 = this.stringForValue(value);
        }
        StringBuffer stringBuffer = new StringBuffer("select count(*) from (sparql define input:storage \"\" select * ");
        for (int i = 0; i < resourceArray.length; ++i) {
            stringBuffer.append("from named <");
            stringBuffer.append(resourceArray[i].stringValue());
            stringBuffer.append("> ");
        }
        stringBuffer.append("where { graph ?g {");
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        stringBuffer.append(" ");
        stringBuffer.append(string3);
        stringBuffer.append(" }})f");
        try {
            java.sql.Statement statement = this.createStatement();
            ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet.next()) {
                l = resultSet.getLong(1);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            throw new StoreException(this.getClass().getCanonicalName() + ": SPARQL execute failed." + "\n" + stringBuffer.toString() + "[" + sQLException + "]", (Throwable)sQLException);
        }
        return l;
    }

    private Cursor<Statement> selectFromQuadStore(Resource resource, URI uRI, Value value, boolean bl, boolean bl2, Resource ... resourceArray) throws StoreException {
        this.verifyIsOpen();
        this.flushDelayAdd();
        ResultSet resultSet = null;
        String string = "?s";
        String string2 = "?p";
        String string3 = "?o";
        if (resource != null) {
            string = this.stringForResource(resource);
        }
        if (uRI != null) {
            string2 = this.stringForURI(uRI);
        }
        if (value != null) {
            string3 = this.stringForValue(value);
        }
        StringBuffer stringBuffer = new StringBuffer("sparql select * ");
        for (int i = 0; i < resourceArray.length; ++i) {
            stringBuffer.append("from named <");
            stringBuffer.append(resourceArray[i].stringValue());
            stringBuffer.append("> ");
        }
        stringBuffer.append("where { graph ?g {");
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        stringBuffer.append(" ");
        stringBuffer.append(string3);
        stringBuffer.append(" }}");
        if (bl2) {
            stringBuffer.append(" LIMIT 1");
        }
        try {
            java.sql.Statement statement = this.createStatement();
            resultSet = statement.executeQuery(stringBuffer.toString());
        }
        catch (SQLException sQLException) {
            throw new StoreException(this.getClass().getCanonicalName() + ": SPARQL execute failed." + "\n" + stringBuffer.toString() + "[" + sQLException + "]", (Throwable)sQLException);
        }
        return new CursorStmt(resultSet, resource, uRI, value);
    }

    private void removeContext(Resource resource, URI uRI, Value value, Resource resource2) throws StoreException {
        PreparedStatement preparedStatement = null;
        String string = "?s";
        String string2 = "?p";
        String string3 = "?o";
        try {
            if (resource == null && uRI == null && value == null && resource2 != null) {
                String string4 = "sparql clear graph iri(??)";
                preparedStatement = this.prepareStatement(string4);
                preparedStatement.setString(1, resource2.stringValue());
                preparedStatement.execute();
            } else if (resource != null && uRI != null && value != null && resource2 != null) {
                preparedStatement = this.prepareStatement(S_DELETE);
                preparedStatement.setString(1, resource2.stringValue());
                this.bindResource(preparedStatement, 2, resource);
                this.bindURI(preparedStatement, 3, uRI);
                this.bindValue(preparedStatement, 4, value);
                preparedStatement.execute();
            } else {
                if (resource != null) {
                    string = this.stringForResource(resource);
                }
                if (uRI != null) {
                    string2 = this.stringForURI(uRI);
                }
                if (value != null) {
                    string3 = this.stringForValue(value);
                }
                String string5 = "sparql delete from graph <" + resource2 + "> { " + string + " " + string2 + " " + string3 + " } from <" + resource2 + "> where { " + string + " " + string2 + " " + string3 + " }";
                java.sql.Statement statement = this.createStatement();
                statement.execute(string5);
            }
        }
        catch (SQLException sQLException) {
            throw new StoreException((Throwable)sQLException);
        }
    }

    private void bindResource(PreparedStatement preparedStatement, int n, Resource resource) throws SQLException {
        if (resource == null) {
            return;
        }
        if (resource instanceof URI) {
            preparedStatement.setString(n, resource.stringValue());
        } else if (resource instanceof BNode) {
            preparedStatement.setString(n, "_:" + ((BNode)resource).getID());
        } else {
            preparedStatement.setString(n, resource.stringValue());
        }
    }

    private void bindURI(PreparedStatement preparedStatement, int n, URI uRI) throws SQLException {
        if (uRI == null) {
            return;
        }
        preparedStatement.setString(n, uRI.stringValue());
    }

    private void bindValue(PreparedStatement preparedStatement, int n, Value value) throws SQLException {
        if (value == null) {
            return;
        }
        if (value instanceof URI) {
            preparedStatement.setInt(n, 1);
            preparedStatement.setString(n + 1, value.stringValue());
            preparedStatement.setNull(n + 2, 12);
        } else if (value instanceof BNode) {
            preparedStatement.setInt(n, 1);
            preparedStatement.setString(n + 1, "_:" + ((BNode)value).getID());
            preparedStatement.setNull(n + 2, 12);
        } else if (value instanceof Literal) {
            Literal literal = (Literal)value;
            if (literal.getLanguage() != null) {
                preparedStatement.setInt(n, 5);
                preparedStatement.setString(n + 1, literal.stringValue());
                preparedStatement.setString(n + 2, literal.getLanguage());
            } else if (literal.getDatatype() != null) {
                preparedStatement.setInt(n, 4);
                preparedStatement.setString(n + 1, literal.stringValue());
                preparedStatement.setString(n + 2, literal.getDatatype().toString());
            } else {
                preparedStatement.setInt(n, 3);
                preparedStatement.setString(n + 1, value.stringValue());
                preparedStatement.setNull(n + 2, 12);
            }
        } else {
            preparedStatement.setInt(n, 3);
            preparedStatement.setString(n + 1, value.stringValue());
            preparedStatement.setNull(n + 2, 12);
        }
    }

    private String escapeString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c;
            if ((c = string.charAt(n++)) == '\'') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private String stringForResource(Resource resource) {
        if (resource instanceof URI) {
            return this.stringForURI((URI)resource);
        }
        if (resource instanceof BNode) {
            return this.stringForBNode((BNode)resource);
        }
        return "<" + resource.stringValue() + ">";
    }

    private String stringForURI(URI uRI) {
        return "<" + uRI.stringValue() + ">";
    }

    private String stringForBNode(BNode bNode) {
        return "<_:" + bNode.getID() + ">";
    }

    private String stringForValue(Value value) {
        if (value instanceof Resource) {
            return this.stringForResource((Resource)value);
        }
        if (value instanceof Literal) {
            Literal literal = (Literal)value;
            String string = "'" + this.escapeString(literal.stringValue()) + "'";
            if (literal.getLanguage() != null) {
                return string + "@" + literal.getLanguage();
            }
            if (literal.getDatatype() != null) {
                return string + "^^<" + literal.getDatatype() + ">";
            }
            return string;
        }
        return "'" + this.escapeString(value.stringValue()) + "'";
    }

    private Value castValue(Object object) throws StoreException {
        if (object == null) {
            return null;
        }
        if (object instanceof ExtendedString) {
            ExtendedString extendedString = (ExtendedString)object;
            String string = extendedString.toString();
            if (extendedString.getIriType() == 1 && (extendedString.getStrType() & 1) == 1) {
                if (string.startsWith("_:")) {
                    string = string.substring(2);
                    return this.getValueFactory().createBNode(string);
                }
                try {
                    if (string.indexOf(58) < 0) {
                        return this.getValueFactory().createURI(":" + string);
                    }
                    return this.getValueFactory().createURI(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new StoreException("VirtuosoRepositoryConnection().castValue() Invalid value from Virtuoso: \"" + string + "\"", (Throwable)illegalArgumentException);
                }
            }
            if (extendedString.getIriType() == 2) {
                try {
                    string = string.substring(9);
                    return this.getValueFactory().createBNode(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new StoreException("VirtuosoRepositoryConnection().castValue() Invalid value from Virtuoso: \"" + string + "\"", (Throwable)illegalArgumentException);
                }
            }
            try {
                return this.getValueFactory().createLiteral(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new StoreException("VirtuosoRepositoryConnection().castValue() Invalid value from Virtuoso: \"" + string + "\", STRTYPE = " + extendedString.getIriType(), (Throwable)illegalArgumentException);
            }
        }
        if (object instanceof RdfBox) {
            RdfBox rdfBox = (RdfBox)object;
            if (rdfBox.getLang() != null) {
                return this.getValueFactory().createLiteral(rdfBox.toString(), rdfBox.getLang());
            }
            if (rdfBox.getType() != null) {
                return this.getValueFactory().createLiteral(rdfBox.toString(), this.getValueFactory().createURI(rdfBox.getType()));
            }
            return this.getValueFactory().createLiteral(rdfBox.toString());
        }
        if (object instanceof Integer) {
            return this.getValueFactory().createLiteral(((Integer)object).intValue());
        }
        if (object instanceof Short) {
            return this.getValueFactory().createLiteral(((Short)object).intValue());
        }
        if (object instanceof Float) {
            return this.getValueFactory().createLiteral(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return this.getValueFactory().createLiteral(((Double)object).doubleValue());
        }
        if (object instanceof BigDecimal) {
            URI uRI = this.getValueFactory().createURI("http://www.w3.org/2001/XMLSchema#decimal");
            return this.getValueFactory().createLiteral(object.toString(), uRI);
        }
        if (object instanceof Blob) {
            URI uRI = this.getValueFactory().createURI("http://www.w3.org/2001/XMLSchema#hexBinary");
            return this.getValueFactory().createLiteral(object.toString(), uRI);
        }
        if (object instanceof Date) {
            URI uRI = this.getValueFactory().createURI("http://www.w3.org/2001/XMLSchema#date");
            return this.getValueFactory().createLiteral(object.toString(), uRI);
        }
        if (object instanceof Timestamp) {
            URI uRI = this.getValueFactory().createURI("http://www.w3.org/2001/XMLSchema#dateTime");
            return this.getValueFactory().createLiteral(this.Timestamp2String((Timestamp)object), uRI);
        }
        if (object instanceof Time) {
            URI uRI = this.getValueFactory().createURI("http://www.w3.org/2001/XMLSchema#time");
            return this.getValueFactory().createLiteral(object.toString(), uRI);
        }
        try {
            return this.getValueFactory().createLiteral((String)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new StoreException("VirtuosoRepositoryConnection().castValue() Could not parse resource: " + object, (Throwable)illegalArgumentException);
        }
    }

    private void verifyIsOpen() throws StoreException {
        try {
            if (this.getQuadStoreConnection().isClosed()) {
                throw new StoreException("Connection has been closed");
            }
        }
        catch (SQLException sQLException) {
            throw new StoreException((Throwable)sQLException);
        }
    }

    private String Timestamp2String(Timestamp timestamp) {
        String string;
        String string2;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(timestamp);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        int n7 = timestamp.getNanos();
        String string3 = "000000000";
        String string4 = "0000";
        if (n < 1000) {
            string2 = "" + n;
            string2 = string4.substring(0, 4 - string2.length()) + string2;
        } else {
            string2 = "" + n;
        }
        String string5 = n2 < 10 ? "0" + n2 : Integer.toString(n2);
        String string6 = n3 < 10 ? "0" + n3 : Integer.toString(n3);
        String string7 = n4 < 10 ? "0" + n4 : Integer.toString(n4);
        String string8 = n5 < 10 ? "0" + n5 : Integer.toString(n5);
        String string9 = n6 < 10 ? "0" + n6 : Integer.toString(n6);
        if (n7 == 0) {
            string = "0";
        } else {
            string = Integer.toString(n7);
            string = string3.substring(0, 9 - string.length()) + string;
            char[] cArray = new char[string.length()];
            string.getChars(0, string.length(), cArray, 0);
            int n8 = 8;
            while (cArray[n8] == '0') {
                --n8;
            }
            string = new String(cArray, 0, n8 + 1);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append("-");
        stringBuffer.append(string5);
        stringBuffer.append("-");
        stringBuffer.append(string6);
        stringBuffer.append("T");
        stringBuffer.append(string7);
        stringBuffer.append(":");
        stringBuffer.append(string8);
        stringBuffer.append(":");
        stringBuffer.append(string9);
        stringBuffer.append(".");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public class CursorGraphResult
    extends CursorBase<Statement> {
        int col_g;
        int col_s;
        int col_p;
        int col_o;

        public CursorGraphResult(ResultSet resultSet) throws StoreException {
            super(resultSet, null, null, null);
            this.col_g = -1;
            this.col_s = -1;
            this.col_p = -1;
            this.col_o = -1;
            try {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    String string = resultSetMetaData.getColumnName(i);
                    if (string.equalsIgnoreCase("G")) {
                        this.col_g = i;
                        continue;
                    }
                    if (string.equalsIgnoreCase("S")) {
                        this.col_s = i;
                        continue;
                    }
                    if (string.equalsIgnoreCase("P")) {
                        this.col_p = i;
                        continue;
                    }
                    if (!string.equalsIgnoreCase("O")) continue;
                    this.col_o = i;
                }
            }
            catch (Exception exception) {
                throw new StoreException((Throwable)exception);
            }
        }

        @Override
        protected void extractRow() throws Exception {
            Resource resource = null;
            URI uRI = null;
            Value value = null;
            Resource resource2 = null;
            if (this.col_s != -1) {
                resource = (Resource)VirtuosoRepositoryConnection.this.castValue(this.v_rs.getObject(this.col_s));
            }
            if (this.col_p != -1) {
                uRI = (URI)VirtuosoRepositoryConnection.this.castValue(this.v_rs.getObject(this.col_p));
            }
            if (this.col_o != -1) {
                value = VirtuosoRepositoryConnection.this.castValue(this.v_rs.getObject(this.col_o));
            }
            if (this.col_g != -1) {
                resource2 = (Resource)VirtuosoRepositoryConnection.this.castValue(this.v_rs.getObject(this.col_g));
            }
            this.v_row = new StatementImpl(resource, uRI, value, resource2);
        }
    }

    public class CursorBindingSet
    extends CursorBase<BindingSet> {
        ResultSetMetaData rsmd;

        public CursorBindingSet(ResultSet resultSet) throws StoreException {
            super(resultSet, null, null, null);
            try {
                this.rsmd = resultSet.getMetaData();
            }
            catch (Exception exception) {
                throw new StoreException((Throwable)exception);
            }
        }

        @Override
        protected void extractRow() throws Exception {
            this.v_row = new QueryBindingSet();
            for (int i = 1; i <= this.rsmd.getColumnCount(); ++i) {
                String string = this.rsmd.getColumnName(i);
                Object object = this.v_rs.getObject(i);
                Value value = VirtuosoRepositoryConnection.this.castValue(object);
                ((QueryBindingSet)this.v_row).setBinding(string, value);
            }
        }
    }

    public class CursorStmt
    extends CursorBase<Statement> {
        int col_g;
        int col_s;
        int col_p;
        int col_o;

        public CursorStmt(ResultSet resultSet, Resource resource, URI uRI, Value value) throws StoreException {
            super(resultSet, resource, uRI, value);
            this.col_g = -1;
            this.col_s = -1;
            this.col_p = -1;
            this.col_o = -1;
            try {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    String string = resultSetMetaData.getColumnName(i);
                    if (string.equalsIgnoreCase("g")) {
                        this.col_g = i;
                        continue;
                    }
                    if (string.equalsIgnoreCase("s")) {
                        this.col_s = i;
                        continue;
                    }
                    if (string.equalsIgnoreCase("p")) {
                        this.col_p = i;
                        continue;
                    }
                    if (!string.equalsIgnoreCase("o")) continue;
                    this.col_o = i;
                }
            }
            catch (Exception exception) {
                throw new StoreException((Throwable)exception);
            }
        }

        @Override
        protected void extractRow() throws Exception {
            Resource resource = null;
            Resource resource2 = this.subject;
            URI uRI = this.predicate;
            Value value = this.object;
            Object object = null;
            try {
                if (this.col_g != -1) {
                    object = this.v_rs.getObject(this.col_g);
                    resource = (Resource)VirtuosoRepositoryConnection.this.castValue(object);
                }
            }
            catch (ClassCastException classCastException) {
                throw new StoreException("Unexpected resource type encountered. Was expecting Resource: " + object, (Throwable)classCastException);
            }
            if (resource2 == null && this.col_s != -1) {
                try {
                    object = this.v_rs.getObject(this.col_s);
                    resource2 = (Resource)VirtuosoRepositoryConnection.this.castValue(object);
                }
                catch (ClassCastException classCastException) {
                    throw new StoreException("Unexpected resource type encountered. Was expecting Resource: " + object, (Throwable)classCastException);
                }
            }
            if (uRI == null && this.col_p != -1) {
                try {
                    object = this.v_rs.getObject(this.col_p);
                    uRI = (URI)VirtuosoRepositoryConnection.this.castValue(object);
                }
                catch (ClassCastException classCastException) {
                    throw new StoreException("Unexpected resource type encountered. Was expecting URI: " + object, (Throwable)classCastException);
                }
            }
            if (value == null && this.col_o != -1) {
                value = VirtuosoRepositoryConnection.this.castValue(this.v_rs.getObject(this.col_o));
            }
            this.v_row = new StatementImpl(resource2, uRI, value, resource);
        }
    }

    public class CursorBase<E>
    implements Cursor<E> {
        E v_row;
        boolean v_finished = false;
        boolean v_prefetched = false;
        Resource subject;
        URI predicate;
        Value object;
        ResultSet v_rs;

        public CursorBase(ResultSet resultSet, Resource resource, URI uRI, Value value) {
            this.v_rs = resultSet;
            this.subject = resource;
            this.predicate = uRI;
            this.object = value;
        }

        public E next() throws StoreException {
            if (!this.v_finished && !this.v_prefetched) {
                this.moveForward();
            }
            this.v_prefetched = false;
            if (this.v_finished) {
                return null;
            }
            return this.v_row;
        }

        public void close() throws StoreException {
            if (!this.v_finished) {
                try {
                    this.v_rs.close();
                }
                catch (SQLException sQLException) {
                    throw new StoreException((Throwable)sQLException);
                }
            }
            this.v_finished = true;
        }

        protected void finalize() throws Throwable {
            if (!this.v_finished) {
                try {
                    this.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        protected void moveForward() throws StoreException {
            try {
                if (!this.v_finished && this.v_rs.next()) {
                    this.extractRow();
                    this.v_prefetched = true;
                } else {
                    this.close();
                }
            }
            catch (Exception exception) {
                throw new StoreException((Throwable)exception);
            }
        }

        protected void extractRow() throws Exception {
        }
    }
}

