# -*- encoding: utf-8 -*-
# REXML is an XML toolkit for Ruby[http://www.ruby-lang.org], in Ruby.
#
# REXML is a _pure_ Ruby, XML 1.0 conforming,
# non-validating[http://www.w3.org/TR/2004/REC-xml-20040204/#sec-conformance]
# toolkit with an intuitive API.  REXML passes 100% of the non-validating Oasis
# tests[http://www.oasis-open.org/committees/xml-conformance/xml-test-suite.shtml],
# and provides tree, stream, SAX2, pull, and lightweight APIs.  REXML also 
# includes a full XPath[http://www.w3c.org/tr/xpath] 1.0 implementation. Since 
# Ruby 1.8, REXML is included in the standard Ruby distribution.
#
# Main page:: http://www.germane-software.com/software/rexml
# Author:: Sean Russell <serATgermaneHYPHENsoftwareDOTcom>
# Version:: 3.1.7.2
# Date:: 2007/275
# Revision:: $Revision: 40812 $
# 
# This API documentation can be downloaded from the REXML home page, or can
# be accessed online[http://www.germane-software.com/software/rexml_doc]
#
# A tutorial is available in the REXML distribution in docs/tutorial.html,
# or can be accessed 
# online[http://www.germane-software.com/software/rexml/docs/tutorial.html]
module REXML
  COPYRIGHT = "Copyright \xC2\xA9 2001-2006 Sean Russell <ser@germane-software.com>"
  VERSION = "3.1.7.3"
  DATE = "2007/275"
  REVISION = "$Revision: 40812 $".gsub(/\$Revision:|\$/,'').strip

  Copyright = COPYRIGHT
  Version = VERSION

  @@entity_expansion_text_limit = 10_240

  # Set the entity expansion limit. By default the limit is set to 10240.
  def self.entity_expansion_text_limit=( val )
    @@entity_expansion_text_limit = val
  end

  # Get the entity expansion limit. By default the limit is set to 10240.
  def self.entity_expansion_text_limit
    return @@entity_expansion_text_limit
  end
end
