<?php
// @codingStandardsIgnoreStart
// {{{ICINGA_LICENSE_HEADER}}}
/**
 * This file is part of Icinga Web 2.
 *
 * Icinga Web 2 - Head for multiple monitoring backends.
 * Copyright (C) 2013 Icinga Development Team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * @copyright  2013 Icinga Development Team <info@icinga.org>
 * @license    http://www.gnu.org/licenses/gpl-2.0.txt GPL, version 2
 * @author     Icinga Development Team <info@icinga.org>
 *
 */
// {{{ICINGA_LICENSE_HEADER}}}

namespace Icinga\Chart\Inline;

use Icinga\Chart\PieChart as PieChartRenderer;
use Imagick;
use Exception;

/**
 * Draw an inline pie-chart directly from the available request parameters.
 */
class PieChart extends Inline
{

    public function render($output = true)
    {
        $pie = new PieChartRenderer();
        $pie->disableLegend();
        $pie->drawPie(array(
            'data' => $this->data, 'colors' => $this->colors, 'labels' => $this->labels
        ));
        $pie->setWidth($this->width)->setHeight($this->height);
        if ($output) {
            echo $pie->render();
        } else {
            return $pie->render();
        }
    }

    public function toPng()
    {
        if (! class_exists('Imagick')) {
            // TODO: This is quick & dirty. 404?
            throw new Exception('Cannot render PNGs without Imagick');
        }
        $image = new Imagick();
        $image->readImageBlob($this->render(false));
        $image->setImageFormat('png24');
        $image->resizeImage($this->width, $this->height, imagick::FILTER_LANCZOS, 1);
        echo $image;
    }
}
