"""Generated message classes for testing version v1.

Allows developers to run automated tests for their mobile applications on
Google infrastructure.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from googlecloudsdk.third_party.apitools.base.protorpclite import messages as _messages
from googlecloudsdk.third_party.apitools.base.py import encoding


package = 'testing'


class AndroidDevice(_messages.Message):
  """A single Android device.

  Fields:
    androidModelId: The id of the Android device to be used. Use the
      EnvironmentDiscoveryService to get supported options. Required
    androidVersionId: The id of the Android OS version to be used. Use the
      EnvironmentDiscoveryService to get supported options. Required
    locale: The locale the test device used for testing. Use the
      EnvironmentDiscoveryService to get supported options. Required
    orientation: How the device is oriented during the test. Use the
      EnvironmentDiscoveryService to get supported options. Required
  """

  androidModelId = _messages.StringField(1)
  androidVersionId = _messages.StringField(2)
  locale = _messages.StringField(3)
  orientation = _messages.StringField(4)


class AndroidDeviceCatalog(_messages.Message):
  """The currently supported Android devices.

  Fields:
    models: The set of supported Android device models. @OutputOnly
    runtimeConfiguration: The set of supported runtime configurations.
      @OutputOnly
    versions: The set of supported Android OS versions. @OutputOnly
  """

  models = _messages.MessageField('AndroidModel', 1, repeated=True)
  runtimeConfiguration = _messages.MessageField('AndroidRuntimeConfiguration', 2)
  versions = _messages.MessageField('AndroidVersion', 3, repeated=True)


class AndroidInstrumentationTest(_messages.Message):
  """A test of an Android application that can control an Android component
  independently of its normal lifecycle. Android instrumentation tests run an
  application APK and test APK inside the same process on a virtual or
  physical AndroidDevice.  They also specify a test runner class, such as
  com.google.GoogleTestRunner, which can vary on the specific instrumentation
  framework chosen.  See
  <http://developer.android.com/tools/testing/testing_android.html> for more
  information on types of Android tests.

  Fields:
    appApk: The APK for the application under test. Required
    appPackageId: The java package for the application under test. Optional,
      default is determined by examining the application's manifest.
    testApk: The APK containing the test code to be executed. Required
    testPackageId: The java package for the test to be executed. Optional,
      default is determined by examining the application's manifest.
    testRunnerClass: The InstrumentationTestRunner class. Optional, default is
      determined by examining the application's manifest.
    testTargets: Each target must be fully qualified with the package name or
      class name, in one of these formats:  - "package package_name"  - "class
      package_name.class_name"  - "class package_name.class_name#method_name"
      If empty, all targets in the module will be run.
  """

  appApk = _messages.MessageField('FileReference', 1)
  appPackageId = _messages.StringField(2)
  testApk = _messages.MessageField('FileReference', 3)
  testPackageId = _messages.StringField(4)
  testRunnerClass = _messages.StringField(5)
  testTargets = _messages.StringField(6, repeated=True)


class AndroidMatrix(_messages.Message):
  """A set of Android device configuration permutations is defined by the the
  cross-product of the given axes.  Internally, the given AndroidMatrix will
  be expanded into a set of AndroidDevices.  Only supported permutations will
  be instantiated.  Invalid permutations (e.g., incompatible models/versions)
  are ignored.

  Fields:
    androidModelIds: The ids of the set of Android device to be used. Use the
      EnvironmentDiscoveryService to get supported options. Required
    androidVersionIds: The ids of the set of Android OS version to be used.
      Use the EnvironmentDiscoveryService to get supported options. Required
    locales: The set of locales the test device will enable for testing. Use
      the EnvironmentDiscoveryService to get supported options. Required
    orientations: The set of orientations to test with. Use the
      EnvironmentDiscoveryService to get supported options. Required
  """

  androidModelIds = _messages.StringField(1, repeated=True)
  androidVersionIds = _messages.StringField(2, repeated=True)
  locales = _messages.StringField(3, repeated=True)
  orientations = _messages.StringField(4, repeated=True)


class AndroidModel(_messages.Message):
  """A description of an Android device tests may be run on.

  Enums:
    FormValueValuesEnum: Whether this device is virtual or physical.
      @OutputOnly

  Fields:
    brand: The company that this device is branded with. Example: "Google",
      "Samsung" @OutputOnly
    codename: The name of the industrial design. This corresponds to
      android.os.Build.DEVICE @OutputOnly
    form: Whether this device is virtual or physical. @OutputOnly
    id: The unique opaque id for this model. Use this for invoking the
      TestExecutionService. @OutputOnly
    manufacturer: The manufacturer of this device. @OutputOnly
    name: The human-readable marketing name for this device model. Examples:
      "Nexus 5", "Galaxy S5" @OutputOnly
    screenX: Screen size in the horizontal (X) dimension measured in pixels.
      @OutputOnly
    screenY: Screen size in the vertical (Y) dimension measured in pixels.
      @OutputOnly
    supportedAbis: The list of supported ABIs for this device. This
      corresponds to either android.os.Build.SUPPORTED_ABIS (for API level 21
      and above) or android.os.Build.CPU_ABI/CPU_ABI2. @OutputOnly
    supportedVersionIds: The set of Android versions this device supports.
      @OutputOnly
    tags: Tags for this dimension. Examples: "default", "preview",
      "deprecated"
  """

  class FormValueValuesEnum(_messages.Enum):
    """Whether this device is virtual or physical. @OutputOnly

    Values:
      DEVICE_FORM_UNSPECIFIED: Do not use.  For proto versioning only.
      VIRTUAL: A software stack that simulates the device
      PHYSICAL: Actual hardware
    """
    DEVICE_FORM_UNSPECIFIED = 0
    VIRTUAL = 1
    PHYSICAL = 2

  brand = _messages.StringField(1)
  codename = _messages.StringField(2)
  form = _messages.EnumField('FormValueValuesEnum', 3)
  id = _messages.StringField(4)
  manufacturer = _messages.StringField(5)
  name = _messages.StringField(6)
  screenX = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  screenY = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  supportedAbis = _messages.StringField(9, repeated=True)
  supportedVersionIds = _messages.StringField(10, repeated=True)
  tags = _messages.StringField(11, repeated=True)


class AndroidMonkeyTest(_messages.Message):
  """A test of an Android application that uses the UI/Application Exerciser
  Monkey from the Android SDK. (Not to be confused with the "monkeyrunner"
  tool, which is also included in the SDK.)  See
  http://developer.android.com/tools/help/monkey.html for details.

  Fields:
    appApk: The APK for the application under test. Required
    appPackageId: The java package for the application under test. Optional,
      default is determined by examining the application's manifest.
    eventCount: Number of random monkey events (e.g. clicks, touches) to
      generate. Defaults to 2000.
    eventDelay: Fixed delay between events. Defaults to 10ms.
    randomSeed: Seed value for pseudo-random number generator. Note that,
      although specifying a seed causes the monkey to generate the same
      sequence of events, it does not guarantee that a particular outcome will
      be reproducible across runs. Optional
  """

  appApk = _messages.MessageField('FileReference', 1)
  appPackageId = _messages.StringField(2)
  eventCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  eventDelay = _messages.StringField(4)
  randomSeed = _messages.IntegerField(5, variant=_messages.Variant.INT32)


class AndroidRoboTest(_messages.Message):
  """A test of an android application that explores the application on a
  virtual or physical Android Device, finding culprits and crashes as it goes.

  Fields:
    appApk: The APK for the application under test. Required
    appInitialActivity: The initial activity that should be used to start the
      app. Optional
    appPackageId: The java package for the application under test. Optional,
      default is determined by examining the application's manifest.
    maxDepth: The max depth of the traversal stack Robo can explore. Needs to
      be at least 2 to make Robo explore the app beyond the first activity.
      Default is 50. Optional
    maxSteps: The max number of steps Robo can execute. Default is no limit.
      Optional
    randomizeSteps: Whether Robo follows a random order of steps on a given
      activity state. Optional
  """

  appApk = _messages.MessageField('FileReference', 1)
  appInitialActivity = _messages.StringField(2)
  appPackageId = _messages.StringField(3)
  maxDepth = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  maxSteps = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  randomizeSteps = _messages.BooleanField(6)


class AndroidRuntimeConfiguration(_messages.Message):
  """Configuration that can be selected at the time a test is run.

  Fields:
    locales: The set of available locales. @OutputOnly
    orientations: The set of available orientations. @OutputOnly
  """

  locales = _messages.MessageField('Locale', 1, repeated=True)
  orientations = _messages.MessageField('Orientation', 2, repeated=True)


class AndroidVersion(_messages.Message):
  """A version of the Android OS

  Fields:
    apiLevel: The API level for this Android version. Examples: 18, 19
      @OutputOnly
    codeName: The code name for this Android version. Examples: "JellyBean",
      "KitKat" @OutputOnly
    distribution: Market share for this version. @OutputOnly
    id: An opaque id for this Android version. Use this id to invoke the
      TestExecutionService. @OutputOnly
    releaseDate: The date this Android version became available in the market.
      @OutputOnly
    tags: Tags for this dimension. Examples: "default", "preview",
      "deprecated"
    versionString: A string representing this version of the Android OS.
      Examples: "4.3", "4.4" @OutputOnly
  """

  apiLevel = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  codeName = _messages.StringField(2)
  distribution = _messages.MessageField('Distribution', 3)
  id = _messages.StringField(4)
  releaseDate = _messages.MessageField('Date', 5)
  tags = _messages.StringField(6, repeated=True)
  versionString = _messages.StringField(7)


class BlobstoreFile(_messages.Message):
  """Reference to a blob in Blobstore.

  Fields:
    blobId: A blob ID. Example: /android_test/blobs/4e9AAT9sqHRY_oBBzIKHSEFgg
    md5Hash: The MD5 hash of the referenced blob. (This is necessary to create
      a Bigstore object directly from the Blobstore reference.)
  """

  blobId = _messages.StringField(1)
  md5Hash = _messages.StringField(2)


class Browser(_messages.Message):
  """An available browser.

  Fields:
    androidCatalog: The catalog of Android devices for which we offer this
      browser. @OutputOnly
    id: A human readable id for this Browser version. Use this id to invoke
      the TestExecutionService. Examples: "chrome-stable-channel", "firefox-
      beta-channel" @OutputOnly
    linuxCatalog: The catalog of Linux machines which we offer this browser.
      @OutputOnly
    name: A string representing the browser name. Examples: "chrome",
      "firefox", "ie" @OutputOnly
    release: The release of the browser. Examples: "stable-channel", "beta-
      channel", "10" (for ie), etc @OutputOnly
    versionString: A string representing the version of the browser. Examples:
      "42.12.34.1234", "37.01", "10.0.9200.16384" (for ie) @OutputOnly
    windowsCatalog: The catalog of Windows machines which we offer this
      browser. @OutputOnly
  """

  androidCatalog = _messages.MessageField('AndroidDeviceCatalog', 1)
  id = _messages.StringField(2)
  linuxCatalog = _messages.MessageField('LinuxMachineCatalog', 3)
  name = _messages.StringField(4)
  release = _messages.StringField(5)
  versionString = _messages.StringField(6)
  windowsCatalog = _messages.MessageField('WindowsMachineCatalog', 7)


class CancelTestMatrixResponse(_messages.Message):
  """Response containing the state of a cancelled test matrix.

  Enums:
    TestStateValueValuesEnum: The rolled-up state of the test matrix just
      before it was cancelled.

  Fields:
    testState: The rolled-up state of the test matrix just before it was
      cancelled.
  """

  class TestStateValueValuesEnum(_messages.Enum):
    """The rolled-up state of the test matrix just before it was cancelled.

    Values:
      TEST_STATE_UNSPECIFIED: Do not use.  For proto versioning only.
      VALIDATING: The execution or matrix is being validated.
      PENDING: The execution or matrix is waiting for resources to become
        available.
      RUNNING: The execution is currently being processed.  Can only be set on
        an execution.
      FINISHED: The execution or matrix has terminated normally.  On a matrix
        this means that the matrix level processing completed normally, but
        individual executions may be in an ERROR state.
      ERROR: The execution or matrix has stopped because it encountered an
        infrastructure failure.
      UNSUPPORTED_ENVIRONMENT: The execution was not run because it
        corresponds to a unsupported environment.  Can only be set on an
        execution.
      INCOMPATIBLE_ENVIRONMENT: The execution was not run because the provided
        inputs are incompatible with the requested environment.  Example:
        requested AndroidVersion is lower than APK's minSdkVersion  Can only
        be set on an execution.
      INCOMPATIBLE_ARCHITECTURE: The execution was not run because the
        provided inputs are incompatible with the requested architecture.
        Example: requested device does not support running the native code in
        the supplied APK  Can only be set on an execution.
      CANCELLED: The user cancelled the execution.  Can only be set on an
        execution.
      INVALID: The execution or matrix was not run because the provided inputs
        are not valid.  Examples: input file is not of the expected type, is
        malformed/corrupt, or was flagged as malware
    """
    TEST_STATE_UNSPECIFIED = 0
    VALIDATING = 1
    PENDING = 2
    RUNNING = 3
    FINISHED = 4
    ERROR = 5
    UNSUPPORTED_ENVIRONMENT = 6
    INCOMPATIBLE_ENVIRONMENT = 7
    INCOMPATIBLE_ARCHITECTURE = 8
    CANCELLED = 9
    INVALID = 10

  testState = _messages.EnumField('TestStateValueValuesEnum', 1)


class ClientInfo(_messages.Message):
  """Information about the client which invoked the test.

  Fields:
    name: Client name, such as gcloud.
  """

  name = _messages.StringField(1)


class ConnectionInfo(_messages.Message):
  """Information needed to connect to services running on the virtual device.
  The ssh_port is used to connect to the device, and then the adb_port and
  vnc_port on the device can be forwarded to two local ports, to which adb and
  vnc can connect, respectively.  All of the fields in this message are
  provided by the backend.

  Fields:
    adbPort: Port for ADB (e.g. 5555) NOT user-specified Required
    ipAddress: IP address of the device. NOT user-specified Required
    sshPort: Port for SSH (e.g. 22) NOT user-specified Required
    vncPassword: Password for VNC NOT user-specified Required
    vncPort: Port for VNC (e.g. 6444) NOT user-specified Required
  """

  adbPort = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  ipAddress = _messages.StringField(2)
  sshPort = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  vncPassword = _messages.StringField(4)
  vncPort = _messages.IntegerField(5, variant=_messages.Variant.INT32)


class Date(_messages.Message):
  """Represents a whole calendar date, e.g. date of birth. The time of day and
  time zone are either specified elsewhere or are not significant. The date is
  relative to the Proleptic Gregorian Calendar. The day may be 0 to represent
  a year and month where the day is not significant, e.g. credit card
  expiration date. The year may be 0 to represent a month and day independent
  of year, e.g. anniversary date. Related types are google.type.TimeOfDay and
  `google.protobuf.Timestamp`.

  Fields:
    day: Day of month. Must be from 1 to 31 and valid for the year and month,
      or 0 if specifying a year/month where the day is not significant.
    month: Month of year. Must be from 1 to 12.
    year: Year of date. Must be from 1 to 9999, or 0 if specifying a date
      without a year.
  """

  day = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  month = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  year = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class Device(_messages.Message):
  """A GCE virtual Android device instance.

  Enums:
    StateValueValuesEnum: State of the device. NOT user-specified

  Fields:
    androidDevice: The Android device configuration. User-specified Required
    creationTime: The time the request to create this device was received. NOT
      user-specified
    deviceDetails: Information about the backing GCE instance and connection.
      NOT user-specified
    id: Unique id set by the backend. NOT user-specified
    projectId: Project id set by the backend. NOT user-specified
    state: State of the device. NOT user-specified
    stateDetails: Details about the state of the device. NOT user-specified
  """

  class StateValueValuesEnum(_messages.Enum):
    """State of the device. NOT user-specified

    Values:
      DEVICE_UNSPECIFIED: Do not use.  For proto versioning only.
      PREPARING: The device is in the process of spinning up.
      READY: The device is created and ready to use.
      CLOSED: The device has been closed.
      DEVICE_ERROR: There has been an error.
    """
    DEVICE_UNSPECIFIED = 0
    PREPARING = 1
    READY = 2
    CLOSED = 3
    DEVICE_ERROR = 4

  androidDevice = _messages.MessageField('AndroidDevice', 1)
  creationTime = _messages.StringField(2)
  deviceDetails = _messages.MessageField('DeviceDetails', 3)
  id = _messages.StringField(4)
  projectId = _messages.StringField(5)
  state = _messages.EnumField('StateValueValuesEnum', 6)
  stateDetails = _messages.MessageField('DeviceStateDetails', 7)


class DeviceDetails(_messages.Message):
  """Details about the GCE instance and connection.

  Fields:
    connectionInfo: Details about the connection to the device.
    gceInstanceDetails: Details about the GCE instance backing the device.
  """

  connectionInfo = _messages.MessageField('ConnectionInfo', 1)
  gceInstanceDetails = _messages.MessageField('GceInstanceDetails', 2)


class DeviceFile(_messages.Message):
  """A single device file description.

  Fields:
    obbFile: A ObbFile attribute.
    regularFile: A RegularFile attribute.
  """

  obbFile = _messages.MessageField('ObbFile', 1)
  regularFile = _messages.MessageField('RegularFile', 2)


class DeviceStateDetails(_messages.Message):
  """Additional details about the status of the device.

  Fields:
    errorDetails: If the DeviceState is ERROR, then this string may contain
      human-readable details about the error.
    progressDetails: A human-readable, detailed description of the device's
      status. For example: "Starting Device\n Device Ready".  During the
      device's lifespan data may be appended to the progress.
  """

  errorDetails = _messages.StringField(1)
  progressDetails = _messages.StringField(2)


class Distribution(_messages.Message):
  """Data about the relative number of devices running a given configuration
  of the Android platform.

  Fields:
    marketShare: The estimated fraction (0-1) of the total market with this
      configuration. @OutputOnly
    measurementTime: The time this distribution was measured. @OutputOnly
  """

  marketShare = _messages.FloatField(1)
  measurementTime = _messages.StringField(2)


class Empty(_messages.Message):
  """A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class Environment(_messages.Message):
  """The environment in which the test is run.

  Fields:
    androidDevice: An Android device which must be used with an Android test.
  """

  androidDevice = _messages.MessageField('AndroidDevice', 1)


class EnvironmentMatrix(_messages.Message):
  """The matrix of environments in which the test is to be executed.

  Fields:
    androidMatrix: A matrix of Android devices
  """

  androidMatrix = _messages.MessageField('AndroidMatrix', 1)


class FileReference(_messages.Message):
  """A reference to a file, used for user inputs.

  Fields:
    blob: A blob in Blobstore.
    gcsPath: A path to a file in Google Cloud Storage. Example: gs://build-
      app-1414623860166/app-debug-unaligned.apk
  """

  blob = _messages.MessageField('BlobstoreFile', 1)
  gcsPath = _messages.StringField(2)


class GceInstanceDetails(_messages.Message):
  """This information is provided for the user to look up additional details
  of the backing GCE instance. It is assumed the user does not modify this
  instance. If so, then the device service makes no guarantees about device
  functionality.

  Fields:
    name: Desired instance name of the device. May be user-specified. If not,
      the backend will choose a name.
    projectId: The GCE project that contains the instance backing this device.
      If user-specified, must be the same as the project_id in the
      CreateDeviceRequest.
    zone: Desired GCE zone for the device user-specified
  """

  name = _messages.StringField(1)
  projectId = _messages.StringField(2)
  zone = _messages.StringField(3)


class GoogleCloudStorage(_messages.Message):
  """A storage location within Google cloud storage (GCS).

  Fields:
    gcsPath: The path to a directory in GCS that will eventually contain the
      results for this test. The requesting user must have write access on the
      bucket in the supplied path.
  """

  gcsPath = _messages.StringField(1)


class LinuxMachine(_messages.Message):
  """A single Linux machine.

  Fields:
    versionId: The version id of the Linux OS to be used. Use the
      EnvironmentDiscoveryService to get supported options.
  """

  versionId = _messages.StringField(1)


class LinuxMachineCatalog(_messages.Message):
  """The currently supported Linux machines.

  Fields:
    versions: The set of supported Linux versions. @OutputOnly
  """

  versions = _messages.MessageField('LinuxVersion', 1, repeated=True)


class LinuxVersion(_messages.Message):
  """A verison of a Linux OS.

  Fields:
    id: The unique opaque id for this Linux Version. @OutputOnly
    tags: Tags for this version. Examples: "default"
    versionString: A string representing this version of the Linux OS.
      Examples: "debian-7-wheezy-v20150325", "debian-7-wheezy-v30150325"
      @OutputOnly
  """

  id = _messages.StringField(1)
  tags = _messages.StringField(2, repeated=True)
  versionString = _messages.StringField(3)


class ListDevicesResponse(_messages.Message):
  """Response containing a list of devices. Supports pagination.

  Fields:
    devices: The GCE virtual Android devices to be returned.
    nextPageToken: The pagination token to retrieve the next page of device
      results.
  """

  devices = _messages.MessageField('Device', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListTestMatricesResponse(_messages.Message):
  """Response contain a list of Test Matrices.

  Fields:
    testMatrices: The set of test matrices.
  """

  testMatrices = _messages.MessageField('TestMatrix', 1, repeated=True)


class ListWebDriverResponse(_messages.Message):
  """Response containing a list of WebDriver environments. Supports
  pagination.

  Fields:
    nextPageToken: The pagination token to retrieve the next page of WebDriver
      results.
    webdriverEnvironments: The WebDriver environments to be returned.
  """

  nextPageToken = _messages.StringField(1)
  webdriverEnvironments = _messages.MessageField('WebDriver', 2, repeated=True)


class Locale(_messages.Message):
  """A location/region designation for language.

  Fields:
    id: The id for this locale. Example: "en_US" @OutputOnly
    name: A human-friendly name for this language/locale. Example: "English"
      @OutputOnly
    region: A human-friendy string representing the region for this locale.
      Example: "United States" Not present for every locale. @OutputOnly
    tags: Tags for this dimension. Examples: "default"
  """

  id = _messages.StringField(1)
  name = _messages.StringField(2)
  region = _messages.StringField(3)
  tags = _messages.StringField(4, repeated=True)


class ObbFile(_messages.Message):
  """A ObbFile object.

  Fields:
    obb: Opaque Binary Blob (OBB) file(s) to install on the device
    obbFileName: OBB file name which must conform to the format as specified
      by Android e.g. [main|patch].0300110.com.example.android.obb which will
      be installed into   <shared-storage>/Android/obb/<package-name>/ on the
      device
  """

  obb = _messages.MessageField('FileReference', 1)
  obbFileName = _messages.StringField(2)


class Orientation(_messages.Message):
  """Screen orientation of the device.

  Fields:
    id: The id for this orientation. Example: "portrait" @OutputOnly
    name: A human-friendly name for this orientation. Example: "portrait"
      @OutputOnly
    tags: Tags for this dimension. Examples: "default"
  """

  id = _messages.StringField(1)
  name = _messages.StringField(2)
  tags = _messages.StringField(3, repeated=True)


class RegularFile(_messages.Message):
  """A file or directory to install on the device before the test starts

  Fields:
    content: A FileReference attribute.
    devicePath: Where to put the content on the device, must be a full,
      whitelisted path. If it exists, it will be completely replaced.
      TODO(user): Make the following path substitutions available: <p>
      ${EXTERNAL_STORAGE} - the external storage mount point (/sdcard) <p>
      ${ANDROID_DATA} - the userdata partition mount point (/data) Note:
      /data/local/tmp is whitelisted, but /data is not.  <p> The corresponding
      paths (in parentheses) will be made available and treated as implicit
      path substitutions, so the user may use them interchangeably. E.g. if
      /sdcard on a particular device does not map to external storage, the
      system will replace it with the external storage path prefix for that
      device and copy the file there.  <p> It is strongly advised to use the
      <a href=
      "http://developer.android.com/reference/android/os/Environment.html">
      Environment API</a> in app and test code to access files on the device
      in a portable way.
  """

  content = _messages.MessageField('FileReference', 1)
  devicePath = _messages.StringField(2)


class ResultStorage(_messages.Message):
  """Locations where the results of running the test are stored.

  Fields:
    googleCloudStorage: Required.
    toolResultsExecution: The tool results execution that results are written
      to. @OutputOnly
    toolResultsHistory: The tool results history that contains the tool
      results execution that results are written to.  If not provided the
      service will choose an appropriate value.
  """

  googleCloudStorage = _messages.MessageField('GoogleCloudStorage', 1)
  toolResultsExecution = _messages.MessageField('ToolResultsExecution', 2)
  toolResultsHistory = _messages.MessageField('ToolResultsHistory', 3)


class StandardQueryParameters(_messages.Message):
  """Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    bearer_token: OAuth bearer token.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    pp: Pretty-print response.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    """Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    """V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  bearer_token = _messages.StringField(4)
  callback = _messages.StringField(5)
  fields = _messages.StringField(6)
  key = _messages.StringField(7)
  oauth_token = _messages.StringField(8)
  pp = _messages.BooleanField(9, default=True)
  prettyPrint = _messages.BooleanField(10, default=True)
  quotaUser = _messages.StringField(11)
  trace = _messages.StringField(12)
  uploadType = _messages.StringField(13)
  upload_protocol = _messages.StringField(14)


class TestDetails(_messages.Message):
  """Additional details about the progress of the running test.

  Fields:
    errorMessage: If the TestState is ERROR, then this string will contain
      human-readable details about the error. @OutputOnly
    progressMessages: Human-readable, detailed descriptions of the test's
      progress. For example: "Provisioning a device", "Starting Test".  During
      the course of execution new data may be appended to the end of
      progress_messages. @OutputOnly
  """

  errorMessage = _messages.StringField(1)
  progressMessages = _messages.StringField(2, repeated=True)


class TestEnvironmentCatalog(_messages.Message):
  """A description of a test environment.

  Fields:
    androidDeviceCatalog: Android devices suitable for running Android
      Instrumentation Tests.
    webDriverCatalog: WebDriver environments suitable for running web tests.
  """

  androidDeviceCatalog = _messages.MessageField('AndroidDeviceCatalog', 1)
  webDriverCatalog = _messages.MessageField('WebDriverCatalog', 2)


class TestExecution(_messages.Message):
  """Specifies a single test to be executed in a single environment.

  Enums:
    StateValueValuesEnum: Indicates the current progress of the test execution
      (e.g., FINISHED). @OutputOnly

  Fields:
    environment: How the host machine(s) are configured. @OutputOnly
    id: Unique id set by the backend. @OutputOnly
    matrixId: Id of the containing TestMatrix. @OutputOnly
    projectId: The cloud project that owns the test execution. @OutputOnly
    state: Indicates the current progress of the test execution (e.g.,
      FINISHED). @OutputOnly
    testDetails: Additional details about the running test. @OutputOnly
    testSpecification: How to run the test. @OutputOnly
    timestamp: The time this test execution was initially created. @OutputOnly
    toolResultsStep: Where the results for this execution are written.
      @OutputOnly
  """

  class StateValueValuesEnum(_messages.Enum):
    """Indicates the current progress of the test execution (e.g., FINISHED).
    @OutputOnly

    Values:
      TEST_STATE_UNSPECIFIED: Do not use.  For proto versioning only.
      VALIDATING: The execution or matrix is being validated.
      PENDING: The execution or matrix is waiting for resources to become
        available.
      RUNNING: The execution is currently being processed.  Can only be set on
        an execution.
      FINISHED: The execution or matrix has terminated normally.  On a matrix
        this means that the matrix level processing completed normally, but
        individual executions may be in an ERROR state.
      ERROR: The execution or matrix has stopped because it encountered an
        infrastructure failure.
      UNSUPPORTED_ENVIRONMENT: The execution was not run because it
        corresponds to a unsupported environment.  Can only be set on an
        execution.
      INCOMPATIBLE_ENVIRONMENT: The execution was not run because the provided
        inputs are incompatible with the requested environment.  Example:
        requested AndroidVersion is lower than APK's minSdkVersion  Can only
        be set on an execution.
      INCOMPATIBLE_ARCHITECTURE: The execution was not run because the
        provided inputs are incompatible with the requested architecture.
        Example: requested device does not support running the native code in
        the supplied APK  Can only be set on an execution.
      CANCELLED: The user cancelled the execution.  Can only be set on an
        execution.
      INVALID: The execution or matrix was not run because the provided inputs
        are not valid.  Examples: input file is not of the expected type, is
        malformed/corrupt, or was flagged as malware
    """
    TEST_STATE_UNSPECIFIED = 0
    VALIDATING = 1
    PENDING = 2
    RUNNING = 3
    FINISHED = 4
    ERROR = 5
    UNSUPPORTED_ENVIRONMENT = 6
    INCOMPATIBLE_ENVIRONMENT = 7
    INCOMPATIBLE_ARCHITECTURE = 8
    CANCELLED = 9
    INVALID = 10

  environment = _messages.MessageField('Environment', 1)
  id = _messages.StringField(2)
  matrixId = _messages.StringField(3)
  projectId = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)
  testDetails = _messages.MessageField('TestDetails', 6)
  testSpecification = _messages.MessageField('TestSpecification', 7)
  timestamp = _messages.StringField(8)
  toolResultsStep = _messages.MessageField('ToolResultsStep', 9)


class TestMatrix(_messages.Message):
  """A group of one or more TestExecutions, built by taking a product of
  values over a pre-defined set of axes.

  Enums:
    StateValueValuesEnum: Indicates the current progress of the test matrix
      (e.g., FINISHED) @OutputOnly

  Fields:
    clientInfo: Information about the client which invoked the test.
    environmentMatrix: How the host machine(s) are configured. Required
    projectId: The cloud project that owns the test matrix. @OutputOnly
    resultStorage: Where the results for the matrix are written. Required
    state: Indicates the current progress of the test matrix (e.g., FINISHED)
      @OutputOnly
    testExecutions: The list of test executions that the service creates for
      this matrix. @OutputOnly
    testMatrixId: Unique id set by the service. @OutputOnly
    testSpecification: How to run the test. Required
    timestamp: The time this test matrix was initially created. @OutputOnly
  """

  class StateValueValuesEnum(_messages.Enum):
    """Indicates the current progress of the test matrix (e.g., FINISHED)
    @OutputOnly

    Values:
      TEST_STATE_UNSPECIFIED: Do not use.  For proto versioning only.
      VALIDATING: The execution or matrix is being validated.
      PENDING: The execution or matrix is waiting for resources to become
        available.
      RUNNING: The execution is currently being processed.  Can only be set on
        an execution.
      FINISHED: The execution or matrix has terminated normally.  On a matrix
        this means that the matrix level processing completed normally, but
        individual executions may be in an ERROR state.
      ERROR: The execution or matrix has stopped because it encountered an
        infrastructure failure.
      UNSUPPORTED_ENVIRONMENT: The execution was not run because it
        corresponds to a unsupported environment.  Can only be set on an
        execution.
      INCOMPATIBLE_ENVIRONMENT: The execution was not run because the provided
        inputs are incompatible with the requested environment.  Example:
        requested AndroidVersion is lower than APK's minSdkVersion  Can only
        be set on an execution.
      INCOMPATIBLE_ARCHITECTURE: The execution was not run because the
        provided inputs are incompatible with the requested architecture.
        Example: requested device does not support running the native code in
        the supplied APK  Can only be set on an execution.
      CANCELLED: The user cancelled the execution.  Can only be set on an
        execution.
      INVALID: The execution or matrix was not run because the provided inputs
        are not valid.  Examples: input file is not of the expected type, is
        malformed/corrupt, or was flagged as malware
    """
    TEST_STATE_UNSPECIFIED = 0
    VALIDATING = 1
    PENDING = 2
    RUNNING = 3
    FINISHED = 4
    ERROR = 5
    UNSUPPORTED_ENVIRONMENT = 6
    INCOMPATIBLE_ENVIRONMENT = 7
    INCOMPATIBLE_ARCHITECTURE = 8
    CANCELLED = 9
    INVALID = 10

  clientInfo = _messages.MessageField('ClientInfo', 1)
  environmentMatrix = _messages.MessageField('EnvironmentMatrix', 2)
  projectId = _messages.StringField(3)
  resultStorage = _messages.MessageField('ResultStorage', 4)
  state = _messages.EnumField('StateValueValuesEnum', 5)
  testExecutions = _messages.MessageField('TestExecution', 6, repeated=True)
  testMatrixId = _messages.StringField(7)
  testSpecification = _messages.MessageField('TestSpecification', 8)
  timestamp = _messages.StringField(9)


class TestSetup(_messages.Message):
  """A description of how to set up the device prior to running the test

  Fields:
    filesToPush: A DeviceFile attribute.
  """

  filesToPush = _messages.MessageField('DeviceFile', 1, repeated=True)


class TestSpecification(_messages.Message):
  """A description of how to run the test.

  Fields:
    androidInstrumentationTest: An Android instrumentation test.
    androidMonkeyTest: An Android monkey test.
    androidRoboTest: An Android robo test.
    autoGoogleLogin: Enables automatic Google account login. If set, the
      service will automatically generate a Google test account and use it to
      log into the device, before executing the test. Note that test accounts
      might be reused. Many applications can be tested more effectively in the
      context of such an account. Default is false. Optional
    testSetup: Test setup requirements e.g. files to install, bootstrap
      scripts
    testTimeout: Max time a test execution is allowed to run before it is
      automatically cancelled.
  """

  androidInstrumentationTest = _messages.MessageField('AndroidInstrumentationTest', 1)
  androidMonkeyTest = _messages.MessageField('AndroidMonkeyTest', 2)
  androidRoboTest = _messages.MessageField('AndroidRoboTest', 3)
  autoGoogleLogin = _messages.BooleanField(4)
  testSetup = _messages.MessageField('TestSetup', 5)
  testTimeout = _messages.StringField(6)


class TestingProjectsDevicesCreateRequest(_messages.Message):
  """A TestingProjectsDevicesCreateRequest object.

  Fields:
    device: A Device resource to be passed as the request body.
    projectId: The GCE project under which to create the device.
    sshPublicKey: The public key to be set on the device in order to SSH into
      it.
  """

  device = _messages.MessageField('Device', 1)
  projectId = _messages.StringField(2, required=True)
  sshPublicKey = _messages.StringField(3)


class TestingProjectsDevicesDeleteRequest(_messages.Message):
  """A TestingProjectsDevicesDeleteRequest object.

  Fields:
    deviceId: The GCE virtual Android device to be deleted.
    projectId: The GCE project that contains the device to be deleted.
  """

  deviceId = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)


class TestingProjectsDevicesGetRequest(_messages.Message):
  """A TestingProjectsDevicesGetRequest object.

  Fields:
    deviceId: The id of the GCE Android virtual device.
    projectId: The GCE project that contains this device instance.
  """

  deviceId = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)


class TestingProjectsDevicesKeepaliveRequest(_messages.Message):
  """A TestingProjectsDevicesKeepaliveRequest object.

  Fields:
    deviceId: The GCE virtual Android device to be issued the keep-alive.
    projectId: The GCE project that contains the device to be issued the keep-
      alive.
  """

  deviceId = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)


class TestingProjectsDevicesListRequest(_messages.Message):
  """A TestingProjectsDevicesListRequest object.

  Fields:
    pageSize: Used to specify the max number of device results to be returned.
    pageToken: Used to request a specific page of the device results list.
    projectId: The GCE project to list the devices from.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  projectId = _messages.StringField(3, required=True)


class TestingProjectsTestMatricesCancelRequest(_messages.Message):
  """A TestingProjectsTestMatricesCancelRequest object.

  Fields:
    projectId: Cloud project that owns the test.
    testMatrixId: Test matrix that will be canceled.
  """

  projectId = _messages.StringField(1, required=True)
  testMatrixId = _messages.StringField(2, required=True)


class TestingProjectsTestMatricesCreateRequest(_messages.Message):
  """A TestingProjectsTestMatricesCreateRequest object.

  Fields:
    projectId: The GCE project under which this job will run.
    requestId: A string id used to detect duplicated requests. Ids are
      automatically scoped to a project, so users should ensure the ID is
      unique per-project. A UUID is recommended.  Optional, but strongly
      recommended.
    testMatrix: A TestMatrix resource to be passed as the request body.
  """

  projectId = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  testMatrix = _messages.MessageField('TestMatrix', 3)


class TestingProjectsTestMatricesDeleteRequest(_messages.Message):
  """A TestingProjectsTestMatricesDeleteRequest object.

  Fields:
    projectId: Cloud project that owns the test.
    testMatrixId: Test matrix that will be canceled.
  """

  projectId = _messages.StringField(1, required=True)
  testMatrixId = _messages.StringField(2, required=True)


class TestingProjectsTestMatricesGetRequest(_messages.Message):
  """A TestingProjectsTestMatricesGetRequest object.

  Fields:
    projectId: Cloud project that owns the test matrix.
    testMatrixId: Unique test matrix id which was assigned by the service.
  """

  projectId = _messages.StringField(1, required=True)
  testMatrixId = _messages.StringField(2, required=True)


class TestingProjectsTestMatricesListRequest(_messages.Message):
  """A TestingProjectsTestMatricesListRequest object.

  Fields:
    projectId: Cloud project that owns the tests.
  """

  projectId = _messages.StringField(1, required=True)


class TestingProjectsWebdriverCreateRequest(_messages.Message):
  """A TestingProjectsWebdriverCreateRequest object.

  Fields:
    projectId: The GCP project under which to create the WebDriver
      environment.
    webDriver: A WebDriver resource to be passed as the request body.
  """

  projectId = _messages.StringField(1, required=True)
  webDriver = _messages.MessageField('WebDriver', 2)


class TestingProjectsWebdriverDeleteRequest(_messages.Message):
  """A TestingProjectsWebdriverDeleteRequest object.

  Fields:
    projectId: The GCP project that contains the WebDriver endpoint to be
      deleted.
    webdriverId: The GCE WebDriver environment to be deleted specified from
      the WebDriver id.
  """

  projectId = _messages.StringField(1, required=True)
  webdriverId = _messages.StringField(2, required=True)


class TestingProjectsWebdriverGetRequest(_messages.Message):
  """A TestingProjectsWebdriverGetRequest object.

  Fields:
    projectId: The GCP project that contains this WebDriver instance.
    webdriverId: The GCE WebDriver environment to be deleted specified from
      the WebDriver id.
  """

  projectId = _messages.StringField(1, required=True)
  webdriverId = _messages.StringField(2, required=True)


class TestingProjectsWebdriverKeepaliveRequest(_messages.Message):
  """A TestingProjectsWebdriverKeepaliveRequest object.

  Fields:
    projectId: The GCP project that contains the webdriver to be issued the
      keep-alive.
    webDriverKeepAliveRequest: A WebDriverKeepAliveRequest resource to be
      passed as the request body.
    webdriverId: The WebDriver environment to be issued the keep-alive.
  """

  projectId = _messages.StringField(1, required=True)
  webDriverKeepAliveRequest = _messages.MessageField('WebDriverKeepAliveRequest', 2)
  webdriverId = _messages.StringField(3, required=True)


class TestingProjectsWebdriverListRequest(_messages.Message):
  """A TestingProjectsWebdriverListRequest object.

  Fields:
    pageSize: Used to specify the max number of results to be returned.
    pageToken: Used to request a specific page of the results list.
    projectId: The GCP project to list the environments from.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  projectId = _messages.StringField(3, required=True)


class TestingTestEnvironmentCatalogGetRequest(_messages.Message):
  """A TestingTestEnvironmentCatalogGetRequest object.

  Enums:
    EnvironmentTypeValueValuesEnum: The type of environment that should be
      listed.

  Fields:
    environmentType: The type of environment that should be listed.
  """

  class EnvironmentTypeValueValuesEnum(_messages.Enum):
    """The type of environment that should be listed.

    Values:
      ENVIRONMENT_TYPE_UNSPECIFIED: <no description>
      ANDROID: <no description>
      WEBDRIVER: <no description>
    """
    ENVIRONMENT_TYPE_UNSPECIFIED = 0
    ANDROID = 1
    WEBDRIVER = 2

  environmentType = _messages.EnumField('EnvironmentTypeValueValuesEnum', 1, required=True)


class ToolResultsExecution(_messages.Message):
  """Represents a tool results execution resource.  This has the results of a
  TestMatrix.

  Fields:
    executionId: A tool results execution ID. @OutputOnly
    historyId: A tool results history ID. @OutputOnly
    projectId: The cloud project that owns the tool results execution.
      @OutputOnly
  """

  executionId = _messages.StringField(1)
  historyId = _messages.StringField(2)
  projectId = _messages.StringField(3)


class ToolResultsHistory(_messages.Message):
  """Represents a tool results history resource.

  Fields:
    historyId: A tool results history ID.
    projectId: The cloud project that owns the tool results history.
  """

  historyId = _messages.StringField(1)
  projectId = _messages.StringField(2)


class ToolResultsStep(_messages.Message):
  """Represents a tool results step resource.  This has the results of a
  TestExecution.

  Fields:
    executionId: A tool results execution ID. @OutputOnly
    historyId: A tool results history ID. @OutputOnly
    projectId: The cloud project that owns the tool results step. @OutputOnly
    stepId: A tool results step ID. @OutputOnly
  """

  executionId = _messages.StringField(1)
  historyId = _messages.StringField(2)
  projectId = _messages.StringField(3)
  stepId = _messages.StringField(4)


class VMDetails(_messages.Message):
  """A VMDetails object.

  Enums:
    StateValueValuesEnum: State of the device. @OutputOnly

  Fields:
    creationTime: The time this device was initially created. @OutputOnly
    deviceDetails: Information about the backing GCE instance and connection.
      @OutputOnly
    state: State of the device. @OutputOnly
    stateDetails: Details about the state of the device. @OutputOnly
  """

  class StateValueValuesEnum(_messages.Enum):
    """State of the device. @OutputOnly

    Values:
      DEVICE_UNSPECIFIED: Do not use.  For proto versioning only.
      PREPARING: The device is in the process of spinning up.
      READY: The device is created and ready to use.
      CLOSED: The device has been closed.
      DEVICE_ERROR: There has been an error.
    """
    DEVICE_UNSPECIFIED = 0
    PREPARING = 1
    READY = 2
    CLOSED = 3
    DEVICE_ERROR = 4

  creationTime = _messages.StringField(1)
  deviceDetails = _messages.MessageField('DeviceDetails', 2)
  state = _messages.EnumField('StateValueValuesEnum', 3)
  stateDetails = _messages.MessageField('DeviceStateDetails', 4)


class WebDriver(_messages.Message):
  """A WebDriver environment.

  Fields:
    androidDevice: An Android device.
    browserId: The id of the browser to be used. Use the
      EnvironmentDiscoveryService to get supported values. Required
    endpoint: The endpoint in host:port format where the target running the
      specified browser accepts WebDriver protocol commands. @OutputOnly
    id: Unique id set by the system. @OutputOnly
    linuxMachine: A Linux virtual machine.
    projectId: The GCE project for this WebDriver test environment.
      @OutputOnly
    sshPublicKey: The public key to be set on the VM in order to SSH into it.
    vmDetails: The state details of the target device/machine. @OutputOnly
    windowsMachine: A Windows virtual machine.
  """

  androidDevice = _messages.MessageField('AndroidDevice', 1)
  browserId = _messages.StringField(2)
  endpoint = _messages.StringField(3)
  id = _messages.StringField(4)
  linuxMachine = _messages.MessageField('LinuxMachine', 5)
  projectId = _messages.StringField(6)
  sshPublicKey = _messages.StringField(7)
  vmDetails = _messages.MessageField('VMDetails', 8)
  windowsMachine = _messages.MessageField('WindowsMachine', 9)


class WebDriverCatalog(_messages.Message):
  """The currently supported WebDriver VM resources.

  Fields:
    browsers: The set of supported browsers. @OutputOnly
  """

  browsers = _messages.MessageField('Browser', 1, repeated=True)


class WebDriverKeepAliveRequest(_messages.Message):
  """Request to issue a keep-alive to a WebDriver environment instance by
  project and webdriver ids.
  """



class WindowsMachine(_messages.Message):
  """A single Windows machine.

  Fields:
    versionId: The version id of the Windows OS to be used. Use the
      EnvironmentDiscoveryService to get supported options.
  """

  versionId = _messages.StringField(1)


class WindowsMachineCatalog(_messages.Message):
  """The currently supported Windows machines.

  Fields:
    versions: The set of supported Windows versions. @OutputOnly
  """

  versions = _messages.MessageField('WindowsVersion', 1, repeated=True)


class WindowsVersion(_messages.Message):
  """A version of a Windows OS.

  Fields:
    id: The unique opaque id for this Windows Version. @OutputOnly
    tags: Tags for this version. Examples: "default"
    versionString: A string representing this version of the Windows OS.
      Examples: "windows-server-2008-r2-dc-v20150331", windows-7" @OutputOnly
  """

  id = _messages.StringField(1)
  tags = _messages.StringField(2, repeated=True)
  versionString = _messages.StringField(3)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv',
    package=u'testing')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1',
    package=u'testing')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2',
    package=u'testing')
