"""Generated message classes for resourceviews version v1beta1.

The Resource View API allows users to create and manage logical sets of Google
Compute Engine instances.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from googlecloudsdk.third_party.apitools.base.protorpclite import messages as _messages


package = 'resourceviews'


class Label(_messages.Message):
  """The Label to be applied to the resource views.

  Fields:
    key: Key of the label.
    value: Value of the label.
  """

  key = _messages.StringField(1)
  value = _messages.StringField(2)


class RegionViewsAddResourcesRequest(_messages.Message):
  """The request to add resources to the resource view.

  Fields:
    resources: The list of resources to be added.
  """

  resources = _messages.StringField(1, repeated=True)


class RegionViewsInsertResponse(_messages.Message):
  """The response to a resource view insert request.

  Fields:
    resource: The resource view object inserted.
  """

  resource = _messages.MessageField('ResourceView', 1)


class RegionViewsListResourcesResponse(_messages.Message):
  """The response to the list resource request.

  Fields:
    members: The resources in the view.
    nextPageToken: A token used for pagination.
  """

  members = _messages.StringField(1, repeated=True)
  nextPageToken = _messages.StringField(2)


class RegionViewsListResponse(_messages.Message):
  """The response to the list resource view request.

  Fields:
    nextPageToken: A token used for pagination.
    resourceViews: The list of resource views that meet the criteria.
  """

  nextPageToken = _messages.StringField(1)
  resourceViews = _messages.MessageField('ResourceView', 2, repeated=True)


class RegionViewsRemoveResourcesRequest(_messages.Message):
  """The request to remove resources from the resource view.

  Fields:
    resources: The list of resources to be removed.
  """

  resources = _messages.StringField(1, repeated=True)


class ResourceView(_messages.Message):
  """The resource view object.

  Fields:
    creationTime: The creation time of the resource view.
    description: The detailed description of the resource view.
    id: [Output Only] The ID of the resource view.
    kind: Type of the resource.
    labels: The labels for events.
    lastModified: The last modified time of the view. Not supported yet.
    members: A list of all resources in the resource view.
    name: The name of the resource view.
    numMembers: The total number of resources in the resource view.
    selfLink: [Output Only] A self-link to the resource view.
  """

  creationTime = _messages.StringField(1)
  description = _messages.StringField(2)
  id = _messages.StringField(3)
  kind = _messages.StringField(4, default=u'resourceviews#resourceView')
  labels = _messages.MessageField('Label', 5, repeated=True)
  lastModified = _messages.StringField(6)
  members = _messages.StringField(7, repeated=True)
  name = _messages.StringField(8)
  numMembers = _messages.IntegerField(9, variant=_messages.Variant.UINT32)
  selfLink = _messages.StringField(10)


class ResourceviewsRegionViewsAddresourcesRequest(_messages.Message):
  """A ResourceviewsRegionViewsAddresourcesRequest object.

  Fields:
    projectName: The project name of the resource view.
    region: The region name of the resource view.
    regionViewsAddResourcesRequest: A RegionViewsAddResourcesRequest resource
      to be passed as the request body.
    resourceViewName: The name of the resource view.
  """

  projectName = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  regionViewsAddResourcesRequest = _messages.MessageField('RegionViewsAddResourcesRequest', 3)
  resourceViewName = _messages.StringField(4, required=True)


class ResourceviewsRegionViewsAddresourcesResponse(_messages.Message):
  """An empty ResourceviewsRegionViewsAddresources response."""


class ResourceviewsRegionViewsDeleteRequest(_messages.Message):
  """A ResourceviewsRegionViewsDeleteRequest object.

  Fields:
    projectName: The project name of the resource view.
    region: The region name of the resource view.
    resourceViewName: The name of the resource view.
  """

  projectName = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resourceViewName = _messages.StringField(3, required=True)


class ResourceviewsRegionViewsDeleteResponse(_messages.Message):
  """An empty ResourceviewsRegionViewsDelete response."""


class ResourceviewsRegionViewsGetRequest(_messages.Message):
  """A ResourceviewsRegionViewsGetRequest object.

  Fields:
    projectName: The project name of the resource view.
    region: The region name of the resource view.
    resourceViewName: The name of the resource view.
  """

  projectName = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resourceViewName = _messages.StringField(3, required=True)


class ResourceviewsRegionViewsInsertRequest(_messages.Message):
  """A ResourceviewsRegionViewsInsertRequest object.

  Fields:
    projectName: The project name of the resource view.
    region: The region name of the resource view.
    resourceView: A ResourceView resource to be passed as the request body.
  """

  projectName = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resourceView = _messages.MessageField('ResourceView', 3)


class ResourceviewsRegionViewsListRequest(_messages.Message):
  """A ResourceviewsRegionViewsListRequest object.

  Fields:
    maxResults: Maximum count of results to be returned. Acceptable values are
      0 to 5000, inclusive. (Default: 5000)
    pageToken: Specifies a nextPageToken returned by a previous list request.
      This token can be used to request the next page of results from a
      previous list request.
    projectName: The project name of the resource view.
    region: The region name of the resource view.
  """

  maxResults = _messages.IntegerField(1, variant=_messages.Variant.INT32, default=5000)
  pageToken = _messages.StringField(2)
  projectName = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)


class ResourceviewsRegionViewsListresourcesRequest(_messages.Message):
  """A ResourceviewsRegionViewsListresourcesRequest object.

  Fields:
    maxResults: Maximum count of results to be returned. Acceptable values are
      0 to 5000, inclusive. (Default: 5000)
    pageToken: Specifies a nextPageToken returned by a previous list request.
      This token can be used to request the next page of results from a
      previous list request.
    projectName: The project name of the resource view.
    region: The region name of the resource view.
    resourceViewName: The name of the resource view.
  """

  maxResults = _messages.IntegerField(1, variant=_messages.Variant.INT32, default=5000)
  pageToken = _messages.StringField(2)
  projectName = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)
  resourceViewName = _messages.StringField(5, required=True)


class ResourceviewsRegionViewsRemoveresourcesRequest(_messages.Message):
  """A ResourceviewsRegionViewsRemoveresourcesRequest object.

  Fields:
    projectName: The project name of the resource view.
    region: The region name of the resource view.
    regionViewsRemoveResourcesRequest: A RegionViewsRemoveResourcesRequest
      resource to be passed as the request body.
    resourceViewName: The name of the resource view.
  """

  projectName = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  regionViewsRemoveResourcesRequest = _messages.MessageField('RegionViewsRemoveResourcesRequest', 3)
  resourceViewName = _messages.StringField(4, required=True)


class ResourceviewsRegionViewsRemoveresourcesResponse(_messages.Message):
  """An empty ResourceviewsRegionViewsRemoveresources response."""


class ResourceviewsZoneViewsAddresourcesRequest(_messages.Message):
  """A ResourceviewsZoneViewsAddresourcesRequest object.

  Fields:
    projectName: The project name of the resource view.
    resourceViewName: The name of the resource view.
    zone: The zone name of the resource view.
    zoneViewsAddResourcesRequest: A ZoneViewsAddResourcesRequest resource to
      be passed as the request body.
  """

  projectName = _messages.StringField(1, required=True)
  resourceViewName = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)
  zoneViewsAddResourcesRequest = _messages.MessageField('ZoneViewsAddResourcesRequest', 4)


class ResourceviewsZoneViewsAddresourcesResponse(_messages.Message):
  """An empty ResourceviewsZoneViewsAddresources response."""


class ResourceviewsZoneViewsDeleteRequest(_messages.Message):
  """A ResourceviewsZoneViewsDeleteRequest object.

  Fields:
    projectName: The project name of the resource view.
    resourceViewName: The name of the resource view.
    zone: The zone name of the resource view.
  """

  projectName = _messages.StringField(1, required=True)
  resourceViewName = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ResourceviewsZoneViewsDeleteResponse(_messages.Message):
  """An empty ResourceviewsZoneViewsDelete response."""


class ResourceviewsZoneViewsGetRequest(_messages.Message):
  """A ResourceviewsZoneViewsGetRequest object.

  Fields:
    projectName: The project name of the resource view.
    resourceViewName: The name of the resource view.
    zone: The zone name of the resource view.
  """

  projectName = _messages.StringField(1, required=True)
  resourceViewName = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ResourceviewsZoneViewsInsertRequest(_messages.Message):
  """A ResourceviewsZoneViewsInsertRequest object.

  Fields:
    projectName: The project name of the resource view.
    resourceView: A ResourceView resource to be passed as the request body.
    zone: The zone name of the resource view.
  """

  projectName = _messages.StringField(1, required=True)
  resourceView = _messages.MessageField('ResourceView', 2)
  zone = _messages.StringField(3, required=True)


class ResourceviewsZoneViewsListRequest(_messages.Message):
  """A ResourceviewsZoneViewsListRequest object.

  Fields:
    maxResults: Maximum count of results to be returned. Acceptable values are
      0 to 5000, inclusive. (Default: 5000)
    pageToken: Specifies a nextPageToken returned by a previous list request.
      This token can be used to request the next page of results from a
      previous list request.
    projectName: The project name of the resource view.
    zone: The zone name of the resource view.
  """

  maxResults = _messages.IntegerField(1, variant=_messages.Variant.INT32, default=5000)
  pageToken = _messages.StringField(2)
  projectName = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ResourceviewsZoneViewsListresourcesRequest(_messages.Message):
  """A ResourceviewsZoneViewsListresourcesRequest object.

  Fields:
    maxResults: Maximum count of results to be returned. Acceptable values are
      0 to 5000, inclusive. (Default: 5000)
    pageToken: Specifies a nextPageToken returned by a previous list request.
      This token can be used to request the next page of results from a
      previous list request.
    projectName: The project name of the resource view.
    resourceViewName: The name of the resource view.
    zone: The zone name of the resource view.
  """

  maxResults = _messages.IntegerField(1, variant=_messages.Variant.INT32, default=5000)
  pageToken = _messages.StringField(2)
  projectName = _messages.StringField(3, required=True)
  resourceViewName = _messages.StringField(4, required=True)
  zone = _messages.StringField(5, required=True)


class ResourceviewsZoneViewsRemoveresourcesRequest(_messages.Message):
  """A ResourceviewsZoneViewsRemoveresourcesRequest object.

  Fields:
    projectName: The project name of the resource view.
    resourceViewName: The name of the resource view.
    zone: The zone name of the resource view.
    zoneViewsRemoveResourcesRequest: A ZoneViewsRemoveResourcesRequest
      resource to be passed as the request body.
  """

  projectName = _messages.StringField(1, required=True)
  resourceViewName = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)
  zoneViewsRemoveResourcesRequest = _messages.MessageField('ZoneViewsRemoveResourcesRequest', 4)


class ResourceviewsZoneViewsRemoveresourcesResponse(_messages.Message):
  """An empty ResourceviewsZoneViewsRemoveresources response."""


class StandardQueryParameters(_messages.Message):
  """Query parameters accepted by all methods.

  Enums:
    AltValueValuesEnum: Data format for the response.

  Fields:
    alt: Data format for the response.
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters. Overrides userIp if both are provided.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    userIp: IP address of the site where the request originates. Use this if
      you want to enforce per-user limits.
  """

  class AltValueValuesEnum(_messages.Enum):
    """Data format for the response.

    Values:
      json: Responses with Content-Type of application/json
    """
    json = 0

  alt = _messages.EnumField('AltValueValuesEnum', 1, default=u'json')
  fields = _messages.StringField(2)
  key = _messages.StringField(3)
  oauth_token = _messages.StringField(4)
  prettyPrint = _messages.BooleanField(5, default=True)
  quotaUser = _messages.StringField(6)
  trace = _messages.StringField(7)
  userIp = _messages.StringField(8)


class ZoneViewsAddResourcesRequest(_messages.Message):
  """The request to add resources to the resource view.

  Fields:
    resources: The list of resources to be added.
  """

  resources = _messages.StringField(1, repeated=True)


class ZoneViewsInsertResponse(_messages.Message):
  """The response to an insert request.

  Fields:
    resource: The resource view object that has been inserted.
  """

  resource = _messages.MessageField('ResourceView', 1)


class ZoneViewsListResourcesResponse(_messages.Message):
  """The response to a list resource request.

  Fields:
    members: The full URL of resources in the view.
    nextPageToken: A token used for pagination.
  """

  members = _messages.StringField(1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ZoneViewsListResponse(_messages.Message):
  """The response to a list request.

  Fields:
    nextPageToken: A token used for pagination.
    resourceViews: The result that contains all resource views that meet the
      criteria.
  """

  nextPageToken = _messages.StringField(1)
  resourceViews = _messages.MessageField('ResourceView', 2, repeated=True)


class ZoneViewsRemoveResourcesRequest(_messages.Message):
  """The request to remove resources from the resource view.

  Fields:
    resources: The list of resources to be removed.
  """

  resources = _messages.StringField(1, repeated=True)


