'\"
'\" Generated from file 'dbus\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2008-2015 Schelte Bron
'\"
.TH "dbus" n 2\&.1 dbus "Tcl DBus extension"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
dbus \- Tcl library for interacting with the DBus
.SH SYNOPSIS
package require \fBTcl  8\&.5\fR
.sp
package require \fBdbus  2\&.1\fR
.sp
\fBdbus\fR \fBcall\fR ?\fIbusID\fR? ?\fB-autostart\fR ?\fIboolean\fR?? ?\fB-dest\fR \fItarget\fR? ?\fB-details\fR ?\fIboolean\fR?? ?\fB-handler\fR \fIscript\fR? ?\fB-signature\fR \fIstring\fR? ?\fB-timeout\fR \fIms\fR? \fIpath\fR \fIinterface\fR \fImethod\fR ?\fIarg\fR \fI\&.\&.\&.\fR?
.sp
\fBdbus\fR \fBclose\fR ?\fIbusID\fR?
.sp
\fBdbus\fR \fBconnect\fR ?\fIaddress\fR?
.sp
\fBdbus\fR \fBerror\fR ?\fIbusID\fR? ?\fB-name\fR \fIstring\fR? \fIdestination\fR \fIserial\fR ?message?
.sp
\fBdbus\fR \fBfilter\fR ?\fIbusID\fR? \fIsubcommand\fR \fB-option\fR \fIvalue\fR ?\fI\&.\&.\&.\fR?
.sp
\fBdbus\fR \fBinfo\fR ?\fIbusID\fR? \fIoption\fR
.sp
\fBdbus\fR \fBlisten\fR ?\fIbusID\fR? ?\fB-details\fR? ?\fIpath\fR ?\fImember\fR ?\fIscript\fR???
.sp
\fBdbus\fR \fBmethod\fR ?\fIbusID\fR? ?\fB-details\fR? ?\fIpath\fR ?\fImember\fR ?\fIscript\fR???
.sp
\fBdbus\fR \fBmonitor\fR ?\fIbusID\fR? ?\fB-details\fR? \fIscript\fR
.sp
\fBdbus\fR \fBname\fR ?\fIbusID\fR? ?\fB-option\fR \fI\&.\&.\&.\fR? \fIname\fR
.sp
\fBdbus\fR \fBrelease\fR ?\fIbusID\fR? \fIname\fR
.sp
\fBdbus\fR \fBreturn\fR ?\fIbusID\fR? ?\fB-signature\fR \fIstring\fR? \fIdestination\fR \fIserial\fR ?\fIarg\fR \fI\&.\&.\&.\fR?
.sp
\fBdbus\fR \fBsignal\fR ?\fIbusID\fR? ?\fB-signature\fR \fIstring\fR? \fIobject\fR \fIinterface\fR \fIname\fR ?\fIarg\fR \fI\&.\&.\&.\fR?
.sp
\fBdbus\fR \fBunknown\fR ?\fIbusID\fR? ?\fB-details\fR? ?\fIpath\fR ?\fIscript\fR??
.sp
\fBdbus\fR \fBvalidate\fR \fIclass\fR \fIstring\fR
.sp
.BE
.SH DESCRIPTION
The \fBdbus\fR package provides commands to interact with DBus
message busses\&. There are three well-known bus names: \fBsession\fR,
\fBsystem\fR, and \fBstarter\fR\&. The starter bus only applies when the
application has been started as a result of a method call from another
application\&. A connection to the starter bus will effectively be an
alternative connection to either the session or the system bus\&.
.PP
Most subcommands take a \fIbusID\fR argument\&. This is the DBus handle as
returned by the \fBdbus\fR \fBconnect\fR subcommand\&. For the
well-known busses the handle matches the name of the bus\&. If the \fIbusID\fR
argument is not specified, it defaults to \fBsession\fR\&.
.TP
\fBdbus\fR \fBcall\fR ?\fIbusID\fR? ?\fB-autostart\fR ?\fIboolean\fR?? ?\fB-dest\fR \fItarget\fR? ?\fB-details\fR ?\fIboolean\fR?? ?\fB-handler\fR \fIscript\fR? ?\fB-signature\fR \fIstring\fR? ?\fB-timeout\fR \fIms\fR? \fIpath\fR \fIinterface\fR \fImethod\fR ?\fIarg\fR \fI\&.\&.\&.\fR?
Send a method call onto the dbus and optionally wait for a reply\&.
If the signature of the DBus \fBmethod_return\fR reply only contains one
top-level element, the arguments of the \fBmethod_return\fR message are
returned as a single value\&. More complex structures are returned as a list\&.
.sp
If the response to the DBus \fBmethod_call\fR message is a DBus
\fBerror\fR message, the command will produce an error\&. In that case the
errorCode variable will be set to \fBDBUS\fR \fBDBUS_MESSAGE_TYPE_ERROR\fR\&.
.sp
The \fB-autostart\fR option specifies whether the bus server should
attempt to start an associated application if the destination name does not
currently exist on the bus\&. \fIBoolean\fR may have any proper boolean value,
such as \fB1\fR or \fBno\fR\&. Defaults to 1 (true)\&.
.sp
The \fB-timeout\fR option specifies the maximum time to wait for a
response\&. A negative timeout indicates that no response should be requested\&.
.sp
If a script is specified with the \fB-handler\fR option, the call will be
asynchronous\&. In that case the command returns the serial of the request\&.
The script will be executed when a response comes back or when there is an
error\&.
.sp
The \fB-signature\fR option defines the types of arguments to be sent on
the dbus\&. See the \fBSignatures\fR section for more information\&.
If no signature is specified, all arguments will be sent as strings\&.
.sp
The \fB-details\fR option specifies how variant arguments in the return
value are represented\&. With the default value of FALSE, only the value of a
variant argument is provided\&. But in some situations the Tcl code may need
to be able to also obtain the argument type\&. When this option is set to TRUE,
each variant argument is represented as a list with two elements\&. The first
list element contains the signature of the argument and the second list
element is the value\&.
.TP
\fBdbus\fR \fBclose\fR ?\fIbusID\fR?
Close the connection to the DBus\&. This will cleanup all handlers, listeners,
and the optional monitor script registered for the \fIbusID\fR\&. The actual
bus connection of the application will not really be terminated if \fIbusID\fR
is one of the three so-called well-known busses, as this is not supported by
libdbus\&. Reconnecting to one of those busses will result in reusing the same
unique name as before\&.
.TP
\fBdbus\fR \fBconnect\fR ?\fIaddress\fR?
Connect to the DBus\&. The \fIaddress\fR argument specifies the bus to connect
to\&. This can be either one of the well-known busses ('session', 'system' or
\'starter'), or a transport name followed by a colon, and then an optional,
comma-separated list of keys and values in the form key=value\&.
The command returns a handle that can be used as the \fIbusID\fR argument
in other dbus commands\&.
It is legal to run this command when already connected\&.
.TP
\fBdbus\fR \fBerror\fR ?\fIbusID\fR? ?\fB-name\fR \fIstring\fR? \fIdestination\fR \fIserial\fR ?message?
Send a DBus \fBerror\fR message with the specified \fIserial\fR and
\fIdestination\fR\&. If the \fB-name\fR option is not specified, it
defaults to "org\&.freedesktop\&.DBus\&.Error\&.Failed"\&.
The values for \fIdestination\fR and \fIserial\fR can be obtained from event
information fields 'sender' and 'serial' correspondingly\&.
See \fBEvent Handlers\fR below for more information\&.
.sp
When employing this subcommand, make sure the result of the
\fBdbus\fR \fBmethod\fR script isn't automatically returned
to the caller by using the \fB-async\fR option of the \fBreturn\fR
command\&. See \fBdbus\fR \fBmethod\fR for more information\&.
.TP
\fBdbus\fR \fBfilter\fR ?\fIbusID\fR? \fIsubcommand\fR \fB-option\fR \fIvalue\fR ?\fI\&.\&.\&.\fR?
The \fBadd\fR subcommand adds a match rule to match messages going through
the message bus\&. The \fBremove\fR subcommand removes the most recently
added rule that exactly matches the specified option settings\&. If there is no
matching rule, the command is silently ignored\&. Available options are:
\fB-destination\fR, \fB-eavesdrop\fR, \fB-interface\fR,
\fB-member\fR, \fB-path\fR, \fB-sender\fR, and \fB-type\fR\&.
The command returns the match rule passed to libdbus\&.
.TP
\fBdbus\fR \fBinfo\fR ?\fIbusID\fR? \fIoption\fR
The info command can be used to obtain information about the DBus\&.
Available \fBinfo\fR options are:
.RS
.TP
\fB\fBcapabilities\fR\fR
Returns a dict describing the capabilities of
the dbus connection\&. Currently only one capability has been defined: unixfd,
which indicates if file descriptor passing is supported on the dbus connection\&.
.TP
\fB\fBlocal\fR\fR
The object path used in local/in-process-generated
messages (\fB/org/freedesktop/DBus/Local\fR)\&.
.TP
\fB\fBmachineid\fR\fR
Get the UUID of the local machine\&.
.TP
\fB\fBname\fR\fR
Get the unique name of the connection as assigned by
the message bus\&.
.TP
\fB\fBpath\fR\fR
The object path used to talk to the bus itself
(\fB/org/freedesktop/DBus\fR)\&.
.TP
\fB\fBpending\fR\fR
Report if any messages are in the queue to be sent\&.
.TP
\fB\fBserverid\fR\fR
Get the UUID of the server we are authenticated to\&.
.TP
\fB\fBservice\fR\fR
The bus name used to talk to the bus itself
(\fBorg\&.freedesktop\&.DBus\fR)\&.
.TP
\fB\fBversion\fR\fR
Returns the version of libdbus\&.
.RE
.sp
.TP
\fBdbus\fR \fBlisten\fR ?\fIbusID\fR? ?\fB-details\fR? ?\fIpath\fR ?\fImember\fR ?\fIscript\fR???
Register a \fIscript\fR to be called when the signal named "\fImember\fR" at
\fIpath\fR appears on the DBus\&.
See \fBEvent Handlers\fR below for more information\&.
.sp
If the \fIpath\fR argument is an empty string, \fIscript\fR will be executed
whenever a signal message is received for any path, unless a dedicated
listener for the exact path has been defined\&.
The \fImember\fR argument may be specified as either a signal name or an
interface and signal name joined by a period\&. If no interface is specified,
the script will be called for signals with any interface\&.
.sp
If \fIscript\fR is an empty string, the currently registered command for the
specified signal and path will be unregistered\&.
If the \fIscript\fR argument is not specified, the currently registered
command for the specified signal and path, if any, is returned\&.
If no \fImember\fR argument is specified a list of all registered signals
and associated commands at the specified path is returned\&.
If no \fIpath\fR argument is specified a list of all paths and their
registered signals and associated commands is returned\&.
.sp
The \fB-details\fR option causes variant arguments to be represented as a
list with two elements: The first list element contains the signature of the
argument and the second list element is the value\&.
.TP
\fBdbus\fR \fBmethod\fR ?\fIbusID\fR? ?\fB-details\fR? ?\fIpath\fR ?\fImember\fR ?\fIscript\fR???
Register a \fIscript\fR to be called when method \fImember\fR is invoked at
the specified \fIpath\fR\&.
See \fBEvent Handlers\fR below for more information\&.
.sp
If the \fIpath\fR argument is an empty string, \fIscript\fR will be executed
whenever a method call message is received for any path, unless a dedicated
method handler for the exact path has been defined\&.
The \fImember\fR argument may be specified as either a method name or an
interface and method name joined by a period\&. If no interface is specified,
the script will be called for methods with any interface, unless another
handler is specified for the method including the interface\&.
If \fIscript\fR is an empty string, the currently registered command for the
specified method and path will be unregistered\&.
.sp
When a \fIscript\fR argument is specified, even if it is an empty string,
the command may fail if another interpreter has already registered a handler
for the exact same path, interface and method\&.
See \fBSlave Interpreters\fR below for more information\&.
.sp
If the \fIscript\fR argument is not specified, the currently registered
command for the specified method and path, if any, is returned\&.
If no \fImember\fR argument is specified a list of all registered methods
and associated commands at the specified path is returned\&.
If no \fIpath\fR argument is specified a list of all paths and their
registered methods and associated commands is returned\&.
.sp
When \fIscript\fR is evaluated, the return value of the script will normally
be returned to the caller using a DBus \fBmethod_return\fR message in a
string argument\&.
If the execution of \fIscript\fR ends with an error, the error message is
returned to the caller in a DBus \fBerror\fR message\&. Any DBus errors that
happen while sending these messages back to the caller are silently ignored\&.
If the caller specified the \fBno_reply\fR flag in the \fBmethod_call\fR
as TRUE, no \fBmethod_return\fR or \fBerror\fR message will be returned\&.
.sp
The script code recognizes an additional \fB-async\fR option for the Tcl
\fBreturn\fR command\&. When that option is specified with a true boolean
value (\fBtrue\fR, \fByes\fR, \fB1\fR), the return value from the body
will not automatically be returned to the caller\&. A response message should
then be generated using the \fBdbus\fR \fBreturn\fR or
\fBdbus\fR \fBerror\fR subcommands\&.
.sp
This method provides more advanced control over the returned messages\&. It
allows for more complex data structures than just a string to be returned\&.
It also makes it possible to generate a return message some time after
\fIscript\fR has already finished\&. Additionally, any dbus errors while
sending back the return message can be detected and handled\&.
.sp
The \fB-details\fR option causes variant arguments to be represented as a
list with two elements: The first list element contains the signature of the
argument and the second list element is the value\&.
.TP
\fBdbus\fR \fBmonitor\fR ?\fIbusID\fR? ?\fB-details\fR? \fIscript\fR
Register a \fIscript\fR to be executed when any DBus message is received\&.
See \fBEvent Handlers\fR below for more information\&.
.sp
This can be useful for building special purpose programs that need to see
all activity on the DBus, for example a DBus monitoring program\&.
If \fIscript\fR is an empty string, the currently configured monitor script
will be removed\&.
.sp
The \fB-details\fR option causes variant arguments to be represented as a
list with two elements: The first list element contains the signature of the
argument and the second list element is the value\&.
.TP
\fBdbus\fR \fBname\fR ?\fIbusID\fR? ?\fB-option\fR \fI\&.\&.\&.\fR? \fIname\fR
Request the bus to assign a given name to the connection\&. The command will
generate an error in all cases where it was unsuccessful in making the
application the primary owner of the name\&.
.sp
The \fB-yield\fR option specifies that the application will release the
requested name when some other application requests the same name and has
indicated that it wants to take over ownership of the name\&. The application
will be informed by a \fINameLost\fR signal when it loses ownership of the
name\&.
The following command can be used to exit the application when the name is
taken over by another process:
.CS


dbus listen [dbus info path] [dbus info service]\&.NameLost \\
  [list apply {{name info str} {if {$str eq $name} exit}} $name]

.CE
.IP
The \fB-replace\fR option indicates that the application wants to take
over the ownership of the name from the application that is currently the
primary owner, if any\&. This request will only be honoured if the current
owner has indicated that it will release the name on request\&.
See also the \fB-yield\fR option\&.
.sp
If the requested name is currently in use and the \fB-replace\fR option
has not been specified, or the \fB-replace\fR option was specified but
the current owner is unwilling to give up its ownership, the name request
will normally be queued\&. Then when the name is released by current owner it
is assigned to the next requester in the queue and a signal is sent to inform
that requester that it is now the primary owner of the name\&.
The \fB-noqueue\fR option may be specified to indicate that the name
request should not be queued\&.
.sp
Note that even if the request has been queued, the command will generate an
error because the goal of becoming the primary owner of the name has not
been achieved\&.
.TP
\fBdbus\fR \fBrelease\fR ?\fIbusID\fR? \fIname\fR
Asks the bus to unassign the given name from this connection\&.
.TP
\fBdbus\fR \fBreturn\fR ?\fIbusID\fR? ?\fB-signature\fR \fIstring\fR? \fIdestination\fR \fIserial\fR ?\fIarg\fR \fI\&.\&.\&.\fR?
Send a DBus \fBmethod_return\fR message with the specified \fIserial\fR
and \fIdestination\fR\&.
The values for \fIdestination\fR and \fIserial\fR can be obtained from event
information fields 'sender' and 'serial' correspondingly\&.
See \fBEvent Handlers\fR below for more information\&.
.sp
When employing this subcommand, make sure the result of the
\fBdbus\fR \fBmethod\fR script isn't automatically returned
to the caller by using the \fB-async\fR option of the \fBreturn\fR
command\&. See \fBdbus\fR \fBmethod\fR for more information\&.
.TP
\fBdbus\fR \fBsignal\fR ?\fIbusID\fR? ?\fB-signature\fR \fIstring\fR? \fIobject\fR \fIinterface\fR \fIname\fR ?\fIarg\fR \fI\&.\&.\&.\fR?
Send a signal onto the dbus with the specified type signature\&. If no
\fB-signature\fR option is provided, all \fIarg\fRs will be sent as
strings\&. The command returns the serial number of the dbus message\&.
.TP
\fBdbus\fR \fBunknown\fR ?\fIbusID\fR? ?\fB-details\fR? ?\fIpath\fR ?\fIscript\fR??
Register a \fIscript\fR to be called when an unknown method is invoked at
the specified \fIpath\fR\&.
See \fBEvent Handlers\fR below for more information\&.
.sp
If the \fIpath\fR argument is an empty string, \fIscript\fR will be executed
whenever an unknown method call message is received for any path, unless a
dedicated unknown handler for the exact path has been defined\&.
If \fIscript\fR is an empty string, the currently registered command for the
specified path will be unregistered\&.
.sp
When a \fIscript\fR argument is specified, even if it is an empty string,
the command may fail if another interpreter has already registered an unknown
handler for the exact same path\&.
See \fBSlave Interpreters\fR below for more information\&.
.sp
If the \fIscript\fR argument is not specified, the currently registered
command for the specified path, if any, is returned\&.
If no \fIpath\fR argument is specified, a list of all paths and their
registered unknown handlers is returned\&.
.sp
An unknown handler will usually return an error, but it is also possible to
return a non-error response\&. The \fBdbus\fR \fBerror\fR and
\fBdbus\fR \fBreturn\fR subcommands should be used for this
purpose\&.
Contrary to the \fBdbus\fR \fBmethod\fR subcommand, the return
value of the handler will not automatically be returned to the caller\&.
Any uncaught error in the evaluation of \fIscript\fR will be reported back
to the caller\&.
.sp
The \fB-details\fR option causes variant arguments to be represented as a
list with two elements: The first list element contains the signature of the
argument and the second list element is the value\&.
.sp
It will generally not be necessary to set up unknown handlers\&. If no unknown
handler is specified, the package returns an
\fBorg\&.freedesktop\&.dbus\&.error\&.unknownmethod\fR error back to the caller of
an unknown method\&.
.TP
\fBdbus\fR \fBvalidate\fR \fIclass\fR \fIstring\fR
Validates \fIstring\fR against the rules of the D-Bus specification for
the type of value specified by \fIclass\fR\&. Returns 1 if validation passes,
otherwise returns 0\&. The following classes are recognized (the class name
can be abbreviated):
.RS
.TP
\fBinterface\fR
Two or more dot-separated non-empty elements\&.
Each element only contains the ASCII characters
"[A-Z][a-z][0-9]_" and does not begin with a digit\&.
.TP
\fBmember\fR
A string that only contains the ASCII characters
"[A-Z][a-z][0-9]_" and does not begin with a digit\&.
.TP
\fBname\fR
Either a unique connection name, or a well-known
connection name\&. Unique connection names begin with a colon and consist of
at least two dot-separated non-empty elements\&. Each element only contains
the ASCII characters "[A-Z][a-z][0-9]_"\&.
Well-known connection names consist of at least two dot-separated
non-empty elements\&. Each element only contains the ASCII characters
"[A-Z][a-z][0-9]_" and does not begin with a digit\&.
.TP
\fBpath\fR
A slash followed by zero or more slash-separated
non-empty elements\&. Each element only contains the ASCII characters
"[A-Z][a-z][0-9]_"\&.
.TP
\fBsignature\fR
A valid D-Bus message type signature\&. See
\fBSignatures\fR below for more information on what constitutes a
valid signature\&.
.RE
.sp
.PP
.SH "EVENT HANDLERS"
The \fBcall\fR, \fBlisten\fR, \fBmethod\fR and \fBmonitor\fR
methods provide the ability to define event handlers\&. The specified script
will be used as the prefix for a command that will be evaluated whenever
the corresponding DBus event occurs\&. When the DBus event occurs, a Tcl
command will be generated by concatenating the script with one or more
arguments\&. The first argument is a dict containing information about the
event\&. If the DBus event contained any arguments they will be appended to
the command as seperate arguments\&.
.PP
The dict with the event details contains the following information:
.TP
member
The interface member being invoked (for methods) or emitted
(for signals)\&.
.TP
interface
The interface this message is being sent to (for methods)
or being emitted from (for signals)\&. The interface name is fully-qualified\&.
.TP
path
The object path this message is being sent to (for methods) or
being emitted from (for signals)\&.
.TP
sender
The unique name of the connection which originated this message,
or the empty string if unknown or inapplicable\&. The sender is filled in by
the message bus\&. Note, the returned sender is always the unique bus name\&.
Connections may own multiple other bus names, but those are not found in the
sender field\&.
.TP
destination
The destination of a message or the empty string if there
is none set\&.
.TP
messagetype
The type of a message\&. Possible values are
\fBmethod_call\fR, \fBmethod_return\fR, \fBerror\fR, and \fBsignal\fR\&.
.TP
signature
The type signature of the message, i\&.e\&. the type specification
of the arguments in the message payload\&. See \fBSignatures\fR below for
more information\&.
.TP
serial
The serial of a message or 0 if none has been specified\&. The
message's serial number is provided by the application sending the message
and is used to identify replies to this message\&. All messages received on a
connection will have a serial provided by the remote application\&. When
sending messages a serial will automatically be assigned by the dbus
library\&.
.TP
replyserial
The serial that the message is a reply to or 0 if none\&.
.TP
noreply
Flag indicating if the sender expects a reply\&. Set to 1 if a
reply is \fInot\fR required\&.
.TP
autostart
Flag indicating if the message will cause an owner for
destination name to be auto-started\&.
.TP
errorname
The error name of a received error message\&. An empty string
for all other message types\&.
.PP
The event handlers are excuted at global level (outside the context of any
Tcl procedure) in the interpreter in which the event handler was installed\&.
.SH SIGNATURES
The DBus specification defines typed arguments\&. This doesn't fit well with
the Tcl philosophy of \fIeverything is a string\fR\&. To be able to closely
control the type of the arguments to be sent onto the DBus a \fBsignature\fR
can be supplied\&. The signature definition is exactly the same as in the DBus
specification\&. A signature is a string where a single character or group of
characters specifies the type of an argument\&. The following types exist:
.TP
s
A UTF-8 encoded, nul-terminated Unicode string\&.
.TP
b
A boolean, FALSE (0), or TRUE (1)\&.
.TP
y
A byte (8-bit unsigned integer)\&.
.TP
n
A 16-bit signed integer\&.
.TP
q
A 16-bit unsigned integer\&.
.TP
i
A 32-bit signed integer\&.
.TP
u
A 32-bit unsigned integer\&.
.TP
x
A 64-bit signed integer\&.
.TP
t
A 64-bit unsigned integer\&.
.TP
d
An 8-byte double in IEEE 754 format\&.
.TP
h
A file descriptor\&.
.TP
g
A type signature\&.
.TP
o
An object path\&.
.TP
a#
A D-Bus array type, which is similar to a Tcl list\&. The # specifies
the type of the array elements\&. This can be any type, including another
array, a struct or a dict entry\&.
.TP
v
A D-Bus variant type\&. The provided value should be a two-element list,
containing a signature and the actual value\&. See \fBVariant Arguments\fR
for more information\&.
.TP
(\&.\&.\&.)
A struct\&. The string inside the parentheses defines the types of
the arguments within the struct, which may consist of a combination of any
of the existing types\&.
.TP
{##}
A dict entry\&. Dict entries may only occur as array elements\&. The
first # specifies the type of the dict key\&. This must be a basic type
(one of 'sbynqiuxtdgo')\&. The second # specifies the type of the dict value\&.
This can again be any existing type\&.
.PP
\fIExample\fR: The signature 'vaas(id)a{i(ss)}' specifies four arguments and
translates to Tcl terminology as follows: The type of the first argument
('v') is extracted from its value\&. The second argument ('aas') is a list
containing lists of strings\&. The third argument ('(id)') is a list containing
an integer and a double\&. The last argument ('a{i(ss)}') is a dict (an array
of dict entries) with integer keys and each value is a list of two strings\&.
.SS "VARIANT ARGUMENTS"
When a signature specifies that an argument is of type "variant", the
argument can still be almost anything\&. Additional information needs to be
located to determine how to package the value for transmission onto the
dbus\&. The preferred way is for the argument to be a two-element list where
the first element specifies the signature for the value and the second
element is the actual value\&.
.PP
The signature for a variant argument has to specify a single complete type\&.
The value of the second list element must match the signature, otherwise an
error will be reported\&.
.PP
If the value provided for a variant argument is not a two-element list, or
the first element is not a valid signature for a single complete type, the
code will attempt to automatically determine the type of the provided value\&.
It does this by selecting a signature based on the internal representation
of the value according to the following table:
.TP
string: s
.TP
int: i
.TP
wideInt: x
.TP
double: d
.TP
boolean: b
.TP
list: as
.TP
dict: a{ss}
.TP
anything else: s
.PP
.SS "FILE DESCRIPTORS"
On output, the value provided for a file handler argument must be an open Tcl
channel (such as has been created with the open or socket commands)\&. An error
will be thrown if the value does not represent an open channel, or if the dbus
connection does not support passing file handler arguments\&.
.PP
On input, a new channel will be created and its name passed to the script\&. The
new channel is opened for both reading and writing\&. If this is not desired,
either direction may be closed using the appropriate half-close version of the
close command\&.
.PP
The channel name is likely to be different in the two involved applications\&.
When finished with the channel, both parties are responsible for closing the
channel using their own channel reference\&.
.SH "SLAVE INTERPRETERS"
The standard D-Bus library \fBlibdbus\fR will only assign a single unique
bus name per application\&. This means that slave interpreters that connect to
the D-Bus will get the same unique bus name as the main interpreter, or any
other slave interpreter that has connected to the D-Bus\&.
.PP
It is not a problem if multiple interpreters register a listener for the
exact same signal\&. The \fBdbus\fR package will execute the
commands for all interpreters (in an undefined order)\&. The same applies to
monitor commands registered by different interpreters\&. However, a method
call generally causes a result being returned to the caller\&. Therefor there
should only be exactly one handler registered for a specific method\&. If any
interpreter tries to register a method handler for an interface and member
at a path that is already registered by another interpreter, the request
will be denied\&.
.SH COPYRIGHT
.nf
Copyright (c) 2008-2015 Schelte Bron

.fi