require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_UVM_UVM_MAP_H_)) {
    eval 'sub _UVM_UVM_MAP_H_ () {1;}' unless defined(&_UVM_UVM_MAP_H_);
    require 'sys/mutex.ph';
    require 'sys/rwlock.ph';
    if(defined(&_KERNEL)) {
	eval 'sub UVM_MAP_CLIP_START {
	    my($_map, $_entry, $_addr) = @_;
    	    eval q( &do {  &KASSERT(($_entry)-> &end + ($_entry)-> &fspace > ($_addr));  &if (($_entry)-> &start < ($_addr))  &uvm_map_clip_start(($_map), ($_entry), ($_addr)); }  &while (0));
	}' unless defined(&UVM_MAP_CLIP_START);
	eval 'sub UVM_MAP_CLIP_END {
	    my($_map, $_entry, $_addr) = @_;
    	    eval q( &do {  &KASSERT(($_entry)-> &start < ($_addr));  &if (($_entry)-> &end > ($_addr))  &uvm_map_clip_end(($_map), ($_entry), ($_addr)); }  &while (0));
	}' unless defined(&UVM_MAP_CLIP_END);
	eval 'sub UVM_EXTRACT_FIXPROT () {0x8;}' unless defined(&UVM_EXTRACT_FIXPROT);
    }
    require 'uvm/uvm_anon.ph';
    eval 'sub uvm_map_entry_start_copy () { &start;}' unless defined(&uvm_map_entry_start_copy);
    eval 'sub uvm_map_entry_stop_copy () { &flags;}' unless defined(&uvm_map_entry_stop_copy);
    eval 'sub UVM_MAP_STATIC () {0x1;}' unless defined(&UVM_MAP_STATIC);
    eval 'sub UVM_MAP_KMEM () {0x2;}' unless defined(&UVM_MAP_KMEM);
    eval 'sub VM_MAPENT_ISWIRED {
        my($entry) = @_;
	    eval q((($entry)-> &wired_count != 0));
    }' unless defined(&VM_MAPENT_ISWIRED);
    eval 'sub VM_MAP_PAGEABLE () {0x1;}' unless defined(&VM_MAP_PAGEABLE);
    eval 'sub VM_MAP_INTRSAFE () {0x2;}' unless defined(&VM_MAP_INTRSAFE);
    eval 'sub VM_MAP_WIREFUTURE () {0x4;}' unless defined(&VM_MAP_WIREFUTURE);
    eval 'sub VM_MAP_BUSY () {0x8;}' unless defined(&VM_MAP_BUSY);
    eval 'sub VM_MAP_WANTLOCK () {0x10;}' unless defined(&VM_MAP_WANTLOCK);
    eval 'sub VM_MAP_GUARDPAGES () {0x20;}' unless defined(&VM_MAP_GUARDPAGES);
    eval 'sub VM_MAP_ISVMSPACE () {0x40;}' unless defined(&VM_MAP_ISVMSPACE);
    if(!defined(&MAX_KMAPENT)) {
	eval 'sub MAX_KMAPENT () {1024;}' unless defined(&MAX_KMAPENT);
    }
    if(defined(&_KERNEL)) {
	eval 'sub vm_map_modflags {
	    my($map, $set, $clear) = @_;
    	    eval q( &do {  &mtx_enter(($map)-> &flags_lock); ($map)-> &flags = (($map)-> &flags | ($set)) & ~($clear);  &mtx_leave(($map)-> &flags_lock); }  &while (0));
	}' unless defined(&vm_map_modflags);
    }
    if(defined(&_KERNEL)) {
    }
    if(defined(&_KERNEL)) {
	require 'sys/time.ph';
	require 'sys/systm.ph';
	if(defined(&DIAGNOSTIC)) {
	    eval 'sub vm_map_lock_try {
	        my($map) = @_;
    		eval q( &vm_map_lock_try_ln($map,  &__FILE__,  &__LINE__));
	    }' unless defined(&vm_map_lock_try);
	    eval 'sub vm_map_lock {
	        my($map) = @_;
    		eval q( &vm_map_lock_ln($map,  &__FILE__,  &__LINE__));
	    }' unless defined(&vm_map_lock);
	    eval 'sub vm_map_lock_read {
	        my($map) = @_;
    		eval q( &vm_map_lock_read_ln($map,  &__FILE__,  &__LINE__));
	    }' unless defined(&vm_map_lock_read);
	    eval 'sub vm_map_unlock {
	        my($map) = @_;
    		eval q( &vm_map_unlock_ln($map,  &__FILE__,  &__LINE__));
	    }' unless defined(&vm_map_unlock);
	    eval 'sub vm_map_unlock_read {
	        my($map) = @_;
    		eval q( &vm_map_unlock_read_ln($map,  &__FILE__,  &__LINE__));
	    }' unless defined(&vm_map_unlock_read);
	    eval 'sub vm_map_downgrade {
	        my($map) = @_;
    		eval q( &vm_map_downgrade_ln($map,  &__FILE__,  &__LINE__));
	    }' unless defined(&vm_map_downgrade);
	    eval 'sub vm_map_upgrade {
	        my($map) = @_;
    		eval q( &vm_map_upgrade_ln($map,  &__FILE__,  &__LINE__));
	    }' unless defined(&vm_map_upgrade);
	    eval 'sub vm_map_busy {
	        my($map) = @_;
    		eval q( &vm_map_busy_ln($map,  &__FILE__,  &__LINE__));
	    }' unless defined(&vm_map_busy);
	    eval 'sub vm_map_unbusy {
	        my($map) = @_;
    		eval q( &vm_map_unbusy_ln($map,  &__FILE__,  &__LINE__));
	    }' unless defined(&vm_map_unbusy);
	} else {
	    eval 'sub vm_map_lock_try {
	        my($map) = @_;
    		eval q( &vm_map_lock_try_ln($map,  &NULL, 0));
	    }' unless defined(&vm_map_lock_try);
	    eval 'sub vm_map_lock {
	        my($map) = @_;
    		eval q( &vm_map_lock_ln($map,  &NULL, 0));
	    }' unless defined(&vm_map_lock);
	    eval 'sub vm_map_lock_read {
	        my($map) = @_;
    		eval q( &vm_map_lock_read_ln($map,  &NULL, 0));
	    }' unless defined(&vm_map_lock_read);
	    eval 'sub vm_map_unlock {
	        my($map) = @_;
    		eval q( &vm_map_unlock_ln($map,  &NULL, 0));
	    }' unless defined(&vm_map_unlock);
	    eval 'sub vm_map_unlock_read {
	        my($map) = @_;
    		eval q( &vm_map_unlock_read_ln($map,  &NULL, 0));
	    }' unless defined(&vm_map_unlock_read);
	    eval 'sub vm_map_downgrade {
	        my($map) = @_;
    		eval q( &vm_map_downgrade_ln($map,  &NULL, 0));
	    }' unless defined(&vm_map_downgrade);
	    eval 'sub vm_map_upgrade {
	        my($map) = @_;
    		eval q( &vm_map_upgrade_ln($map,  &NULL, 0));
	    }' unless defined(&vm_map_upgrade);
	    eval 'sub vm_map_busy {
	        my($map) = @_;
    		eval q( &vm_map_busy_ln($map,  &NULL, 0));
	    }' unless defined(&vm_map_busy);
	    eval 'sub vm_map_unbusy {
	        my($map) = @_;
    		eval q( &vm_map_unbusy_ln($map,  &NULL, 0));
	    }' unless defined(&vm_map_unbusy);
	}
    }
    eval 'sub vm_map_min {
        my($map) = @_;
	    eval q((($map)-> &min_offset));
    }' unless defined(&vm_map_min);
    eval 'sub vm_map_max {
        my($map) = @_;
	    eval q((($map)-> &max_offset));
    }' unless defined(&vm_map_max);
    eval 'sub vm_map_pmap {
        my($map) = @_;
	    eval q((($map)-> &pmap));
    }' unless defined(&vm_map_pmap);
}
1;
