require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS__ENDIAN_H_)) {
    eval 'sub _SYS__ENDIAN_H_ () {1;}' unless defined(&_SYS__ENDIAN_H_);
    require 'sys/_types.ph';
    eval 'sub __FROM_SYS__ENDIAN () {1;}' unless defined(&__FROM_SYS__ENDIAN);
    require 'machine/endian.ph';
    undef(&__FROM_SYS__ENDIAN) if defined(&__FROM_SYS__ENDIAN);
    eval 'sub _LITTLE_ENDIAN () {1234;}' unless defined(&_LITTLE_ENDIAN);
    eval 'sub _BIG_ENDIAN () {4321;}' unless defined(&_BIG_ENDIAN);
    eval 'sub _PDP_ENDIAN () {3412;}' unless defined(&_PDP_ENDIAN);
    if(defined(&__GNUC__)) {
	eval 'sub __swap16gen {
	    my($x) = @_;
    	    eval q( &__statement({  &__uint16_t  &__swap16gen_x = ($x); ( &__uint16_t)(( &__swap16gen_x & 0xff) << 8| ( &__swap16gen_x & 0xff00) >> 8); }));
	}' unless defined(&__swap16gen);
	eval 'sub __swap32gen {
	    my($x) = @_;
    	    eval q( &__statement({  &__uint32_t  &__swap32gen_x = ($x); ( &__uint32_t)(( &__swap32gen_x & 0xff) << 24| ( &__swap32gen_x & 0xff00) << 8| ( &__swap32gen_x & 0xff0000) >> 8| ( &__swap32gen_x & 0xff000000) >> 24); }));
	}' unless defined(&__swap32gen);
	eval 'sub __swap64gen {
	    my($x) = @_;
    	    eval q( &__statement({  &__uint64_t  &__swap64gen_x = ($x); ( &__uint64_t)(( &__swap64gen_x & 0xff) << 56| ( &__swap64gen_x & 0xff00) << 40| ( &__swap64gen_x & 0xff0000) << 24| ( &__swap64gen_x & 0xff000000) << 8| ( &__swap64gen_x & 0xff00000000) >> 8| ( &__swap64gen_x & 0xff0000000000) >> 24| ( &__swap64gen_x & 0xff000000000000) >> 40| ( &__swap64gen_x & 0xff00000000000000) >> 56); }));
	}' unless defined(&__swap64gen);
    } else {
	eval 'sub __swap16gen {
	    my($x) = @_;
    	    eval q(( &__uint16_t)((( &__uint16_t)($x) & 0xff) << 8| (( &__uint16_t)($x) & 0xff00) >> 8));
	}' unless defined(&__swap16gen);
	eval 'sub __swap32gen {
	    my($x) = @_;
    	    eval q(( &__uint32_t)((( &__uint32_t)($x) & 0xff) << 24| (( &__uint32_t)($x) & 0xff00) << 8| (( &__uint32_t)($x) & 0xff0000) >> 8| (( &__uint32_t)($x) & 0xff000000) >> 24));
	}' unless defined(&__swap32gen);
	eval 'sub __swap64gen {
	    my($x) = @_;
    	    eval q(( &__uint64_t)(((( &__uint64_t)($x) & 0xff) << 56) | (( &__uint64_t)($x) & 0xff00) << 40| (( &__uint64_t)($x) & 0xff0000) << 24| (( &__uint64_t)($x) & 0xff000000) << 8| (( &__uint64_t)($x) & 0xff00000000) >> 8| (( &__uint64_t)($x) & 0xff0000000000) >> 24| (( &__uint64_t)($x) & 0xff000000000000) >> 40| (( &__uint64_t)($x) & 0xff00000000000000) >> 56));
	}' unless defined(&__swap64gen);
    }
    if(defined(&__HAVE_MD_SWAP)) {
	if((defined(&__GNUC__) ? &__GNUC__ : undef)) {
	    eval 'sub __swap16 {
	        my($x) = @_;
    		eval q( &__statement({  &__uint16_t  &__swap16_x = ($x);  &__builtin_constant_p($x) ?  &__swap16gen( &__swap16_x) :  &__swap16md( &__swap16_x); }));
	    }' unless defined(&__swap16);
	    eval 'sub __swap32 {
	        my($x) = @_;
    		eval q( &__statement({  &__uint32_t  &__swap32_x = ($x);  &__builtin_constant_p($x) ?  &__swap32gen( &__swap32_x) :  &__swap32md( &__swap32_x); }));
	    }' unless defined(&__swap32);
	    eval 'sub __swap64 {
	        my($x) = @_;
    		eval q( &__statement({  &__uint64_t  &__swap64_x = ($x);  &__builtin_constant_p($x) ?  &__swap64gen( &__swap64_x) :  &__swap64md( &__swap64_x); }));
	    }' unless defined(&__swap64);
	} else {
	    eval 'sub __swap16 () { &__swap16md;}' unless defined(&__swap16);
	    eval 'sub __swap32 () { &__swap32md;}' unless defined(&__swap32);
	    eval 'sub __swap64 () { &__swap64md;}' unless defined(&__swap64);
	}
    } else {
	eval 'sub __swap16 () { &__swap16gen;}' unless defined(&__swap16);
	eval 'sub __swap32 () { &__swap32gen;}' unless defined(&__swap32);
	eval 'sub __swap64 () { &__swap64gen;}' unless defined(&__swap64);
    }
    eval 'sub __swap16_multi {
        my($v, $n) = @_;
	    eval q( &do {  &__size_t  &__swap16_multi_n = ($n);  &__uint16_t * &__swap16_multi_v = ($v);  &while ( &__swap16_multi_n) { * &__swap16_multi_v =  &swap16(* &__swap16_multi_v);  &__swap16_multi_v++;  &__swap16_multi_n--; } }  &while (0));
    }' unless defined(&__swap16_multi);
    if((defined(&_BYTE_ORDER) ? &_BYTE_ORDER : undef) == (defined(&_LITTLE_ENDIAN) ? &_LITTLE_ENDIAN : undef)) {
	eval 'sub _QUAD_HIGHWORD () {1;}' unless defined(&_QUAD_HIGHWORD);
	eval 'sub _QUAD_LOWWORD () {0;}' unless defined(&_QUAD_LOWWORD);
	eval 'sub __htobe16 () { &__swap16;}' unless defined(&__htobe16);
	eval 'sub __htobe32 () { &__swap32;}' unless defined(&__htobe32);
	eval 'sub __htobe64 () { &__swap64;}' unless defined(&__htobe64);
	eval 'sub __htole16 {
	    my($x) = @_;
    	    eval q((( &__uint16_t)($x)));
	}' unless defined(&__htole16);
	eval 'sub __htole32 {
	    my($x) = @_;
    	    eval q((( &__uint32_t)($x)));
	}' unless defined(&__htole32);
	eval 'sub __htole64 {
	    my($x) = @_;
    	    eval q((( &__uint64_t)($x)));
	}' unless defined(&__htole64);
	if(defined(&_KERNEL)) {
	    if(defined(&__HAVE_MD_SWAPIO)) {
		eval 'sub __bemtoh16 {
		    my($_x) = @_;
    		    eval q( &__mswap16($_x));
		}' unless defined(&__bemtoh16);
		eval 'sub __bemtoh32 {
		    my($_x) = @_;
    		    eval q( &__mswap32($_x));
		}' unless defined(&__bemtoh32);
		eval 'sub __bemtoh64 {
		    my($_x) = @_;
    		    eval q( &__mswap64($_x));
		}' unless defined(&__bemtoh64);
		eval 'sub __htobem16 {
		    my($_x, $_v) = @_;
    		    eval q( &__swapm16(($_x), ($_v)));
		}' unless defined(&__htobem16);
		eval 'sub __htobem32 {
		    my($_x, $_v) = @_;
    		    eval q( &__swapm32(($_x), ($_v)));
		}' unless defined(&__htobem32);
		eval 'sub __htobem64 {
		    my($_x, $_v) = @_;
    		    eval q( &__swapm64(($_x), ($_v)));
		}' unless defined(&__htobem64);
	    }
	}
    }
    if((defined(&_BYTE_ORDER) ? &_BYTE_ORDER : undef) == (defined(&_BIG_ENDIAN) ? &_BIG_ENDIAN : undef)) {
	eval 'sub _QUAD_HIGHWORD () {0;}' unless defined(&_QUAD_HIGHWORD);
	eval 'sub _QUAD_LOWWORD () {1;}' unless defined(&_QUAD_LOWWORD);
	eval 'sub __htobe16 {
	    my($x) = @_;
    	    eval q((( &__uint16_t)($x)));
	}' unless defined(&__htobe16);
	eval 'sub __htobe32 {
	    my($x) = @_;
    	    eval q((( &__uint32_t)($x)));
	}' unless defined(&__htobe32);
	eval 'sub __htobe64 {
	    my($x) = @_;
    	    eval q((( &__uint64_t)($x)));
	}' unless defined(&__htobe64);
	eval 'sub __htole16 () { &__swap16;}' unless defined(&__htole16);
	eval 'sub __htole32 () { &__swap32;}' unless defined(&__htole32);
	eval 'sub __htole64 () { &__swap64;}' unless defined(&__htole64);
	if(defined(&_KERNEL)) {
	    if(defined(&__HAVE_MD_SWAPIO)) {
		eval 'sub __lemtoh16 {
		    my($_x) = @_;
    		    eval q( &__mswap16($_x));
		}' unless defined(&__lemtoh16);
		eval 'sub __lemtoh32 {
		    my($_x) = @_;
    		    eval q( &__mswap32($_x));
		}' unless defined(&__lemtoh32);
		eval 'sub __lemtoh64 {
		    my($_x) = @_;
    		    eval q( &__mswap64($_x));
		}' unless defined(&__lemtoh64);
		eval 'sub __htolem16 {
		    my($_x, $_v) = @_;
    		    eval q( &__swapm16(($_x), ($_v)));
		}' unless defined(&__htolem16);
		eval 'sub __htolem32 {
		    my($_x, $_v) = @_;
    		    eval q( &__swapm32(($_x), ($_v)));
		}' unless defined(&__htolem32);
		eval 'sub __htolem64 {
		    my($_x, $_v) = @_;
    		    eval q( &__swapm64(($_x), ($_v)));
		}' unless defined(&__htolem64);
	    }
	}
    }
    if(defined(&_KERNEL)) {
	unless(defined(&__bemtoh16)) {
	    eval 'sub __bemtoh16 {
	        my($_x) = @_;
    		eval q( &__htobe16(*( &__uint16_t *)($_x)));
	    }' unless defined(&__bemtoh16);
	    eval 'sub __bemtoh32 {
	        my($_x) = @_;
    		eval q( &__htobe32(*( &__uint32_t *)($_x)));
	    }' unless defined(&__bemtoh32);
	    eval 'sub __bemtoh64 {
	        my($_x) = @_;
    		eval q( &__htobe64(*( &__uint64_t *)($_x)));
	    }' unless defined(&__bemtoh64);
	}
	unless(defined(&__htobem16)) {
	    eval 'sub __htobem16 {
	        my($_x, $_v) = @_;
    		eval q((*( &__uint16_t *)($_x) =  &__htobe16($_v)));
	    }' unless defined(&__htobem16);
	    eval 'sub __htobem32 {
	        my($_x, $_v) = @_;
    		eval q((*( &__uint32_t *)($_x) =  &__htobe32($_v)));
	    }' unless defined(&__htobem32);
	    eval 'sub __htobem64 {
	        my($_x, $_v) = @_;
    		eval q((*( &__uint64_t *)($_x) =  &__htobe64($_v)));
	    }' unless defined(&__htobem64);
	}
	unless(defined(&__lemtoh16)) {
	    eval 'sub __lemtoh16 {
	        my($_x) = @_;
    		eval q( &__htole16(*( &__uint16_t *)($_x)));
	    }' unless defined(&__lemtoh16);
	    eval 'sub __lemtoh32 {
	        my($_x) = @_;
    		eval q( &__htole32(*( &__uint32_t *)($_x)));
	    }' unless defined(&__lemtoh32);
	    eval 'sub __lemtoh64 {
	        my($_x) = @_;
    		eval q( &__htole64(*( &__uint64_t *)($_x)));
	    }' unless defined(&__lemtoh64);
	}
	unless(defined(&__htolem16)) {
	    eval 'sub __htolem16 {
	        my($_x, $_v) = @_;
    		eval q((*( &__uint16_t *)($_x) =  &__htole16($_v)));
	    }' unless defined(&__htolem16);
	    eval 'sub __htolem32 {
	        my($_x, $_v) = @_;
    		eval q((*( &__uint32_t *)($_x) =  &__htole32($_v)));
	    }' unless defined(&__htolem32);
	    eval 'sub __htolem64 {
	        my($_x, $_v) = @_;
    		eval q((*( &__uint64_t *)($_x) =  &__htole64($_v)));
	    }' unless defined(&__htolem64);
	}
    }
}
1;
