require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MACHINE_PARAM_H_)) {
    eval 'sub _MACHINE_PARAM_H_ () {1;}' unless defined(&_MACHINE_PARAM_H_);
    if(defined(&_KERNEL)) {
	if(defined(&_LOCORE)) {
	    require 'machine/psl.ph';
	} else {
	    require 'machine/cpu.ph';
	}
    }
    eval 'sub _MACHINE () { &amd64;}' unless defined(&_MACHINE);
    eval 'sub MACHINE () {"amd64";}' unless defined(&MACHINE);
    eval 'sub _MACHINE_ARCH () { &amd64;}' unless defined(&_MACHINE_ARCH);
    eval 'sub MACHINE_ARCH () {"amd64";}' unless defined(&MACHINE_ARCH);
    eval 'sub MID_MACHINE () { &MID_AMD64;}' unless defined(&MID_MACHINE);
    eval 'sub PAGE_SHIFT () {12;}' unless defined(&PAGE_SHIFT);
    eval 'sub PAGE_SIZE () {(1<<  &PAGE_SHIFT);}' unless defined(&PAGE_SIZE);
    eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
    eval 'sub KERNBASE () {0xffffffff80000000;}' unless defined(&KERNBASE);
    if(defined(&_KERNEL)) {
	eval 'sub KERNTEXTOFF () {( &KERNBASE+0x1000000);}' unless defined(&KERNTEXTOFF);
	eval 'sub KERNTEXTOFF_HI () {0xffffffff;}' unless defined(&KERNTEXTOFF_HI);
	eval 'sub KERNTEXTOFF_LO () {0x81000000;}' unless defined(&KERNTEXTOFF_LO);
	eval 'sub KERNBASE_HI () {0xffffffff;}' unless defined(&KERNBASE_HI);
	eval 'sub KERNBASE_LO () {0x80000000;}' unless defined(&KERNBASE_LO);
	eval 'sub NBPG () { &PAGE_SIZE;}' unless defined(&NBPG);
	eval 'sub PGSHIFT () { &PAGE_SHIFT;}' unless defined(&PGSHIFT);
	eval 'sub PGOFSET () { &PAGE_MASK;}' unless defined(&PGOFSET);
	eval 'sub UPAGES () {5;}' unless defined(&UPAGES);
	eval 'sub USPACE () {( &UPAGES *  &PAGE_SIZE);}' unless defined(&USPACE);
	eval 'sub USPACE_ALIGN () {0;}' unless defined(&USPACE_ALIGN);
	eval 'sub NMBCLUSTERS () {6144;}' unless defined(&NMBCLUSTERS);
	unless(defined(&MSGBUFSIZE)) {
	    eval 'sub MSGBUFSIZE () {(16*  &PAGE_SIZE);}' unless defined(&MSGBUFSIZE);
	}
	eval 'sub NKMEMPAGES_MAX_DEFAULT () {((128* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MAX_DEFAULT);
    }
}
1;
