require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_IF_BWIREG_H)) {
    eval 'sub _IF_BWIREG_H () {1;}' unless defined(&_IF_BWIREG_H);
    eval 'sub BWI_FLAGS () {0xf18;}' unless defined(&BWI_FLAGS);
    eval 'sub BWI_FLAGS_INTR_MASK () {0x3f;}' unless defined(&BWI_FLAGS_INTR_MASK);
    eval 'sub BWI_IMSTATE () {0xf90;}' unless defined(&BWI_IMSTATE);
    eval 'sub BWI_IMSTATE_INBAND_ERR () {(1<< 17);}' unless defined(&BWI_IMSTATE_INBAND_ERR);
    eval 'sub BWI_IMSTATE_TIMEOUT () {(1<< 18);}' unless defined(&BWI_IMSTATE_TIMEOUT);
    eval 'sub BWI_INTRVEC () {0xf94;}' unless defined(&BWI_INTRVEC);
    eval 'sub BWI_STATE_LO () {0xf98;}' unless defined(&BWI_STATE_LO);
    eval 'sub BWI_STATE_LO_RESET () {(1<< 0);}' unless defined(&BWI_STATE_LO_RESET);
    eval 'sub BWI_STATE_LO_DISABLE1 () {(1<< 1);}' unless defined(&BWI_STATE_LO_DISABLE1);
    eval 'sub BWI_STATE_LO_DISABLE2 () {(1<< 2);}' unless defined(&BWI_STATE_LO_DISABLE2);
    eval 'sub BWI_STATE_LO_CLOCK () {(1<< 16);}' unless defined(&BWI_STATE_LO_CLOCK);
    eval 'sub BWI_STATE_LO_GATED_CLOCK () {(1<< 17);}' unless defined(&BWI_STATE_LO_GATED_CLOCK);
    eval 'sub BWI_STATE_LO_FLAG_PHYCLKEN () {(1<< 0);}' unless defined(&BWI_STATE_LO_FLAG_PHYCLKEN);
    eval 'sub BWI_STATE_LO_FLAG_PHYRST () {(1<< 1);}' unless defined(&BWI_STATE_LO_FLAG_PHYRST);
    eval 'sub BWI_STATE_LO_FLAG_PHYLNK () {(1<< 11);}' unless defined(&BWI_STATE_LO_FLAG_PHYLNK);
    eval 'sub BWI_STATE_LO_FLAGS_MASK () {0x3ffc0000;}' unless defined(&BWI_STATE_LO_FLAGS_MASK);
    eval 'sub BWI_STATE_HI () {0xf9c;}' unless defined(&BWI_STATE_HI);
    eval 'sub BWI_STATE_HI_SERROR () {(1<< 0);}' unless defined(&BWI_STATE_HI_SERROR);
    eval 'sub BWI_STATE_HI_BUSY () {(1<< 2);}' unless defined(&BWI_STATE_HI_BUSY);
    eval 'sub BWI_STATE_HI_FLAG_MAGIC1 () {0x1;}' unless defined(&BWI_STATE_HI_FLAG_MAGIC1);
    eval 'sub BWI_STATE_HI_FLAG_MAGIC2 () {0x2;}' unless defined(&BWI_STATE_HI_FLAG_MAGIC2);
    eval 'sub BWI_STATE_HI_FLAG_64BIT () {0x1000;}' unless defined(&BWI_STATE_HI_FLAG_64BIT);
    eval 'sub BWI_STATE_HI_FLAGS_MASK () {0x1fff0000;}' unless defined(&BWI_STATE_HI_FLAGS_MASK);
    eval 'sub BWI_CONF_LO () {0xfa8;}' unless defined(&BWI_CONF_LO);
    eval 'sub BWI_CONF_LO_SERVTO_MASK () {0x7;}' unless defined(&BWI_CONF_LO_SERVTO_MASK);
    eval 'sub BWI_CONF_LO_SERVTO () {2;}' unless defined(&BWI_CONF_LO_SERVTO);
    eval 'sub BWI_CONF_LO_REQTO_MASK () {0x70;}' unless defined(&BWI_CONF_LO_REQTO_MASK);
    eval 'sub BWI_CONF_LO_REQTO () {3;}' unless defined(&BWI_CONF_LO_REQTO);
    eval 'sub BWI_ID_LO () {0xff8;}' unless defined(&BWI_ID_LO);
    eval 'sub BWI_ID_LO_BUSREV_MASK () {0xf0000000;}' unless defined(&BWI_ID_LO_BUSREV_MASK);
    eval 'sub BWI_BUSREV_0 () {0;}' unless defined(&BWI_BUSREV_0);
    eval 'sub BWI_BUSREV_1 () {1;}' unless defined(&BWI_BUSREV_1);
    eval 'sub BWI_ID_HI () {0xffc;}' unless defined(&BWI_ID_HI);
    eval 'sub BWI_ID_HI_REGWIN_REV {
        my($v) = @_;
	    eval q(((($v) & 0xf) | ((($v) & 0x7000) >> 8)));
    }' unless defined(&BWI_ID_HI_REGWIN_REV);
    eval 'sub BWI_ID_HI_REGWIN_TYPE {
        my($v) = @_;
	    eval q(((($v) & 0x8ff0) >> 4));
    }' unless defined(&BWI_ID_HI_REGWIN_TYPE);
    eval 'sub BWI_ID_HI_REGWIN_VENDOR_MASK () {0xffff0000;}' unless defined(&BWI_ID_HI_REGWIN_VENDOR_MASK);
    eval 'sub BWI_INFO () {0x;}' unless defined(&BWI_INFO);
    eval 'sub BWI_INFO_BBPID_MASK () {0xffff;}' unless defined(&BWI_INFO_BBPID_MASK);
    eval 'sub BWI_INFO_BBPREV_MASK () {0xf0000;}' unless defined(&BWI_INFO_BBPREV_MASK);
    eval 'sub BWI_INFO_BBPPKG_MASK () {0xf00000;}' unless defined(&BWI_INFO_BBPPKG_MASK);
    eval 'sub BWI_INFO_NREGWIN_MASK () {0xf000000;}' unless defined(&BWI_INFO_NREGWIN_MASK);
    eval 'sub BWI_CAPABILITY () {0x4;}' unless defined(&BWI_CAPABILITY);
    eval 'sub BWI_CAP_CLKMODE () {(1<< 18);}' unless defined(&BWI_CAP_CLKMODE);
    eval 'sub BWI_CONTROL () {0x28;}' unless defined(&BWI_CONTROL);
    eval 'sub BWI_CONTROL_MAGIC0 () {0x3a4;}' unless defined(&BWI_CONTROL_MAGIC0);
    eval 'sub BWI_CONTROL_MAGIC1 () {0xa4;}' unless defined(&BWI_CONTROL_MAGIC1);
    eval 'sub BWI_PLL_ON_DELAY () {0xb0;}' unless defined(&BWI_PLL_ON_DELAY);
    eval 'sub BWI_FREQ_SEL_DELAY () {0xb4;}' unless defined(&BWI_FREQ_SEL_DELAY);
    eval 'sub BWI_CLOCK_CTRL () {0xb8;}' unless defined(&BWI_CLOCK_CTRL);
    eval 'sub BWI_CLOCK_CTRL_CLKSRC () {(7<< 0);}' unless defined(&BWI_CLOCK_CTRL_CLKSRC);
    eval 'sub BWI_CLOCK_CTRL_SLOW () {(1<< 11);}' unless defined(&BWI_CLOCK_CTRL_SLOW);
    eval 'sub BWI_CLOCK_CTRL_IGNPLL () {(1<< 12);}' unless defined(&BWI_CLOCK_CTRL_IGNPLL);
    eval 'sub BWI_CLOCK_CTRL_NODYN () {(1<< 13);}' unless defined(&BWI_CLOCK_CTRL_NODYN);
    eval 'sub BWI_CLOCK_CTRL_FDIV () {(0xffff << 16);}' unless defined(&BWI_CLOCK_CTRL_FDIV);
    eval 'sub BWI_CLKSRC_LP_OSC () {0;}' unless defined(&BWI_CLKSRC_LP_OSC);
    eval 'sub BWI_CLKSRC_CS_OSC () {1;}' unless defined(&BWI_CLKSRC_CS_OSC);
    eval 'sub BWI_CLKSRC_PCI () {2;}' unless defined(&BWI_CLKSRC_PCI);
    eval 'sub BWI_CLKSRC_MAX () {3;}' unless defined(&BWI_CLKSRC_MAX);
    eval 'sub BWI_CLKSRC_LP_OSC_FMIN () {25000;}' unless defined(&BWI_CLKSRC_LP_OSC_FMIN);
    eval 'sub BWI_CLKSRC_LP_OSC_FMAX () {43000;}' unless defined(&BWI_CLKSRC_LP_OSC_FMAX);
    eval 'sub BWI_CLKSRC_CS_OSC_FMIN () {19800000;}' unless defined(&BWI_CLKSRC_CS_OSC_FMIN);
    eval 'sub BWI_CLKSRC_CS_OSC_FMAX () {20200000;}' unless defined(&BWI_CLKSRC_CS_OSC_FMAX);
    eval 'sub BWI_CLKSRC_PCI_FMIN () {25000000;}' unless defined(&BWI_CLKSRC_PCI_FMIN);
    eval 'sub BWI_CLKSRC_PCI_FMAX () {34000000;}' unless defined(&BWI_CLKSRC_PCI_FMAX);
    eval 'sub BWI_CLOCK_INFO () {0xc0;}' unless defined(&BWI_CLOCK_INFO);
    eval 'sub BWI_CLOCK_INFO_FDIV () {(0xffff << 16);}' unless defined(&BWI_CLOCK_INFO_FDIV);
    eval 'sub BWI_BUS_ADDR () {0x50;}' unless defined(&BWI_BUS_ADDR);
    eval 'sub BWI_BUS_ADDR_MAGIC () {0xfd8;}' unless defined(&BWI_BUS_ADDR_MAGIC);
    eval 'sub BWI_BUS_DATA () {0x54;}' unless defined(&BWI_BUS_DATA);
    eval 'sub BWI_BUS_CONFIG () {0x108;}' unless defined(&BWI_BUS_CONFIG);
    eval 'sub BWI_BUS_CONFIG_PREFETCH () {(1<< 2);}' unless defined(&BWI_BUS_CONFIG_PREFETCH);
    eval 'sub BWI_BUS_CONFIG_BURST () {(1<< 3);}' unless defined(&BWI_BUS_CONFIG_BURST);
    eval 'sub BWI_BUS_CONFIG_MRM () {(1<< 5);}' unless defined(&BWI_BUS_CONFIG_MRM);
    eval 'sub BWI_TXRX_INTR_STATUS_BASE () {0x20;}' unless defined(&BWI_TXRX_INTR_STATUS_BASE);
    eval 'sub BWI_TXRX_INTR_MASK_BASE () {0x24;}' unless defined(&BWI_TXRX_INTR_MASK_BASE);
    eval 'sub BWI_TXRX_INTR_STATUS {
        my($i) = @_;
	    eval q(( &BWI_TXRX_INTR_STATUS_BASE + (($i) * 8)));
    }' unless defined(&BWI_TXRX_INTR_STATUS);
    eval 'sub BWI_TXRX_INTR_MASK {
        my($i) = @_;
	    eval q(( &BWI_TXRX_INTR_MASK_BASE + (($i) * 8)));
    }' unless defined(&BWI_TXRX_INTR_MASK);
    eval 'sub BWI_MAC_STATUS () {0x120;}' unless defined(&BWI_MAC_STATUS);
    eval 'sub BWI_MAC_STATUS_ENABLE () {(1 << 0);}' unless defined(&BWI_MAC_STATUS_ENABLE);
    eval 'sub BWI_MAC_STATUS_UCODE_START () {(1 << 1);}' unless defined(&BWI_MAC_STATUS_UCODE_START);
    eval 'sub BWI_MAC_STATUS_UCODE_JUMP0 () {(1 << 2);}' unless defined(&BWI_MAC_STATUS_UCODE_JUMP0);
    eval 'sub BWI_MAC_STATUS_IHREN () {(1 << 10);}' unless defined(&BWI_MAC_STATUS_IHREN);
    eval 'sub BWI_MAC_STATUS_GPOSEL_MASK () {(3 << 14);}' unless defined(&BWI_MAC_STATUS_GPOSEL_MASK);
    eval 'sub BWI_MAC_STATUS_BSWAP () {(1 << 16);}' unless defined(&BWI_MAC_STATUS_BSWAP);
    eval 'sub BWI_MAC_STATUS_INFRA () {(1 << 17);}' unless defined(&BWI_MAC_STATUS_INFRA);
    eval 'sub BWI_MAC_STATUS_OPMODE_HOSTAP () {(1 << 18);}' unless defined(&BWI_MAC_STATUS_OPMODE_HOSTAP);
    eval 'sub BWI_MAC_STATUS_RFLOCK () {(1 << 19);}' unless defined(&BWI_MAC_STATUS_RFLOCK);
    eval 'sub BWI_MAC_STATUS_PASS_BCN () {(1 << 20);}' unless defined(&BWI_MAC_STATUS_PASS_BCN);
    eval 'sub BWI_MAC_STATUS_PASS_BADPLCP () {(1 << 21);}' unless defined(&BWI_MAC_STATUS_PASS_BADPLCP);
    eval 'sub BWI_MAC_STATUS_PASS_CTL () {(1 << 22);}' unless defined(&BWI_MAC_STATUS_PASS_CTL);
    eval 'sub BWI_MAC_STATUS_PASS_BADFCS () {(1 << 23);}' unless defined(&BWI_MAC_STATUS_PASS_BADFCS);
    eval 'sub BWI_MAC_STATUS_PROMISC () {(1 << 24);}' unless defined(&BWI_MAC_STATUS_PROMISC);
    eval 'sub BWI_MAC_STATUS_HW_PS () {(1 << 25);}' unless defined(&BWI_MAC_STATUS_HW_PS);
    eval 'sub BWI_MAC_STATUS_WAKEUP () {(1 << 26);}' unless defined(&BWI_MAC_STATUS_WAKEUP);
    eval 'sub BWI_MAC_STATUS_PHYLNK () {(1 << 31);}' unless defined(&BWI_MAC_STATUS_PHYLNK);
    eval 'sub BWI_MAC_INTR_STATUS () {0x128;}' unless defined(&BWI_MAC_INTR_STATUS);
    eval 'sub BWI_MAC_INTR_MASK () {0x12c;}' unless defined(&BWI_MAC_INTR_MASK);
    eval 'sub BWI_MAC_TMPLT_CTRL () {0x130;}' unless defined(&BWI_MAC_TMPLT_CTRL);
    eval 'sub BWI_MAC_TMPLT_DATA () {0x134;}' unless defined(&BWI_MAC_TMPLT_DATA);
    eval 'sub BWI_MAC_PS_STATUS () {0x140;}' unless defined(&BWI_MAC_PS_STATUS);
    eval 'sub BWI_MOBJ_CTRL () {0x160;}' unless defined(&BWI_MOBJ_CTRL);
    eval 'sub BWI_MOBJ_CTRL_VAL {
        my($objid, $ofs) = @_;
	    eval q((($objid) << 16| ($ofs)));
    }' unless defined(&BWI_MOBJ_CTRL_VAL);
    eval 'sub BWI_MOBJ_DATA () {0x164;}' unless defined(&BWI_MOBJ_DATA);
    eval 'sub BWI_MOBJ_DATA_UNALIGN () {0x166;}' unless defined(&BWI_MOBJ_DATA_UNALIGN);
    eval 'sub BWI_WR_MOBJ_AUTOINC () {0x100;}' unless defined(&BWI_WR_MOBJ_AUTOINC);
    eval 'sub BWI_RD_MOBJ_AUTOINC () {0x200;}' unless defined(&BWI_RD_MOBJ_AUTOINC);
    eval 'sub BWI_FW_UCODE_MOBJ () {0x;}' unless defined(&BWI_FW_UCODE_MOBJ);
    eval 'sub BWI_COMM_MOBJ () {0x1;}' unless defined(&BWI_COMM_MOBJ);
    eval 'sub BWI_COMM_MOBJ_FWREV () {0x;}' unless defined(&BWI_COMM_MOBJ_FWREV);
    eval 'sub BWI_COMM_MOBJ_FWPATCHLV () {0x2;}' unless defined(&BWI_COMM_MOBJ_FWPATCHLV);
    eval 'sub BWI_COMM_MOBJ_SLOTTIME () {0x10;}' unless defined(&BWI_COMM_MOBJ_SLOTTIME);
    eval 'sub BWI_COMM_MOBJ_MACREV () {0x16;}' unless defined(&BWI_COMM_MOBJ_MACREV);
    eval 'sub BWI_COMM_MOBJ_TX_ACK () {0x22;}' unless defined(&BWI_COMM_MOBJ_TX_ACK);
    eval 'sub BWI_COMM_MOBJ_UCODE_STATE () {0x40;}' unless defined(&BWI_COMM_MOBJ_UCODE_STATE);
    eval 'sub BWI_COMM_MOBJ_SHRETRY_FB () {0x44;}' unless defined(&BWI_COMM_MOBJ_SHRETRY_FB);
    eval 'sub BWI_COMM_MOBJ_LGRETEY_FB () {0x46;}' unless defined(&BWI_COMM_MOBJ_LGRETEY_FB);
    eval 'sub BWI_COMM_MOBJ_TX_BEACON () {0x54;}' unless defined(&BWI_COMM_MOBJ_TX_BEACON);
    eval 'sub BWI_COMM_MOBJ_KEYTABLE_OFS () {0x56;}' unless defined(&BWI_COMM_MOBJ_KEYTABLE_OFS);
    eval 'sub BWI_COMM_MOBJ_TSSI_DS () {0x58;}' unless defined(&BWI_COMM_MOBJ_TSSI_DS);
    eval 'sub BWI_COMM_MOBJ_HFLAGS_LO () {0x5e;}' unless defined(&BWI_COMM_MOBJ_HFLAGS_LO);
    eval 'sub BWI_COMM_MOBJ_HFLAGS_MI () {0x60;}' unless defined(&BWI_COMM_MOBJ_HFLAGS_MI);
    eval 'sub BWI_COMM_MOBJ_HFLAGS_HI () {0x62;}' unless defined(&BWI_COMM_MOBJ_HFLAGS_HI);
    eval 'sub BWI_COMM_MOBJ_RF_ATTEN () {0x64;}' unless defined(&BWI_COMM_MOBJ_RF_ATTEN);
    eval 'sub BWI_COMM_MOBJ_TSSI_OFDM () {0x70;}' unless defined(&BWI_COMM_MOBJ_TSSI_OFDM);
    eval 'sub BWI_COMM_MOBJ_PROBE_RESP_TO () {0x74;}' unless defined(&BWI_COMM_MOBJ_PROBE_RESP_TO);
    eval 'sub BWI_COMM_MOBJ_CHAN () {0xa0;}' unless defined(&BWI_COMM_MOBJ_CHAN);
    eval 'sub BWI_COMM_MOBJ_KEY_ALGO () {0x100;}' unless defined(&BWI_COMM_MOBJ_KEY_ALGO);
    eval 'sub BWI_COMM_MOBJ_TX_PROBE_RESP () {0x188;}' unless defined(&BWI_COMM_MOBJ_TX_PROBE_RESP);
    eval 'sub BWI_HFLAG_AUTO_ANTDIV () {0x1;}' unless defined(&BWI_HFLAG_AUTO_ANTDIV);
    eval 'sub BWI_HFLAG_SYM_WA () {0x2;}' unless defined(&BWI_HFLAG_SYM_WA);
    eval 'sub BWI_HFLAG_PWR_BOOST_DS () {0x8;}' unless defined(&BWI_HFLAG_PWR_BOOST_DS);
    eval 'sub BWI_HFLAG_GDC_WA () {0x20;}' unless defined(&BWI_HFLAG_GDC_WA);
    eval 'sub BWI_HFLAG_OFDM_PA () {0x40;}' unless defined(&BWI_HFLAG_OFDM_PA);
    eval 'sub BWI_HFLAG_NOT_JAPAN () {0x80;}' unless defined(&BWI_HFLAG_NOT_JAPAN);
    eval 'sub BWI_HFLAG_MAGIC1 () {0x200;}' unless defined(&BWI_HFLAG_MAGIC1);
    eval 'sub BWI_UCODE_STATE_PS () {4;}' unless defined(&BWI_UCODE_STATE_PS);
    eval 'sub BWI_LO_TSSI_MASK () {0xff;}' unless defined(&BWI_LO_TSSI_MASK);
    eval 'sub BWI_HI_TSSI_MASK () {0xff00;}' unless defined(&BWI_HI_TSSI_MASK);
    eval 'sub BWI_INVALID_TSSI () {0x7f;}' unless defined(&BWI_INVALID_TSSI);
    eval 'sub BWI_80211_MOBJ () {0x2;}' unless defined(&BWI_80211_MOBJ);
    eval 'sub BWI_80211_MOBJ_CWMIN () {0xc;}' unless defined(&BWI_80211_MOBJ_CWMIN);
    eval 'sub BWI_80211_MOBJ_CWMAX () {0x10;}' unless defined(&BWI_80211_MOBJ_CWMAX);
    eval 'sub BWI_80211_MOBJ_SHRETRY () {0x18;}' unless defined(&BWI_80211_MOBJ_SHRETRY);
    eval 'sub BWI_80211_MOBJ_LGRETRY () {0x1c;}' unless defined(&BWI_80211_MOBJ_LGRETRY);
    eval 'sub BWI_FW_PCM_MOBJ () {0x3;}' unless defined(&BWI_FW_PCM_MOBJ);
    eval 'sub BWI_PKEY_ADDR_MOBJ () {0x4;}' unless defined(&BWI_PKEY_ADDR_MOBJ);
    eval 'sub BWI_TXSTATUS_0 () {0x170;}' unless defined(&BWI_TXSTATUS_0);
    eval 'sub BWI_TXSTATUS_0_MORE () {(1<< 0);}' unless defined(&BWI_TXSTATUS_0_MORE);
    eval 'sub BWI_TXSTATUS_0_TXID_MASK () {0xffff0000;}' unless defined(&BWI_TXSTATUS_0_TXID_MASK);
    eval 'sub BWI_TXSTATUS_0_INFO {
        my($st) = @_;
	    eval q(((($st) & 0xfff0) | ((($st) & 0xf) >> 1)));
    }' unless defined(&BWI_TXSTATUS_0_INFO);
    eval 'sub BWI_TXSTATUS_1 () {0x174;}' unless defined(&BWI_TXSTATUS_1);
    eval 'sub BWI_TXRX_CTRL_BASE () {0x200;}' unless defined(&BWI_TXRX_CTRL_BASE);
    eval 'sub BWI_TX32_CTRL () {0x;}' unless defined(&BWI_TX32_CTRL);
    eval 'sub BWI_TX32_RINGINFO () {0x4;}' unless defined(&BWI_TX32_RINGINFO);
    eval 'sub BWI_TX32_INDEX () {0x8;}' unless defined(&BWI_TX32_INDEX);
    eval 'sub BWI_TX32_STATUS () {0xc;}' unless defined(&BWI_TX32_STATUS);
    eval 'sub BWI_TX32_STATUS_STATE_MASK () {0xf000;}' unless defined(&BWI_TX32_STATUS_STATE_MASK);
    eval 'sub BWI_TX32_STATUS_STATE_DISABLED () {0;}' unless defined(&BWI_TX32_STATUS_STATE_DISABLED);
    eval 'sub BWI_TX32_STATUS_STATE_IDLE () {2;}' unless defined(&BWI_TX32_STATUS_STATE_IDLE);
    eval 'sub BWI_TX32_STATUS_STATE_STOPPED () {3;}' unless defined(&BWI_TX32_STATUS_STATE_STOPPED);
    eval 'sub BWI_RX32_CTRL () {0x10;}' unless defined(&BWI_RX32_CTRL);
    eval 'sub BWI_RX32_CTRL_HDRSZ_MASK () {0xfe;}' unless defined(&BWI_RX32_CTRL_HDRSZ_MASK);
    eval 'sub BWI_RX32_RINGINFO () {0x14;}' unless defined(&BWI_RX32_RINGINFO);
    eval 'sub BWI_RX32_INDEX () {0x18;}' unless defined(&BWI_RX32_INDEX);
    eval 'sub BWI_RX32_STATUS () {0x1c;}' unless defined(&BWI_RX32_STATUS);
    eval 'sub BWI_RX32_STATUS_INDEX_MASK () {0xfff;}' unless defined(&BWI_RX32_STATUS_INDEX_MASK);
    eval 'sub BWI_RX32_STATUS_STATE_MASK () {0xf000;}' unless defined(&BWI_RX32_STATUS_STATE_MASK);
    eval 'sub BWI_RX32_STATUS_STATE_DISABLED () {0;}' unless defined(&BWI_RX32_STATUS_STATE_DISABLED);
    eval 'sub BWI_TXRX32_CTRL_ENABLE () {(1<< 0);}' unless defined(&BWI_TXRX32_CTRL_ENABLE);
    eval 'sub BWI_TXRX32_CTRL_ADDRHI_MASK () {0x30000;}' unless defined(&BWI_TXRX32_CTRL_ADDRHI_MASK);
    eval 'sub BWI_TXRX32_RINGINFO_FUNC_TXRX () {0x1;}' unless defined(&BWI_TXRX32_RINGINFO_FUNC_TXRX);
    eval 'sub BWI_TXRX32_RINGINFO_FUNC_MASK () {0xc0000000;}' unless defined(&BWI_TXRX32_RINGINFO_FUNC_MASK);
    eval 'sub BWI_TXRX32_RINGINFO_ADDR_MASK () {0x3fffffff;}' unless defined(&BWI_TXRX32_RINGINFO_ADDR_MASK);
    eval 'sub BWI_PHYINFO () {0x3e0;}' unless defined(&BWI_PHYINFO);
    eval 'sub BWI_PHYINFO_REV_MASK () {0xf;}' unless defined(&BWI_PHYINFO_REV_MASK);
    eval 'sub BWI_PHYINFO_TYPE_MASK () {0xf00;}' unless defined(&BWI_PHYINFO_TYPE_MASK);
    eval 'sub BWI_PHYINFO_TYPE_11A () {0;}' unless defined(&BWI_PHYINFO_TYPE_11A);
    eval 'sub BWI_PHYINFO_TYPE_11B () {1;}' unless defined(&BWI_PHYINFO_TYPE_11B);
    eval 'sub BWI_PHYINFO_TYPE_11G () {2;}' unless defined(&BWI_PHYINFO_TYPE_11G);
    eval 'sub BWI_PHYINFO_TYPE_11N () {5;}' unless defined(&BWI_PHYINFO_TYPE_11N);
    eval 'sub BWI_PHYINFO_VER_MASK () {0xf000;}' unless defined(&BWI_PHYINFO_VER_MASK);
    eval 'sub BWI_RF_ANTDIV () {0x3e2;}' unless defined(&BWI_RF_ANTDIV);
    eval 'sub BWI_PHY_MAGIC_REG1 () {0x3e4;}' unless defined(&BWI_PHY_MAGIC_REG1);
    eval 'sub BWI_PHY_MAGIC_REG1_VAL1 () {0x3000;}' unless defined(&BWI_PHY_MAGIC_REG1_VAL1);
    eval 'sub BWI_PHY_MAGIC_REG1_VAL2 () {0x9;}' unless defined(&BWI_PHY_MAGIC_REG1_VAL2);
    eval 'sub BWI_BBP_ATTEN () {0x3e6;}' unless defined(&BWI_BBP_ATTEN);
    eval 'sub BWI_BBP_ATTEN_MAGIC () {0xf4;}' unless defined(&BWI_BBP_ATTEN_MAGIC);
    eval 'sub BWI_BBP_ATTEN_MAGIC2 () {0x8140;}' unless defined(&BWI_BBP_ATTEN_MAGIC2);
    eval 'sub BWI_BPHY_CTRL () {0x3ec;}' unless defined(&BWI_BPHY_CTRL);
    eval 'sub BWI_BPHY_CTRL_INIT () {0x3f22;}' unless defined(&BWI_BPHY_CTRL_INIT);
    eval 'sub BWI_RF_CHAN () {0x3f0;}' unless defined(&BWI_RF_CHAN);
    eval 'sub BWI_RF_CHAN_EX () {0x3f4;}' unless defined(&BWI_RF_CHAN_EX);
    eval 'sub BWI_RF_CTRL () {0x3f6;}' unless defined(&BWI_RF_CTRL);
    eval 'sub BWI_RF_CTRL_RFINFO () {0x1;}' unless defined(&BWI_RF_CTRL_RFINFO);
    eval 'sub BWI_RF_CTRL_RD_11A () {0x40;}' unless defined(&BWI_RF_CTRL_RD_11A);
    eval 'sub BWI_RF_CTRL_RD_11BG () {0x80;}' unless defined(&BWI_RF_CTRL_RD_11BG);
    eval 'sub BWI_RF_DATA_HI () {0x3f8;}' unless defined(&BWI_RF_DATA_HI);
    eval 'sub BWI_RF_DATA_LO () {0x3fa;}' unless defined(&BWI_RF_DATA_LO);
    eval 'sub BWI_RFINFO_MANUFACT_MASK () {0xfff;}' unless defined(&BWI_RFINFO_MANUFACT_MASK);
    eval 'sub BWI_RF_MANUFACT_BCM () {0x17f;}' unless defined(&BWI_RF_MANUFACT_BCM);
    eval 'sub BWI_RFINFO_TYPE_MASK () {0xffff000;}' unless defined(&BWI_RFINFO_TYPE_MASK);
    eval 'sub BWI_RF_T_BCM2050 () {0x2050;}' unless defined(&BWI_RF_T_BCM2050);
    eval 'sub BWI_RF_T_BCM2053 () {0x2053;}' unless defined(&BWI_RF_T_BCM2053);
    eval 'sub BWI_RF_T_BCM2060 () {0x2060;}' unless defined(&BWI_RF_T_BCM2060);
    eval 'sub BWI_RFINFO_REV_MASK () {0xf0000000;}' unless defined(&BWI_RFINFO_REV_MASK);
    eval 'sub BWI_PHY_CTRL () {0x3fc;}' unless defined(&BWI_PHY_CTRL);
    eval 'sub BWI_PHY_DATA () {0x3fe;}' unless defined(&BWI_PHY_DATA);
    eval 'sub BWI_ADDR_FILTER_CTRL () {0x420;}' unless defined(&BWI_ADDR_FILTER_CTRL);
    eval 'sub BWI_ADDR_FILTER_CTRL_SET () {0x20;}' unless defined(&BWI_ADDR_FILTER_CTRL_SET);
    eval 'sub BWI_ADDR_FILTER_MYADDR () {0;}' unless defined(&BWI_ADDR_FILTER_MYADDR);
    eval 'sub BWI_ADDR_FILTER_BSSID () {3;}' unless defined(&BWI_ADDR_FILTER_BSSID);
    eval 'sub BWI_ADDR_FILTER_DATA () {0x422;}' unless defined(&BWI_ADDR_FILTER_DATA);
    eval 'sub BWI_MAC_GPIO_CTRL () {0x49c;}' unless defined(&BWI_MAC_GPIO_CTRL);
    eval 'sub BWI_MAC_GPIO_MASK () {0x49e;}' unless defined(&BWI_MAC_GPIO_MASK);
    eval 'sub BWI_MAC_PRE_TBTT () {0x612;}' unless defined(&BWI_MAC_PRE_TBTT);
    eval 'sub BWI_MAC_SLOTTIME () {0x684;}' unless defined(&BWI_MAC_SLOTTIME);
    eval 'sub BWI_MAC_SLOTTIME_ADJUST () {510;}' unless defined(&BWI_MAC_SLOTTIME_ADJUST);
    eval 'sub BWI_MAC_POWERUP_DELAY () {0x6a8;}' unless defined(&BWI_MAC_POWERUP_DELAY);
    eval 'sub BWI_GPIO_CTRL () {0x6c;}' unless defined(&BWI_GPIO_CTRL);
    eval 'sub BWI_PCIR_BAR () { &PCIR_BAR(0);}' unless defined(&BWI_PCIR_BAR);
    eval 'sub BWI_PCIR_SEL_REGWIN () {0x80;}' unless defined(&BWI_PCIR_SEL_REGWIN);
    eval 'sub BWI_PCIM_REGWIN {
        my($id) = @_;
	    eval q(((($id) * 0x1000) + 0x18000000));
    }' unless defined(&BWI_PCIM_REGWIN);
    eval 'sub BWI_PCIR_GPIO_IN () {0xb0;}' unless defined(&BWI_PCIR_GPIO_IN);
    eval 'sub BWI_PCIR_GPIO_OUT () {0xb4;}' unless defined(&BWI_PCIR_GPIO_OUT);
    eval 'sub BWI_PCIM_GPIO_OUT_CLKSRC () {(1<< 4);}' unless defined(&BWI_PCIM_GPIO_OUT_CLKSRC);
    eval 'sub BWI_PCIR_GPIO_ENABLE () {0xb8;}' unless defined(&BWI_PCIR_GPIO_ENABLE);
    eval 'sub BWI_PCIM_GPIO_PWR_ON () {(1<< 6);}' unless defined(&BWI_PCIM_GPIO_PWR_ON);
    eval 'sub BWI_PCIM_GPIO_PLL_PWR_OFF () {(1<< 7);}' unless defined(&BWI_PCIM_GPIO_PLL_PWR_OFF);
    eval 'sub BWI_PCIR_INTCTL () {0x94;}' unless defined(&BWI_PCIR_INTCTL);
    eval 'sub BWI_PCI_SUBDEVICE_BU4306 () {0x416;}' unless defined(&BWI_PCI_SUBDEVICE_BU4306);
    eval 'sub BWI_PCI_SUBDEVICE_BCM4309G () {0x421;}' unless defined(&BWI_PCI_SUBDEVICE_BCM4309G);
    eval 'sub BWI_IS_BRCM_BU4306 {
        my($sc) = @_;
	    eval q((($sc)-> &sc_pci_subvid ==  &PCI_VENDOR_BROADCOM  && ($sc)-> &sc_pci_subdid ==  &BWI_PCI_SUBDEVICE_BU4306));
    }' unless defined(&BWI_IS_BRCM_BU4306);
    eval 'sub BWI_IS_BRCM_BCM4309G {
        my($sc) = @_;
	    eval q((($sc)-> &sc_pci_subvid ==  &PCI_VENDOR_BROADCOM  && ($sc)-> &sc_pci_subdid ==  &BWI_PCI_SUBDEVICE_BCM4309G));
    }' unless defined(&BWI_IS_BRCM_BCM4309G);
    eval 'sub BWI_SPROM_START () {0x1000;}' unless defined(&BWI_SPROM_START);
    eval 'sub BWI_SPROM_11BG_EADDR () {0x48;}' unless defined(&BWI_SPROM_11BG_EADDR);
    eval 'sub BWI_SPROM_11A_EADDR () {0x54;}' unless defined(&BWI_SPROM_11A_EADDR);
    eval 'sub BWI_SPROM_CARD_INFO () {0x5c;}' unless defined(&BWI_SPROM_CARD_INFO);
    eval 'sub BWI_SPROM_CARD_INFO_LOCALE () {(0xf << 8);}' unless defined(&BWI_SPROM_CARD_INFO_LOCALE);
    eval 'sub BWI_SPROM_LOCALE_JAPAN () {5;}' unless defined(&BWI_SPROM_LOCALE_JAPAN);
    eval 'sub BWI_SPROM_PA_PARAM_11BG () {0x5e;}' unless defined(&BWI_SPROM_PA_PARAM_11BG);
    eval 'sub BWI_SPROM_GPIO01 () {0x64;}' unless defined(&BWI_SPROM_GPIO01);
    eval 'sub BWI_SPROM_GPIO_0 () {0xff;}' unless defined(&BWI_SPROM_GPIO_0);
    eval 'sub BWI_SPROM_GPIO_1 () {0xff00;}' unless defined(&BWI_SPROM_GPIO_1);
    eval 'sub BWI_SPROM_GPIO23 () {0x66;}' unless defined(&BWI_SPROM_GPIO23);
    eval 'sub BWI_SPROM_GPIO_2 () {0xff;}' unless defined(&BWI_SPROM_GPIO_2);
    eval 'sub BWI_SPROM_GPIO_3 () {0xff00;}' unless defined(&BWI_SPROM_GPIO_3);
    eval 'sub BWI_SPROM_MAX_TXPWR () {0x68;}' unless defined(&BWI_SPROM_MAX_TXPWR);
    eval 'sub BWI_SPROM_MAX_TXPWR_MASK_11BG () {0xff;}' unless defined(&BWI_SPROM_MAX_TXPWR_MASK_11BG);
    eval 'sub BWI_SPROM_MAX_TXPWR_MASK_11A () {0xff00;}' unless defined(&BWI_SPROM_MAX_TXPWR_MASK_11A);
    eval 'sub BWI_SPROM_PA_PARAM_11A () {0x6a;}' unless defined(&BWI_SPROM_PA_PARAM_11A);
    eval 'sub BWI_SPROM_IDLE_TSSI () {0x70;}' unless defined(&BWI_SPROM_IDLE_TSSI);
    eval 'sub BWI_SPROM_IDLE_TSSI_MASK_11BG () {0xff;}' unless defined(&BWI_SPROM_IDLE_TSSI_MASK_11BG);
    eval 'sub BWI_SPROM_IDLE_TSSI_MASK_11A () {0xff00;}' unless defined(&BWI_SPROM_IDLE_TSSI_MASK_11A);
    eval 'sub BWI_SPROM_CARD_FLAGS () {0x72;}' unless defined(&BWI_SPROM_CARD_FLAGS);
    eval 'sub BWI_SPROM_ANT_GAIN () {0x74;}' unless defined(&BWI_SPROM_ANT_GAIN);
    eval 'sub BWI_SPROM_ANT_GAIN_MASK_11A () {0xff;}' unless defined(&BWI_SPROM_ANT_GAIN_MASK_11A);
    eval 'sub BWI_SPROM_ANT_GAIN_MASK_11BG () {0xff00;}' unless defined(&BWI_SPROM_ANT_GAIN_MASK_11BG);
    eval 'sub BWI_CARD_F_PA_GPIO9 () {(1<< 1);}' unless defined(&BWI_CARD_F_PA_GPIO9);
    eval 'sub BWI_CARD_F_SW_NRSSI () {(1<< 3);}' unless defined(&BWI_CARD_F_SW_NRSSI);
    eval 'sub BWI_CARD_F_NO_SLOWCLK () {(1<< 5);}' unless defined(&BWI_CARD_F_NO_SLOWCLK);
    eval 'sub BWI_CARD_F_EXT_LNA () {(1<< 12);}' unless defined(&BWI_CARD_F_EXT_LNA);
    eval 'sub BWI_CARD_F_ALT_IQ () {(1<< 15);}' unless defined(&BWI_CARD_F_ALT_IQ);
    eval 'sub BWI_LED_ACT_LOW () {(1<< 7);}' unless defined(&BWI_LED_ACT_LOW);
    eval 'sub BWI_LED_ACT_MASK () {0x7f;}' unless defined(&BWI_LED_ACT_MASK);
    eval 'sub BWI_LED_ACT_OFF () {0;}' unless defined(&BWI_LED_ACT_OFF);
    eval 'sub BWI_LED_ACT_ON () {1;}' unless defined(&BWI_LED_ACT_ON);
    eval 'sub BWI_LED_ACT_BLINK () {2;}' unless defined(&BWI_LED_ACT_BLINK);
    eval 'sub BWI_LED_ACT_RF_ENABLED () {3;}' unless defined(&BWI_LED_ACT_RF_ENABLED);
    eval 'sub BWI_LED_ACT_5GHZ () {4;}' unless defined(&BWI_LED_ACT_5GHZ);
    eval 'sub BWI_LED_ACT_2GHZ () {5;}' unless defined(&BWI_LED_ACT_2GHZ);
    eval 'sub BWI_LED_ACT_11G () {6;}' unless defined(&BWI_LED_ACT_11G);
    eval 'sub BWI_LED_ACT_BLINK_SLOW () {7;}' unless defined(&BWI_LED_ACT_BLINK_SLOW);
    eval 'sub BWI_LED_ACT_BLINK_POLL () {8;}' unless defined(&BWI_LED_ACT_BLINK_POLL);
    eval 'sub BWI_LED_ACT_UNKN () {9;}' unless defined(&BWI_LED_ACT_UNKN);
    eval 'sub BWI_LED_ACT_ASSOC () {10;}' unless defined(&BWI_LED_ACT_ASSOC);
    eval 'sub BWI_LED_ACT_NULL () {11;}' unless defined(&BWI_LED_ACT_NULL);
    eval 'sub BWI_VENDOR_LED_ACT_COMPAQ () { &BWI_LED_ACT_RF_ENABLED,  &BWI_LED_ACT_2GHZ,  &BWI_LED_ACT_5GHZ,  &BWI_LED_ACT_OFF;}' unless defined(&BWI_VENDOR_LED_ACT_COMPAQ);
    eval 'sub BWI_VENDOR_LED_ACT_LINKSYS () { &BWI_LED_ACT_ASSOC,  &BWI_LED_ACT_2GHZ,  &BWI_LED_ACT_5GHZ,  &BWI_LED_ACT_OFF;}' unless defined(&BWI_VENDOR_LED_ACT_LINKSYS);
    eval 'sub BWI_VENDOR_LED_ACT_DEFAULT () { &BWI_LED_ACT_BLINK,  &BWI_LED_ACT_2GHZ,  &BWI_LED_ACT_5GHZ,  &BWI_LED_ACT_OFF;}' unless defined(&BWI_VENDOR_LED_ACT_DEFAULT);
    eval 'sub BWI_BBPID_BCM4301 () {0x4301;}' unless defined(&BWI_BBPID_BCM4301);
    eval 'sub BWI_BBPID_BCM4306 () {0x4306;}' unless defined(&BWI_BBPID_BCM4306);
    eval 'sub BWI_BBPID_BCM4317 () {0x4317;}' unless defined(&BWI_BBPID_BCM4317);
    eval 'sub BWI_BBPID_BCM4320 () {0x4320;}' unless defined(&BWI_BBPID_BCM4320);
    eval 'sub BWI_BBPID_BCM4321 () {0x4321;}' unless defined(&BWI_BBPID_BCM4321);
    eval 'sub BWI_REGWIN_T_COM () {0x800;}' unless defined(&BWI_REGWIN_T_COM);
    eval 'sub BWI_REGWIN_T_BUSPCI () {0x804;}' unless defined(&BWI_REGWIN_T_BUSPCI);
    eval 'sub BWI_REGWIN_T_MAC () {0x812;}' unless defined(&BWI_REGWIN_T_MAC);
    eval 'sub BWI_REGWIN_T_BUSPCIE () {0x820;}' unless defined(&BWI_REGWIN_T_BUSPCIE);
    eval 'sub BWI_INTR_READY () {(1<< 0);}' unless defined(&BWI_INTR_READY);
    eval 'sub BWI_INTR_BEACON () {(1<< 1);}' unless defined(&BWI_INTR_BEACON);
    eval 'sub BWI_INTR_TBTT () {(1<< 2);}' unless defined(&BWI_INTR_TBTT);
    eval 'sub BWI_INTR_EO_ATIM () {(1<< 5);}' unless defined(&BWI_INTR_EO_ATIM);
    eval 'sub BWI_INTR_PMQ () {(1<< 6);}' unless defined(&BWI_INTR_PMQ);
    eval 'sub BWI_INTR_MAC_TXERR () {(1<< 9);}' unless defined(&BWI_INTR_MAC_TXERR);
    eval 'sub BWI_INTR_PHY_TXERR () {(1<< 11);}' unless defined(&BWI_INTR_PHY_TXERR);
    eval 'sub BWI_INTR_TIMER1 () {(1<< 14);}' unless defined(&BWI_INTR_TIMER1);
    eval 'sub BWI_INTR_RX_DONE () {(1<< 15);}' unless defined(&BWI_INTR_RX_DONE);
    eval 'sub BWI_INTR_TX_FIFO () {(1<< 16);}' unless defined(&BWI_INTR_TX_FIFO);
    eval 'sub BWI_INTR_NOISE () {(1<< 18);}' unless defined(&BWI_INTR_NOISE);
    eval 'sub BWI_INTR_RF_DISABLED () {(1<< 28);}' unless defined(&BWI_INTR_RF_DISABLED);
    eval 'sub BWI_INTR_TX_DONE () {(1<< 29);}' unless defined(&BWI_INTR_TX_DONE);
    eval 'sub BWI_INIT_INTRS () {( &BWI_INTR_READY |  &BWI_INTR_BEACON |  &BWI_INTR_TBTT |  &BWI_INTR_EO_ATIM |  &BWI_INTR_PMQ |  &BWI_INTR_MAC_TXERR |  &BWI_INTR_PHY_TXERR |  &BWI_INTR_RX_DONE |  &BWI_INTR_TX_FIFO |  &BWI_INTR_NOISE |  &BWI_INTR_RF_DISABLED |  &BWI_INTR_TX_DONE);}' unless defined(&BWI_INIT_INTRS);
    eval 'sub BWI_ALL_INTRS () {0xffffffff;}' unless defined(&BWI_ALL_INTRS);
    eval 'sub BWI_I_PC () {(1<< 10);}' unless defined(&BWI_I_PC);
    eval 'sub BWI_I_PD () {(1<< 11);}' unless defined(&BWI_I_PD);
    eval 'sub BWI_I_DE () {(1<< 12);}' unless defined(&BWI_I_DE);
    eval 'sub BWI_I_RU () {(1<< 13);}' unless defined(&BWI_I_RU);
    eval 'sub BWI_I_RO () {(1<< 14);}' unless defined(&BWI_I_RO);
    eval 'sub BWI_I_XU () {(1<< 15);}' unless defined(&BWI_I_XU);
    eval 'sub BWI_I_RI () {(1<< 16);}' unless defined(&BWI_I_RI);
    eval 'sub BWI_I_XI () {(1<< 24);}' unless defined(&BWI_I_XI);
    eval 'sub BWI_TXRX_INTR_ERROR () {( &BWI_I_XU |  &BWI_I_RO |  &BWI_I_DE |  &BWI_I_PD |  &BWI_I_PC);}' unless defined(&BWI_TXRX_INTR_ERROR);
    eval 'sub BWI_TXRX_INTR_RX () { &BWI_I_RI;}' unless defined(&BWI_TXRX_INTR_RX);
    eval 'sub BWI_TXRX_TX_INTRS () { &BWI_TXRX_INTR_ERROR;}' unless defined(&BWI_TXRX_TX_INTRS);
    eval 'sub BWI_TXRX_RX_INTRS () {( &BWI_TXRX_INTR_ERROR |  &BWI_TXRX_INTR_RX);}' unless defined(&BWI_TXRX_RX_INTRS);
    eval 'sub BWI_TXRX_IS_RX {
        my($i) = @_;
	    eval q((($i) % 3== 0));
    }' unless defined(&BWI_TXRX_IS_RX);
    eval 'sub BWI_PHYR_NRSSI_THR_11B () {0x20;}' unless defined(&BWI_PHYR_NRSSI_THR_11B);
    eval 'sub BWI_PHYR_BBP_ATTEN () {0x60;}' unless defined(&BWI_PHYR_BBP_ATTEN);
    eval 'sub BWI_PHYR_TBL_CTRL_11A () {0x72;}' unless defined(&BWI_PHYR_TBL_CTRL_11A);
    eval 'sub BWI_PHYR_TBL_DATA_LO_11A () {0x73;}' unless defined(&BWI_PHYR_TBL_DATA_LO_11A);
    eval 'sub BWI_PHYR_TBL_DATA_HI_11A () {0x74;}' unless defined(&BWI_PHYR_TBL_DATA_HI_11A);
    eval 'sub BWI_PHYR_TBL_CTRL_11G () {0x472;}' unless defined(&BWI_PHYR_TBL_CTRL_11G);
    eval 'sub BWI_PHYR_TBL_DATA_LO_11G () {0x473;}' unless defined(&BWI_PHYR_TBL_DATA_LO_11G);
    eval 'sub BWI_PHYR_TBL_DATA_HI_11G () {0x474;}' unless defined(&BWI_PHYR_TBL_DATA_HI_11G);
    eval 'sub BWI_PHYR_NRSSI_THR_11G () {0x48a;}' unless defined(&BWI_PHYR_NRSSI_THR_11G);
    eval 'sub BWI_PHYR_NRSSI_CTRL () {0x803;}' unless defined(&BWI_PHYR_NRSSI_CTRL);
    eval 'sub BWI_PHYR_NRSSI_DATA () {0x804;}' unless defined(&BWI_PHYR_NRSSI_DATA);
    eval 'sub BWI_PHYR_RF_LO () {0x810;}' unless defined(&BWI_PHYR_RF_LO);
    eval 'sub BWI_PHY_FREQ_11G_REV1 () {0x89, 0x2e9, 0x409, 0x4e9, 0x5a9, 0x669, 0x709, 0x789, 0x829, 0x8a9, 0x929, 0x989, 0xa09, 0xa69, 0xac9, 0xb29, 0xba9, 0xbe9, 0xc49, 0xca9, 0xd09, 0xd69, 0xda9, 0xe09, 0xe69, 0xea9, 0xf09, 0xf49, 0xfa9, 0xfe9, 0x1029, 0x1089, 0x10c9, 0x1109, 0x1169, 0x11a9, 0x11e9, 0x1229, 0x1289, 0x12c9, 0x1309, 0x1349, 0x1389, 0x13c9, 0x1409, 0x1449, 0x14a9, 0x14e9, 0x1529, 0x1569, 0x15a9, 0x15e9, 0x1629, 0x1669, 0x16a9, 0x16e8, 0x1728, 0x1768, 0x17a8, 0x17e8, 0x1828, 0x1868, 0x18a8, 0x18e8, 0x1928, 0x1968, 0x19a8, 0x19e8, 0x1a28, 0x1a68, 0x1aa8, 0x1ae8, 0x1b28, 0x1b68, 0x1ba8, 0x1be8, 0x1c28, 0x1c68, 0x1ca8, 0x1ce8, 0x1d28, 0x1d68, 0x1dc8, 0x1e08, 0x1e48, 0x1e88, 0x1ec8, 0x1f08, 0x1f48, 0x1f88, 0x1fe8, 0x2028, 0x2068, 0x20a8, 0x2108, 0x2148, 0x2188, 0x21c8, 0x2228, 0x2268, 0x22c8, 0x2308, 0x2348, 0x23a8, 0x23e8, 0x2448, 0x24a8, 0x24e8, 0x2548, 0x25a8, 0x2608, 0x2668, 0x26c8, 0x2728, 0x2787, 0x27e7, 0x2847, 0x28c7, 0x2947, 0x29a7, 0x2a27, 0x2ac7, 0x2b47, 0x2be7, 0x2ca7, 0x2d67, 0x2e47, 0x2f67, 0x3247, 0x3526, 0x3646, 0x3726, 0x3806, 0x38a6, 0x3946, 0x39e6, 0x3a66, 0x3ae6, 0x3b66, 0x3bc6, 0x3c45, 0x3ca5, 0x3d05, 0x3d85, 0x3de5, 0x3e45, 0x3ea5, 0x3ee5, 0x3f45, 0x3fa5, 0x4005, 0x4045, 0x40a5, 0x40e5, 0x4145, 0x4185, 0x41e5, 0x4225, 0x4265, 0x42c5, 0x4305, 0x4345, 0x43a5, 0x43e5, 0x4424, 0x4464, 0x44c4, 0x4504, 0x4544, 0x4584, 0x45c4, 0x4604, 0x4644, 0x46a4, 0x46e4, 0x4724, 0x4764, 0x47a4, 0x47e4, 0x4824, 0x4864, 0x48a4, 0x48e4, 0x4924, 0x4964, 0x49a4, 0x49e4, 0x4a24, 0x4a64, 0x4aa4, 0x4ae4, 0x4b23, 0x4b63, 0x4ba3, 0x4be3, 0x4c23, 0x4c63, 0x4ca3, 0x4ce3, 0x4d23, 0x4d63, 0x4da3, 0x4de3, 0x4e23, 0x4e63, 0x4ea3, 0x4ee3, 0x4f23, 0x4f63, 0x4fc3, 0x5003, 0x5043, 0x5083, 0x50c3, 0x5103, 0x5143, 0x5183, 0x51e2, 0x5222, 0x5262, 0x52a2, 0x52e2, 0x5342, 0x5382, 0x53c2, 0x5402, 0x5462, 0x54a2, 0x5502, 0x5542, 0x55a2, 0x55e2, 0x5642, 0x5682, 0x56e2, 0x5722, 0x5782, 0x57e1, 0x5841, 0x58a1, 0x5901, 0x5961, 0x59c1, 0x5a21, 0x5aa1, 0x5b01, 0x5b81, 0x5be1, 0x5c61, 0x5d01, 0x5d80, 0x5e20, 0x5ee0, 0x5fa0, 0x6080, 0x61c0;}' unless defined(&BWI_PHY_FREQ_11G_REV1);
    eval 'sub BWI_PHY_NOISE_11G_REV1 () {0x13c, 0x1f5, 0x31a, 0x631, 0x1, 0x1, 0x1, 0x1;}' unless defined(&BWI_PHY_NOISE_11G_REV1);
    eval 'sub BWI_PHY_NOISE_11G () {0x5484, 0x3c40, 0x, 0x, 0x, 0x, 0x, 0x;}' unless defined(&BWI_PHY_NOISE_11G);
    eval 'sub BWI_PHY_ROTOR_11G_REV1 () {0xfeb93ffd, 0xfec63ffd, 0xfed23ffd, 0xfedf3ffd, 0xfeec3ffe, 0xfef83ffe, 0xff053ffe, 0xff113ffe, 0xff1e3ffe, 0xff2a3fff, 0xff373fff, 0xff443fff, 0xff503fff, 0xff5d3fff, 0xff693fff, 0xff763fff, 0xff824000, 0xff8f4000, 0xff9b4000, 0xffa84000, 0xffb54000, 0xffc14000, 0xffce4000, 0xffda4000, 0xffe74000, 0xfff34000, 0x4000, 0xd4000, 0x194000, 0x264000, 0x324000, 0x3f4000, 0x4b4000, 0x584000, 0x654000, 0x714000, 0x7e4000, 0x8a3fff, 0x973fff, 0xa33fff, 0xb03fff, 0xbc3fff, 0xc93fff, 0xd63fff, 0xe23ffe, 0xef3ffe, 0xfb3ffe, 0x1083ffe, 0x1143ffe, 0x1213ffd, 0x12e3ffd, 0x13a3ffd, 0x1473ffd;}' unless defined(&BWI_PHY_ROTOR_11G_REV1);
    eval 'sub BWI_PHY_NOISE_SCALE_11G_REV2 () {0x6c77, 0x5162, 0x3b40, 0x3335, 0x2f2d, 0x2a2a, 0x2527, 0x1f21, 0x1a1d, 0x1719, 0x1616, 0x1414, 0x1414, 0x1400, 0x1414, 0x1614, 0x1716, 0x1a19, 0x1f1d, 0x2521, 0x2a27, 0x2f2a, 0x332d, 0x3b35, 0x5140, 0x6c62, 0x77;}' unless defined(&BWI_PHY_NOISE_SCALE_11G_REV2);
    eval 'sub BWI_PHY_NOISE_SCALE_11G_REV7 () {0xa4a4, 0xa4a4, 0xa4a4, 0xa4a4, 0xa4a4, 0xa4a4, 0xa4a4, 0xa4a4, 0xa4a4, 0xa4a4, 0xa4a4, 0xa4a4, 0xa4a4, 0xa400, 0xa4a4, 0xa4a4, 0xa4a4, 0xa4a4, 0xa4a4, 0xa4a4, 0xa4a4, 0xa4a4, 0xa4a4, 0xa4a4, 0xa4a4, 0xa4a4, 0xa4;}' unless defined(&BWI_PHY_NOISE_SCALE_11G_REV7);
    eval 'sub BWI_PHY_NOISE_SCALE_11G () {0xd8dd, 0xcbd4, 0xbcc0, 0xb6b7, 0xb2b0, 0xadad, 0xa7a9, 0x9fa1, 0x969b, 0x9195, 0x8f8f, 0x8a8a, 0x8a8a, 0x8a00, 0x8a8a, 0x8f8a, 0x918f, 0x9695, 0x9f9b, 0xa7a1, 0xada9, 0xb2ad, 0xb6b0, 0xbcb7, 0xcbc0, 0xd8d4, 0xdd;}' unless defined(&BWI_PHY_NOISE_SCALE_11G);
    eval 'sub BWI_PHY_SIGMA_SQ_11G_REV2 () {0x7a, 0x75, 0x71, 0x6c, 0x67, 0x63, 0x5e, 0x59, 0x54, 0x50, 0x4b, 0x46, 0x42, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x42, 0x46, 0x4b, 0x50, 0x54, 0x59, 0x5e, 0x63, 0x67, 0x6c, 0x71, 0x75, 0x7a;}' unless defined(&BWI_PHY_SIGMA_SQ_11G_REV2);
    eval 'sub BWI_PHY_SIGMA_SQ_11G_REV7 () {0xde, 0xdc, 0xda, 0xd8, 0xd6, 0xd4, 0xd2, 0xcf, 0xcd, 0xca, 0xc7, 0xc4, 0xc1, 0xbe, 0xbe, 0xbe, 0xbe, 0xbe, 0xbe, 0xbe, 0xbe, 0xbe, 0xbe, 0xbe, 0xbe, 0xbe, 0x, 0xbe, 0xbe, 0xbe, 0xbe, 0xbe, 0xbe, 0xbe, 0xbe, 0xbe, 0xbe, 0xbe, 0xbe, 0xbe, 0xc1, 0xc4, 0xc7, 0xca, 0xcd, 0xcf, 0xd2, 0xd4, 0xd6, 0xd8, 0xda, 0xdc, 0xde;}' unless defined(&BWI_PHY_SIGMA_SQ_11G_REV7);
    eval 'sub BWI_PHY_DELAY_11G_REV1 () {0xdb93cb87, 0xd666cf64, 0xd1fdd358, 0xcda6d826, 0xca38dd9f, 0xc729e2b4, 0xc469e88e, 0xc26aee2b, 0xc0def46c, 0xc073fa62, 0xc01d00d5, 0xc0760743, 0xc1560d1e, 0xc2e51369, 0xc4ed18ff, 0xc7ac1ed7, 0xcb2823b2, 0xcefa28d9, 0xd2f62d3f, 0xd7bb3197, 0xdce53568, 0xe1fe3875, 0xe7d13b35, 0xed663d35, 0xf39b3ec4, 0xf98e3fa7, 0x4000, 0x6723fa7, 0xc653ec4, 0x129a3d35, 0x182f3b35, 0x1e023875, 0x231b3568, 0x28453197, 0x2d0a2d3f, 0x310628d9, 0x34d823b2, 0x38541ed7, 0x3b1318ff, 0x3d1b1369, 0x3eaa0d1e, 0x3f8a0743, 0x3fe300d5, 0x3f8dfa62, 0x3f22f46c, 0x3d96ee2b, 0x3b97e88e, 0x38d7e2b4, 0x35c8dd9f, 0x325ad826, 0x2e03d358, 0x299acf64, 0x246dcb87;}' unless defined(&BWI_PHY_DELAY_11G_REV1);
    eval 'sub BWI_RFR_ATTEN () {0x43;}' unless defined(&BWI_RFR_ATTEN);
    eval 'sub BWI_RFR_TXPWR () {0x52;}' unless defined(&BWI_RFR_TXPWR);
    eval 'sub BWI_RFR_TXPWR1_MASK () {0x70;}' unless defined(&BWI_RFR_TXPWR1_MASK);
    eval 'sub BWI_RFR_BBP_ATTEN () {0x60;}' unless defined(&BWI_RFR_BBP_ATTEN);
    eval 'sub BWI_RFR_BBP_ATTEN_CALIB_BIT () {(1<< 0);}' unless defined(&BWI_RFR_BBP_ATTEN_CALIB_BIT);
    eval 'sub BWI_RFR_BBP_ATTEN_CALIB_IDX () {(0xf << 1);}' unless defined(&BWI_RFR_BBP_ATTEN_CALIB_IDX);
    eval 'sub BWI_TXPOWER_MAP_11B () {0x4d, 0x4c, 0x4b, 0x4a, 0x4a, 0x49, 0x48, 0x47, 0x47, 0x46, 0x45, 0x45, 0x44, 0x43, 0x42, 0x42, 0x41, 0x40, 0x3f, 0x3e, 0x3d, 0x3c, 0x3b, 0x3a, 0x39, 0x38, 0x37, 0x36, 0x35, 0x34, 0x32, 0x31, 0x30, 0x2f, 0x2d, 0x2c, 0x2b, 0x29, 0x28, 0x26, 0x25, 0x23, 0x21, 0x1f, 0x1d, 0x1a, 0x17, 0x14, 0x10, 0xc, 0x6, 0x, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7;}' unless defined(&BWI_TXPOWER_MAP_11B);
    eval 'sub BWI_TXPOWER_MAP_11G () {77, 77, 77, 76, 76, 76, 75, 75, 74, 74, 73, 73, 73, 72, 72, 71, 71, 70, 70, 69, 68, 68, 67, 67, 66, 65, 65, 64, 63, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 50, 49, 47, 45, 43, 40, 37, 33, 28, 22, 14, 5, -7, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20;}' unless defined(&BWI_TXPOWER_MAP_11G);
    eval 'sub __LOWEST_SET_BIT {
        my($__mask) = @_;
	    eval q((((($__mask) - 1) & ($__mask)) ^ ($__mask)));
    }' unless defined(&__LOWEST_SET_BIT);
    eval 'sub __SHIFTOUT {
        my($__x, $__mask) = @_;
	    eval q(((($__x) & ($__mask)) /  &__LOWEST_SET_BIT($__mask)));
    }' unless defined(&__SHIFTOUT);
    eval 'sub __SHIFTIN {
        my($__x, $__mask) = @_;
	    eval q((($__x) *  &__LOWEST_SET_BIT($__mask)));
    }' unless defined(&__SHIFTIN);
    eval 'sub __SHIFTOUT_MASK {
        my($__mask) = @_;
	    eval q( &__SHIFTOUT(($__mask), ($__mask)));
    }' unless defined(&__SHIFTOUT_MASK);
}
1;
