require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_DRM_P_H_)) {
    eval 'sub _DRM_P_H_ () {1;}' unless defined(&_DRM_P_H_);
    if(defined(&_KERNEL) || defined(&__KERNEL__)) {
	require 'sys/param.ph';
	require 'sys/queue.ph';
	require 'sys/malloc.ph';
	require 'sys/pool.ph';
	require 'sys/kernel.ph';
	require 'sys/systm.ph';
	require 'sys/proc.ph';
	require 'sys/conf.ph';
	require 'sys/mutex.ph';
	require 'sys/tree.ph';
	require 'sys/endian.ph';
	require 'sys/stdint.ph';
	require 'sys/memrange.ph';
	require 'sys/extent.ph';
	require 'sys/rwlock.ph';
	if(defined(&DDB)) {
	    require 'ddb/db_var.ph';
	}
	require 'uvm/uvm_extern.ph';
	require 'uvm/uvm_object.ph';
	require 'dev/pci/pcidevs.ph';
	require 'dev/pci/pcivar.ph';
	require 'dev/pci/agpvar.ph';
	require 'machine/bus.ph';
	require './dev/pci/drm/drm_linux.ph';
	require './dev/pci/drm/drm_linux_list.ph';
	require './dev/pci/drm/drm.ph';
	require './dev/pci/drm/drm_mm.ph';
	require './dev/pci/drm/drm_atomic.ph';
	require './dev/pci/drm/agp.ph';
	eval 'sub DRM_DEBUGBITS_DEBUG () {0x1;}' unless defined(&DRM_DEBUGBITS_DEBUG);
	eval 'sub DRM_DEBUGBITS_KMS () {0x2;}' unless defined(&DRM_DEBUGBITS_KMS);
	eval 'sub DRM_DEBUGBITS_FAILED_IOCTL () {0x4;}' unless defined(&DRM_DEBUGBITS_FAILED_IOCTL);
	eval 'sub __OS_HAS_AGP () {( &NAGP > 0);}' unless defined(&__OS_HAS_AGP);
	eval 'sub DRM_IF_VERSION {
	    my($maj, $min) = @_;
    	    eval q(($maj << 16| $min));
	}' unless defined(&DRM_IF_VERSION);
	eval 'sub DRM_CURRENTPID () { ($curproc->{p_pid});}' unless defined(&DRM_CURRENTPID);
	eval 'sub DRM_MAXUNITS () {8;}' unless defined(&DRM_MAXUNITS);
	eval 'sub DRM_SUSER {
	    my($p) = @_;
    	    eval q(( &suser($p, 0) == 0));
	}' unless defined(&DRM_SUSER);
	eval 'sub DRM_MTRR_WC () { &MDF_WRITECOMBINE;}' unless defined(&DRM_MTRR_WC);
	eval 'sub DRM_WAKEUP {
	    my($x) = @_;
    	    eval q( &wakeup($x));
	}' unless defined(&DRM_WAKEUP);
	eval 'sub drm_msleep {
	    my($x, $msg) = @_;
    	    eval q( &mdelay($x));
	}' unless defined(&drm_msleep);
	eval 'sub TAILQ_CONCAT {
	    my($head1, $head2, $field) = @_;
    	    eval q( &do {  &if (! &TAILQ_EMPTY($head2)) { *($head1)-> &tqh_last = ($head2)-> &tqh_first; ($head2)-> ($tqh_first->{field}->{tqe_prev}) = ($head1)-> &tqh_last; ($head1)-> &tqh_last = ($head2)-> &tqh_last;  &TAILQ_INIT(($head2)); } }  &while (0));
	}' unless defined(&TAILQ_CONCAT);
	eval 'sub DRM_ARRAY_SIZE () { &nitems;}' unless defined(&DRM_ARRAY_SIZE);
	if(defined(&__i386__)) {
	    eval 'sub DRM_READMEMORYBARRIER () {
	        eval q( &__asm  &__volatile( \\"lock; addl $0,0(%%esp)\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_READMEMORYBARRIER);
	    eval 'sub DRM_WRITEMEMORYBARRIER () {
	        eval q( &__asm  &__volatile(\\"\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_WRITEMEMORYBARRIER);
	    eval 'sub DRM_MEMORYBARRIER () {
	        eval q( &__asm  &__volatile( \\"lock; addl $0,0(%%esp)\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_MEMORYBARRIER);
	}
 elsif(defined(&__alpha__)) {
	    eval 'sub DRM_READMEMORYBARRIER () {
	        eval q( &alpha_mb(););
	    }' unless defined(&DRM_READMEMORYBARRIER);
	    eval 'sub DRM_WRITEMEMORYBARRIER () {
	        eval q( &alpha_wmb(););
	    }' unless defined(&DRM_WRITEMEMORYBARRIER);
	    eval 'sub DRM_MEMORYBARRIER () {
	        eval q( &alpha_mb(););
	    }' unless defined(&DRM_MEMORYBARRIER);
	}
 elsif(defined(&__amd64__)) {
	    eval 'sub DRM_READMEMORYBARRIER () {
	        eval q( &__asm  &__volatile( \\"lock; addl $0,0(%%rsp)\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_READMEMORYBARRIER);
	    eval 'sub DRM_WRITEMEMORYBARRIER () {
	        eval q( &__asm  &__volatile(\\"\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_WRITEMEMORYBARRIER);
	    eval 'sub DRM_MEMORYBARRIER () {
	        eval q( &__asm  &__volatile( \\"lock; addl $0,0(%%rsp)\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_MEMORYBARRIER);
	}
 elsif(defined(&__mips64__)) {
	    eval 'sub DRM_READMEMORYBARRIER () {
	        eval q( &DRM_MEMORYBARRIER());
	    }' unless defined(&DRM_READMEMORYBARRIER);
	    eval 'sub DRM_WRITEMEMORYBARRIER () {
	        eval q( &DRM_MEMORYBARRIER());
	    }' unless defined(&DRM_WRITEMEMORYBARRIER);
	    eval 'sub DRM_MEMORYBARRIER () {
	        eval q( &mips_sync());
	    }' unless defined(&DRM_MEMORYBARRIER);
	}
 elsif(defined(&__powerpc__)) {
	    eval 'sub DRM_READMEMORYBARRIER () {
	        eval q( &DRM_MEMORYBARRIER());
	    }' unless defined(&DRM_READMEMORYBARRIER);
	    eval 'sub DRM_WRITEMEMORYBARRIER () {
	        eval q( &DRM_MEMORYBARRIER());
	    }' unless defined(&DRM_WRITEMEMORYBARRIER);
	    eval 'sub DRM_MEMORYBARRIER () {
	        eval q( &__asm  &__volatile(\\"sync\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_MEMORYBARRIER);
	}
 elsif(defined(&__sparc64__)) {
	    eval 'sub DRM_READMEMORYBARRIER () {
	        eval q( &DRM_MEMORYBARRIER());
	    }' unless defined(&DRM_READMEMORYBARRIER);
	    eval 'sub DRM_WRITEMEMORYBARRIER () {
	        eval q( &DRM_MEMORYBARRIER());
	    }' unless defined(&DRM_WRITEMEMORYBARRIER);
	    eval 'sub DRM_MEMORYBARRIER () {
	        eval q( &membar( &Sync));
	    }' unless defined(&DRM_MEMORYBARRIER);
	}
	eval 'sub smp_mb__before_atomic_dec () {
	    eval q( &DRM_MEMORYBARRIER());
	}' unless defined(&smp_mb__before_atomic_dec);
	eval 'sub smp_mb__after_atomic_dec () {
	    eval q( &DRM_MEMORYBARRIER());
	}' unless defined(&smp_mb__after_atomic_dec);
	eval 'sub smp_mb__before_atomic_inc () {
	    eval q( &DRM_MEMORYBARRIER());
	}' unless defined(&smp_mb__before_atomic_inc);
	eval 'sub smp_mb__after_atomic_inc () {
	    eval q( &DRM_MEMORYBARRIER());
	}' unless defined(&smp_mb__after_atomic_inc);
	eval 'sub mb () {
	    eval q( &DRM_MEMORYBARRIER());
	}' unless defined(&mb);
	eval 'sub rmb () {
	    eval q( &DRM_READMEMORYBARRIER());
	}' unless defined(&rmb);
	eval 'sub wmb () {
	    eval q( &DRM_WRITEMEMORYBARRIER());
	}' unless defined(&wmb);
	eval 'sub smp_rmb () {
	    eval q( &DRM_READMEMORYBARRIER());
	}' unless defined(&smp_rmb);
	eval 'sub smp_wmb () {
	    eval q( &DRM_WRITEMEMORYBARRIER());
	}' unless defined(&smp_wmb);
	eval 'sub mmiowb () {
	    eval q( &DRM_WRITEMEMORYBARRIER());
	}' unless defined(&mmiowb);
	eval 'sub DRM_COPY_TO_USER {
	    my($user, $kern, $size) = @_;
    	    eval q( &copyout($kern, $user, $size));
	}' unless defined(&DRM_COPY_TO_USER);
	eval 'sub DRM_COPY_FROM_USER {
	    my($kern, $user, $size) = @_;
    	    eval q( &copyin($user, $kern, $size));
	}' unless defined(&DRM_COPY_FROM_USER);
	eval 'sub DRM_UDELAY {
	    my($udelay) = @_;
    	    eval q( &DELAY($udelay));
	}' unless defined(&DRM_UDELAY);
	eval 'sub DRM_WAIT_ON {
	    my($ret, $queue, $lock,  $timeout, $msg, $condition ) = @_;
    	    eval q( &do {  &mtx_enter($lock);  &while (($ret) == 0) {  &if ($condition)  &break; $ret =  &msleep(($queue), ($lock),  &PZERO |  &PCATCH, ($msg), ($timeout)); }  &mtx_leave($lock); }  &while ( 0));
	}' unless defined(&DRM_WAIT_ON);
	eval 'sub DRM_ERROR () {( &fmt,  &arg...)  &printf("error: ["  &DRM_NAME ":pid%d:%s] *ERROR* "  &fmt,  ($curproc->{p_pid}),  &__func__ ,   &arg);}' unless defined(&DRM_ERROR);
	if(defined(&DRMDEBUG)) {
	    eval 'sub DRM_INFO () {( &fmt,  &arg...)  &printf("drm: "  &fmt,   &arg);}' unless defined(&DRM_INFO);
	} else {
	    eval 'sub DRM_INFO () {( &fmt,  &arg...)  &do { }  &while( 0);}' unless defined(&DRM_INFO);
	}
	if(defined(&DRMDEBUG)) {
	    undef(&DRM_DEBUG) if defined(&DRM_DEBUG);
	    eval 'sub DRM_DEBUG () {( &fmt,  &arg...)  &do {  &if ( &drm_debug_flag)  &printf("["  &DRM_NAME ":pid%d:%s] "  &fmt,  ($curproc->{p_pid}),  &__func__ ,   &arg); }  &while (0);}' unless defined(&DRM_DEBUG);
	} else {
	    eval 'sub DRM_DEBUG () {( &fmt,  &arg...)  &do { }  &while( 0);}' unless defined(&DRM_DEBUG);
	}
	if(defined(&DRMDEBUG)) {
	    undef(&DRM_DEBUG_KMS) if defined(&DRM_DEBUG_KMS);
	    eval 'sub DRM_DEBUG_KMS () {( &fmt,  &arg...)  &do {  &if ( &drm_debug_flag)  &printf("["  &DRM_NAME ":pid%d:%s] "  &fmt,  ($curproc->{p_pid}),  &__func__ ,   &arg); }  &while (0);}' unless defined(&DRM_DEBUG_KMS);
	} else {
	    eval 'sub DRM_DEBUG_KMS () {( &fmt,  &arg...)  &do { }  &while( 0);}' unless defined(&DRM_DEBUG_KMS);
	}
	if(defined(&DRMDEBUG)) {
	    undef(&DRM_LOG_KMS) if defined(&DRM_LOG_KMS);
	    eval 'sub DRM_LOG_KMS () {( &fmt,  &arg...)  &do {  &if ( &drm_debug_flag)  &printf( &fmt,   &arg); }  &while (0);}' unless defined(&DRM_LOG_KMS);
	} else {
	    eval 'sub DRM_LOG_KMS () {( &fmt,  &arg...)  &do { }  &while( 0);}' unless defined(&DRM_LOG_KMS);
	}
	if(defined(&DRMDEBUG)) {
	    undef(&DRM_DEBUG_DRIVER) if defined(&DRM_DEBUG_DRIVER);
	    eval 'sub DRM_DEBUG_DRIVER () {( &fmt,  &arg...)  &do {  &if ( &drm_debug_flag)  &printf("["  &DRM_NAME ":pid%d:%s] "  &fmt,  ($curproc->{p_pid}),  &__func__ ,   &arg); }  &while (0);}' unless defined(&DRM_DEBUG_DRIVER);
	} else {
	    eval 'sub DRM_DEBUG_DRIVER () {( &fmt,  &arg...)  &do { }  &while( 0);}' unless defined(&DRM_DEBUG_DRIVER);
	}
	eval 'sub DRM_AUTH () {0x1;}' unless defined(&DRM_AUTH);
	eval 'sub DRM_MASTER () {0x2;}' unless defined(&DRM_MASTER);
	eval 'sub DRM_ROOT_ONLY () {0x4;}' unless defined(&DRM_ROOT_ONLY);
	eval 'sub DRM_CONTROL_ALLOW () {0x8;}' unless defined(&DRM_CONTROL_ALLOW);
	eval 'sub DRM_UNLOCKED () {0x10;}' unless defined(&DRM_UNLOCKED);
	eval 'sub DRM_IOCTL_DEF_DRV {
	    my($ioctl, $_func, $_flags) = @_;
    	    eval q([ &DRM_IOCTL_NR( &DRM_$ioctl)] = {. &cmd =  &DRM_$ioctl, . &func = $_func, . &flags = $_flags, . &cmd_drv =  &DRM_IOCTL_$ioctl});
	}' unless defined(&DRM_IOCTL_DEF_DRV);
	eval("sub _DRM_DMA_USE_AGP () { 0x01; }") unless defined(&_DRM_DMA_USE_AGP);
	eval("sub _DRM_DMA_USE_SG () { 0x02; }") unless defined(&_DRM_DMA_USE_SG);
	eval 'sub DRM_ATI_GART_MAIN () {1;}' unless defined(&DRM_ATI_GART_MAIN);
	eval 'sub DRM_ATI_GART_FB () {2;}' unless defined(&DRM_ATI_GART_FB);
	eval 'sub DRM_ATI_GART_PCI () {1;}' unless defined(&DRM_ATI_GART_PCI);
	eval 'sub DRM_ATI_GART_PCIE () {2;}' unless defined(&DRM_ATI_GART_PCIE);
	eval 'sub DRM_ATI_GART_IGP () {3;}' unless defined(&DRM_ATI_GART_IGP);
	eval 'sub DRM_ATI_GART_R600 () {4;}' unless defined(&DRM_ATI_GART_R600);
	eval 'sub DRM_BUSY () {0x1;}' unless defined(&DRM_BUSY);
	eval 'sub DRM_WANTED () {0x2;}' unless defined(&DRM_WANTED);
	eval 'sub DRM_VBLANKTIME_RBSIZE () {2;}' unless defined(&DRM_VBLANKTIME_RBSIZE);
	eval 'sub DRM_CALLED_FROM_VBLIRQ () {1;}' unless defined(&DRM_CALLED_FROM_VBLIRQ);
	eval 'sub DRM_VBLANKTIME_SCANOUTPOS_METHOD () {(1<< 0);}' unless defined(&DRM_VBLANKTIME_SCANOUTPOS_METHOD);
	eval 'sub DRM_VBLANKTIME_INVBL () {(1<< 1);}' unless defined(&DRM_VBLANKTIME_INVBL);
	eval 'sub DRM_SCANOUTPOS_VALID () {(1<< 0);}' unless defined(&DRM_SCANOUTPOS_VALID);
	eval 'sub DRM_SCANOUTPOS_INVBL () {(1<< 1);}' unless defined(&DRM_SCANOUTPOS_INVBL);
	eval 'sub DRM_SCANOUTPOS_ACCURATE () {(1<< 2);}' unless defined(&DRM_SCANOUTPOS_ACCURATE);
	eval 'sub DRIVER_AGP () {0x1;}' unless defined(&DRIVER_AGP);
	eval 'sub DRIVER_AGP_REQUIRE () {0x2;}' unless defined(&DRIVER_AGP_REQUIRE);
	eval 'sub DRIVER_MTRR () {0x4;}' unless defined(&DRIVER_MTRR);
	eval 'sub DRIVER_DMA () {0x8;}' unless defined(&DRIVER_DMA);
	eval 'sub DRIVER_PCI_DMA () {0x10;}' unless defined(&DRIVER_PCI_DMA);
	eval 'sub DRIVER_SG () {0x20;}' unless defined(&DRIVER_SG);
	eval 'sub DRIVER_IRQ () {0x40;}' unless defined(&DRIVER_IRQ);
	eval 'sub DRIVER_GEM () {0x80;}' unless defined(&DRIVER_GEM);
	eval 'sub DRIVER_MODESET () {0x100;}' unless defined(&DRIVER_MODESET);
	require './dev/pci/drm/drm_crtc.ph';
	eval 'sub DRMDEVCF_CONSOLE () {0;}' unless defined(&DRMDEVCF_CONSOLE);
	eval 'sub drmdevcf_console () { $cf_loc[ &DRMDEVCF_CONSOLE];}' unless defined(&drmdevcf_console);
	eval 'sub DRMDEVCF_CONSOLE_UNK () {-1;}' unless defined(&DRMDEVCF_CONSOLE_UNK);
	require './dev/pci/drm/drm_mem_util.ph';
	eval 'sub drm_core_ioremap_wc () { &drm_core_ioremap;}' unless defined(&drm_core_ioremap_wc);
	eval 'sub drm_gem_object_reference {
	    my($obj) = @_;
    	    eval q({  &drm_ref( ($obj->{u$obj})); });
	}' unless defined(&drm_gem_object_reference);
	eval 'sub drm_gem_object_unreference {
	    my($obj) = @_;
    	    eval q({  &drm_unref( ($obj->{u$obj})); });
	}' unless defined(&drm_gem_object_unreference);
	eval 'sub drm_gem_object_unreference_unlocked {
	    my($obj) = @_;
    	    eval q({ \'struct drm_device\' * &dev =  ($obj->{dev});  &mutex_lock( ($dev->{struct_mutex}));  &drm_unref( ($obj->{u$obj}));  &mutex_unlock( ($dev->{struct_mutex})); });
	}' unless defined(&drm_gem_object_unreference_unlocked);
	eval 'sub DRM_PCIE_SPEED_25 () {1;}' unless defined(&DRM_PCIE_SPEED_25);
	eval 'sub DRM_PCIE_SPEED_50 () {2;}' unless defined(&DRM_PCIE_SPEED_50);
	eval 'sub DRM_PCIE_SPEED_80 () {4;}' unless defined(&DRM_PCIE_SPEED_80);
    }
}
1;
