<?php
/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
 */

namespace MySQLFabric;

use Doctrine\DBAL\Sharding\ShardingException;

/**
 * MySQL Fabric related Exceptions
 */
class MySQLFabricException extends ShardingException
{
    /**
     * @return \Doctrine\DBAL\Sharding\MySQLFabric\MySQLFabricException
     */
    static public function notFabric()
    {
        return new self("This connection does not use MySQL Fabric.");
    }
    
    /**
     * @return \Doctrine\DBAL\Sharding\MySQLFabric\MySQLFabricException
     */
    static public function missingShardTable()
    {
        return new self("No MySQL Fabric shardTable set in configuration.");
    }
}
