/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import gnu.java.nio.charset.ByteDecodeLoopHelper;
import gnu.java.nio.charset.ByteEncodeLoopHelper;
import gnu.java.nio.charset.US_ASCII;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

abstract class ByteCharset
extends Charset {
    protected final char[] lookupTable;
    protected static final char NONE = '\ufffd';

    ByteCharset(String canonicalName, String[] aliases, char[] lookup) {
        super(canonicalName, aliases);
        this.lookupTable = lookup;
    }

    public boolean contains(Charset cs) {
        return cs instanceof US_ASCII || cs.getClass() == this.getClass();
    }

    char[] getLookupTable() {
        return this.lookupTable;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static final class Decoder
    extends CharsetDecoder {
        private final char[] lookup;
        private final ByteDecodeLoopHelper helper = new ByteDecodeLoopHelper(this){
            final /* synthetic */ Decoder this$1;
            {
                this.this$1 = decoder;
            }

            protected boolean isMappable(byte b) {
                return Decoder.access$0(this.this$1)[b & 0xFF] != '\ufffd';
            }

            protected char mapToChar(byte b) {
                return Decoder.access$0(this.this$1)[b & 0xFF];
            }
        };

        Decoder(ByteCharset cs) {
            super(cs, 1.0f, 1.0f);
            this.lookup = cs.getLookupTable();
        }

        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            return this.helper.decodeLoop(in, out);
        }

        static /* synthetic */ char[] access$0(Decoder decoder) {
            return decoder.lookup;
        }
    }

    private static final class Encoder
    extends CharsetEncoder {
        private final byte[] lookup;
        private final ByteEncodeLoopHelper helper = new ByteEncodeLoopHelper(this){
            final /* synthetic */ Encoder this$1;
            {
                this.this$1 = encoder;
            }

            protected boolean isMappable(char c) {
                return this.this$1.canEncode(c);
            }

            protected byte mapToByte(char c) {
                return Encoder.access$0(this.this$1)[c];
            }
        };

        Encoder(ByteCharset cs) {
            super(cs, 1.0f, 1.0f);
            char c;
            char[] lookup_table = cs.getLookupTable();
            char max = '\u0000';
            int i = 0;
            while (i < lookup_table.length) {
                c = lookup_table[i];
                max = c > max && c < '\ufffd' ? c : max;
                ++i;
            }
            this.lookup = new byte[max + 1];
            i = 0;
            while (i < lookup_table.length) {
                c = lookup_table[i];
                if (c != '\u0000' && c < '\ufffd') {
                    this.lookup[c] = (byte)i;
                }
                ++i;
            }
        }

        public boolean canEncode(char c) {
            byte b;
            byte by = b = c < this.lookup.length ? this.lookup[c] : (byte)0;
            return b != 0 || c == '\u0000';
        }

        public boolean canEncode(CharSequence cs) {
            int i = 0;
            while (i < cs.length()) {
                if (!this.canEncode(cs.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            return this.helper.encodeLoop(in, out);
        }

        static /* synthetic */ byte[] access$0(Encoder encoder) {
            return encoder.lookup;
        }
    }
}

