/*
 *  This file is part of the WebKit open source project.
 *  This file has been generated by generate-bindings.pl. DO NOT MODIFY!
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#ifndef WebKitDOMDocumentUnstable_h
#define WebKitDOMDocumentUnstable_h

#ifdef WEBKIT_DOM_USE_UNSTABLE_API

#include <webkitdom/webkitdomdefines-unstable.h>

G_BEGIN_DECLS

/**
 * webkit_dom_document_caret_range_from_point:
 * @self: A #WebKitDOMDocument
 * @x: A #glong
 * @y: A #glong
 *
 * Returns: (transfer full): A #WebKitDOMRange
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMRange*
webkit_dom_document_caret_range_from_point(WebKitDOMDocument* self, glong x, glong y);

/**
 * webkit_dom_document_webkit_cancel_full_screen:
 * @self: A #WebKitDOMDocument
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_document_webkit_cancel_full_screen(WebKitDOMDocument* self);

/**
 * webkit_dom_document_webkit_exit_fullscreen:
 * @self: A #WebKitDOMDocument
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_document_webkit_exit_fullscreen(WebKitDOMDocument* self);

/**
 * webkit_dom_document_exit_pointer_lock:
 * @self: A #WebKitDOMDocument
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_document_exit_pointer_lock(WebKitDOMDocument* self);

/**
 * webkit_dom_document_webkit_get_named_flows:
 * @self: A #WebKitDOMDocument
 *
 * Returns: (transfer full): A #WebKitDOMDOMNamedFlowCollection
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMDOMNamedFlowCollection*
webkit_dom_document_webkit_get_named_flows(WebKitDOMDocument* self);

/**
 * webkit_dom_document_create_touch:
 * @self: A #WebKitDOMDocument
 * @window: A #WebKitDOMDOMWindow
 * @target: A #WebKitDOMEventTarget
 * @identifier: A #glong
 * @pageX: A #glong
 * @pageY: A #glong
 * @screenX: A #glong
 * @screenY: A #glong
 * @webkitRadiusX: A #glong
 * @webkitRadiusY: A #glong
 * @webkitRotationAngle: A #gfloat
 * @webkitForce: A #gfloat
 * @error: #GError
 *
 * Returns: (transfer full): A #WebKitDOMTouch
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMTouch*
webkit_dom_document_create_touch(WebKitDOMDocument* self, WebKitDOMDOMWindow* window, WebKitDOMEventTarget* target, glong identifier, glong pageX, glong pageY, glong screenX, glong screenY, glong webkitRadiusX, glong webkitRadiusY, gfloat webkitRotationAngle, gfloat webkitForce, GError** error);

/**
 * webkit_dom_document_get_content_type:
 * @self: A #WebKitDOMDocument
 *
 * Returns: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API gchar*
webkit_dom_document_get_content_type(WebKitDOMDocument* self);

/**
 * webkit_dom_document_get_compat_mode:
 * @self: A #WebKitDOMDocument
 *
 * Returns: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API gchar*
webkit_dom_document_get_compat_mode(WebKitDOMDocument* self);

/**
 * webkit_dom_document_get_webkit_is_full_screen:
 * @self: A #WebKitDOMDocument
 *
 * Returns: A #gboolean
 *
 * Stability: Unstable
**/
WEBKIT_API gboolean
webkit_dom_document_get_webkit_is_full_screen(WebKitDOMDocument* self);

/**
 * webkit_dom_document_get_webkit_full_screen_keyboard_input_allowed:
 * @self: A #WebKitDOMDocument
 *
 * Returns: A #gboolean
 *
 * Stability: Unstable
**/
WEBKIT_API gboolean
webkit_dom_document_get_webkit_full_screen_keyboard_input_allowed(WebKitDOMDocument* self);

/**
 * webkit_dom_document_get_webkit_current_full_screen_element:
 * @self: A #WebKitDOMDocument
 *
 * Returns: (transfer none): A #WebKitDOMElement
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMElement*
webkit_dom_document_get_webkit_current_full_screen_element(WebKitDOMDocument* self);

/**
 * webkit_dom_document_get_webkit_fullscreen_enabled:
 * @self: A #WebKitDOMDocument
 *
 * Returns: A #gboolean
 *
 * Stability: Unstable
**/
WEBKIT_API gboolean
webkit_dom_document_get_webkit_fullscreen_enabled(WebKitDOMDocument* self);

/**
 * webkit_dom_document_get_webkit_fullscreen_element:
 * @self: A #WebKitDOMDocument
 *
 * Returns: (transfer none): A #WebKitDOMElement
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMElement*
webkit_dom_document_get_webkit_fullscreen_element(WebKitDOMDocument* self);

/**
 * webkit_dom_document_get_pointer_lock_element:
 * @self: A #WebKitDOMDocument
 *
 * Returns: (transfer none): A #WebKitDOMElement
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMElement*
webkit_dom_document_get_pointer_lock_element(WebKitDOMDocument* self);

/**
 * webkit_dom_document_get_visibility_state:
 * @self: A #WebKitDOMDocument
 *
 * Returns: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API gchar*
webkit_dom_document_get_visibility_state(WebKitDOMDocument* self);

/**
 * webkit_dom_document_get_hidden:
 * @self: A #WebKitDOMDocument
 *
 * Returns: A #gboolean
 *
 * Stability: Unstable
**/
WEBKIT_API gboolean
webkit_dom_document_get_hidden(WebKitDOMDocument* self);

/**
 * webkit_dom_document_get_security_policy:
 * @self: A #WebKitDOMDocument
 *
 * Returns: (transfer full): A #WebKitDOMDOMSecurityPolicy
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMDOMSecurityPolicy*
webkit_dom_document_get_security_policy(WebKitDOMDocument* self);

/**
 * webkit_dom_document_get_current_script:
 * @self: A #WebKitDOMDocument
 *
 * Returns: (transfer none): A #WebKitDOMHTMLScriptElement
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMHTMLScriptElement*
webkit_dom_document_get_current_script(WebKitDOMDocument* self);

/**
 * webkit_dom_document_get_origin:
 * @self: A #WebKitDOMDocument
 *
 * Returns: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API gchar*
webkit_dom_document_get_origin(WebKitDOMDocument* self);


G_END_DECLS

#endif /* WEBKIT_DOM_USE_UNSTABLE_API */
#endif /* WebKitDOMDocumentUnstable_h */
