/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport.nio;

import java.io.IOException;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.transport.AbstractSender;
import org.apache.catalina.tribes.transport.DataSender;
import org.apache.catalina.tribes.transport.PooledSender;
import org.apache.catalina.tribes.transport.nio.ParallelNioSender;
import org.apache.catalina.tribes.util.StringManager;

public class PooledParallelSender
extends PooledSender {
    protected static final StringManager sm = StringManager.getManager(PooledParallelSender.class.getPackage().getName());
    protected boolean connected = true;

    @Override
    public void sendMessage(Member[] destination, ChannelMessage message) throws ChannelException {
        if (!this.connected) {
            throw new ChannelException(sm.getString("pooledParallelSender.sender.disconnected"));
        }
        ParallelNioSender sender = (ParallelNioSender)this.getSender();
        if (sender == null) {
            ChannelException cx = new ChannelException(sm.getString("pooledParallelSender.unable.retrieveSender.timeout", this.getMaxWait()));
            for (int i = 0; i < destination.length; ++i) {
                cx.addFaultyMember(destination[i], new NullPointerException(sm.getString("pooledParallelSender.unable.retrieveSender")));
            }
            throw cx;
        }
        try {
            sender.sendMessage(destination, message);
            sender.keepalive();
        }
        catch (ChannelException x) {
            sender.disconnect();
            throw x;
        }
        finally {
            this.returnSender(sender);
            if (!this.connected) {
                this.disconnect();
            }
        }
    }

    @Override
    public DataSender getNewDataSender() {
        try {
            ParallelNioSender sender = new ParallelNioSender();
            AbstractSender.transferProperties(this, sender);
            return sender;
        }
        catch (IOException x) {
            throw new RuntimeException(sm.getString("pooledParallelSender.unable.open"), x);
        }
    }

    @Override
    public synchronized void disconnect() {
        this.connected = false;
        super.disconnect();
    }

    @Override
    public synchronized void connect() throws IOException {
        this.connected = true;
        super.connect();
    }
}

