/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.cos;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSBoolean;
import org.pdfbox.cos.COSFloat;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNull;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.COSObject;
import org.pdfbox.cos.COSString;
import org.pdfbox.cos.ICOSVisitor;
import org.pdfbox.exceptions.COSVisitorException;
import org.pdfbox.pdmodel.common.COSObjectable;

public class COSDictionary
extends COSBase {
    private static final String PATH_SEPARATOR = "/";
    private Map items = new HashMap();
    private List keys = new ArrayList();

    public COSDictionary() {
    }

    public COSDictionary(COSDictionary dict) {
        this.items = new HashMap(dict.items);
        this.keys = new ArrayList(dict.keys);
    }

    public int size() {
        return this.keys.size();
    }

    public void clear() {
        this.items.clear();
        this.keys.clear();
    }

    public COSBase getDictionaryObject(String key) {
        return this.getDictionaryObject(COSName.getPDFName(key));
    }

    public COSBase getDictionaryObject(String[] keyList) {
        COSBase retval = null;
        for (int i = 0; i < keyList.length && retval == null; ++i) {
            retval = this.getDictionaryObject(COSName.getPDFName(keyList[i]));
        }
        return retval;
    }

    public COSBase getDictionaryObject(COSName key) {
        COSBase retval = (COSBase)this.items.get(key);
        if (retval instanceof COSObject) {
            retval = ((COSObject)retval).getObject();
        }
        if (retval instanceof COSNull) {
            retval = null;
        }
        return retval;
    }

    public void setItem(COSName key, COSBase value) {
        if (value == null) {
            this.removeItem(key);
        } else {
            if (!this.items.containsKey(key)) {
                this.keys.add(key);
            }
            this.items.put(key, value);
        }
    }

    public void setItem(COSName key, COSObjectable value) {
        COSBase base = null;
        if (value != null) {
            base = value.getCOSObject();
        }
        this.setItem(key, base);
    }

    public void setItem(String key, COSObjectable value) {
        this.setItem(COSName.getPDFName(key), value);
    }

    public void setItem(String key, boolean value) {
        this.setItem(COSName.getPDFName(key), (COSBase)COSBoolean.getBoolean(value));
    }

    public void setItem(COSName key, boolean value) {
        this.setItem(key, (COSBase)COSBoolean.getBoolean(value));
    }

    public void setItem(String key, COSBase value) {
        this.setItem(COSName.getPDFName(key), value);
    }

    public void setName(String key, String value) {
        this.setName(COSName.getPDFName(key), value);
    }

    public void setName(COSName key, String value) {
        COSName name = null;
        if (value != null) {
            name = COSName.getPDFName(value);
        }
        this.setItem(key, (COSBase)name);
    }

    public void setString(String key, String value) {
        this.setString(COSName.getPDFName(key), value);
    }

    public void setString(COSName key, String value) {
        COSString name = null;
        if (value != null) {
            name = new COSString(value);
        }
        this.setItem(key, name);
    }

    public void setInt(String key, int value) {
        this.setInt(COSName.getPDFName(key), value);
    }

    public void setInt(COSName key, int value) {
        COSInteger intVal = null;
        intVal = new COSInteger(value);
        this.setItem(key, (COSBase)intVal);
    }

    public void setFloat(String key, float value) {
        this.setFloat(COSName.getPDFName(key), value);
    }

    public void setFloat(COSName key, float value) {
        COSFloat fltVal = new COSFloat(value);
        this.setItem(key, (COSBase)fltVal);
    }

    public String getNameAsString(String key) {
        return this.getNameAsString(COSName.getPDFName(key));
    }

    public String getNameAsString(COSName key) {
        String retval = null;
        COSName name = (COSName)this.getDictionaryObject(key);
        if (name != null) {
            retval = name.getName();
        }
        return retval;
    }

    public String getNameAsString(String key, String defaultValue) {
        return this.getNameAsString(COSName.getPDFName(key), defaultValue);
    }

    public String getNameAsString(COSName key, String defaultValue) {
        String retval = this.getNameAsString(key);
        if (retval == null) {
            retval = defaultValue;
        }
        return retval;
    }

    public String getString(String key) {
        return this.getString(COSName.getPDFName(key));
    }

    public String getString(COSName key) {
        String retval = null;
        COSString name = (COSString)this.getDictionaryObject(key);
        if (name != null) {
            retval = name.getString();
        }
        return retval;
    }

    public String getString(String key, String defaultValue) {
        return this.getString(COSName.getPDFName(key), defaultValue);
    }

    public String getString(COSName key, String defaultValue) {
        String retval = this.getString(key);
        if (retval == null) {
            retval = defaultValue;
        }
        return retval;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getBoolean(COSName.getPDFName(key), defaultValue);
    }

    public boolean getBoolean(COSName key, boolean defaultValue) {
        boolean retval = defaultValue;
        COSBoolean bool = (COSBoolean)this.getDictionaryObject(key);
        if (bool != null) {
            retval = bool.getValue();
        }
        return retval;
    }

    public int getInt(String key) {
        return this.getInt(COSName.getPDFName(key));
    }

    public int getInt(COSName key) {
        return this.getInt(key, -1);
    }

    public int getInt(String[] keyList, int defaultValue) {
        int retval = defaultValue;
        COSNumber obj = (COSNumber)this.getDictionaryObject(keyList);
        if (obj != null) {
            retval = obj.intValue();
        }
        return retval;
    }

    public int getInt(String key, int defaultValue) {
        return this.getInt(new String[]{key}, defaultValue);
    }

    public int getInt(COSName key, int defaultValue) {
        return this.getInt(key.getName(), defaultValue);
    }

    public float getFloat(String key) {
        return this.getFloat(COSName.getPDFName(key));
    }

    public float getFloat(COSName key) {
        return this.getFloat(key, -1.0f);
    }

    public float getFloat(String key, float defaultValue) {
        return this.getFloat(COSName.getPDFName(key), defaultValue);
    }

    public float getFloat(COSName key, float defaultValue) {
        float retval = defaultValue;
        COSNumber obj = (COSNumber)this.getDictionaryObject(key);
        if (obj != null) {
            retval = obj.floatValue();
        }
        return retval;
    }

    public void removeItem(COSName key) {
        this.keys.remove(key);
        this.items.remove(key);
    }

    public COSBase getItem(COSName key) {
        return (COSBase)this.items.get(key);
    }

    public List keyList() {
        return this.keys;
    }

    public Collection getValues() {
        return this.items.values();
    }

    public Object accept(ICOSVisitor visitor) throws COSVisitorException {
        return visitor.visitFromDictionary(this);
    }

    public void addAll(COSDictionary dic) {
        Iterator dicKeys = dic.keyList().iterator();
        while (dicKeys.hasNext()) {
            COSName key = (COSName)dicKeys.next();
            COSBase value = dic.getItem(key);
            this.setItem(key, value);
        }
    }

    public void mergeInto(COSDictionary dic) {
        Iterator dicKeys = dic.keyList().iterator();
        while (dicKeys.hasNext()) {
            COSName key = (COSName)dicKeys.next();
            COSBase value = dic.getItem(key);
            if (this.getItem(key) != null) continue;
            this.setItem(key, value);
        }
    }

    public COSBase getObjectFromPath(String objPath) {
        COSBase retval = null;
        String[] path = objPath.split(PATH_SEPARATOR);
        retval = this;
        for (int i = 0; i < path.length; ++i) {
            if (retval instanceof COSArray) {
                int idx = new Integer(path[i].replaceAll("\\[", "").replaceAll("\\]", ""));
                retval = ((COSArray)retval).getObject(idx);
                continue;
            }
            if (!(retval instanceof COSDictionary)) continue;
            retval = retval.getDictionaryObject(path[i]);
        }
        return retval;
    }
}

