/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.demux.vob;

import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.Time;
import javax.media.Track;
import javax.media.TrackListener;
import javax.media.format.VideoFormat;
import net.sourceforge.jffmpeg.GPLLicense;
import net.sourceforge.jffmpeg.demux.vob.DataBuffer;
import net.sourceforge.jffmpeg.demux.vob.VobDemux;

public class VideoTrack
extends DataBuffer
implements Track,
GPLLicense {
    private int totalNumberOfFrames = 0;
    private int framesDelivered = 0;
    public int videoFramesBufferTargetLow = 0;
    public int videoFramesBufferTargetHigh = 0;
    private int packetsPerFrame = 0;
    private static final int PACKETS_PER_FRAME = 10;
    private int width;
    private int height;
    private float frameRate = 30.0f;
    private long halfSeconds = 0L;
    VobDemux demux;
    int streamNumber;
    boolean enabled;
    Time time = new Time((long)(1000.0f / this.frameRate));
    public static final byte PICTURE_START_CODE = 0;
    public static final byte SEQUENCE_START_CODE = -77;
    public static final int I_TYPE = 1;
    public static final int P_TYPE = 2;
    public static final int B_TYPE = 3;
    public static final String[] pictName = new String[]{"0", "I", "P", "B", "4", "5", "6", "7"};
    private int currentFrameNumber = 0;
    public static final int FRAME_BUFFER_MASK = 255;
    private int[] frameType = new int[256];
    private long[] frameReference = new long[256];
    private Buffer[] frameBuffer = new Buffer[256];
    private Buffer partialFrame = new Buffer();
    private Buffer temp = new Buffer();
    private int[] framePointer = new int[256];
    public static final float[] frameRateTable = new float[]{0.0f, 24000.0f, 24024.0f, 25025.0f, 30000.0f, 30030.0f, 50050.0f, 60000.0f, 60060.0f, 15015.0f, 5005.0f, 10010.0f, 12012.0f, 15015.0f};
    public static final double[] aspectRatioTable = new double[]{0.0, 1.0, -0.75, -0.5625, -0.45248868778280543, 0.0, 1.0, -0.75, -0.5625, -0.45248868778280543, 0.0, 1.0, -0.75, -0.5625, -0.45248868778280543, 0.0, 1.0, -0.75, -0.5625, -0.45248868778280543};
    private int numberOfFramesAvailable = 0;

    public VideoTrack(VobDemux vobDemux, int n) {
        this.demux = vobDemux;
        this.streamNumber = n;
        this.enabled = n == 480;
        for (int i = 0; i < this.frameBuffer.length; ++i) {
            this.frameBuffer[i] = new Buffer();
            this.frameBuffer[i].setData((Object)new byte[1000]);
        }
        this.partialFrame.setData((Object)new byte[1000]);
        this.partialFrame.setLength(0);
    }

    public Time getDuration() {
        return this.time;
    }

    public Format getFormat() {
        return new VideoFormat("mpeg", new Dimension(this.width, this.height), 10000, new byte[0].getClass(), this.frameRate);
    }

    public Time getStartTime() {
        System.out.println("Get Start time");
        return new Time(2000L);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Time mapFrameToTime(int n) {
        System.out.println("Map Frame to time");
        return new Time((long)n);
    }

    public int mapTimeToFrame(Time time) {
        System.out.println("Map Time to Frame");
        return 0;
    }

    private static final void appendBuffer(Buffer buffer, byte[] byArray, int n) {
        int n2;
        byte[] byArray2 = (byte[])buffer.getData();
        if (byArray2.length < (n2 = buffer.getLength()) + n) {
            byte[] byArray3 = new byte[(n2 + n) * 2];
            System.arraycopy(byArray2, 0, byArray3, 0, n2);
            buffer.setData((Object)byArray3);
            byArray2 = byArray3;
        }
        System.arraycopy(byArray, 0, byArray2, n2, n);
        buffer.setLength(n2 + n);
    }

    private static final void setBuffer(Buffer buffer, byte[] byArray, int n, int n2) {
        byte[] byArray2 = (byte[])buffer.getData();
        if (byArray2.length < n2) {
            byArray2 = new byte[n2 * 2];
            buffer.setData((Object)byArray2);
        }
        System.arraycopy(byArray, n, byArray2, 0, n2);
        buffer.setLength(n2);
    }

    public void readFrame(Buffer buffer) {
        buffer.setFlags(64);
        try {
            if (!this.enabled) {
                this.demux.readVideo(this.streamNumber, this.temp);
                buffer.setLength(0);
                return;
            }
            while (true) {
                if (this.currentFrameNumber == this.getNumberOfFrames()) {
                    this.demux.parse(this.streamNumber);
                    continue;
                }
                buffer.setData(this.frameBuffer[this.currentFrameNumber].getData());
                buffer.setLength(this.frameBuffer[this.currentFrameNumber].getLength());
                this.currentFrameNumber = this.currentFrameNumber + 1 & 0xFF;
                if (this.frameType[this.currentFrameNumber - 1 & 0xFF] != 3 || !this.demux.isVideoSlow(this.frameReference[this.currentFrameNumber])) break;
            }
            ++this.framesDelivered;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void setTrackListener(TrackListener trackListener) {
    }

    private synchronized int getNumberOfFrames() {
        return this.numberOfFramesAvailable;
    }

    private synchronized void setNumberOfFrames(int n) {
        this.numberOfFramesAvailable = n;
    }

    public synchronized void readData(long l, InputStream inputStream, int n) throws IOException {
        int n2;
        int n3;
        if (this.buffer.length < n) {
            this.buffer = new byte[n * 2];
        }
        this.size = 0;
        int n4 = 0;
        while (n > 0) {
            n4 = inputStream.read(this.buffer, this.size, n);
            if (n4 < 0) {
                throw new IOException("End of Stream");
            }
            n -= n4;
            this.size += n4;
        }
        VideoTrack.appendBuffer(this.partialFrame, this.buffer, this.size);
        if (this.packetsPerFrame-- > 0) {
            return;
        }
        this.packetsPerFrame = 10;
        byte[] byArray = (byte[])this.partialFrame.getData();
        int n5 = this.partialFrame.getLength();
        int n6 = n3 = this.getNumberOfFrames();
        boolean bl = false;
        for (n2 = 0; n2 < n5 - 6; ++n2) {
            if (byArray[n2] != 0 || byArray[n2 + 1] != 0 || byArray[n2 + 2] != 1) continue;
            byte by = byArray[n2 + 3];
            if (by == 0) {
                int n7 = (byArray[n2 + 4] & 0xFF) << 2 | byArray[n2 + 5] >> 6 & 3;
                int n8 = byArray[n2 + 5] >> 3 & 7;
                if (!bl) {
                    this.framePointer[n3] = n2;
                    n3 = n3 + 1 & 0xFF;
                }
                this.frameType[n3 - 1 & 0xFF] = n8;
                this.frameReference[n3 - 1 & 0xFF] = l;
                bl = false;
            }
            if (by != -77) continue;
            bl = true;
            this.framePointer[n3] = n2;
            n3 = n3 + 1 & 0xFF;
            this.width = (byArray[n2 + 4] & 0xFF) << 4 | (byArray[n2 + 5] & 0xFF) >> 4;
            this.height = (byArray[n2 + 5] & 0xF) << 8 | byArray[n2 + 6] & 0xFF;
            double d = aspectRatioTable[byArray[n2 + 7] >> 4 & 0xF];
            this.frameRate = frameRateTable[byArray[n2 + 7] & 0xF] / 1001.0f;
        }
        if (n3 != n6) {
            n3 = n3 - 1 & 0xFF;
            n2 = n6;
            while (n2 != n3) {
                VideoTrack.setBuffer(this.frameBuffer[n2], byArray, this.framePointer[n2], this.framePointer[n2 + 1 & 0xFF] - this.framePointer[n2]);
                ++this.totalNumberOfFrames;
                n2 = n2 + 1 & 0xFF;
            }
        }
        VideoTrack.setBuffer(this.partialFrame, byArray, this.framePointer[n3], n5 - this.framePointer[n3]);
        this.setNumberOfFrames(n3);
    }

    public synchronized void drop() {
        this.setNumberOfFrames(1);
        this.currentFrameNumber = 0;
        this.totalNumberOfFrames = 0;
        super.drop();
        for (int i = 0; i < this.frameBuffer.length; ++i) {
            this.frameBuffer[i] = new Buffer();
            this.frameBuffer[i].setData((Object)new byte[1000]);
        }
        this.partialFrame.setData((Object)new byte[1000]);
        this.partialFrame.setLength(0);
    }
}

