/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.demux.ogg;

import java.io.IOException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.Time;
import javax.media.Track;
import javax.media.TrackListener;
import javax.media.format.AudioFormat;
import net.sourceforge.jffmpeg.demux.ogg.OggDemux;

public class AudioTrack
implements Track {
    private long sampleRate = 44100L;
    private long sampleDuration = 22675L;
    private OggDemux demux;
    private int serial;
    private int headersRequired = 3;
    private static final int HEADER_INFO = 1;
    private static final int HEADER_COMMENT = 3;
    private static final int HEADER_BOOKS = 5;
    private byte[] packetBuffer = new byte[0];
    private int packetBufferLength = 0;

    public AudioTrack(OggDemux oggDemux, int n) {
        this.demux = oggDemux;
        this.serial = n;
    }

    public Time getDuration() {
        return this.demux.getDuration();
    }

    public Format getFormat() {
        if (this.headersRequired > 0) {
            while (this.headersRequired > 0) {
                this.readFrame(new Buffer());
            }
            this.demux.seekPacket(0L, this.serial);
        }
        return new AudioFormat("vorbis", (double)this.sampleRate, 16, 2, 0, 1);
    }

    public void setEnabled(boolean bl) {
    }

    public boolean isEnabled() {
        return true;
    }

    public Time mapFrameToTime(int n) {
        return new Time((long)n * this.sampleDuration);
    }

    public int mapTimeToFrame(Time time) {
        return (int)(time.getNanoseconds() / this.sampleDuration);
    }

    public void readFrame(Buffer buffer) {
        try {
            this.demux.readFrame(buffer, this.serial, this.sampleDuration);
            if (this.headersRequired > 0) {
                this.process(buffer);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public Time getStartTime() {
        return new Time(0L);
    }

    public void setTrackListener(TrackListener trackListener) {
    }

    private void process(Buffer buffer) {
        try {
            byte[] byArray = (byte[])buffer.getData();
            int n = buffer.getLength();
            int n2 = byArray[26] & 0xFF;
            int n3 = 0;
            int n4 = 27 + n2;
            while (n3 < n2) {
                int n5 = 0;
                do {
                    n5 += byArray[27 + n3] & 0xFF;
                } while (byArray[27 + (++n3 - 1)] == -1 && n3 < n2);
                if (this.packetBuffer.length < n5 + this.packetBufferLength) {
                    byte[] byArray2 = this.packetBuffer;
                    this.packetBuffer = new byte[n5 + this.packetBufferLength];
                    System.arraycopy(byArray2, 0, this.packetBuffer, 0, this.packetBufferLength);
                }
                System.arraycopy(byArray, n4, this.packetBuffer, this.packetBufferLength, n5);
                this.packetBufferLength += n5;
                if (byArray[27 + (n3 - 1)] == -1) continue;
                this.decodeHeader(this.packetBuffer, 0, this.packetBufferLength);
                n4 += n5;
                this.packetBufferLength = 0;
            }
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
    }

    private void decodeHeader(byte[] byArray, int n, int n2) {
        byte by = byArray[n];
        if (byArray[n + 1] != 118 || byArray[n + 2] != 111 || byArray[n + 3] != 114 || byArray[n + 4] != 98 || byArray[n + 5] != 105 || byArray[n + 6] != 115) {
            return;
        }
        n += 7;
        n2 -= 7;
        switch (by) {
            case 1: {
                this.vorbis_unpack_info(byArray, n, n2);
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new Error("Invalid header ID: " + by);
            }
        }
        --this.headersRequired;
    }

    private void vorbis_unpack_info(byte[] byArray, int n, int n2) {
        int n3 = this.readInt(byArray, n);
        int n4 = byArray[n + 4] & 0xFF;
        int n5 = this.readInt(byArray, n + 5);
        int n6 = this.readInt(byArray, n + 9);
        int n7 = this.readInt(byArray, n + 13);
        int n8 = this.readInt(byArray, n + 17);
        this.sampleRate = n5;
        this.sampleDuration = 1000000000L / (long)n5;
    }

    private int readInt(byte[] byArray, int n) {
        int n2 = 0;
        n2 = n2 << 8 | byArray[n + 3] & 0xFF;
        n2 = n2 << 8 | byArray[n + 2] & 0xFF;
        n2 = n2 << 8 | byArray[n + 1] & 0xFF;
        n2 = n2 << 8 | byArray[n + 0] & 0xFF;
        return n2;
    }
}

