/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.util.Vector;
import oracle.xml.parser.v2.AttrDecl;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.DTD2SchemaConstants;
import oracle.xml.parser.v2.ElementDecl;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNotation;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class DTD2SchemaBuilder
implements DTD2SchemaConstants,
XMLConstants {
    DTD2SchemaBuilder() {
    }

    private boolean isDefinedElement(XMLElement xMLElement, String[] stringArray) {
        String string = xMLElement.getAttributeNS("", "name").intern();
        for (int i = 0; i < stringArray.length; ++i) {
            if (string != stringArray[i]) continue;
            return true;
        }
        return false;
    }

    String[] getDefinedElems(ElementDecl[] elementDeclArray) {
        int n = elementDeclArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            ElementDecl elementDecl = elementDeclArray[i];
            stringArray[i] = elementDecl.getNodeName();
        }
        return stringArray;
    }

    XMLElement[] getNotationDecls(DTD dTD, XMLDocument xMLDocument) {
        NamedNodeMap namedNodeMap = dTD.getNotations();
        if (namedNodeMap == null) {
            return null;
        }
        int n = namedNodeMap.getLength();
        XMLElement[] xMLElementArray = new XMLElement[n];
        String string = null;
        String string2 = null;
        for (int i = 0; i < n; ++i) {
            XMLNotation xMLNotation = (XMLNotation)namedNodeMap.item(i);
            String string3 = xMLNotation.getNodeName();
            string = xMLNotation.getSystemId();
            string2 = xMLNotation.getPublicId();
            XMLElement xMLElement = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:notation");
            xMLElement.setAttributeNS("", "name", string3);
            if (string2 != null) {
                xMLElement.setAttributeNS("", "public", string2);
                string2 = null;
            } else if (string != null) {
                xMLElement.setAttributeNS("", "system", string);
                string = null;
            }
            xMLElementArray[i] = xMLElement;
        }
        return xMLElementArray;
    }

    XMLDocument buildSchemaTree(XMLElement[] xMLElementArray, XMLElement[] xMLElementArray2, XMLDocument xMLDocument) {
        int n;
        XMLElement xMLElement = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:schema");
        xMLElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xs", "http://www.w3.org/2001/XMLSchema");
        xMLDocument.appendChild(xMLElement);
        if (xMLElementArray2 != null) {
            for (n = 0; n < xMLElementArray2.length; ++n) {
                xMLElement.appendChild(xMLElementArray2[n]);
            }
        }
        if (xMLElementArray != null) {
            for (n = xMLElementArray.length - 1; n >= 0; --n) {
                xMLElement.appendChild(xMLElementArray[n]);
            }
        }
        return xMLDocument;
    }

    ElementDecl[] getElementDecls(DTD dTD, String string) {
        NamedNodeMap namedNodeMap;
        if (string == null || string.length() == 0) {
            string = dTD.getRootTag();
        }
        if ((namedNodeMap = dTD.getElementDecls()) == null) {
            return null;
        }
        int n = namedNodeMap.getLength();
        ElementDecl[] elementDeclArray = new ElementDecl[n];
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            Node node = namedNodeMap.item(i);
            String string2 = node.getNodeName().intern();
            if (string2 == string) {
                elementDeclArray[0] = (ElementDecl)node;
                continue;
            }
            elementDeclArray[n2++] = (ElementDecl)node;
        }
        return elementDeclArray;
    }

    private String getAttrPresence(AttrDecl attrDecl) {
        switch (attrDecl.getAttrPresence()) {
            case 2: {
                return "optional";
            }
            case 1: {
                return "required";
            }
            case 3: {
                return "fixed";
            }
        }
        return "optional";
    }

    private Object getAttrType(AttrDecl attrDecl) {
        int n = attrDecl.getAttrType();
        String string = null;
        Vector vector = null;
        switch (n) {
            case 9: {
                vector = attrDecl.getEnumerationValues();
                return vector;
            }
            case 0: {
                string = "xs:string";
                return "xs:string";
            }
            case 1: {
                string = "xs:ID";
                return "xs:ID";
            }
            case 2: {
                string = "xs:IDREF";
                return "xs:IDREF";
            }
            case 3: {
                string = "xs:IDREFS";
                return "xs:IDREFS";
            }
            case 4: {
                string = "xs:ENTITY";
                return "xs:ENTITY";
            }
            case 5: {
                string = "xs:ENTITIES";
                return "xs:ENTITIES";
            }
            case 6: {
                string = "xs:NMTOKEN";
                return "xs:NMTOKEN";
            }
            case 7: {
                string = "xs:NMTOKENS";
                return "xs:NMTOKENS";
            }
        }
        return null;
    }

    XMLElement[] getAttrDecls(ElementDecl elementDecl, XMLDocument xMLDocument) {
        NamedNodeMap namedNodeMap = elementDecl.getAttrDecls();
        if (namedNodeMap == null) {
            return null;
        }
        int n = namedNodeMap.getLength();
        XMLElement[] xMLElementArray = new XMLElement[n];
        String string = null;
        String string2 = null;
        String string3 = null;
        Vector vector = null;
        for (int i = 0; i < n; ++i) {
            AttrDecl attrDecl = (AttrDecl)namedNodeMap.item(i);
            String string4 = attrDecl.getNodeName();
            Object object = this.getAttrType(attrDecl);
            string2 = this.getAttrPresence(attrDecl);
            string3 = attrDecl.getDefaultValue();
            XMLElement xMLElement = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:attribute");
            xMLElement.setAttributeNS("", "name", string4);
            if (object instanceof String) {
                if (string3 != null) {
                    if (string2 == "fixed") {
                        xMLElement.setAttributeNS("", "fixed", string3);
                    } else {
                        xMLElement.setAttributeNS("", "default", string3);
                    }
                } else {
                    xMLElement.setAttributeNS("", "use", string2);
                    string2 = null;
                }
                string = object.toString();
                xMLElement.setAttributeNS("", "type", string);
                string = null;
            } else {
                xMLElement.setAttributeNS("", "use", string2);
                string2 = null;
                if (string3 != null) {
                    xMLElement.setAttributeNS("", "default", string3);
                }
                vector = (Vector)object;
                int n2 = vector.size();
                XMLElement xMLElement2 = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:simpleType");
                XMLElement xMLElement3 = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:restriction");
                xMLElement3.setAttributeNS("", "base", "xs:NMTOKEN");
                xMLElement2.appendChild(xMLElement3);
                xMLElement.appendChild(xMLElement2);
                for (int j = 0; j < n2; ++j) {
                    XMLElement xMLElement4 = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:enumeration");
                    xMLElement4.setAttributeNS("", "value", vector.elementAt(j).toString());
                    xMLElement3.appendChild(xMLElement4);
                }
                vector = null;
            }
            xMLElementArray[i] = xMLElement;
            string3 = null;
        }
        return xMLElementArray;
    }

    XMLElement convert2ref(XMLElement xMLElement, String[] stringArray) {
        XMLElement xMLElement2 = xMLElement;
        boolean bl = false;
        if (xMLElement != null) {
            bl = xMLElement.hasChildNodes();
            if (bl) {
                boolean bl2 = this.isDefinedElement(xMLElement = (XMLElement)xMLElement.getFirstChild(), stringArray);
                if (bl2) {
                    String string = this.removeAllAttrs(xMLElement);
                    xMLElement.setAttributeNS("", "ref", string);
                }
                this.convert2ref(xMLElement, stringArray);
            } else {
                XMLElement xMLElement3 = (XMLElement)xMLElement.getNextSibling();
                while (xMLElement3 == null) {
                    if ((xMLElement = (XMLElement)xMLElement.getParentNode()) == null) {
                        return xMLElement2;
                    }
                    xMLElement3 = (XMLElement)xMLElement.getNextSibling();
                }
                boolean bl3 = this.isDefinedElement(xMLElement3, stringArray);
                if (bl3) {
                    String string = this.removeAllAttrs(xMLElement3);
                    xMLElement3.setAttributeNS("", "ref", string);
                }
                this.convert2ref(xMLElement3, stringArray);
            }
        }
        return xMLElement2;
    }

    private String removeAllAttrs(XMLElement xMLElement) {
        NamedNodeMap namedNodeMap;
        XMLElement xMLElement2 = (XMLElement)xMLElement.getFirstChild();
        if (xMLElement2 != null) {
            xMLElement.removeChild(xMLElement2);
        }
        if ((namedNodeMap = xMLElement.getAttributes()) == null) {
            return null;
        }
        int n = namedNodeMap.getLength();
        String string = null;
        for (int i = 0; i < n; ++i) {
            Node node = namedNodeMap.item(0);
            String string2 = node.getNodeName().intern();
            if (string2 == "name") {
                string = node.getNodeValue();
            }
            if (string2 == "minOccurs" || string2 == "maxOccurs") continue;
            xMLElement.removeAttributeNS("", string2);
        }
        return string;
    }
}

