/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.mpxj.CustomField;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FieldTypeClass;
import net.sf.mpxj.common.Pair;
import net.sf.mpxj.mpp.CustomFieldValueItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomFieldContainer
implements Iterable<CustomField> {
    private Map<FieldType, CustomField> m_configMap = new HashMap<FieldType, CustomField>();
    private Map<Integer, CustomFieldValueItem> m_valueMap = new HashMap<Integer, CustomFieldValueItem>();
    private Map<Pair<FieldTypeClass, String>, FieldType> m_aliasMap = new HashMap<Pair<FieldTypeClass, String>, FieldType>();

    public CustomField getCustomField(FieldType fieldType) {
        CustomField customField = this.m_configMap.get(fieldType);
        if (customField == null) {
            customField = new CustomField(fieldType, this);
            this.m_configMap.put(fieldType, customField);
        }
        return customField;
    }

    @Override
    public Iterator<CustomField> iterator() {
        return this.m_configMap.values().iterator();
    }

    public CustomFieldValueItem getCustomFieldValueItemByUniqueID(int n) {
        return this.m_valueMap.get(n);
    }

    void registerValue(CustomFieldValueItem customFieldValueItem) {
        this.m_valueMap.put(customFieldValueItem.getUniqueID(), customFieldValueItem);
    }

    void deregisterValue(CustomFieldValueItem customFieldValueItem) {
        this.m_valueMap.remove(customFieldValueItem.getUniqueID());
    }

    void registerAlias(FieldType fieldType, String string) {
        this.m_aliasMap.put(new Pair<FieldTypeClass, String>(fieldType.getFieldTypeClass(), string), fieldType);
    }

    public FieldType getFieldByAlias(FieldTypeClass fieldTypeClass, String string) {
        return this.m_aliasMap.get(new Pair<FieldTypeClass, String>(fieldTypeClass, string));
    }
}

