/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre.core.pm.exchange;

import com.projectlibre.core.pm.exchange.ImprovedMSPDIReader;
import com.projectlibre.core.pm.exchange.converters.mpx.MpxAssignmentConverter;
import com.projectlibre.core.pm.exchange.converters.mpx.MpxCalendarConverter;
import com.projectlibre.core.pm.exchange.converters.mpx.MpxDependencyConverter;
import com.projectlibre.core.pm.exchange.converters.mpx.MpxImportState;
import com.projectlibre.core.pm.exchange.converters.mpx.MpxOptionsConverter;
import com.projectlibre.core.pm.exchange.converters.mpx.MpxProjectConverter;
import com.projectlibre.core.pm.exchange.converters.mpx.MpxResourceConverter;
import com.projectlibre.core.pm.exchange.converters.mpx.MpxTaskConverter;
import com.projectlibre.core.pm.exchange.converters.mpx.type.MpxDurationConverter;
import com.projectlibre.core.pm.exchange.converters.type.DateUTCConverter;
import com.projectlibre.core.pm.exchange.converters.type.PercentNumberRatioDoubleConverter;
import com.projectlibre.core.time.Duration;
import com.projectlibre.pm.calendar.DefaultWorkCalendar;
import com.projectlibre.pm.calendar.DuplicateCalendarException;
import com.projectlibre.pm.resources.Resource;
import com.projectlibre.pm.resources.ResourcePool;
import com.projectlibre.pm.tasks.Assignment;
import com.projectlibre.pm.tasks.Dependency;
import com.projectlibre.pm.tasks.Project;
import com.projectlibre.pm.tasks.SnapshotList;
import com.projectlibre.pm.tasks.TaskSnapshot;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Relation;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mpx.MPXReader;
import net.sf.mpxj.mspdi.schema.TimephasedDataType;
import net.sf.mpxj.planner.PlannerReader;
import net.sf.mpxj.reader.AbstractProjectReader;

public class MspImporter {
    protected ProjectFile mpxProjectFile;
    protected MpxImportState state = new MpxImportState();
    protected AbstractProjectReader reader;
    protected long earliestTaskStart = -1L;
    protected Task mpxRootTask = null;

    public Project importProject(String string, ProgressClosure progressClosure) throws Exception {
        progressClosure.updateProgress(0.0f, "Start");
        this.parseProject(string);
        return this.importProject_(progressClosure);
    }

    public Project importProject(InputStream inputStream, String string, ProgressClosure progressClosure) throws Exception {
        progressClosure.updateProgress(0.0f, "Start");
        this.parseProject(inputStream, string);
        return this.importProject_(progressClosure);
    }

    private Project importProject_(ProgressClosure progressClosure) throws Exception {
        progressClosure.updateProgress(0.2f, "File parsed");
        if (this.state.isMspdi()) {
            this.state.setMpxTimephasedMap(((ImprovedMSPDIReader)this.reader).getTimephasedMap());
        } else {
            this.state.setMpxTimephasedMap(new HashMap<ResourceAssignment, List<TimephasedDataType>>());
        }
        Project project = new Project();
        this.importOptions(project);
        progressClosure.updateProgress(0.3f, "Options converted");
        this.importCalendars(project);
        progressClosure.updateProgress(0.4f, "Calendars converted");
        this.importResourcePool(project);
        progressClosure.updateProgress(0.5f, "Resources converted");
        this.importTasks(project);
        progressClosure.updateProgress(0.7f, "Tasks converted");
        this.importDependencies(project);
        progressClosure.updateProgress(0.8f, "Dependencies converted");
        this.importProjectHeader(project);
        progressClosure.updateProgress(0.9f, "Project headers converted");
        progressClosure.updateProgress(1.0f, "Completed");
        return project;
    }

    protected void parseProject(InputStream inputStream, String string) throws Exception {
        try {
            if (string.equals("xml")) {
                this.reader = new ImprovedMSPDIReader();
                this.state.setMspdi(true);
            } else if (string.equals("mpp")) {
                this.reader = new MPPReader();
            } else if (string.equals("mpx")) {
                this.reader = new MPXReader();
            } else if (string.equals("planner")) {
                this.reader = new PlannerReader();
            }
            this.mpxProjectFile = this.reader.read(inputStream);
            this.state.setMpxProjectFile(this.mpxProjectFile);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    protected void parseProject(String string) throws Exception {
        int n = (string = string.trim()).lastIndexOf(".");
        String string2 = n == -1 ? "xml" : string.substring(n + 1).toLowerCase();
        this.parseProject(new FileInputStream(string), string2);
    }

    protected void importOptions(Project project) {
        MpxOptionsConverter mpxOptionsConverter = new MpxOptionsConverter();
        mpxOptionsConverter.from(this.mpxProjectFile.getProjectProperties(), project.getCalendarOptions(), this.state);
    }

    protected void importProjectHeader(Project project) {
        MpxProjectConverter mpxProjectConverter = new MpxProjectConverter();
        mpxProjectConverter.from(this.mpxProjectFile.getProjectProperties(), project, this.state);
        if (this.earliestTaskStart != -1L) {
            project.setPropertyValue("start", new Date(this.earliestTaskStart));
        }
    }

    protected void importCalendars(Project project) {
        this.state.setCalendarManager(project.getCalendarManager());
        this.state.setProjectTitle(this.mpxProjectFile.getProjectProperties().getProjectTitle());
        MpxCalendarConverter mpxCalendarConverter = new MpxCalendarConverter();
        for (ProjectCalendar projectCalendar : this.mpxProjectFile.getCalendars()) {
            DefaultWorkCalendar defaultWorkCalendar = new DefaultWorkCalendar();
            if ("Standard".equals(projectCalendar.getName())) {
                this.state.setMpxStandardBaseCalendar(projectCalendar);
                project.getCalendarManager().setStandardBaseCalendar(defaultWorkCalendar);
            }
            mpxCalendarConverter.from(projectCalendar, defaultWorkCalendar, this.state);
            try {
                project.getCalendarManager().addBaseCalendar(defaultWorkCalendar);
                this.state.mapBaseCalendar(defaultWorkCalendar, projectCalendar);
            }
            catch (DuplicateCalendarException duplicateCalendarException) {
                duplicateCalendarException.printStackTrace();
            }
        }
    }

    protected void importResourcePool(Project project) {
        ResourcePool resourcePool = new ResourcePool();
        project.setResourcePool(resourcePool);
        this.state.setResourcePool(resourcePool);
        this.importResources(resourcePool);
    }

    protected void importResources(ResourcePool resourcePool) {
        this.state.setResourcePool(resourcePool);
        MpxResourceConverter mpxResourceConverter = new MpxResourceConverter();
        for (net.sf.mpxj.Resource resource : this.mpxProjectFile.getAllResources()) {
            Resource resource2;
            if (resource.getNull() || resource.getID() == null) continue;
            if (resource.getID() == 0) {
                resource2 = resourcePool.getUnassignedResource();
            } else {
                resource2 = new Resource();
                resourcePool.addResource(resource2);
            }
            mpxResourceConverter.from(resource, resource2, this.state);
            this.state.mapResource(resource, resource2);
        }
    }

    protected void importTasks(Project project) {
        for (Task task : this.mpxProjectFile.getChildTasks()) {
            this.importTasks(project, task, null);
        }
    }

    protected void importTasks(Project project, Task task, com.projectlibre.pm.tasks.Task task2) {
        MpxTaskConverter mpxTaskConverter = new MpxTaskConverter();
        if (task.getNull() || task.getID() == null) {
            return;
        }
        com.projectlibre.pm.tasks.Task task3 = null;
        if (task.getOutlineNumber() != null && task.getOutlineLevel() == 0) {
            if (this.mpxRootTask == null) {
                this.mpxRootTask = task;
            }
        } else {
            task3 = new com.projectlibre.pm.tasks.Task();
            mpxTaskConverter.from(task, task3, this.state);
            long l = ((Date)task3.getPropertyValue("start")).getTime();
            if (this.earliestTaskStart == -1L || l < this.earliestTaskStart) {
                this.earliestTaskStart = l;
            }
            project.addTask(task3, task2);
            this.state.mapTask(task, task3);
            MpxDurationConverter mpxDurationConverter = new MpxDurationConverter();
            DateUTCConverter dateUTCConverter = new DateUTCConverter();
            SnapshotList snapshotList = task3.getSnapshotList();
            for (int i = 0; i < 11; ++i) {
                Date date = i == 0 ? task.getBaselineStart() : task.getBaselineStart(i);
                if (date == null) continue;
                TaskSnapshot taskSnapshot = snapshotList.getSnapshot(i, true);
                taskSnapshot.setStart((Date)dateUTCConverter.from(date));
                Date date2 = i == 0 ? task.getBaselineFinish() : task.getBaselineFinish(i);
                taskSnapshot.setFinish((Date)dateUTCConverter.from(date2));
                net.sf.mpxj.Duration duration = i == 0 ? task.getBaselineDuration() : task.getBaselineDuration(i);
                taskSnapshot.setDuration((Duration)mpxDurationConverter.from(duration));
            }
            this.importAssignments(task, task3);
        }
        for (Task task4 : task.getChildTasks()) {
            this.importTasks(project, task4, task3);
        }
    }

    protected void importAssignments(Task task, com.projectlibre.pm.tasks.Task task2) {
        for (ResourceAssignment resourceAssignment : task.getResourceAssignments()) {
            MpxAssignmentConverter mpxAssignmentConverter = new MpxAssignmentConverter();
            Assignment assignment = new Assignment();
            assignment.setTask(task2);
            mpxAssignmentConverter.from(resourceAssignment, assignment, this.state, 11);
            task2.addAssignment(assignment);
            MpxDurationConverter mpxDurationConverter = new MpxDurationConverter();
            DateUTCConverter dateUTCConverter = new DateUTCConverter();
            PercentNumberRatioDoubleConverter percentNumberRatioDoubleConverter = new PercentNumberRatioDoubleConverter();
            for (int i = 0; i < 11; ++i) {
                Date date = i == 0 ? resourceAssignment.getBaselineStart() : resourceAssignment.getBaselineStart(i);
                if (date == null) continue;
                Assignment assignment2 = new Assignment();
                assignment2.setTask(task2);
                mpxAssignmentConverter.from(resourceAssignment, assignment2, this.state, i);
                assignment2.setFieldValue("Field.start", dateUTCConverter.from(date));
                Date date2 = i == 0 ? resourceAssignment.getBaselineFinish() : resourceAssignment.getBaselineFinish(i);
                assignment2.setFieldValue("Field.finish", dateUTCConverter.from(date2));
                net.sf.mpxj.Duration duration = i == 0 ? resourceAssignment.getBaselineWork() : resourceAssignment.getBaselineWork(i);
                assignment2.setFieldValue("Field.work", mpxDurationConverter.from(duration));
                assignment2.setFieldValue("Field.units", percentNumberRatioDoubleConverter.from(resourceAssignment.getUnits()));
                task2.addAssignment(assignment2, i);
            }
        }
    }

    protected void importDependencies(Project project) {
        MpxDependencyConverter mpxDependencyConverter = new MpxDependencyConverter();
        for (Task task : this.mpxProjectFile.getAllTasks()) {
            List<Relation> list;
            if (task == this.mpxRootTask || (list = task.getPredecessors()) == null) continue;
            for (Relation relation : list) {
                Dependency dependency = new Dependency();
                mpxDependencyConverter.from(relation, dependency, this.state);
                project.addDependency(dependency);
            }
        }
    }

    public static interface ProgressClosure {
        public void updateProgress(float var1, String var2);
    }
}

