/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.modules.uihandler.api.Deactivated;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class EnabledModulesCollector
implements Deactivated {
    private List<ModuleInfo> previouslyEnabled = Collections.emptyList();
    private List<ModuleInfo> previouslyDisabled = Collections.emptyList();

    @Override
    public void deactivated(Logger uiLogger) {
        SpecificationVersion specVersion;
        int i;
        LogRecord rec;
        ArrayList<ModuleInfo> enabled = new ArrayList<ModuleInfo>();
        ArrayList<ModuleInfo> disabled = new ArrayList<ModuleInfo>();
        for (ModuleInfo m : Lookup.getDefault().lookupAll(ModuleInfo.class)) {
            if (m.isEnabled()) {
                enabled.add(m);
                continue;
            }
            disabled.add(m);
        }
        ArrayList newEnabled = new ArrayList(enabled);
        newEnabled.removeAll(this.previouslyEnabled);
        ArrayList newDisabled = new ArrayList(disabled);
        newDisabled.removeAll(this.previouslyDisabled);
        if (!newEnabled.isEmpty()) {
            rec = new LogRecord(Level.CONFIG, "UI_ENABLED_MODULES");
            Object[] enabledNames = new String[newEnabled.size()];
            i = 0;
            for (ModuleInfo m : newEnabled) {
                specVersion = m.getSpecificationVersion();
                if (specVersion != null) {
                    enabledNames[i++] = m.getCodeName() + " [" + specVersion.toString() + "]";
                    continue;
                }
                enabledNames[i++] = m.getCodeName();
            }
            rec.setParameters(enabledNames);
            rec.setLoggerName(uiLogger.getName());
            rec.setResourceBundle(NbBundle.getBundle(EnabledModulesCollector.class));
            rec.setResourceBundleName(EnabledModulesCollector.class.getPackage().getName() + ".Bundle");
            uiLogger.log(rec);
        }
        if (!newDisabled.isEmpty()) {
            rec = new LogRecord(Level.CONFIG, "UI_DISABLED_MODULES");
            Object[] disabledNames = new String[newDisabled.size()];
            i = 0;
            for (ModuleInfo m : newDisabled) {
                specVersion = m.getSpecificationVersion();
                if (specVersion != null) {
                    disabledNames[i++] = m.getCodeName() + " [" + specVersion.toString() + "]";
                    continue;
                }
                disabledNames[i++] = m.getCodeName();
            }
            rec.setParameters(disabledNames);
            rec.setLoggerName(uiLogger.getName());
            rec.setResourceBundle(NbBundle.getBundle(EnabledModulesCollector.class));
            rec.setResourceBundleName(EnabledModulesCollector.class.getPackage().getName() + ".Bundle");
            uiLogger.log(rec);
        }
        this.previouslyEnabled = enabled;
        this.previouslyDisabled = disabled;
    }
}

