/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.Image;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditorSupport;
import java.beans.SimpleBeanInfo;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import org.netbeans.modules.editor.options.AbbrevsEditor;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.ColoringArrayEditor;
import org.netbeans.modules.editor.options.KeyBindingsEditor;
import org.netbeans.modules.editor.options.MacrosEditor;
import org.netbeans.modules.editor.options.ScrollInsetsEditor;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class BaseOptionsBeanInfo
extends SimpleBeanInfo {
    private String iconPrefix;
    private String bundlePrefix;
    private Image icon;
    private Image icon32;
    private HashMap names2PD;
    PropertyDescriptor[] descriptors;
    private static final String[] EXPERT_PROP_NAMES = new String[]{"caretBlinkRate", "caretTypeInsertMode", "caretTypeOverwriteMode", "caretColorInsertMode", "caretColorOverwriteMode", "highlightCaretRow", "highlightMatchingBracket", "lineHeightCorrection", "margin", "scrollJumpInsets", "scrollFindInsets", "statusBarCaretDelay", "statusBarVisible", "textLimitLineColor", "textLimitLineVisible", "textLimitWidth", "textAntialiasing"};

    public BaseOptionsBeanInfo() {
        this("/org/netbeans/modules/editor/resources/baseOptions");
    }

    public BaseOptionsBeanInfo(String iconPrefix) {
        this(iconPrefix, "");
    }

    public BaseOptionsBeanInfo(String iconPrefix, String bundlePrefix) {
        this.iconPrefix = iconPrefix;
        this.bundlePrefix = bundlePrefix;
    }

    @Override
    public PropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            String[] propNames = this.getPropNames();
            PropertyDescriptor[] pds = new PropertyDescriptor[propNames.length];
            for (int i = 0; i < propNames.length; ++i) {
                pds[i] = this.createPropertyDescriptor(propNames[i]);
                pds[i].setDisplayName(this.getString("PROP_" + this.bundlePrefix + propNames[i]));
                pds[i].setShortDescription(this.getString("HINT_" + this.bundlePrefix + propNames[i]));
            }
            this.descriptors = pds;
            this.updatePropertyDescriptors();
        }
        return this.descriptors;
    }

    protected PropertyDescriptor createPropertyDescriptor(String propName) {
        PropertyDescriptor pd;
        block9: {
            try {
                pd = new PropertyDescriptor(propName, this.getBeanClass());
            }
            catch (IntrospectionException e) {
                try {
                    pd = new PropertyDescriptor(propName, null, null);
                }
                catch (IntrospectionException e2) {
                    throw new IllegalStateException("Invalid property name=" + propName);
                }
                String cap = BaseOptionsBeanInfo.capitalize(propName);
                Method m = this.findMethod("get" + cap);
                if (m != null) {
                    try {
                        pd.setReadMethod(m);
                    }
                    catch (IntrospectionException e2) {
                        // empty catch block
                    }
                }
                if ((m = this.findMethod("set" + cap)) == null) break block9;
                try {
                    pd.setWriteMethod(m);
                }
                catch (IntrospectionException e2) {
                    // empty catch block
                }
            }
        }
        return pd;
    }

    private Method findMethod(String name) {
        try {
            Method[] ma = this.getBeanClass().getDeclaredMethods();
            for (int i = 0; i < ma.length; ++i) {
                if (!name.equals(ma[i].getName())) continue;
                return ma[i];
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    private static String capitalize(String s) {
        if (s.length() == 0) {
            return s;
        }
        char[] chars = s.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    protected void updatePropertyDescriptors() {
        String[] stringArray;
        this.setPropertyEditor("abbrevMap", AbbrevsEditor.class, false);
        this.setPropertyEditor("caretTypeInsertMode", CaretTypeEditor.class);
        this.setPropertyEditor("caretTypeOverwriteMode", CaretTypeEditor.class);
        this.setPropertyEditor("keyBindingList", KeyBindingsEditor.class, false);
        this.setPropertyEditor("coloringMap", ColoringArrayEditor.class, false);
        this.setPropertyEditor("scrollJumpInsets", ScrollInsetsEditor.class);
        this.setPropertyEditor("scrollFindInsets", ScrollInsetsEditor.class);
        this.setPropertyEditor("macroMap", MacrosEditor.class, false);
        this.setExpert(EXPERT_PROP_NAMES);
        boolean usesNewOptions = this.usesNewOptions();
        if (usesNewOptions) {
            String[] stringArray2 = new String[26];
            stringArray2[0] = "abbrevMap";
            stringArray2[1] = "caretBlinkRate";
            stringArray2[2] = "caretColorInsertMode";
            stringArray2[3] = "caretColorOverwriteMode";
            stringArray2[4] = "caretItalicInsertMode";
            stringArray2[5] = "caretItalicOverwriteMode";
            stringArray2[6] = "caretTypeInsertMode";
            stringArray2[7] = "caretTypeOverwriteMode";
            stringArray2[8] = "codeFoldingProps";
            stringArray2[9] = "coloringMap";
            stringArray2[10] = "expandTabs";
            stringArray2[11] = "fontSize";
            stringArray2[12] = "highlightCaretRow";
            stringArray2[13] = "highlightMatchingBracket";
            stringArray2[14] = "keyBindingList";
            stringArray2[15] = "macroMap";
            stringArray2[16] = "margin";
            stringArray2[17] = "optionsVersion";
            stringArray2[18] = "pairCharactersCompletion";
            stringArray2[19] = "scrollFindInsets";
            stringArray2[20] = "scrollJumpInsets";
            stringArray2[21] = "spacesPerTab";
            stringArray2[22] = "tabSize";
            stringArray2[23] = "textLimitLineColor";
            stringArray2[24] = "textLimitLineVisible";
            stringArray = stringArray2;
            stringArray2[25] = "textLimitWidth";
        } else {
            String[] stringArray3 = new String[10];
            stringArray3[0] = "caretItalicInsertMode";
            stringArray3[1] = "caretItalicOverwriteMode";
            stringArray3[2] = "expandTabs";
            stringArray3[3] = "highlightCaretRow";
            stringArray3[4] = "highlightMatchingBracket";
            stringArray3[5] = "margin";
            stringArray3[6] = "optionsVersion";
            stringArray3[7] = "scrollFindInsets";
            stringArray3[8] = "scrollJumpInsets";
            stringArray = stringArray3;
            stringArray3[9] = "spacesPerTab";
        }
        String[] hidden = stringArray;
        this.setHidden(hidden);
    }

    protected boolean usesNewOptions() {
        Collection infos = Lookup.getDefault().lookupAll(ModuleInfo.class);
        for (ModuleInfo mi : infos) {
            if (!mi.getCodeNameBase().startsWith("org.netbeans.modules.options.editor") || !mi.isEnabled()) continue;
            return true;
        }
        return false;
    }

    protected Class getBeanClass() {
        return BaseOptions.class;
    }

    protected String[] getPropNames() {
        return BaseOptions.BASE_PROP_NAMES;
    }

    protected synchronized PropertyDescriptor getPD(String propName) {
        if (this.names2PD == null) {
            this.names2PD = new HashMap(37);
            PropertyDescriptor[] pds = this.getPropertyDescriptors();
            for (int i = pds.length - 1; i >= 0; --i) {
                this.names2PD.put(pds[i].getName(), pds[i]);
            }
        }
        return (PropertyDescriptor)this.names2PD.get(propName);
    }

    protected void setPropertyEditor(String propName, Class propEditor, boolean canEditAsText) {
        PropertyDescriptor pd = this.getPD(propName);
        if (pd != null) {
            pd.setPropertyEditorClass(propEditor);
            pd.setValue("canEditAsText", canEditAsText ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    protected void setPropertyEditor(String propName, Class propEditor) {
        this.setPropertyEditor(propName, propEditor, true);
    }

    protected void setExpert(String[] propNames) {
        for (int i = 0; i < propNames.length; ++i) {
            PropertyDescriptor pd = this.getPD(propNames[i]);
            if (pd == null) continue;
            pd.setExpert(true);
        }
    }

    protected void setHidden(String[] propNames) {
        for (int i = 0; i < propNames.length; ++i) {
            PropertyDescriptor pd = this.getPD(propNames[i]);
            if (pd == null) continue;
            pd.setHidden(true);
        }
    }

    @Override
    public Image getIcon(int type) {
        if (type == 1 || type == 3) {
            if (this.icon == null) {
                this.icon = this.loadImage(this.iconPrefix + ".gif");
            }
            return this.icon;
        }
        if (this.icon32 == null) {
            this.icon32 = this.loadImage(this.iconPrefix + "32.gif");
        }
        return this.icon32;
    }

    protected String getString(String key) {
        return NbBundle.getMessage(BaseOptionsBeanInfo.class, (String)key);
    }

    public static class CaretTypeEditor
    extends PropertyEditorSupport {
        private static String[] tags = new String[]{"line-caret", "thin-line-caret", "block-caret"};
        private static String[] locTags = new String[]{CaretTypeEditor.getString("LINE_CARET"), CaretTypeEditor.getString("THIN_LINE_CARET"), CaretTypeEditor.getString("BLOCK_CARET")};

        @Override
        public String[] getTags() {
            return locTags;
        }

        @Override
        public void setAsText(String txt) {
            for (int i = 0; i < locTags.length; ++i) {
                if (!locTags[i].equals(txt)) continue;
                this.setValue(tags[i]);
                break;
            }
        }

        @Override
        public String getAsText() {
            String val = (String)this.getValue();
            for (int i = 0; i < tags.length; ++i) {
                if (!tags[i].equals(val)) continue;
                return locTags[i];
            }
            throw new IllegalStateException();
        }

        static String getString(String s) {
            return NbBundle.getMessage(BaseOptionsBeanInfo.class, (String)s);
        }
    }
}

