/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.actions;

import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.modules.websvc.core.actions.InvokeOperationAction;
import org.netbeans.modules.websvc.project.api.WebServiceData;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public class WebServiceClientActionGroup
extends NodeAction
implements Presenter.Popup {
    public String getName() {
        return NbBundle.getMessage(WebServiceClientActionGroup.class, (String)"LBL_WebServiceClientActionGroup");
    }

    private static final SystemAction[] grouped() {
        return new SystemAction[]{SystemAction.get(InvokeOperationAction.class)};
    }

    public JMenuItem getPopupPresenter() {
        Node[] nodeArray = this.getActivatedNodes();
        if (nodeArray.length == 1 && this.hasWebServiceClient()) {
            return new LazyMenu();
        }
        JMenuItem jMenuItem = super.getPopupPresenter();
        jMenuItem.setVisible(false);
        return jMenuItem;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean enable(Node[] nodeArray) {
        return true;
    }

    protected void performAction(Node[] nodeArray) {
        assert (false) : "Should never be called: ";
    }

    private boolean hasWebServiceClient() {
        Node[] nodeArray = this.getActivatedNodes();
        DataObject dataObject = (DataObject)nodeArray[0].getLookup().lookup(DataObject.class);
        if (dataObject != null) {
            Project project = FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile());
            if (project != null && WebServiceData.getWebServiceData((Project)project) != null) {
                return true;
            }
            WebServicesClientSupport webServicesClientSupport = WebServicesClientSupport.getWebServicesClientSupport((FileObject)dataObject.getPrimaryFile());
            if (webServicesClientSupport != null) {
                return true;
            }
        }
        return false;
    }

    public Action createContextAwareInstance(Lookup lookup) {
        boolean bl = this.enable(lookup.lookup(new Lookup.Template(Node.class)).allInstances().toArray(new Node[0]));
        return bl ? this : null;
    }

    private final class LazyMenu
    extends JMenu {
        public LazyMenu() {
            super(WebServiceClientActionGroup.this.getName());
        }

        @Override
        public JPopupMenu getPopupMenu() {
            if (this.getItemCount() == 0) {
                SystemAction[] systemActionArray = WebServiceClientActionGroup.grouped();
                for (int i = 0; i < systemActionArray.length; ++i) {
                    SystemAction systemAction = systemActionArray[i];
                    if (systemAction == null) {
                        this.addSeparator();
                        continue;
                    }
                    if (systemAction instanceof Presenter.Popup) {
                        this.add(((Presenter.Popup)systemAction).getPopupPresenter());
                        continue;
                    }
                    assert (false) : "Action had no popup presenter: " + systemAction;
                }
            }
            return super.getPopupMenu();
        }
    }
}

