/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rhtml;

import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.editor.indent.spi.ExtraLock;
import org.netbeans.modules.editor.indent.spi.IndentTask;
import org.netbeans.modules.ruby.RubyFormatter;
import org.netbeans.modules.ruby.rhtml.lexer.api.RhtmlTokenId;

public class RhtmlIndentTask
implements IndentTask {
    private Context context;

    RhtmlIndentTask(Context context) {
        this.context = context;
    }

    public void reindent() throws BadLocationException {
        int rowEnd;
        BaseDocument doc = (BaseDocument)this.context.document();
        int start = this.context.startOffset();
        int end = Math.min(this.context.endOffset(), doc.getLength());
        doc.putProperty((Object)"HTML_FORMATTER_ACTS_ON_TOP_LEVEL", (Object)Boolean.TRUE);
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        TokenSequence ts = th.tokenSequence(RhtmlTokenId.language());
        if (ts == null) {
            return;
        }
        int offset = Utilities.getRowStart((BaseDocument)doc, (int)end);
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        boolean prevWasNonHtml = false;
        while (offset >= start) {
            int lineStart = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset);
            if (lineStart != -1) {
                TokenId id;
                prevWasNonHtml = false;
                ts.move(lineStart);
                if (ts.moveNext() && (id = ts.token().id()) != RhtmlTokenId.HTML) {
                    prevWasNonHtml = true;
                    offsets.add(offset);
                }
            } else if (prevWasNonHtml) {
                offsets.add(offset);
            }
            if (offset <= 0) break;
            --offset;
            offset = Utilities.getRowStart((BaseDocument)doc, (int)offset);
        }
        if (offsets.size() > 0) {
            for (Integer lineOffset : offsets) {
                assert (lineOffset == Utilities.getRowStart((BaseDocument)doc, (int)lineOffset));
                this.context.modifyIndent(lineOffset.intValue(), 0);
            }
        }
        if (this.context.isIndent() && start > 0 && (rowEnd = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)(start - 1))) != -1) {
            String s = doc.getText(start, end - start);
            if (s.indexOf(10) != -1) {
                return;
            }
            int delta = ts.move(rowEnd + 1);
            if (delta > 0 ? !ts.moveNext() : !ts.movePrevious()) {
                return;
            }
            Token token = ts.token();
            if (token.id() == RhtmlTokenId.DELIMITER) {
                int rowStart = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)rowEnd);
                int balance = RubyFormatter.getTokenBalance((BaseDocument)doc, (int)rowStart, (int)(rowEnd + 1), (boolean)true, (boolean)true);
                int indent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)(start - 1));
                if (balance > 0) {
                    indent += IndentUtils.indentLevelSize((Document)doc);
                }
                this.context.modifyIndent(Utilities.getRowStart((BaseDocument)doc, (int)start), indent);
            }
        }
    }

    public ExtraLock indentLock() {
        return null;
    }
}

