/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.modules.versioning.util.Utils;

public class KeyringSupport {
    private static final Logger LOG = Logger.getLogger("versioning.util.KeyringSupport");

    public static void save(String keyPrefix, String key, char[] password, String description) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Saving password for {0}:{1}", new String[]{keyPrefix, key});
        }
        Keyring.save((String)KeyringSupport.getKeyringKey(keyPrefix, key), (char[])password, (String)description);
    }

    public static char[] read(String keyPrefix, String key) {
        char[] retval = Keyring.read((String)KeyringSupport.getKeyringKey(keyPrefix, key));
        if (LOG.isLoggable(Level.FINE) && retval == null) {
            LOG.log(Level.FINE, "No password for {0}:{1}", new String[]{keyPrefix, key});
        }
        return retval;
    }

    private static String getKeyringKey(String keyPrefix, String keyToHash) {
        String keyPart = "";
        if (keyToHash != null) {
            try {
                keyPart = Utils.getHash("SHA-1", keyToHash.getBytes());
            }
            catch (NoSuchAlgorithmException ex) {
                Logger.getLogger(KeyringSupport.class.getName()).log(Level.INFO, null, ex);
                keyPart = keyToHash;
            }
        }
        return keyPrefix + keyPart;
    }
}

