/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.Method;
import org.netbeans.modules.form.palette.AddToPaletteWizard;
import org.netbeans.modules.form.palette.CategorySelector;
import org.netbeans.modules.form.palette.PaletteItemDataObject;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.netbeans.modules.form.project.ClassSource;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public final class BeanInstaller {
    private static Reference<AddToPaletteWizard> wizardRef;

    private BeanInstaller() {
    }

    public static void installBeans(Class<? extends ClassSource.Entry> clazz) {
        AddToPaletteWizard addToPaletteWizard = BeanInstaller.getAddWizard();
        if (addToPaletteWizard.show(clazz)) {
            BeanInstaller.createPaletteItems(addToPaletteWizard.getSelectedBeans(), addToPaletteWizard.getSelectedCategory());
        }
    }

    public static void installBeans(Node[] nodeArray) {
        String string;
        Object object;
        Object object2;
        Object object3;
        final LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        LinkedList linkedList3 = new LinkedList();
        for (int i = 0; i < nodeArray.length; ++i) {
            object3 = (DataObject)nodeArray[i].getCookie(DataObject.class);
            if (object3 == null) continue;
            object2 = object3.getPrimaryFile();
            object = new JavaClassHandler((FileObject)object2, linkedList2, linkedList, linkedList3){
                final /* synthetic */ FileObject val$fo;
                final /* synthetic */ List val$unableToInstall;
                final /* synthetic */ List val$beans;
                final /* synthetic */ List val$noBeans;
                {
                    this.val$fo = fileObject;
                    this.val$unableToInstall = list;
                    this.val$beans = list2;
                    this.val$noBeans = list3;
                }

                @Override
                public void handle(String string, String string2) {
                    if (string2 == null) {
                        ClassSource classSource = ClassPathUtils.getProjectClassSource(this.val$fo, string);
                        if (classSource == null) {
                            this.val$unableToInstall.add(string);
                        } else {
                            this.val$beans.add(classSource);
                        }
                    } else {
                        this.val$noBeans.add(string);
                        this.val$noBeans.add(string2);
                    }
                }
            };
            BeanInstaller.scanFileObject(object2.getParent(), object2, (JavaClassHandler)object);
        }
        if (linkedList2.size() > 0) {
            Iterator iterator = linkedList2.iterator();
            object3 = new StringBuilder();
            while (iterator.hasNext()) {
                ((StringBuilder)object3).append(iterator.next()).append(", ");
            }
            ((StringBuilder)object3).delete(((StringBuilder)object3).length() - 2, ((StringBuilder)object3).length());
            object2 = PaletteUtils.getBundleString("MSG_cannotInstallBeans");
            object = MessageFormat.format((String)object2, ((StringBuilder)object3).toString());
            string = new NotifyDescriptor.Message(object);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)string);
            if (linkedList.isEmpty()) {
                return;
            }
        }
        String string2 = null;
        if (linkedList.isEmpty()) {
            string2 = PaletteUtils.getBundleString("MSG_noBeansUnderNodes");
        }
        if (!linkedList3.isEmpty()) {
            object3 = linkedList3.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                object = (String)object3.next();
                string = MessageFormat.format((String)object, object2);
                string2 = string2 != null ? string2 + '\n' : "";
                string2 = string2 + string;
            }
        }
        if (string2 != null) {
            object3 = new NotifyDescriptor.Message((Object)string2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)object3);
        }
        if (linkedList.isEmpty()) {
            return;
        }
        object3 = CategorySelector.selectCategory();
        if (object3 == null) {
            return;
        }
        object2 = PaletteUtils.getPaletteFolder().getFileObject((String)object3);
        try {
            FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction((FileObject)object2){
                final /* synthetic */ FileObject val$categoryFolder;
                {
                    this.val$categoryFolder = fileObject;
                }

                public void run() {
                    for (ClassSource classSource : linkedList) {
                        try {
                            PaletteItemDataObject.createFile(this.val$categoryFolder, classSource);
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify(1, (Throwable)iOException);
                        }
                    }
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<ItemInfo> findJavaBeansInJar(List<? extends ClassSource.Entry> list) {
        HashMap<String, ItemInfo> hashMap = null;
        for (ClassSource.Entry entry : list) {
            for (URL uRL : entry.getClasspath()) {
                Manifest manifest;
                File file;
                FileObject fileObject;
                URL uRL2 = FileUtil.getArchiveFile((URL)uRL);
                if (uRL2 == null || (fileObject = URLMapper.findFileObject((URL)uRL2)) == null || (file = FileUtil.toFile((FileObject)fileObject)) == null) continue;
                try {
                    JarFile jarFile = new JarFile(file);
                    try {
                        manifest = jarFile.getManifest();
                    }
                    finally {
                        jarFile.close();
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                    continue;
                }
                if (manifest == null) continue;
                for (Map.Entry entry2 : manifest.getEntries().entrySet()) {
                    String string;
                    if (!((String)entry2.getKey()).endsWith(".class") || !"True".equalsIgnoreCase(string = ((Attributes)entry2.getValue()).getValue("Java-Bean"))) continue;
                    String string2 = ((String)entry2.getKey()).substring(0, ((String)entry2.getKey()).length() - 6).replace('\\', '/').replace('/', '.');
                    if (string2.startsWith(".")) {
                        string2 = string2.substring(1);
                    }
                    ItemInfo itemInfo = new ItemInfo();
                    itemInfo.classname = string2;
                    itemInfo.entry = entry;
                    if (hashMap == null) {
                        hashMap = new HashMap<String, ItemInfo>(100);
                    }
                    hashMap.put(itemInfo.classname, itemInfo);
                }
            }
        }
        return hashMap != null ? new ArrayList(hashMap.values()) : null;
    }

    static List<ItemInfo> findJavaBeans(List<? extends ClassSource.Entry> list) {
        HashMap<String, ItemInfo> hashMap = new HashMap<String, ItemInfo>(100);
        for (ClassSource.Entry entry : list) {
            for (URL uRL : entry.getClasspath()) {
                FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                if (fileObject == null) continue;
                BeanInstaller.scanFolderForBeans(fileObject, hashMap, entry);
            }
        }
        return new ArrayList<ItemInfo>(hashMap.values());
    }

    private static void createPaletteItems(final ItemInfo[] itemInfoArray, String string) {
        if (itemInfoArray.length == 0) {
            return;
        }
        final FileObject fileObject = PaletteUtils.getPaletteFolder().getFileObject(string);
        if (fileObject == null) {
            return;
        }
        try {
            FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

                public void run() {
                    for (int i = 0; i < itemInfoArray.length; ++i) {
                        try {
                            PaletteItemDataObject.createFile(fileObject, new ClassSource(itemInfoArray[i].classname, itemInfoArray[i].entry));
                            continue;
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify(1, (Throwable)iOException);
                        }
                    }
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void scanFolderForBeans(FileObject fileObject, final Map<String, ItemInfo> map, final ClassSource.Entry entry) {
        JavaClassHandler javaClassHandler = new JavaClassHandler(){

            @Override
            public void handle(String string, String string2) {
                if (string2 == null) {
                    ItemInfo itemInfo = new ItemInfo();
                    itemInfo.classname = string;
                    itemInfo.entry = entry;
                    map.put(itemInfo.classname, itemInfo);
                }
            }
        };
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject fileObject2 = fileObjectArray[i];
            if (fileObject2.isFolder()) {
                BeanInstaller.scanFolderForBeans(fileObject2, map, entry);
                continue;
            }
            try {
                if (!"class".equals(fileObject2.getExt()) || DataObject.find((FileObject)fileObject2) == null) continue;
                BeanInstaller.scanFileObject(fileObject, fileObject2, javaClassHandler);
                continue;
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    private static void scanFileObject(FileObject fileObject, FileObject fileObject2, JavaClassHandler javaClassHandler) {
        if ("class".equals(fileObject2.getExt())) {
            BeanInstaller.processClassFile(fileObject2, javaClassHandler);
        } else if ("java".equals(fileObject2.getExt())) {
            BeanInstaller.processJavaFile(fileObject2, javaClassHandler);
        }
    }

    public static String findJavaBeanName(FileObject fileObject) {
        final String[] stringArray = new String[1];
        BeanInstaller.scanFileObject(null, fileObject, new JavaClassHandler(){

            @Override
            public void handle(String string, String string2) {
                if (string2 == null) {
                    stringArray[0] = string;
                }
            }
        });
        return stringArray[0];
    }

    private static void processJavaFile(final FileObject fileObject, final JavaClassHandler javaClassHandler) {
        try {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = BeanInstaller.findClass(compilationController, fileObject.getName());
                    if (typeElement != null) {
                        javaClassHandler.handle(typeElement.getQualifiedName().toString(), BeanInstaller.isDeclaredAsJavaBean(typeElement));
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            Logger.getLogger(BeanInstaller.class.getClass().getName()).log(Level.SEVERE, fileObject.toString(), iOException);
        }
    }

    private static TypeElement findClass(CompilationController compilationController, String string) {
        for (Tree tree : compilationController.getCompilationUnit().getTypeDecls()) {
            if (!string.equals(((ClassTree)tree).getSimpleName().toString())) continue;
            TreePath treePath = compilationController.getTrees().getPath(compilationController.getCompilationUnit(), tree);
            TypeElement typeElement = (TypeElement)compilationController.getTrees().getElement(treePath);
            return typeElement;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processClassFile(FileObject fileObject, JavaClassHandler javaClassHandler) {
        try {
            ClassFile classFile;
            InputStream inputStream = null;
            try {
                inputStream = fileObject.getInputStream();
                classFile = new ClassFile(inputStream, false);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            if (classFile != null) {
                javaClassHandler.handle(classFile.getName().getExternalName(), BeanInstaller.isDeclaredAsJavaBean(classFile));
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(BeanInstaller.class.getClass().getName()).log(Level.SEVERE, fileObject.toString(), iOException);
        }
    }

    public static String isDeclaredAsJavaBean(TypeElement typeElement) {
        if (ElementKind.CLASS != typeElement.getKind()) {
            return PaletteUtils.getBundleString("MSG_notAClass");
        }
        Set<javax.lang.model.element.Modifier> set = typeElement.getModifiers();
        if (set.contains((Object)javax.lang.model.element.Modifier.ABSTRACT)) {
            return PaletteUtils.getBundleString("MSG_abstractClass");
        }
        if (!set.contains((Object)javax.lang.model.element.Modifier.PUBLIC)) {
            return PaletteUtils.getBundleString("MSG_notPublic");
        }
        for (Element element : typeElement.getEnclosedElements()) {
            set = element.getModifiers();
            if (ElementKind.CONSTRUCTOR != element.getKind() || !set.contains((Object)javax.lang.model.element.Modifier.PUBLIC) || !((ExecutableElement)element).getParameters().isEmpty()) continue;
            return null;
        }
        return PaletteUtils.getBundleString("MSG_noPublicConstructor");
    }

    public static String isDeclaredAsJavaBean(ClassFile classFile) {
        int n = classFile.getAccess();
        if (Modifier.isInterface(n) || classFile.isAnnotation() || classFile.isEnum() || classFile.isSynthetic()) {
            return PaletteUtils.getBundleString("MSG_notAClass");
        }
        if (Modifier.isAbstract(n)) {
            return PaletteUtils.getBundleString("MSG_abstractClass");
        }
        if (!Modifier.isPublic(n)) {
            return PaletteUtils.getBundleString("MSG_notPublic");
        }
        for (Method method : classFile.getMethods()) {
            Method method2 = method;
            if (!method2.isPublic() || !method2.getParameters().isEmpty() || !"<init>".equals(method2.getName())) continue;
            return null;
        }
        return PaletteUtils.getBundleString("MSG_noPublicConstructor");
    }

    private static AddToPaletteWizard getAddWizard() {
        AddToPaletteWizard addToPaletteWizard = null;
        if (wizardRef != null) {
            addToPaletteWizard = wizardRef.get();
        }
        if (addToPaletteWizard == null) {
            addToPaletteWizard = new AddToPaletteWizard();
            wizardRef = new WeakReference<AddToPaletteWizard>(addToPaletteWizard);
        }
        return addToPaletteWizard;
    }

    private static interface JavaClassHandler {
        public void handle(String var1, String var2);
    }

    static class ItemInfo
    implements Comparable<ItemInfo> {
        String classname;
        ClassSource.Entry entry;

        ItemInfo() {
        }

        @Override
        public int compareTo(ItemInfo itemInfo) {
            int n = this.classname.lastIndexOf(46);
            String string = n >= 0 ? this.classname.substring(n + 1) : this.classname;
            n = itemInfo.classname.lastIndexOf(46);
            String string2 = n >= 0 ? itemInfo.classname.substring(n + 1) : itemInfo.classname;
            return string.compareTo(string2);
        }
    }
}

