/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.BindingProperty;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormEvents;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormRootNode;
import org.netbeans.modules.form.MetaBinding;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutSupportDelegate;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.openide.ErrorManager;
import org.openide.nodes.Node;

public class FormModelEvent
extends EventObject {
    public static final int FORM_LOADED = 1;
    public static final int FORM_TO_BE_SAVED = 2;
    public static final int FORM_TO_BE_CLOSED = 3;
    public static final int CONTAINER_LAYOUT_EXCHANGED = 4;
    public static final int CONTAINER_LAYOUT_CHANGED = 5;
    public static final int COMPONENT_LAYOUT_CHANGED = 6;
    public static final int COMPONENT_ADDED = 7;
    public static final int COMPONENT_REMOVED = 8;
    public static final int COMPONENTS_REORDERED = 9;
    public static final int COMPONENT_PROPERTY_CHANGED = 10;
    public static final int BINDING_PROPERTY_CHANGED = 16;
    public static final int SYNTHETIC_PROPERTY_CHANGED = 11;
    public static final int EVENT_HANDLER_ADDED = 12;
    public static final int EVENT_HANDLER_REMOVED = 13;
    public static final int EVENT_HANDLER_RENAMED = 14;
    public static final int OTHER_CHANGE = 15;
    private int changeType;
    private boolean createdDeleted;
    private RADComponent component;
    private ComponentContainer container;
    private LayoutConstraints constraints;
    private int componentIndex = -1;
    private int[] reordering;
    private String propertyName;
    private String subPropertyName;
    private Object oldPropertyValue;
    private Object newPropertyValue;
    private Event componentEvent;
    private UndoableEdit undoableEdit;
    private FormModelEvent additionalEvent;
    private static List<FormModelEvent> interestList;

    FormModelEvent(FormModel formModel, int n) {
        super(formModel);
        this.changeType = n;
        FormModelEvent.informInterestedEvents(this);
    }

    void setProperty(String string, Object object, Object object2) {
        this.propertyName = string;
        this.oldPropertyValue = object;
        this.newPropertyValue = object2;
    }

    void setSubProperty(String string) {
        this.subPropertyName = string;
    }

    void setComponentAndContainer(RADComponent rADComponent, ComponentContainer componentContainer) {
        this.component = rADComponent;
        this.container = componentContainer != null ? componentContainer : FormModelEvent.deriveContainer(rADComponent);
    }

    void setLayout(RADVisualContainer rADVisualContainer, LayoutSupportDelegate layoutSupportDelegate, LayoutSupportDelegate layoutSupportDelegate2) {
        this.component = rADVisualContainer;
        this.container = rADVisualContainer;
        this.oldPropertyValue = layoutSupportDelegate;
        this.newPropertyValue = layoutSupportDelegate2;
    }

    void setReordering(int[] nArray) {
        this.reordering = nArray;
    }

    void setAddData(RADComponent rADComponent, ComponentContainer componentContainer, boolean bl) {
        this.setComponentAndContainer(rADComponent, componentContainer);
        this.createdDeleted = bl;
        if (this.component instanceof RADVisualComponent && this.container instanceof RADVisualContainer) {
            LayoutSupportManager layoutSupportManager;
            this.componentIndex = this.container.getIndexOf(this.component);
            if (this.componentIndex >= 0 && (layoutSupportManager = ((RADVisualContainer)this.container).getLayoutSupport()) != null) {
                this.constraints = layoutSupportManager.getConstraints(this.componentIndex);
            }
        }
    }

    void setRemoveData(RADComponent rADComponent, ComponentContainer componentContainer, int n, boolean bl) {
        this.component = rADComponent;
        this.container = componentContainer;
        this.componentIndex = n;
        this.createdDeleted = bl;
        if (rADComponent instanceof RADVisualComponent && componentContainer instanceof RADVisualContainer) {
            LayoutSupportManager layoutSupportManager = ((RADVisualContainer)componentContainer).getLayoutSupport();
            this.constraints = layoutSupportManager == null ? null : layoutSupportManager.getStoredConstraints((RADVisualComponent)rADComponent);
        }
    }

    void setEvent(Event event, String string, String string2, String string3, boolean bl) {
        if (event != null) {
            this.component = event.getComponent();
        }
        this.componentEvent = event;
        this.propertyName = string;
        this.newPropertyValue = string2;
        this.oldPropertyValue = string3;
        this.createdDeleted = bl;
    }

    void setEvent(String string, String string2) {
        this.oldPropertyValue = string;
        this.propertyName = string2;
        this.newPropertyValue = string2;
    }

    void setChangeType(int n) {
        this.changeType = n;
    }

    private static ComponentContainer deriveContainer(RADComponent rADComponent) {
        if (rADComponent == null) {
            return null;
        }
        if (rADComponent.getParentComponent() instanceof ComponentContainer) {
            return (ComponentContainer)((Object)rADComponent.getParentComponent());
        }
        if (rADComponent.getParentComponent() == null) {
            return rADComponent.getFormModel().getModelContainer();
        }
        return null;
    }

    public final FormModel getFormModel() {
        return (FormModel)this.getSource();
    }

    public final int getChangeType() {
        return this.changeType;
    }

    public final boolean isModifying() {
        return this.changeType != 1 && this.changeType != 2 && this.changeType != 3 && (this.changeType != 12 || this.componentEvent != null);
    }

    public final boolean getCreatedDeleted() {
        return this.createdDeleted;
    }

    public final ComponentContainer getContainer() {
        return this.container;
    }

    public final RADComponent getComponent() {
        return this.component;
    }

    public final LayoutConstraints getComponentLayoutConstraints() {
        return this.constraints;
    }

    public final int getComponentIndex() {
        return this.componentIndex;
    }

    public final String getPropertyName() {
        return this.propertyName;
    }

    public final String getSubPropertyName() {
        return this.subPropertyName;
    }

    public final RADProperty getComponentProperty() {
        return this.component != null && this.propertyName != null ? this.component.getBeanProperty(this.propertyName) : null;
    }

    public final Object getOldPropertyValue() {
        return this.oldPropertyValue;
    }

    public final Object getNewPropertyValue() {
        return this.newPropertyValue;
    }

    public final MetaBinding getOldBinding() {
        return (MetaBinding)this.oldPropertyValue;
    }

    public final MetaBinding getNewBinding() {
        return (MetaBinding)this.newPropertyValue;
    }

    public final LayoutSupportDelegate getOldLayoutSupport() {
        return (LayoutSupportDelegate)this.oldPropertyValue;
    }

    public final LayoutSupportDelegate getNewLayoutSupport() {
        return (LayoutSupportDelegate)this.newPropertyValue;
    }

    public final int[] getReordering() {
        return this.reordering;
    }

    public final Event getComponentEvent() {
        return this.componentEvent;
    }

    public final String getEventHandler() {
        return this.propertyName;
    }

    public final String getOldEventHandler() {
        return (String)this.oldPropertyValue;
    }

    public final String getNewEventHandler() {
        return (String)this.newPropertyValue;
    }

    public final String getNewEventHandlerContent() {
        return this.changeType == 12 || this.changeType == 13 ? (String)this.newPropertyValue : null;
    }

    public final String getNewEventHandlerAnnotation() {
        return this.changeType == 12 || this.changeType == 13 ? (String)this.oldPropertyValue : null;
    }

    public final String getOldEventHandlerContent() {
        if (this.changeType == 12 || this.changeType == 13) {
            if (this.additionalEvent != null) {
                if (this.additionalEvent.changeType == 13 || this.additionalEvent.changeType == 12) {
                    this.oldPropertyValue = this.additionalEvent.oldPropertyValue;
                }
                this.additionalEvent = null;
            }
            return (String)this.oldPropertyValue;
        }
        return null;
    }

    public final void setOldEventHandlerContent(String string) {
        if (this.changeType == 12 || this.changeType == 13) {
            this.oldPropertyValue = string;
        }
    }

    public final String getOldEventHandlerAnnotation() {
        if (this.changeType == 12 || this.changeType == 13) {
            if (this.additionalEvent != null) {
                if (this.additionalEvent.changeType == 13 || this.additionalEvent.changeType == 12) {
                    this.newPropertyValue = this.additionalEvent.newPropertyValue;
                }
                this.additionalEvent = null;
            }
            return (String)this.newPropertyValue;
        }
        return null;
    }

    public final void setOldEventHandlerAnnotation(String string) {
        if (this.changeType == 12 || this.changeType == 13) {
            this.newPropertyValue = string;
        }
    }

    UndoableEdit getUndoableEdit() {
        if (this.undoableEdit == null) {
            this.undoableEdit = new FormUndoableEdit();
        }
        return this.undoableEdit;
    }

    private static void addToInterestList(FormModelEvent formModelEvent) {
        if (interestList == null) {
            interestList = new ArrayList<FormModelEvent>();
        } else {
            interestList.remove(formModelEvent);
        }
        interestList.add(formModelEvent);
    }

    private static void removeFromInterestList(FormModelEvent formModelEvent) {
        if (interestList != null) {
            interestList.remove(formModelEvent);
        }
    }

    private static void informInterestedEvents(FormModelEvent formModelEvent) {
        if (interestList != null) {
            Iterator<FormModelEvent> iterator = interestList.iterator();
            while (iterator.hasNext()) {
                iterator.next().newEventCreated(formModelEvent);
            }
        }
    }

    private void newEventCreated(FormModelEvent formModelEvent) {
        this.additionalEvent = formModelEvent;
    }

    private class FormUndoableEdit
    extends AbstractUndoableEdit {
        private FormUndoableEdit() {
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            boolean bl = FormModelEvent.this.getFormModel().isUndoRedoRecording();
            if (bl) {
                FormModelEvent.this.getFormModel().setUndoRedoRecording(false);
            }
            switch (FormModelEvent.this.changeType) {
                case 4: {
                    FormModel.t("UNDO: container layout change");
                    this.undoContainerLayoutExchange();
                    break;
                }
                case 5: {
                    FormModel.t("UNDO: container layout property change");
                    this.undoContainerLayoutChange();
                    break;
                }
                case 6: {
                    FormModel.t("UNDO: component layout constraints change");
                    this.undoComponentLayoutChange();
                    break;
                }
                case 9: {
                    FormModel.t("UNDO: components reorder");
                    this.undoComponentsReorder();
                    break;
                }
                case 7: {
                    FormModel.t("UNDO: component addition");
                    this.undoComponentAddition();
                    break;
                }
                case 8: {
                    FormModel.t("UNDO: component removal");
                    this.undoComponentRemoval();
                    break;
                }
                case 10: {
                    FormModel.t("UNDO: component property change");
                    this.undoComponentPropertyChange();
                    break;
                }
                case 11: {
                    FormModel.t("UNDO: synthetic property change");
                    this.undoSyntheticPropertyChange();
                    break;
                }
                case 12: {
                    FormModel.t("UNDO: event handler addition");
                    this.undoEventHandlerAddition();
                    break;
                }
                case 13: {
                    FormModel.t("UNDO: event handler removal");
                    this.undoEventHandlerRemoval();
                    break;
                }
                case 14: {
                    FormModel.t("UNDO: event handler renaming");
                    this.undoEventHandlerRenaming();
                    break;
                }
                case 16: {
                    FormModel.t("UNDO: binding property change");
                    this.undoBindingPropertyChange();
                    break;
                }
                default: {
                    FormModel.t("UNDO: " + FormModelEvent.this.changeType);
                }
            }
            if (bl) {
                FormModelEvent.this.getFormModel().setUndoRedoRecording(true);
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            boolean bl = FormModelEvent.this.getFormModel().isUndoRedoRecording();
            if (bl) {
                FormModelEvent.this.getFormModel().setUndoRedoRecording(false);
            }
            switch (FormModelEvent.this.changeType) {
                case 4: {
                    FormModel.t("REDO: container layout change");
                    this.redoContainerLayoutExchange();
                    break;
                }
                case 5: {
                    FormModel.t("REDO: container layout property change");
                    this.redoContainerLayoutChange();
                    break;
                }
                case 6: {
                    FormModel.t("REDO: component layout constraints change");
                    this.redoComponentLayoutChange();
                    break;
                }
                case 9: {
                    FormModel.t("REDO: components reorder");
                    this.redoComponentsReorder();
                    break;
                }
                case 7: {
                    FormModel.t("REDO: component addition");
                    this.redoComponentAddition();
                    break;
                }
                case 8: {
                    FormModel.t("REDO: component removal");
                    this.redoComponentRemoval();
                    break;
                }
                case 10: {
                    FormModel.t("REDO: component property change");
                    this.redoComponentPropertyChange();
                    break;
                }
                case 11: {
                    FormModel.t("REDO: synthetic property change");
                    this.redoSyntheticPropertyChange();
                    break;
                }
                case 12: {
                    FormModel.t("REDO: event handler addition");
                    this.redoEventHandlerAddition();
                    break;
                }
                case 13: {
                    FormModel.t("REDO: event handler removal");
                    this.redoEventHandlerRemoval();
                    break;
                }
                case 14: {
                    FormModel.t("REDO: event handler renaming");
                    this.redoEventHandlerRenaming();
                    break;
                }
                case 16: {
                    FormModel.t("REDO: binding property change");
                    this.redoBindingPropertyChange();
                    break;
                }
                default: {
                    FormModel.t("REDO: " + FormModelEvent.this.changeType);
                }
            }
            if (bl) {
                FormModelEvent.this.getFormModel().setUndoRedoRecording(true);
            }
        }

        @Override
        public String getUndoPresentationName() {
            return "";
        }

        @Override
        public String getRedoPresentationName() {
            return "";
        }

        private void undoContainerLayoutExchange() {
            try {
                LayoutSupportDelegate layoutSupportDelegate = FormModelEvent.this.getOldLayoutSupport();
                if (layoutSupportDelegate != null) {
                    FormModelEvent.this.getFormModel().setContainerLayoutImpl((RADVisualContainer)FormModelEvent.this.getContainer(), layoutSupportDelegate);
                } else {
                    FormModelEvent.this.getFormModel().setNaturalContainerLayoutImpl((RADVisualContainer)FormModelEvent.this.getContainer());
                }
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }

        private void redoContainerLayoutExchange() {
            try {
                LayoutSupportDelegate layoutSupportDelegate = FormModelEvent.this.getNewLayoutSupport();
                if (layoutSupportDelegate != null) {
                    FormModelEvent.this.getFormModel().setContainerLayoutImpl((RADVisualContainer)FormModelEvent.this.getContainer(), layoutSupportDelegate);
                } else {
                    FormModelEvent.this.getFormModel().setNaturalContainerLayoutImpl((RADVisualContainer)FormModelEvent.this.getContainer());
                }
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }

        private void undoContainerLayoutChange() {
            RADVisualContainer rADVisualContainer = (RADVisualContainer)FormModelEvent.this.getComponent();
            LayoutSupportManager layoutSupportManager = rADVisualContainer.getLayoutSupport();
            if (layoutSupportManager != null) {
                Node.Property property;
                String string = FormModelEvent.this.getPropertyName();
                if (string != null && (property = layoutSupportManager.getLayoutProperty(string)) != null) {
                    try {
                        property.setValue(FormModelEvent.this.getOldPropertyValue());
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
                    }
                }
            } else {
                FormModelEvent.this.getFormModel().fireContainerLayoutChanged(rADVisualContainer, null, null, null);
            }
        }

        private void redoContainerLayoutChange() {
            RADVisualContainer rADVisualContainer = (RADVisualContainer)FormModelEvent.this.getComponent();
            LayoutSupportManager layoutSupportManager = rADVisualContainer.getLayoutSupport();
            if (layoutSupportManager != null) {
                Node.Property property;
                String string = FormModelEvent.this.getPropertyName();
                if (string != null && (property = layoutSupportManager.getLayoutProperty(string)) != null) {
                    try {
                        property.setValue(FormModelEvent.this.getNewPropertyValue());
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
                    }
                }
            } else {
                FormModelEvent.this.getFormModel().fireContainerLayoutChanged(rADVisualContainer, null, null, null);
            }
        }

        private void undoComponentLayoutChange() {
            if (FormModelEvent.this.getComponent() instanceof RADVisualComponent) {
                ((RADVisualComponent)FormModelEvent.this.getComponent()).getConstraintsProperties();
                Node.Property property = FormModelEvent.this.getComponent().getPropertyByName(FormModelEvent.this.getPropertyName());
                if (property != null) {
                    try {
                        property.setValue(FormModelEvent.this.getOldPropertyValue());
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
                    }
                }
            }
        }

        private void redoComponentLayoutChange() {
            if (FormModelEvent.this.getComponent() instanceof RADVisualComponent) {
                ((RADVisualComponent)FormModelEvent.this.getComponent()).getConstraintsProperties();
                Node.Property property = FormModelEvent.this.getComponent().getPropertyByName(FormModelEvent.this.getPropertyName());
                if (property != null) {
                    try {
                        property.setValue(FormModelEvent.this.getNewPropertyValue());
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
                    }
                }
            }
        }

        private void undoComponentAddition() {
            this.removeComponent();
        }

        private void undoComponentRemoval() {
            this.addComponent();
        }

        private void redoComponentAddition() {
            this.addComponent();
        }

        private void redoComponentRemoval() {
            this.removeComponent();
        }

        private void addComponent() {
            RADComponent rADComponent = FormModelEvent.this.getComponent();
            ComponentContainer componentContainer = FormModelEvent.this.getContainer();
            RADComponent[] rADComponentArray = componentContainer.getSubBeans();
            RADComponent[] rADComponentArray2 = new RADComponent[rADComponentArray.length + 1];
            if (FormModelEvent.this.componentIndex < 0) {
                FormModelEvent.this.componentIndex = rADComponentArray.length;
            }
            int n = 0;
            for (int i = 0; i < rADComponentArray2.length; ++i) {
                if (n == FormModelEvent.this.componentIndex) {
                    rADComponentArray2[i] = rADComponent;
                    if (n == rADComponentArray.length) break;
                    ++i;
                }
                rADComponentArray2[i] = rADComponentArray[n];
                ++n;
            }
            if (FormModelEvent.this.getCreatedDeleted() || !rADComponent.isInModel()) {
                FormModel.setInModelRecursively(rADComponent, true);
            }
            componentContainer.initSubComponents(rADComponentArray2);
            if (rADComponent instanceof RADVisualComponent) {
                if (componentContainer instanceof RADVisualContainer) {
                    LayoutSupportManager layoutSupportManager = ((RADVisualContainer)componentContainer).getLayoutSupport();
                    if (layoutSupportManager != null) {
                        layoutSupportManager.addComponents(new RADVisualComponent[]{(RADVisualComponent)rADComponent}, new LayoutConstraints[]{FormModelEvent.this.getComponentLayoutConstraints()}, FormModelEvent.this.componentIndex);
                    }
                } else {
                    ((RADVisualComponent)rADComponent).resetConstraintsProperties();
                }
            }
            FormModelEvent.this.getFormModel().fireComponentAdded(rADComponent, FormModelEvent.this.getCreatedDeleted());
        }

        private void removeComponent() {
            FormModelEvent.this.getFormModel().removeComponentImpl(FormModelEvent.this.getComponent(), FormModelEvent.this.getCreatedDeleted());
        }

        private void undoComponentsReorder() {
            if (FormModelEvent.this.getContainer() != null && FormModelEvent.this.reordering != null) {
                int[] nArray = new int[FormModelEvent.this.reordering.length];
                for (int i = 0; i < FormModelEvent.this.reordering.length; ++i) {
                    nArray[((FormModelEvent)FormModelEvent.this).reordering[i]] = i;
                }
                FormModelEvent.this.getContainer().reorderSubComponents(nArray);
                FormModelEvent.this.getFormModel().fireComponentsReordered(FormModelEvent.this.getContainer(), nArray);
            }
        }

        private void redoComponentsReorder() {
            if (FormModelEvent.this.getContainer() != null && FormModelEvent.this.reordering != null) {
                FormModelEvent.this.getContainer().reorderSubComponents(FormModelEvent.this.reordering);
                FormModelEvent.this.getFormModel().fireComponentsReordered(FormModelEvent.this.getContainer(), FormModelEvent.this.reordering);
            }
        }

        private void undoComponentPropertyChange() {
            Node.Property property = FormModelEvent.this.getComponent().getPropertyByName(FormModelEvent.this.getPropertyName());
            if (property != null) {
                try {
                    property.setValue(FormModelEvent.this.getOldPropertyValue());
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
                }
            }
        }

        private void redoComponentPropertyChange() {
            Node.Property property = FormModelEvent.this.getComponent().getPropertyByName(FormModelEvent.this.getPropertyName());
            if (property != null) {
                try {
                    property.setValue(FormModelEvent.this.getNewPropertyValue());
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
                }
            }
        }

        private void undoBindingPropertyChange() {
            String string = FormModelEvent.this.getSubPropertyName();
            BindingProperty bindingProperty = FormModelEvent.this.getComponent().getBindingProperty(FormModelEvent.this.getPropertyName());
            if (string == null) {
                if (bindingProperty != null) {
                    try {
                        bindingProperty.setValue(FormModelEvent.this.getOldBinding());
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
                    }
                }
            } else {
                FormProperty formProperty = bindingProperty.getSubProperty(string);
                try {
                    formProperty.setValue(FormModelEvent.this.getOldPropertyValue());
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
                }
            }
        }

        private void redoBindingPropertyChange() {
            String string = FormModelEvent.this.getSubPropertyName();
            BindingProperty bindingProperty = FormModelEvent.this.getComponent().getBindingProperty(FormModelEvent.this.getPropertyName());
            if (string == null) {
                if (bindingProperty != null) {
                    try {
                        bindingProperty.setValue(FormModelEvent.this.getNewBinding());
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
                    }
                }
            } else {
                FormProperty formProperty = bindingProperty.getSubProperty(string);
                try {
                    formProperty.setValue(FormModelEvent.this.getNewPropertyValue());
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
                }
            }
        }

        private void undoSyntheticPropertyChange() {
            block7: {
                Node.Property[] propertyArray;
                String string;
                block5: {
                    block6: {
                        string = FormModelEvent.this.getPropertyName();
                        if (!string.startsWith("$$$_")) break block5;
                        if (!string.startsWith("$$$_preCode_")) break block6;
                        FormProperty formProperty = (FormProperty)FormModelEvent.this.getComponent().getPropertyByName(string.substring("$$$_preCode_".length()));
                        formProperty.setPreCode((String)FormModelEvent.this.getOldPropertyValue());
                        break block7;
                    }
                    if (!string.startsWith("$$$_postCode_")) break block7;
                    FormProperty formProperty = (FormProperty)FormModelEvent.this.getComponent().getPropertyByName(string.substring("$$$_postCode_".length()));
                    formProperty.setPostCode((String)FormModelEvent.this.getOldPropertyValue());
                    break block7;
                }
                if (FormModelEvent.this.getComponent() == null) {
                    FormEditor formEditor = FormEditor.getFormEditor(FormModelEvent.this.getFormModel());
                    FormRootNode formRootNode = (FormRootNode)formEditor.getFormRootNode();
                    propertyArray = formRootNode.getAllProperties();
                } else {
                    propertyArray = FormModelEvent.this.getComponent().getSyntheticProperties();
                }
                for (int i = 0; i < propertyArray.length; ++i) {
                    if (!propertyArray[i].getName().equals(string)) continue;
                    try {
                        propertyArray[i].setValue(FormModelEvent.this.getOldPropertyValue());
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
                    }
                    break;
                }
            }
        }

        private void redoSyntheticPropertyChange() {
            block7: {
                Node.Property[] propertyArray;
                String string;
                block5: {
                    block6: {
                        string = FormModelEvent.this.getPropertyName();
                        if (!string.startsWith("$$$_")) break block5;
                        if (!string.startsWith("$$$_preCode_")) break block6;
                        FormProperty formProperty = (FormProperty)FormModelEvent.this.getComponent().getPropertyByName(string.substring("$$$_preCode_".length()));
                        formProperty.setPreCode((String)FormModelEvent.this.getNewPropertyValue());
                        break block7;
                    }
                    if (!string.startsWith("$$$_postCode_")) break block7;
                    FormProperty formProperty = (FormProperty)FormModelEvent.this.getComponent().getPropertyByName(string.substring("$$$_postCode_".length()));
                    formProperty.setPostCode((String)FormModelEvent.this.getNewPropertyValue());
                    break block7;
                }
                if (FormModelEvent.this.getComponent() == null) {
                    FormEditor formEditor = FormEditor.getFormEditor(FormModelEvent.this.getFormModel());
                    FormRootNode formRootNode = (FormRootNode)formEditor.getFormRootNode();
                    propertyArray = formRootNode.getAllProperties();
                } else {
                    propertyArray = FormModelEvent.this.getComponent().getSyntheticProperties();
                }
                for (int i = 0; i < propertyArray.length; ++i) {
                    if (!propertyArray[i].getName().equals(string)) continue;
                    try {
                        propertyArray[i].setValue(FormModelEvent.this.getNewPropertyValue());
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
                    }
                    break;
                }
            }
        }

        private void undoEventHandlerAddition() {
            Event event = FormModelEvent.this.getComponentEvent();
            if (event == null) {
                return;
            }
            FormModelEvent.addToInterestList(FormModelEvent.this);
            FormModelEvent.this.getFormModel().getFormEvents().detachEvent(event, FormModelEvent.this.getEventHandler());
            FormModelEvent.removeFromInterestList(FormModelEvent.this);
            Node.Property property = FormModelEvent.this.getComponent().getPropertyByName(event.getId());
            if (property != null) {
                try {
                    if (FormModelEvent.this.getEventHandler().equals(property.getValue())) {
                        property.setValue(null);
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
                }
            }
        }

        private void redoEventHandlerAddition() {
            Event event = FormModelEvent.this.getComponentEvent();
            if (event == null) {
                return;
            }
            FormModelEvent.this.getFormModel().getFormEvents().attachEvent(event, FormModelEvent.this.getEventHandler(), FormModelEvent.this.getOldEventHandlerContent(), FormModelEvent.this.getOldEventHandlerAnnotation());
            Node.Property property = FormModelEvent.this.getComponent().getPropertyByName(event.getId());
            if (property != null) {
                try {
                    property.setValue((Object)FormModelEvent.this.getEventHandler());
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
                }
            }
        }

        private void undoEventHandlerRemoval() {
            Event event = FormModelEvent.this.getComponentEvent();
            if (event == null) {
                return;
            }
            FormModelEvent.this.getFormModel().getFormEvents().attachEvent(event, FormModelEvent.this.getEventHandler(), FormModelEvent.this.getOldEventHandlerContent(), FormModelEvent.this.getOldEventHandlerAnnotation());
            Node.Property property = FormModelEvent.this.getComponent().getPropertyByName(event.getId());
            if (property != null) {
                try {
                    property.setValue((Object)FormModelEvent.this.getEventHandler());
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
                }
            }
        }

        private void redoEventHandlerRemoval() {
            Event event = FormModelEvent.this.getComponentEvent();
            if (event == null) {
                return;
            }
            FormModelEvent.addToInterestList(FormModelEvent.this);
            FormModelEvent.this.getFormModel().getFormEvents().detachEvent(event, FormModelEvent.this.getEventHandler());
            FormModelEvent.removeFromInterestList(FormModelEvent.this);
            Node.Property property = FormModelEvent.this.getComponent().getPropertyByName(event.getId());
            if (property != null) {
                try {
                    if (FormModelEvent.this.getEventHandler().equals(property.getValue())) {
                        property.setValue(null);
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
                }
            }
        }

        private void undoEventHandlerRenaming() {
            FormEvents formEvents = FormModelEvent.this.getFormModel().getFormEvents();
            formEvents.renameEventHandler(FormModelEvent.this.getNewEventHandler(), FormModelEvent.this.getOldEventHandler());
            Event[] eventArray = formEvents.getEventsForHandler(FormModelEvent.this.getOldEventHandler());
            for (int i = 0; i < eventArray.length; ++i) {
                Node.Property property = eventArray[i].getComponent().getPropertyByName(eventArray[i].getId());
                if (property == null) continue;
                try {
                    property.setValue((Object)FormModelEvent.this.getOldEventHandler());
                    continue;
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
                }
            }
        }

        private void redoEventHandlerRenaming() {
            FormEvents formEvents = FormModelEvent.this.getFormModel().getFormEvents();
            formEvents.renameEventHandler(FormModelEvent.this.getOldEventHandler(), FormModelEvent.this.getNewEventHandler());
            Event[] eventArray = formEvents.getEventsForHandler(FormModelEvent.this.getNewEventHandler());
            for (int i = 0; i < eventArray.length; ++i) {
                Node.Property property = eventArray[i].getComponent().getPropertyByName(eventArray[i].getId());
                if (property == null) continue;
                try {
                    property.setValue((Object)FormModelEvent.this.getNewEventHandler());
                    continue;
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
                }
            }
        }
    }
}

