/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x.visitor;

import org.hibernate.HibernateException;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.Set;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.tool.hbm2x.Cfg2JavaTool;
import org.hibernate.tool.hbm2x.visitor.DefaultValueVisitor;
import org.hibernate.type.CompositeCustomType;
import org.hibernate.type.CustomType;
import org.hibernate.type.Type;

public class JavaTypeFromValueVisitor
extends DefaultValueVisitor {
    private boolean preferRawTypeNames = true;

    public JavaTypeFromValueVisitor() {
        super(true);
    }

    public Object accept(Map o) {
        if (o.isSorted()) {
            return "java.util.SortedMap";
        }
        return super.accept(o);
    }

    public Object accept(Set o) {
        if (o.isSorted()) {
            return "java.util.SortedSet";
        }
        return super.accept(o);
    }

    public Object accept(Component value) {
        return value.getComponentClassName();
    }

    public Object accept(OneToOne o) {
        return this.acceptToOne((ToOne)o);
    }

    public Object accept(ManyToOne o) {
        return this.acceptToOne((ToOne)o);
    }

    private Object acceptToOne(ToOne value) {
        return value.getReferencedEntityName();
    }

    public Object accept(OneToMany value) {
        return value.getAssociatedClass().getClassName();
    }

    private String toName(Class c) {
        if (c.isArray()) {
            Class<?> a = c.getComponentType();
            return a.getName() + "[]";
        }
        return c.getName();
    }

    protected Object handle(Value o) {
        String val;
        String typename;
        Value value = o;
        try {
            Type type = value.getType();
            if (type instanceof CustomType || type instanceof CompositeCustomType) {
                return this.toName(type.getReturnedClass());
            }
        }
        catch (HibernateException he) {
            // empty catch block
        }
        if (this.preferRawTypeNames && value.isSimpleValue() && !Cfg2JavaTool.isNonPrimitiveTypeName(typename = ((SimpleValue)value).getTypeName()) && (val = ((SimpleValue)value).getTypeName()) != null) {
            return val;
        }
        return this.toName(value.getType().getReturnedClass());
    }
}

