/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.metadata.model.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObject;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObjectManager;

public class PersistentObjectList<T extends PersistentObject> {
    private static final Logger LOGGER = Logger.getLogger(PersistentObjectManager.class.getName());
    private final Map<ElementHandle<TypeElement>, List<T>> type2Objects = new HashMap<ElementHandle<TypeElement>, List<T>>();

    public void add(List<T> list) {
        for (PersistentObject persistentObject : list) {
            List<T> list2 = this.type2Objects.get(persistentObject.getTypeElementHandle());
            if (list2 == null) {
                list2 = new ArrayList<T>();
                this.type2Objects.put(persistentObject.getTypeElementHandle(), list2);
            }
            list2.add(persistentObject);
        }
    }

    public boolean put(ElementHandle<TypeElement> elementHandle, List<T> list) {
        ArrayList<PersistentObject> arrayList = new ArrayList<PersistentObject>();
        for (PersistentObject persistentObject : list) {
            ElementHandle<TypeElement> elementHandle2 = persistentObject.getTypeElementHandle();
            if (elementHandle2.equals(elementHandle)) {
                arrayList.add(persistentObject);
                continue;
            }
            LOGGER.log(Level.WARNING, "setObjects: ignoring object with incorrect ElementHandle {0} (expected {1})", new Object[]{elementHandle2, elementHandle});
        }
        if (arrayList.size() > 0) {
            this.type2Objects.put(elementHandle, arrayList);
            return true;
        }
        List<T> list2 = this.type2Objects.remove(elementHandle);
        return list2 != null;
    }

    public List<T> remove(ElementHandle<TypeElement> elementHandle) {
        return this.type2Objects.remove(elementHandle);
    }

    public void clear() {
        this.type2Objects.clear();
    }

    public List<T> get() {
        ArrayList<T> arrayList = new ArrayList<T>(this.type2Objects.size() * 2);
        for (List<T> list : this.type2Objects.values()) {
            arrayList.addAll(list);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List<T> get(ElementHandle<TypeElement> elementHandle) {
        List<T> list = this.type2Objects.get(elementHandle);
        return list != null ? Collections.unmodifiableList(list) : null;
    }
}

