/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.metadata.model.api.support.annotation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.JavaContextListener;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.ObjectProvider;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObject;
import org.netbeans.modules.j2ee.metadata.model.support.PersistentObjectList;
import org.openide.util.ChangeSupport;
import org.openide.util.RequestProcessor;

public class PersistentObjectManager<T extends PersistentObject>
implements JavaContextListener {
    private static final Logger LOGGER = Logger.getLogger(PersistentObjectManager.class.getName());
    private static final boolean NO_EVENTS = Boolean.getBoolean("netbeans.metadata.model.noevents");
    private final AnnotationModelHelper helper;
    private final ObjectProvider<T> provider;
    private final PersistentObjectList<T> objectList = new PersistentObjectList();
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final RequestProcessor rp = new RequestProcessor("PersistentObjectManager", 1);
    boolean initialized = false;
    boolean temporary = false;

    static <V extends PersistentObject> PersistentObjectManager<V> create(AnnotationModelHelper annotationModelHelper, ObjectProvider<V> objectProvider) {
        PersistentObjectManager<V> persistentObjectManager = new PersistentObjectManager<V>(annotationModelHelper, objectProvider);
        if (NO_EVENTS) {
            LOGGER.log(Level.FINE, "ignoring events");
        }
        annotationModelHelper.addJavaContextListener(persistentObjectManager);
        return persistentObjectManager;
    }

    private PersistentObjectManager(AnnotationModelHelper annotationModelHelper, ObjectProvider<T> objectProvider) {
        this.helper = annotationModelHelper;
        this.provider = objectProvider;
    }

    public Collection<T> getObjects() {
        this.ensureInitialized();
        List<T> list = this.objectList.get();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "getObjects returning {0} objects: {1}", new Object[]{list.size(), list});
        } else {
            LOGGER.log(Level.FINE, "getObjects returning {0} objects", list.size());
        }
        return list;
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            List<T> list;
            boolean bl = SourceUtils.isScanInProgress();
            this.temporary = NO_EVENTS | bl;
            if (this.temporary) {
                LOGGER.log(Level.FINE, "initalizing temporarily (scanInProgress: {0})", bl);
            } else {
                LOGGER.log(Level.FINE, "intializing");
            }
            try {
                list = this.provider.createInitialObjects();
            }
            catch (InterruptedException interruptedException) {
                LOGGER.log(Level.FINE, "initializing temporarily (createInitialObjects() throwed InterruptedException)");
                this.temporary = true;
                list = Collections.emptyList();
            }
            LOGGER.log(Level.FINE, "created initial objects {0}", list);
            this.objectList.add(list);
            this.initialized = true;
        }
    }

    private void deinitialize() {
        this.initialized = false;
        this.objectList.clear();
    }

    void typesAdded(Iterable<? extends ElementHandle<TypeElement>> iterable) {
        LOGGER.log(Level.FINE, "typesAdded: called with {0}", iterable);
        if (!this.initialized) {
            LOGGER.log(Level.FINE, "typesAdded: not initialized, firing change event");
            this.fireChange();
            return;
        }
        for (ElementHandle<TypeElement> elementHandle : iterable) {
            TypeElement typeElement = (TypeElement)elementHandle.resolve((CompilationInfo)this.helper.getCompilationController());
            if (typeElement == null) {
                LOGGER.log(Level.WARNING, "typesAdded: type {0} has dissapeared", elementHandle);
                continue;
            }
            List<T> list = this.provider.createObjects(typeElement);
            LOGGER.log(Level.FINE, "typesAdded: new objects {0}", list);
            if (!this.objectList.put(elementHandle, list)) continue;
            this.fireChange();
        }
    }

    void typesRemoved(Iterable<? extends ElementHandle<TypeElement>> iterable) {
        LOGGER.log(Level.FINE, "typesRemoved: called with {0}", iterable);
        if (!this.initialized) {
            LOGGER.log(Level.FINE, "typesRemoved: not initialized, firing change event");
            this.fireChange();
            return;
        }
        for (ElementHandle<TypeElement> elementHandle : iterable) {
            List<T> list = this.objectList.remove(elementHandle);
            if (list == null) continue;
            LOGGER.log(Level.FINE, "typesRemoved: removing objects {0}", list);
            this.fireChange();
        }
    }

    void typesChanged(Iterable<? extends ElementHandle<TypeElement>> iterable) {
        LOGGER.log(Level.FINE, "typesChanged: called with {0}", iterable);
        if (!this.initialized) {
            LOGGER.log(Level.FINE, "typesChanged: not initialized, firing change event");
            this.fireChange();
            return;
        }
        for (ElementHandle<TypeElement> elementHandle : iterable) {
            List<T> list;
            TypeElement typeElement;
            List<T> list2 = this.objectList.get(elementHandle);
            if (list2 != null) {
                typeElement = (TypeElement)elementHandle.resolve((CompilationInfo)this.helper.getCompilationController());
                if (typeElement == null) {
                    LOGGER.log(Level.WARNING, "typesChanged: type {0} has dissapeared", elementHandle);
                    continue;
                }
                list = new ArrayList<T>(list2);
                boolean bl = this.provider.modifyObjects(typeElement, list);
                if (bl) {
                    LOGGER.log(Level.FINE, "typesChanged: modified objects to {0}", list);
                    if (!this.objectList.put(elementHandle, list)) continue;
                    this.fireChange();
                    continue;
                }
                LOGGER.log(Level.FINE, "typesChanged: not modifying any objects");
                continue;
            }
            typeElement = (TypeElement)elementHandle.resolve((CompilationInfo)this.helper.getCompilationController());
            if (typeElement == null) {
                LOGGER.log(Level.WARNING, "typesChanged: type {0} has dissapeared", elementHandle);
                continue;
            }
            list = this.provider.createObjects(typeElement);
            LOGGER.log(Level.FINE, "typesChanged: new objects {0}", list);
            if (!this.objectList.put(elementHandle, list)) continue;
            this.fireChange();
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    private void fireChange() {
        LOGGER.log(Level.FINE, "firing change event");
        if (!this.changeSupport.hasListeners()) {
            return;
        }
        this.rp.post(new Runnable(){

            @Override
            public void run() {
                PersistentObjectManager.this.changeSupport.fireChange();
            }
        });
    }

    void rootsChanged() {
        LOGGER.log(Level.FINE, "rootsChanged called");
        this.deinitialize();
        this.fireChange();
    }

    @Override
    public void javaContextLeft() {
        if (this.initialized && this.temporary) {
            LOGGER.log(Level.FINE, "discarding temporary manager");
            this.deinitialize();
        }
    }
}

