/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.model;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class ImageUtils {
    private static final Component component = new Component(){};
    private static final GraphicsConfiguration gc;

    public static BufferedImage loadImage(URL uRL) throws IllegalArgumentException {
        try {
            BufferedImage bufferedImage = ImageIO.read(uRL);
            if (bufferedImage == null) {
                return null;
            }
            int n = bufferedImage.getColorModel().getTransparency();
            BufferedImage bufferedImage2 = gc.createCompatibleImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.dispose();
            return bufferedImage2;
        }
        catch (IOException iOException) {
            System.err.println("Load Image error for " + uRL + ":\n" + iOException);
            iOException.printStackTrace();
            return null;
        }
    }

    public static Image getScaledImage(Image image, int n, int n2) {
        Image image2 = image;
        if (n != 0 && n2 != 0) {
            float f = (float)n2 / (float)n;
            float f2 = (float)image.getHeight(null) / (float)image.getWidth(null);
            image2 = f > f2 ? image.getScaledInstance(n, -1, 20) : image.getScaledInstance(-1, n2, 20);
        }
        MediaTracker mediaTracker = new MediaTracker(component);
        mediaTracker.addImage(image2, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            mediaTracker.removeImage(image2, 0);
            interruptedException.printStackTrace();
        }
        mediaTracker.removeImage(image2, 0);
        return image2;
    }

    static {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        gc = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
    }
}

