/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.undo.CompoundEdit;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.util.GapList;
import org.netbeans.modules.editor.lib.EditorPackageAccessor;

public final class BeforeSaveTasks {
    private static final Logger LOG = Logger.getLogger(BeforeSaveTasks.class.getName());
    private final BaseDocument doc;
    private List<Task> tasks = new GapList(1);

    public static synchronized BeforeSaveTasks get(BaseDocument doc) {
        BeforeSaveTasks beforeSaveTasks = (BeforeSaveTasks)doc.getProperty(BeforeSaveTasks.class);
        if (beforeSaveTasks == null) {
            beforeSaveTasks = new BeforeSaveTasks(doc);
            doc.putProperty(BeforeSaveTasks.class, beforeSaveTasks);
        }
        return beforeSaveTasks;
    }

    private BeforeSaveTasks(BaseDocument doc) {
        this.doc = doc;
        Runnable beforeSaveRunnable = (Runnable)doc.getProperty("beforeSaveRunnable");
        if (beforeSaveRunnable != null) {
            throw new IllegalStateException("\"beforeSaveRunnable\" property of document " + doc + " is already occupied by " + beforeSaveRunnable);
        }
        beforeSaveRunnable = new Runnable(){

            @Override
            public void run() {
                BeforeSaveTasks.this.runTasks();
            }
        };
        doc.putProperty("beforeSaveRunnable", beforeSaveRunnable);
    }

    public synchronized void addTask(Task task) {
        if (task == null) {
            throw new IllegalArgumentException("task must not be null");
        }
        this.tasks.add(task);
    }

    public synchronized boolean removeTask(Runnable task) {
        return this.tasks.remove(task);
    }

    private void runTasks() {
        this.doc.runAtomicAsUser(new Runnable(){

            @Override
            public void run() {
                CompoundEdit atomicEdit = EditorPackageAccessor.get().BaseDocument_markAtomicEditsNonSignificant(BeforeSaveTasks.this.doc);
                try {
                    for (Task task : BeforeSaveTasks.this.tasks) {
                        task.run(atomicEdit);
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Exception thrown in before-save tasks", e);
                }
            }
        });
    }

    public static interface Task {
        public void run(CompoundEdit var1);
    }
}

