/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.export;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import javax.microedition.m2g.SVGImage;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.export.AnimationRasterizer;
import org.netbeans.modules.mobility.svgcore.export.ComponentGroup;
import org.netbeans.modules.mobility.svgcore.export.SVGRasterizerPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class SVGImageRasterizerPanel
extends SVGRasterizerPanel {
    private final ComponentGroup m_currentTime;
    private JSlider animationSlider;
    private ButtonGroup buttonGroup1;
    private JLabel compressionLabel;
    private JComboBox compressionLevelCombo;
    private JLabel compressionQualityLabel;
    private JSpinner compressionQualitySpinner;
    private JSpinner currentTimeSpinner;
    private JPanel exportPanel;
    private JComboBox formatComboBox;
    private JScrollPane imageHolder;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JCheckBox keepRatio;
    private JPanel optionsPanel;
    private JTextField previewFileText;
    private JTextField previewFormatText;
    private JTextField previewSizeText;
    private JCheckBox progressiveCheckBox;
    private JRadioButton radioExportAll;
    private JRadioButton radioExportCurrent;
    private JComboBox reductionCombo;
    private JLabel reductionLabel;
    private JPanel sizePanel;
    private JSpinner spinnerHeight;
    private JSpinner spinnerWidth;
    private JPanel timeLinePanel;
    private JCheckBox transparentCheckBox;

    public SVGImageRasterizerPanel(SVGDataObject dObj, String elementId) throws IOException, BadLocationException {
        super(dObj, elementId);
        this.initComponents();
        this.m_currentTime = this.createTimeGroup(this.currentTimeSpinner, this.animationSlider, true);
        this.createCompressionGroup(this.compressionLevelCombo, this.compressionQualitySpinner);
        this.radioExportAll.setEnabled(this.isInProject() && this.m_elementId == null);
        this.radioExportCurrent.setEnabled(this.isInProject());
        this.m_ratio = this.m_dim.getHeight() / this.m_dim.getWidth();
        this.spinnerHeight.setModel(new SpinnerNumberModel((int)this.m_dim.getHeight(), 1, 2048, 1));
        this.spinnerWidth.setModel(new SpinnerNumberModel((int)this.m_dim.getWidth(), 1, 2048, 1));
        this.spinnerWidth.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (SVGImageRasterizerPanel.this.keepRatio.isSelected()) {
                    SVGImageRasterizerPanel.this.spinnerHeight.setValue(new Integer((int)(((Integer)SVGImageRasterizerPanel.this.spinnerWidth.getValue()).doubleValue() * SVGImageRasterizerPanel.this.m_ratio)));
                }
                SVGImageRasterizerPanel.this.updateImage(SVGImageRasterizerPanel.this.spinnerWidth, true);
            }
        });
        this.updateImage(null, true);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.sizePanel = new JPanel();
        JLabel jLabel11 = new JLabel();
        this.spinnerWidth = new JSpinner();
        JLabel jLabel12 = new JLabel();
        this.spinnerHeight = new JSpinner();
        this.keepRatio = new JCheckBox();
        this.optionsPanel = new JPanel();
        JLabel jLabel2 = new JLabel();
        this.formatComboBox = new JComboBox();
        this.jPanel1 = new JPanel();
        this.progressiveCheckBox = new JCheckBox();
        this.compressionLabel = new JLabel();
        this.compressionLevelCombo = new JComboBox<AnimationRasterizer.CompressionLevel>(AnimationRasterizer.CompressionLevel.values());
        this.compressionQualityLabel = new JLabel();
        this.transparentCheckBox = new JCheckBox();
        this.compressionQualitySpinner = new JSpinner();
        this.reductionLabel = new JLabel();
        this.reductionCombo = new JComboBox<AnimationRasterizer.ColorReductionMethod>(AnimationRasterizer.ColorReductionMethod.values());
        this.timeLinePanel = new JPanel();
        this.currentTimeSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 30.0, 1.0));
        JLabel startTimeLabel = new JLabel();
        this.animationSlider = new JSlider();
        this.exportPanel = new JPanel();
        this.radioExportCurrent = new JRadioButton();
        this.radioExportAll = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.imageHolder = new JScrollPane();
        this.jPanel4 = new JPanel();
        JLabel previewFormatLabel = new JLabel();
        JLabel previewSizeLabel = new JLabel();
        JLabel previewFileLabel = new JLabel();
        this.previewFormatText = new JTextField();
        this.previewSizeText = new JTextField();
        this.previewFileText = new JTextField();
        this.sizePanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_ImageSize")));
        jLabel11.setLabelFor(this.spinnerWidth);
        Mnemonics.setLocalizedText((JLabel)jLabel11, (String)NbBundle.getBundle(SVGImageRasterizerPanel.class).getString("LBL_AnimationImageWidth"));
        jLabel11.setName("");
        jLabel12.setLabelFor(this.spinnerHeight);
        Mnemonics.setLocalizedText((JLabel)jLabel12, (String)NbBundle.getBundle(SVGImageRasterizerPanel.class).getString("LBL_AnimationImageHeight"));
        this.spinnerHeight.setEnabled(false);
        this.keepRatio.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.keepRatio, (String)NbBundle.getBundle(SVGImageRasterizerPanel.class).getString("LBL_AnimationKeepRatio"));
        this.keepRatio.setToolTipText("Images for other configurations are transformed using screen ratio.");
        this.keepRatio.setMargin(new Insets(0, 0, 0, 0));
        this.keepRatio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVGImageRasterizerPanel.this.keepRatioActionPerformed(evt);
            }
        });
        GroupLayout sizePanelLayout = new GroupLayout((Container)this.sizePanel);
        this.sizePanel.setLayout((LayoutManager)sizePanelLayout);
        sizePanelLayout.setHorizontalGroup((GroupLayout.Group)sizePanelLayout.createParallelGroup(1).add((GroupLayout.Group)sizePanelLayout.createSequentialGroup().add((GroupLayout.Group)sizePanelLayout.createParallelGroup(1).add((GroupLayout.Group)sizePanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)sizePanelLayout.createParallelGroup(1).add((Component)jLabel11).add((Component)jLabel12)).addPreferredGap(0).add((GroupLayout.Group)sizePanelLayout.createParallelGroup(1).add((Component)this.spinnerHeight, -2, 56, -2).add((Component)this.spinnerWidth, -2, 56, -2))).add((GroupLayout.Group)sizePanelLayout.createSequentialGroup().add(12, 12, 12).add((Component)this.keepRatio))).addContainerGap(131, Short.MAX_VALUE)));
        sizePanelLayout.setVerticalGroup((GroupLayout.Group)sizePanelLayout.createParallelGroup(1).add((GroupLayout.Group)sizePanelLayout.createSequentialGroup().add((GroupLayout.Group)sizePanelLayout.createParallelGroup(3).add((Component)jLabel11).add((Component)this.spinnerWidth, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)sizePanelLayout.createParallelGroup(3).add((Component)jLabel12).add((Component)this.spinnerHeight, -2, -1, -2)).addPreferredGap(0).add((Component)this.keepRatio)));
        jLabel11.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_sizePanel_name"));
        jLabel11.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_sizePanel_description"));
        this.spinnerWidth.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_jSpinner_name"));
        this.spinnerWidth.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_jSpinner_descriprion"));
        jLabel12.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_panelHeight_name"));
        jLabel12.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_panelHeight_description"));
        this.spinnerHeight.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_spinnerHeight_name"));
        this.spinnerHeight.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_spinnerHeight_description"));
        this.keepRatio.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_keepRation_name"));
        this.keepRatio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_keepRation_name"));
        this.optionsPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_ImageOptions")));
        jLabel2.setLabelFor(this.formatComboBox);
        Mnemonics.setLocalizedText((JLabel)jLabel2, (String)NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_OptionsFormat"));
        this.formatComboBox.setModel(SVGImageRasterizerPanel.createImageTypeComboBoxModel());
        this.formatComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVGImageRasterizerPanel.this.formatComboBoxActionPerformed(evt);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.progressiveCheckBox, (String)NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_OptionsProgressive"));
        this.progressiveCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.compressionLabel.setLabelFor(this.compressionLevelCombo);
        Mnemonics.setLocalizedText((JLabel)this.compressionLabel, (String)NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_OptionsQuality"));
        this.compressionQualityLabel.setLabelFor(this.compressionQualitySpinner);
        Mnemonics.setLocalizedText((JLabel)this.compressionQualityLabel, (String)NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_OptionsRate"));
        Mnemonics.setLocalizedText((AbstractButton)this.transparentCheckBox, (String)NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_OptionsTransparent"));
        this.transparentCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.transparentCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVGImageRasterizerPanel.this.transparencyChanged(evt);
            }
        });
        this.reductionLabel.setLabelFor(this.reductionCombo);
        Mnemonics.setLocalizedText((JLabel)this.reductionLabel, (String)NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_OptionsColorReduction"));
        this.reductionCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVGImageRasterizerPanel.this.colorReductionChanged(evt);
            }
        });
        GroupLayout optionsPanelLayout = new GroupLayout((Container)this.optionsPanel);
        this.optionsPanel.setLayout((LayoutManager)optionsPanelLayout);
        optionsPanelLayout.setHorizontalGroup((GroupLayout.Group)optionsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)optionsPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)optionsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)optionsPanelLayout.createSequentialGroup().add(245, 245, 245).add((Component)this.jPanel1, -1, 37, Short.MAX_VALUE)).add((GroupLayout.Group)optionsPanelLayout.createSequentialGroup().add((Component)this.transparentCheckBox).addContainerGap(145, Short.MAX_VALUE)).add((GroupLayout.Group)optionsPanelLayout.createSequentialGroup().add((Component)this.compressionLabel).addContainerGap(130, Short.MAX_VALUE)).add((GroupLayout.Group)optionsPanelLayout.createSequentialGroup().add((GroupLayout.Group)optionsPanelLayout.createParallelGroup(2, false).add(1, (Component)this.reductionCombo, 0, -1, Short.MAX_VALUE).add(1, (Component)this.reductionLabel, -1, -1, Short.MAX_VALUE)).addContainerGap(110, Short.MAX_VALUE)).add(2, (GroupLayout.Group)optionsPanelLayout.createSequentialGroup().add((GroupLayout.Group)optionsPanelLayout.createParallelGroup(2).add(1, (GroupLayout.Group)optionsPanelLayout.createSequentialGroup().add((Component)jLabel2).addPreferredGap(1).add((Component)this.formatComboBox, 0, 97, Short.MAX_VALUE)).add(1, (Component)this.progressiveCheckBox).add((GroupLayout.Group)optionsPanelLayout.createSequentialGroup().add((Component)this.compressionLevelCombo, -2, 93, -2).addPreferredGap(1).add((Component)this.compressionQualityLabel).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.compressionQualitySpinner, -2, 46, -2))).add(106, 106, 106)))));
        optionsPanelLayout.setVerticalGroup((GroupLayout.Group)optionsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)optionsPanelLayout.createSequentialGroup().add((GroupLayout.Group)optionsPanelLayout.createParallelGroup(3).add((Component)jLabel2).add((Component)this.formatComboBox, -2, -1, -2)).addPreferredGap(0).add((Component)this.progressiveCheckBox).addPreferredGap(0).add((Component)this.transparentCheckBox).add(14, 14, 14).add((GroupLayout.Group)optionsPanelLayout.createParallelGroup(1).add((Component)this.jPanel1, -2, -1, -2).add((Component)this.reductionLabel)).addPreferredGap(0, 27, Short.MAX_VALUE).add((Component)this.reductionCombo, -2, -1, -2).addPreferredGap(1).add((Component)this.compressionLabel).addPreferredGap(0).add((GroupLayout.Group)optionsPanelLayout.createParallelGroup(4).add((Component)this.compressionQualitySpinner, -2, 25, -2).add((Component)this.compressionLevelCombo, -2, 25, -2).add((Component)this.compressionQualityLabel)).addContainerGap()));
        jLabel2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_jLabel2_name"));
        jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_jLabel2_descritpion"));
        this.formatComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_formatComboBox_name"));
        this.formatComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_jLabel2_descritpion"));
        this.progressiveCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_progressiveCheckBox_name"));
        this.progressiveCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_progressiveCheckBox_description"));
        this.compressionLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_compressionLabel_name"));
        this.compressionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_compressionLabel_description"));
        this.compressionLevelCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_compressionLevelCombo_name"));
        this.compressionLevelCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_compressionLevelCombo_description"));
        this.compressionQualityLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_compressionQuailityLabel_name"));
        this.compressionQualityLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_compressionQuailityLabel_description"));
        this.transparentCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_transpartenCheckBox_name"));
        this.transparentCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_transpartenCheckBox_description"));
        this.compressionQualitySpinner.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_compressionQuailitySpinner_name"));
        this.compressionQualitySpinner.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_compressionQuailitySpinner_description"));
        this.reductionLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_reductionLabel_name"));
        this.reductionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_reductionLabel_descritpion"));
        this.reductionCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_reductionCombo_name"));
        this.reductionCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_reductionCombo_description"));
        this.timeLinePanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_AnimationFrameTime")));
        startTimeLabel.setLabelFor(this.currentTimeSpinner);
        Mnemonics.setLocalizedText((JLabel)startTimeLabel, (String)NbBundle.getBundle(SVGImageRasterizerPanel.class).getString("LBL_AnimationTime"));
        GroupLayout timeLinePanelLayout = new GroupLayout((Container)this.timeLinePanel);
        this.timeLinePanel.setLayout((LayoutManager)timeLinePanelLayout);
        timeLinePanelLayout.setHorizontalGroup((GroupLayout.Group)timeLinePanelLayout.createParallelGroup(1).add((GroupLayout.Group)timeLinePanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)timeLinePanelLayout.createParallelGroup(1).add((GroupLayout.Group)timeLinePanelLayout.createSequentialGroup().add((Component)startTimeLabel).addPreferredGap(0).add((Component)this.currentTimeSpinner, -2, 56, -2)).add((Component)this.animationSlider, -1, 216, Short.MAX_VALUE)).addContainerGap()));
        timeLinePanelLayout.setVerticalGroup((GroupLayout.Group)timeLinePanelLayout.createParallelGroup(1).add((GroupLayout.Group)timeLinePanelLayout.createSequentialGroup().add((GroupLayout.Group)timeLinePanelLayout.createParallelGroup(3).add((Component)startTimeLabel).add((Component)this.currentTimeSpinner, -2, -1, -2)).addPreferredGap(0).add((Component)this.animationSlider, -2, -1, -2)));
        this.currentTimeSpinner.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_currentTimeSpinner_name"));
        this.currentTimeSpinner.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_currentTimeSpinner_description"));
        startTimeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_startTimeLabel_name"));
        startTimeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_stopTimeLabel_description"));
        this.animationSlider.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_animationSlider_name"));
        this.animationSlider.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_animationSlider_description"));
        this.exportPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_ExportLabel")));
        this.buttonGroup1.add(this.radioExportCurrent);
        this.radioExportCurrent.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.radioExportCurrent, (String)NbBundle.getBundle(SVGImageRasterizerPanel.class).getString("LBL_AnimationOnlyActiveConfiguration"));
        this.radioExportCurrent.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroup1.add(this.radioExportAll);
        Mnemonics.setLocalizedText((AbstractButton)this.radioExportAll, (String)NbBundle.getBundle(SVGImageRasterizerPanel.class).getString("LBL_AnimationAllConfigurations"));
        this.radioExportAll.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout exportPanelLayout = new GroupLayout((Container)this.exportPanel);
        this.exportPanel.setLayout((LayoutManager)exportPanelLayout);
        exportPanelLayout.setHorizontalGroup((GroupLayout.Group)exportPanelLayout.createParallelGroup(1).add((GroupLayout.Group)exportPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)exportPanelLayout.createParallelGroup(1).add((Component)this.radioExportCurrent).add((Component)this.radioExportAll)).addContainerGap(69, Short.MAX_VALUE)));
        exportPanelLayout.setVerticalGroup((GroupLayout.Group)exportPanelLayout.createParallelGroup(1).add((GroupLayout.Group)exportPanelLayout.createSequentialGroup().add((Component)this.radioExportCurrent).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.radioExportAll)));
        this.radioExportCurrent.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_radioExportCurrent_name"));
        this.radioExportCurrent.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_radioExportCurrent_description"));
        this.radioExportAll.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_radioExportAll_name"));
        this.radioExportAll.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_radioExportAll_description"));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_PreviewTitle")));
        this.imageHolder.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel4.setBorder(BorderFactory.createEtchedBorder());
        previewFormatLabel.setLabelFor(this.previewFormatText);
        Mnemonics.setLocalizedText((JLabel)previewFormatLabel, (String)NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_PreviewFormat"));
        previewSizeLabel.setLabelFor(this.previewSizeText);
        Mnemonics.setLocalizedText((JLabel)previewSizeLabel, (String)NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_PreviewSize"));
        previewFileLabel.setLabelFor(this.previewFileText);
        Mnemonics.setLocalizedText((JLabel)previewFileLabel, (String)NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_PreviewFile"));
        this.previewFormatText.setEditable(false);
        this.previewFormatText.setText("JPEG");
        this.previewSizeText.setEditable(false);
        this.previewSizeText.setText("200 KBytes");
        this.previewFileText.setEditable(false);
        this.previewFileText.setText("C:\\Program Files\\about.svg");
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((Component)previewFormatLabel).add((Component)previewSizeLabel).add((Component)previewFileLabel)).addPreferredGap(1).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((Component)this.previewSizeText, -2, 82, -2).add((Component)this.previewFileText, -1, 285, Short.MAX_VALUE).add((Component)this.previewFormatText, -2, 64, -2)).addContainerGap()));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)previewFormatLabel).add((Component)this.previewFormatText, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)previewSizeLabel).add((Component)this.previewSizeText, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)previewFileLabel).add((Component)this.previewFileText, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        previewFormatLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_previewFormatlabel_name"));
        previewFormatLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_previewFormatlabel_description"));
        previewSizeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_previewSizelabel_name"));
        previewSizeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_previewSizelabel_description"));
        previewFileLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_previewFileLabel_name"));
        previewFileLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_previewFileLabel_description"));
        this.previewFormatText.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_previewFormatlabel_name"));
        this.previewFormatText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_previewFormatlabel_description"));
        this.previewSizeText.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_previewSizelabel_name"));
        this.previewSizeText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_previewSizelabel_description"));
        this.previewFileText.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_previewFileLabel_name"));
        this.previewFileText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_previewFileLabel_description"));
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(2, (Component)this.imageHolder, -1, 353, Short.MAX_VALUE).add(2, (Component)this.jPanel4, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.imageHolder, -1, 349, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel4, -2, -1, -2).addContainerGap()));
        this.jPanel4.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_jPanel4_name"));
        this.jPanel4.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_jPanel4_description"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.sizePanel, -1, -1, Short.MAX_VALUE).add((Component)this.timeLinePanel, -1, -1, Short.MAX_VALUE).add((Component)this.exportPanel, -1, -1, Short.MAX_VALUE).add((Component)this.optionsPanel, 0, 248, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.sizePanel, -2, -1, -2).addPreferredGap(0).add((Component)this.optionsPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.timeLinePanel, -2, -1, -2).addPreferredGap(0).add((Component)this.exportPanel, -2, -1, -2))).addContainerGap()));
        this.sizePanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_sizePanel_name"));
        this.sizePanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_sizePanel_description"));
        this.optionsPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_optionsPanel_name"));
        this.optionsPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_optionsPanel_description"));
        this.timeLinePanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_timeLinePanel_name"));
        this.timeLinePanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_timeLinePanel_description"));
        this.exportPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_exportPanel_name"));
        this.exportPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_exportPanel_description"));
        this.jPanel3.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_jPanel3_name"));
        this.jPanel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_jPanel3_description"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_jPanel_name"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_jPanel_description"));
    }

    private void colorReductionChanged(ActionEvent evt) {
        this.updateImage((JComponent)evt.getSource(), true);
    }

    private void transparencyChanged(ActionEvent evt) {
        this.updateImage((JComponent)evt.getSource(), true);
    }

    private void formatComboBoxActionPerformed(ActionEvent evt) {
        this.updateImage((JComponent)evt.getSource(), true);
    }

    private void keepRatioActionPerformed(ActionEvent evt) {
        this.spinnerHeight.setEnabled(!this.keepRatio.isSelected());
    }

    @Override
    public int getImageWidth() {
        return this.m_overrideWidth != -1 ? this.m_overrideWidth : (Integer)this.spinnerWidth.getValue();
    }

    @Override
    public int getImageHeight() {
        return this.m_overrideHeight != -1 ? this.m_overrideHeight : (Integer)this.spinnerHeight.getValue();
    }

    @Override
    public boolean isForAllConfigurations() {
        return this.radioExportAll.isSelected();
    }

    @Override
    public float getCompressionQuality() {
        int sliderValue = ((Number)this.compressionQualitySpinner.getValue()).intValue();
        return (float)sliderValue / 100.0f;
    }

    @Override
    public boolean isProgressive() {
        return this.progressiveCheckBox.isSelected();
    }

    @Override
    public boolean isTransparent() {
        return this.transparentCheckBox.isSelected();
    }

    @Override
    public AnimationRasterizer.ImageType getImageType() {
        return (AnimationRasterizer.ImageType)((Object)this.formatComboBox.getSelectedItem());
    }

    @Override
    public AnimationRasterizer.ColorReductionMethod getColorReductionMethod() {
        return (AnimationRasterizer.ColorReductionMethod)this.reductionCombo.getSelectedItem();
    }

    @Override
    public float getStartTime() {
        return this.m_currentTime.getValue();
    }

    @Override
    public int getNumberFrames() {
        return 1;
    }

    @Override
    public boolean isInSingleImage() {
        return true;
    }

    @Override
    protected String getPreviewFileName() {
        return this.previewFileText.getText();
    }

    @Override
    protected void updateImage(JComponent source, boolean isOutputChanged) {
        final JLabel label = new JLabel("Updating image...");
        label.setHorizontalAlignment(0);
        label.setVerticalAlignment(0);
        this.imageHolder.setViewportView(label);
        AnimationRasterizer.ImageType imgType = this.getImageType();
        boolean supportsCompression = imgType.supportsCompression();
        this.compressionQualitySpinner.setEnabled(supportsCompression);
        this.compressionLevelCombo.setEnabled(supportsCompression);
        this.compressionLabel.setEnabled(supportsCompression);
        this.compressionQualityLabel.setEnabled(supportsCompression);
        boolean needsColorReduction = imgType.needsColorReduction();
        this.reductionCombo.setEnabled(needsColorReduction);
        this.reductionLabel.setEnabled(needsColorReduction);
        if (imgType.supportsTransparency()) {
            this.transparentCheckBox.setEnabled(true);
        } else {
            this.transparentCheckBox.setEnabled(false);
            this.transparentCheckBox.setSelected(false);
        }
        String filenameRoot = AnimationRasterizer.createFileNameRoot(this.m_dObj, this, null, true);
        final String fileName = AnimationRasterizer.createFileName(filenameRoot, this, -1, -1);
        final float currentTime = this.m_currentTime.getValue();
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    SVGImage svgImage = SVGImageRasterizerPanel.this.getSVGImage();
                    if (svgImage != null) {
                        final AnimationRasterizer.PreviewInfo preview = AnimationRasterizer.previewFrame(svgImage, SVGImageRasterizerPanel.this, -1, currentTime);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                String sizeText = preview.m_imageSize < 1024 ? preview.m_imageSize + " Bytes" : (double)Math.round((double)preview.m_imageSize / 102.4) / 10.0 + " KBytes";
                                SVGImageRasterizerPanel.this.previewSizeText.setText(sizeText);
                                SVGImageRasterizerPanel.this.previewFormatText.setText(preview.m_imageFormat);
                                SVGImageRasterizerPanel.this.previewFileText.setText(fileName);
                                label.setText(null);
                                label.setIcon(new ImageIcon(preview.m_image));
                                label.invalidate();
                                SVGImageRasterizerPanel.this.imageHolder.validate();
                                SVGImageRasterizerPanel.this.imageHolder.repaint();
                            }
                        });
                    } else {
                        label.setText("Load of SVG image failed");
                        label.setIcon(null);
                        label.invalidate();
                        SVGImageRasterizerPanel.this.imageHolder.validate();
                        SVGImageRasterizerPanel.this.imageHolder.repaint();
                    }
                }
                catch (Exception ex) {
                    SceneManager.log(Level.INFO, ex.getMessage(), ex);
                }
            }
        });
    }
}

