/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.export;

import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.PerseusController;
import org.openide.util.actions.CookieAction;

public abstract class AbstractSaveAction
extends CookieAction {
    protected void resumeAnimatorState(SVGDataObject doj, int state, float time) {
        if (state == 2) {
            this.startAnimator(doj, time);
        } else if (state == 3) {
            this.pauseAnimation(doj, time);
        }
    }

    protected int getAnimatorState(SVGDataObject doj) {
        PerseusController pc = this.getPerseusController(doj);
        if (pc != null) {
            return pc.getAnimatorState();
        }
        return 1;
    }

    protected float stopAnimator(SVGDataObject doj) {
        float stoppedTime = 0.0f;
        PerseusController pc = this.getPerseusController(doj);
        if (pc != null) {
            stoppedTime = pc.getAnimatorTime();
            pc.stopAnimator();
        }
        return stoppedTime;
    }

    private void startAnimator(SVGDataObject doj, float time) {
        assert (doj != null);
        PerseusController pc = doj.getSceneManager().getPerseusController();
        if (pc != null) {
            pc.setAnimatorTime(time);
            pc.startAnimator();
        }
    }

    private void pauseAnimation(SVGDataObject doj, float time) {
        assert (doj != null);
        PerseusController pc = doj.getSceneManager().getPerseusController();
        if (pc != null) {
            pc.setAnimatorTime(time);
            pc.startAnimator();
            pc.pauseAnimator();
        }
    }

    private PerseusController getPerseusController(SVGDataObject doj) {
        assert (doj != null);
        return doj.getSceneManager().getPerseusController();
    }
}

