/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer.actions;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.microedition.m2g.SVGImage;
import javax.swing.Action;
import org.netbeans.modules.mobility.svgcore.composer.AbstractComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.AbstractComposerActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.ActionMouseCursor;
import org.netbeans.modules.mobility.svgcore.composer.ComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.PerseusController;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.SVGObjectOutline;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.view.svg.AbstractSVGAction;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatableElement;

public final class MoveFocusActionFactory
extends AbstractComposerActionFactory {
    private static final ActionMouseCursor ACTIVATE_MOUSE_CURSOR = new ActionMouseCursor(12, 3);
    private static final Color FOCUS_OUTLINE_COLOR = Color.GREEN;
    private final AbstractSVGAction m_focusNext = new AbstractSVGAction("svg_focus_next", false){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (++MoveFocusActionFactory.this.m_focusedIdIndex > MoveFocusActionFactory.this.m_focusTargets.size() - 1) {
                MoveFocusActionFactory.this.m_focusedIdIndex = 0;
            }
            MoveFocusActionFactory.this.focusElement();
        }
    };
    private final transient AbstractSVGAction m_focusPrevious = new AbstractSVGAction("svg_focus_previous", false){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (--MoveFocusActionFactory.this.m_focusedIdIndex < 0) {
                MoveFocusActionFactory.this.m_focusedIdIndex = MoveFocusActionFactory.this.m_focusTargets.size() - 1;
            }
            assert (MoveFocusActionFactory.this.m_focusedIdIndex >= 0);
            MoveFocusActionFactory.this.focusElement();
        }
    };
    private final transient AbstractSVGAction m_activateFocused = new AbstractSVGAction("svg_activate_focused", false){

        @Override
        public void actionPerformed(ActionEvent e) {
            SVGImage svgImg = MoveFocusActionFactory.this.m_sceneMgr.getSVGImage();
            if (svgImg != null) {
                svgImg.activate();
            }
        }
    };
    private final List<String> m_focusTargets = new ArrayList<String>();
    private int m_focusedIdIndex = -1;
    private ShowFocusAction m_showFocusAction = null;

    public MoveFocusActionFactory(SceneManager sceneMgr) {
        super(sceneMgr);
    }

    private void focusElement() {
        if (this.m_showFocusAction != null) {
            this.m_showFocusAction.actionCompleted();
            this.m_showFocusAction = null;
        }
        SVGObject obj = null;
        String id = this.m_focusTargets.get(this.m_focusedIdIndex);
        if (id != null) {
            obj = this.getPerseusController().getObjectById(id);
            assert (obj != null);
            this.m_showFocusAction = new ShowFocusAction(obj);
            this.m_sceneMgr.startAction(this.m_showFocusAction);
        }
        this.m_sceneMgr.getSVGImage().focusOn((SVGElement)(obj != null ? obj.getSVGElement() : null));
        this.m_sceneMgr.getScreenManager().repaint();
    }

    @Override
    public synchronized ComposerAction startAction(AWTEvent e, boolean isOutsideEvent) {
        int index;
        MouseEvent me;
        if (e.getID() == 2533) {
            ((PerseusController)e.getSource()).getFocusableTargets(this.m_focusTargets);
            this.m_focusedIdIndex = 0;
            this.setActionseEnabled(true);
        } else if (e.getID() == 2534) {
            this.m_focusTargets.clear();
            this.setActionseEnabled(false);
        } else if (e.getID() == 500 && (me = (MouseEvent)e).getButton() == 1 && me.getClickCount() == 1 && (index = this.getFocusTargetIdAt(me, isOutsideEvent)) != -1) {
            this.m_focusedIdIndex = index;
            this.focusElement();
            this.m_activateFocused.actionPerformed(null);
        }
        return null;
    }

    @Override
    public ActionMouseCursor getMouseCursor(MouseEvent me, boolean isOutsideEvent) {
        return me.getID() == 503 && this.getFocusTargetIdAt(me, isOutsideEvent) != -1 ? ACTIVATE_MOUSE_CURSOR : null;
    }

    private int getFocusTargetIdAt(MouseEvent me, boolean isOutsideEvent) {
        String id;
        SVGLocatableElement elem;
        if (!isOutsideEvent && this.m_sceneMgr.isReadOnly() && this.m_focusTargets.size() > 0 && (elem = this.m_sceneMgr.getPerseusController().findElementAt(me.getX(), me.getY())) != null && (id = elem.getId()) != null) {
            return this.m_focusTargets.indexOf(id);
        }
        return -1;
    }

    @Override
    public Action[] getMenuActions() {
        return new Action[]{this.m_focusNext, this.m_focusPrevious, this.m_activateFocused};
    }

    private void setActionseEnabled(boolean enabled) {
        this.m_activateFocused.setEnabled(enabled);
        this.m_focusNext.setEnabled(enabled);
        this.m_focusPrevious.setEnabled(enabled);
    }

    private final class ShowFocusAction
    extends AbstractComposerAction {
        private final SVGObject m_focused;

        public ShowFocusAction(SVGObject focused) {
            super(MoveFocusActionFactory.this);
            this.m_focused = focused;
        }

        @Override
        public void paint(Graphics g, int x, int y, boolean isReadOnly) {
            if (isReadOnly && !this.m_isCompleted) {
                SVGObjectOutline outline = this.m_focused.getOutline();
                outline.draw(g, x, y, FOCUS_OUTLINE_COLOR, false);
                outline.setDirty();
            }
        }

        @Override
        public void actionCompleted() {
            this.m_focused.repaint(5);
            super.actionCompleted();
        }
    }
}

