/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer;

import com.sun.perseus.j2d.Transform;
import java.awt.Rectangle;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.mobility.svgcore.composer.PerseusController;
import org.netbeans.modules.mobility.svgcore.composer.SVGObjectOutline;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.composer.ScreenManager;
import org.netbeans.modules.mobility.svgcore.composer.prototypes.PatchedTransformableElement;
import org.netbeans.modules.mobility.svgcore.model.SVGFileModel;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatableElement;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGRect;

public final class SVGObject {
    private final SceneManager m_sceneMgr;
    private final SVGLocatableElement m_elem;
    private Transform m_initialTransform;
    private SVGObjectOutline m_outline = null;
    private boolean m_isDeleted = false;
    private float m_translateDx = 0.0f;
    private float m_translateDy = 0.0f;
    private float m_skewX = 0.0f;
    private float m_skewY = 0.0f;
    private float m_scaleX = 1.0f;
    private float m_scaleY = 1.0f;
    private float m_rotate = 0.0f;
    private ScalePivotPoint m_scalePivot = null;
    private boolean m_lanscapeUpdate = false;

    public SVGObject(SceneManager sceneMgr, SVGLocatableElement elem) {
        assert (sceneMgr != null);
        assert (elem != null);
        this.m_sceneMgr = sceneMgr;
        this.m_elem = elem;
        this.m_initialTransform = new Transform(this.m_elem instanceof PatchedTransformableElement ? ((PatchedTransformableElement)this.m_elem).getTransform() : null);
        SceneManager.log(Level.FINE, "SVGObject created: " + this.m_elem);
    }

    public SceneManager getSceneManager() {
        return this.m_sceneMgr;
    }

    public ScreenManager getScreenManager() {
        return this.m_sceneMgr.getScreenManager();
    }

    public SVGLocatableElement getSVGElement() {
        return this.m_elem;
    }

    public String getElementId() {
        String id = this.m_elem.getId();
        assert (id != null) : "Null ID of SVGElement " + this.m_elem;
        return id;
    }

    public SVGRect getSafeBBox() {
        return PerseusController.getSafeBBox(this.m_elem);
    }

    public Rectangle getScreenBBox() {
        return this.getOutline().getScreenBoundingBox();
    }

    public boolean isDeleted() {
        return this.m_isDeleted;
    }

    public void repaint() {
        this.repaint(0);
    }

    public void repaint(int x, int y, int w, int h) {
        this.m_sceneMgr.getScreenManager().repaint(x, y, w, h);
    }

    public void repaint(int overlap) {
        if (!this.m_isDeleted) {
            Rectangle rect = this.getScreenBBox();
            assert (rect != null);
            this.m_sceneMgr.getScreenManager().repaint(rect, overlap);
        }
    }

    public synchronized SVGObjectOutline getOutline() {
        if (this.m_outline == null) {
            this.m_outline = new SVGObjectOutline(this);
        }
        return this.m_outline;
    }

    public SVGMatrix getParentTransformation() {
        return PerseusController.getParentTransformation(this.m_elem.getParentNode());
    }

    public void translate(final float dx, final float dy, final boolean isRelative) {
        this.m_sceneMgr.getPerseusController().execute(new Runnable(){

            @Override
            public void run() {
                float _dx = dx;
                float _dy = dy;
                try {
                    Transform txf = (Transform)SVGObject.this.getParentTransformation();
                    if (txf != null) {
                        txf = (Transform)txf.inverse();
                        float[] point = new float[2];
                        txf.transformPoint(new float[]{dx, dy}, point);
                        _dx = point[0] - txf.getComponent(4);
                        _dy = point[1] - txf.getComponent(5);
                    }
                    if (isRelative) {
                        SVGObject.this.m_translateDx += _dx;
                        SVGObject.this.m_translateDy += _dy;
                    } else {
                        SVGObject.this.m_translateDx = _dx;
                        SVGObject.this.m_translateDy = _dy;
                    }
                    SVGObject.this.applyUserTransform();
                }
                catch (Exception ex) {
                    SceneManager.error("Translate operation failed!", ex);
                }
            }
        });
    }

    public void scale(final float scaleX, final float scaleY, final ScalePivotPoint scalePivot) {
        this.m_sceneMgr.getPerseusController().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    SVGObject.this.m_scaleX = scaleX;
                    SVGObject.this.m_scaleY = scaleY;
                    SVGObject.this.m_scalePivot = scalePivot;
                    SVGObject.this.applyUserTransform();
                }
                catch (Exception ex) {
                    SceneManager.error("Scale operation failed!", ex);
                }
            }
        });
    }

    public void setLandscape(int rotateAngle, float[] translate) {
        this.m_lanscapeUpdate = true;
        this.rotate(rotateAngle);
        this.translate(translate[0], translate[1], true);
    }

    public void rotate(final float rotate) {
        this.m_sceneMgr.getPerseusController().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    SVGObject.this.m_rotate = rotate;
                    SVGObject.this.applyUserTransform();
                }
                catch (Exception ex) {
                    SceneManager.error("Rotate operation failed!", ex);
                }
            }
        });
    }

    public void skew(final float skewX, final float skewY) {
        this.m_sceneMgr.getPerseusController().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    SVGObject.this.m_skewX = skewX;
                    SVGObject.this.m_skewY = skewY;
                    SVGObject.this.applyUserTransform();
                }
                catch (Exception ex) {
                    SceneManager.error("Skew operation failed!", ex);
                }
            }
        });
    }

    public void moveToTop() {
        String id = this.getElementId();
        this.getPerseusController().moveToTop(this.m_elem);
        this.getFileModel().moveToTop(id);
        this.repaint();
    }

    public void moveToBottom() {
        String id = this.getElementId();
        this.getPerseusController().moveToBottom(this.m_elem);
        this.getFileModel().moveToBottom(id);
        this.repaint();
    }

    public void moveForward() {
        String id = this.getElementId();
        this.getPerseusController().moveForward(this.m_elem);
        this.getFileModel().moveForward(id);
        this.repaint();
    }

    public void moveBackward() {
        String id = this.getElementId();
        this.getPerseusController().moveBackward(this.m_elem);
        this.getFileModel().moveBackward(id);
        this.repaint();
    }

    public void delete() {
        if (!this.m_isDeleted) {
            String id = this.getElementId();
            this.getFileModel().deleteElement(id, new SVGFileModel.TransactionCommand(){

                @Override
                public Object execute(Object userData) {
                    SVGObject.this.repaint(5);
                    SVGObject.this.m_isDeleted = true;
                    PerseusController pc = SVGObject.this.getPerseusController();
                    for (String id : (List)userData) {
                        SVGElement elem = pc.getElementById(id);
                        SVGObject.this.getPerseusController().delete(elem);
                    }
                    return null;
                }
            });
        } else {
            SceneManager.log(Level.SEVERE, "SVGObject is already deleted.");
        }
    }

    public void applyTextChanges() {
        SVGFileModel model = this.m_sceneMgr.getDataObject().getModel();
        String[] changedAttrs = this.prepareTextChanges();
        if (changedAttrs != null) {
            model.setAttributes(this.getElementId(), changedAttrs);
        }
    }

    public String[] prepareTextChanges() {
        PatchedTransformableElement pte;
        String[] changedAttrs = null;
        if (this.m_elem != null && this.m_elem instanceof PatchedTransformableElement && (changedAttrs = (pte = (PatchedTransformableElement)this.m_elem).optimizeTransform()) == null) {
            String transform = SVGObject.getTransformAsText((SVGMatrix)pte.getTransform());
            changedAttrs = new String[]{"transform", transform};
        }
        return changedAttrs;
    }

    public void commitChanges() {
        this.applyUserTransform(true);
        this.m_translateDx = 0.0f;
        this.m_translateDy = 0.0f;
        this.m_skewX = 0.0f;
        this.m_skewY = 0.0f;
        this.m_scaleX = 1.0f;
        this.m_scaleY = 1.0f;
        this.m_scalePivot = null;
        this.m_rotate = 0.0f;
        this.m_lanscapeUpdate = false;
        this.repaint(5);
    }

    public float[] getCurrentTranslate() {
        return new float[]{this.getCurrentTranslateX(), this.getCurrentTranslateY()};
    }

    public float getCurrentTranslateX() {
        return this.m_translateDx;
    }

    public float getCurrentTranslateY() {
        return this.m_translateDy;
    }

    public float getCurrentScaleX() {
        return this.m_scaleX;
    }

    public float getCurrentScaleY() {
        return this.m_scaleY;
    }

    public ScalePivotPoint getCurrentScalePivot() {
        return this.m_scalePivot != null ? this.m_scalePivot : ScalePivotPoint.NW_CORNER;
    }

    public float getCurrentRotate() {
        return this.m_rotate % 360.0f;
    }

    public float getCurrentSkewX() {
        return this.m_skewX;
    }

    public float getCurrentSkewY() {
        return this.m_skewY;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SVGObject( tag=");
        sb.append(this.m_elem.getLocalName());
        sb.append(" id=");
        sb.append(this.m_elem.getId());
        sb.append(" isDeleted=");
        sb.append(this.m_isDeleted);
        sb.append(" translateX=");
        sb.append(this.m_translateDx);
        sb.append(" translateY=");
        sb.append(this.m_translateDy);
        sb.append(" skewX=");
        sb.append(this.m_skewX);
        sb.append(" skewY=");
        sb.append(this.m_skewY);
        sb.append(" scaleX=");
        sb.append(this.m_scaleX);
        sb.append(" scaleY=");
        sb.append(this.m_scaleY);
        sb.append(" scalePivot=");
        sb.append((Object)this.m_scalePivot);
        sb.append(" rotate=");
        sb.append(this.m_rotate);
        sb.append(" lanscapeUpdate=");
        sb.append(this.m_lanscapeUpdate);
        sb.append(")");
        return sb.toString();
    }

    protected void applyUserTransform() {
        this.applyUserTransform(false);
    }

    protected void applyUserTransform(boolean commit) {
        if (this.m_elem instanceof PatchedTransformableElement) {
            this.getScreenManager().incrementChangeTicker();
            PatchedTransformableElement pe = (PatchedTransformableElement)this.m_elem;
            SVGRect rect = PerseusController.getSafeBBox(this.m_elem);
            if (rect != null) {
                Transform skewTxf;
                float[] rotatePivot = this.prepareRotatePivot(rect);
                float[] scalePivot = this.prepareScalePivot(rect);
                Transform txf = new Transform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                txf.mTranslate(this.getCurrentTranslateX() + rotatePivot[0], this.getCurrentTranslateY() + rotatePivot[1]);
                float skew = this.getCurrentSkewX();
                if (skew != 0.0f && skew > -90.0f && skew < 90.0f) {
                    skewTxf = new Transform(1.0f, 0.0f, (float)Math.tan(Math.toRadians(skew)), 1.0f, 0.0f, 0.0f);
                    txf.mMultiply((SVGMatrix)skewTxf);
                }
                if ((skew = this.getCurrentSkewY()) != 0.0f && skew > -90.0f && skew < 90.0f) {
                    skewTxf = new Transform(1.0f, (float)Math.tan(Math.toRadians(skew)), 0.0f, 1.0f, 0.0f, 0.0f);
                    txf.mMultiply((SVGMatrix)skewTxf);
                }
                txf.mRotate(this.getCurrentRotate());
                txf.mTranslate(-rotatePivot[0], -rotatePivot[1]);
                txf.mTranslate(scalePivot[0], scalePivot[1]);
                txf.mScale(this.getCurrentScaleX(), this.getCurrentScaleY());
                txf.mTranslate(-scalePivot[0], -scalePivot[1]);
                txf.mMultiply((SVGMatrix)this.m_initialTransform);
                pe.setTransform(txf);
                if (commit) {
                    this.m_initialTransform = txf;
                }
            } else {
                SceneManager.log(Level.SEVERE, "Null BBox for " + pe);
            }
        }
    }

    private float[] prepareRotatePivot(SVGRect rect) {
        if (!this.m_lanscapeUpdate) {
            float[] tempRotatePivot = new float[]{rect.getX() + rect.getWidth() / 2.0f, rect.getY() + rect.getHeight() / 2.0f};
            float[] rotatePivot = new float[2];
            this.m_initialTransform.transformPoint(tempRotatePivot, rotatePivot);
            return rotatePivot;
        }
        return new float[]{0.0f, 0.0f};
    }

    private float[] prepareScalePivot(SVGRect rect) {
        float[] fArray;
        if (this.getCurrentScalePivot().isNWCorner()) {
            float[] fArray2 = new float[2];
            fArray2[0] = rect.getX();
            fArray = fArray2;
            fArray2[1] = rect.getY();
        } else {
            float[] fArray3 = new float[2];
            fArray3[0] = rect.getX() + rect.getWidth();
            fArray = fArray3;
            fArray3[1] = rect.getY() + rect.getHeight();
        }
        float[] tempScalePivot = fArray;
        float[] scalePivot = new float[2];
        this.m_initialTransform.transformPoint(tempScalePivot, scalePivot);
        return scalePivot;
    }

    protected final PerseusController getPerseusController() {
        return this.m_sceneMgr.getPerseusController();
    }

    protected final SVGFileModel getFileModel() {
        return this.m_sceneMgr.getDataObject().getModel();
    }

    public static boolean areSame(SVGObject[] arr1, SVGObject[] arr2) {
        if (arr1 == arr2) {
            return true;
        }
        if (arr1 == null || arr2 == null) {
            return false;
        }
        if (arr1.length != arr2.length) {
            return false;
        }
        for (int i = 0; i < arr1.length; ++i) {
            if (arr1[i] == arr2[i]) continue;
            return false;
        }
        return true;
    }

    public static String getTransformAsText(SVGMatrix tfm) {
        StringBuilder sb = new StringBuilder();
        if (tfm != null) {
            if (PerseusController.isIdentityTransform(tfm, true)) {
                sb.append("translate(");
                sb.append(tfm.getComponent(4));
                sb.append(',');
                sb.append(tfm.getComponent(5));
                sb.append(")");
            } else {
                sb.append("matrix(");
                for (int i = 0; i < 5; ++i) {
                    sb.append(tfm.getComponent(i));
                    sb.append(',');
                }
                sb.append(tfm.getComponent(5));
                sb.append(")");
            }
        }
        return sb.toString();
    }

    public static enum ScalePivotPoint {
        NW_CORNER,
        SE_CORNER;


        public boolean isSECorner() {
            switch (this) {
                case SE_CORNER: {
                    return true;
                }
            }
            return false;
        }

        public boolean isNWCorner() {
            switch (this) {
                case NW_CORNER: {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            switch (this) {
                case NW_CORNER: {
                    return "NW_CORNER";
                }
                case SE_CORNER: {
                    return "SE_CORNER";
                }
            }
            return "Unsupported";
        }
    }
}

