/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.platform.semc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.JPanel;
import org.netbeans.modules.j2me.cdc.platform.CDCDevice;
import org.netbeans.modules.j2me.cdc.platform.CDCPlatform;
import org.netbeans.modules.j2me.cdc.platform.semc.SDKConfigPanel;
import org.netbeans.modules.j2me.cdc.platform.spi.CDCPlatformConfigurator;
import org.netbeans.modules.j2me.cdc.platform.spi.CDCPlatformDetector;
import org.netbeans.modules.j2me.cdc.platform.spi.CDCPlatformUtil;
import org.netbeans.modules.j2me.cdc.platform.spi.StreamReader;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class SEMCPlatformDetector
extends CDCPlatformDetector {
    public String getPlatformName() {
        return "Sony Ericsson CDC Platform 1";
    }

    public String getPlatformType() {
        return "semc";
    }

    public boolean accept(FileObject dir) {
        FileObject tool = CDCPlatformUtil.findTool((String)"epoc32/release/winscw/udeb", (String)"epoc", Collections.singleton(dir));
        return tool != null;
    }

    public CDCPlatform detectPlatform(FileObject dir) throws IOException {
        Process process;
        String[] command;
        assert (dir != null);
        FileObject java = CDCPlatformUtil.findTool((String)"epoc32/tools", (String)"epoc", Collections.singleton(dir));
        if (java == null) {
            throw new IOException("epoc.bat can not be found in desired location!");
        }
        File javaFile = FileUtil.toFile((FileObject)java);
        if (javaFile == null) {
            throw new IOException("epoc.bat can not be found in desired location!");
        }
        String javapath = javaFile.getAbsolutePath();
        FileObject bin = dir.getFileObject("epoc32/tools");
        StringBuffer sb = new StringBuffer();
        ArrayList<String> env = new ArrayList<String>();
        String absPath = FileUtil.toFile((FileObject)dir).getAbsolutePath();
        env.add("SDKDRIVE=" + String.valueOf(absPath.charAt(0)));
        env.add("EPOCROOT=" + absPath.substring(2) + "\\");
        env.add("Path=" + absPath + "\\epoc32\\gcc\\bin;" + absPath + "\\epoc32\\tools;" + absPath + "\\epoc32\\include;" + System.getProperty("java.library.path"));
        File path = FileUtil.toFile((FileObject)bin);
        try {
            command = new String[]{"perl", "-version"};
            process = Runtime.getRuntime().exec(command, env != null ? env.toArray(new String[0]) : null, path);
            StringBuffer sou = new StringBuffer();
            StreamReader ior = new StreamReader(process.getInputStream(), sou);
            StringBuffer err = new StringBuffer();
            StreamReader irr = new StreamReader(process.getErrorStream(), err);
            ior.join();
            irr.join();
            process.waitFor();
            process.getOutputStream().close();
            process.getInputStream().close();
            int exitValue = process.exitValue();
            if (exitValue != 0) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SEMCPlatformDetector.class, (String)"ERR_NoPerl"), 0));
            }
        }
        catch (InterruptedException ex) {
            IOException e = new IOException(NbBundle.getMessage(SEMCPlatformDetector.class, (String)"ERR_NoPerl"));
            ErrorManager.getDefault().annotate((Throwable)e, (Throwable)ex);
            throw e;
        }
        catch (IOException ioEx) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SEMCPlatformDetector.class, (String)"ERR_NoPerl"), 0));
            throw ioEx;
        }
        try {
            command = new String[]{javapath, "-version"};
            process = Runtime.getRuntime().exec(command, env != null ? env.toArray(new String[0]) : null, path);
            StreamReader ior = new StreamReader(process.getInputStream(), sb);
            StringBuffer err = new StringBuffer();
            StreamReader irr = new StreamReader(process.getErrorStream(), err);
            ior.join();
            irr.join();
            process.waitFor();
            process.getOutputStream().close();
            int exitValue = process.exitValue();
            System.out.println(err);
            if (exitValue != 0) {
                throw new IOException();
            }
            FileObject libBin = dir.getFileObject("epoc32/release/winscw/udeb/Z/Resource/ive/lib");
            StringBuffer bcp = new StringBuffer();
            Enumeration children = libBin.getChildren(true);
            while (children.hasMoreElements()) {
                FileObject elem = (FileObject)children.nextElement();
                String ext = elem.getExt();
                if (!"jar".equalsIgnoreCase(ext) && !"zip".equalsIgnoreCase(ext)) continue;
                bcp.append(FileUtil.toFile((FileObject)elem).getAbsolutePath());
                if (!children.hasMoreElements()) continue;
                bcp.append(';');
            }
            CDCDevice.CDCProfile profile = new CDCDevice.CDCProfile("PP-1.0", "Sony Ericsson CDC-1.0 PP-1.0", "1.0", null, bcp.toString(), null, true);
            CDCDevice device = new CDCDevice();
            device.setProfiles(new CDCDevice.CDCProfile[]{profile});
            return new CDCPlatform("SEMC " + sb.toString(), "SEMC " + sb.toString(), "semc", "1.2", Collections.singletonList(dir.getURL()), Collections.EMPTY_LIST, Collections.EMPTY_LIST, new CDCDevice[]{device}, true);
        }
        catch (InterruptedException ex) {
            IOException e = new IOException();
            ErrorManager.getDefault().annotate((Throwable)e, (Throwable)ex);
            throw e;
        }
    }

    public int getVersion() {
        return 1;
    }

    public CDCPlatformConfigurator getConfigurator(final FileObject installedFolder) {
        assert (installedFolder != null);
        return new CDCPlatformConfigurator(){

            public boolean isConfigured() {
                return installedFolder != null && CDCPlatformUtil.findTool((String)"epoc32/tools/ppro-custom-launcher", (String)"custom-app", Collections.singleton(installedFolder)) != null;
            }

            public JPanel getConfigurationTools() {
                return new SDKConfigPanel(installedFolder);
            }

            public String getInfo() {
                if (installedFolder != null && CDCPlatformUtil.findTool((String)"epoc32/tools/ppro-custom-launcher", (String)"custom-app", Collections.singleton(installedFolder)) == null) {
                    return NbBundle.getMessage(SEMCPlatformDetector.class, (String)"ERR_MissingTools");
                }
                return "";
            }
        };
    }
}

