/*
 * Decompiled with CFR 0.152.
 */
package org.joni.encoding.specific;

import org.joni.CodeRangeBuffer;
import org.joni.IntHolder;
import org.joni.encoding.MultiByteEncoding;
import org.joni.encoding.specific.ASCIIEncoding;
import org.joni.exception.InternalException;
import org.joni.util.BytesHash;

public final class SJISEncoding
extends MultiByteEncoding {
    static final boolean[] SJIS_CAN_BE_TRAIL_TABLE = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false};
    private static final int[] CR_Hiragana = new int[]{1, 33439, 33521};
    private static final int[] CR_Katakana = new int[]{4, 166, 175, 177, 221, 33600, 33662, 33664, 33686};
    private static final int[][] PropertyList = new int[][]{CR_Hiragana, CR_Katakana};
    private static final BytesHash<Integer> CTypeNameHash = new BytesHash();
    static final int[] SjisEncLen;
    public static final SJISEncoding INSTANCE;

    protected SJISEncoding() {
        super(SjisEncLen, ASCIIEncoding.AsciiCtypeTable);
    }

    public String toString() {
        return "Shift_JIS";
    }

    public int maxLength() {
        return 2;
    }

    public int minLength() {
        return 1;
    }

    public boolean isFixedWidth() {
        return false;
    }

    public int mbcToCode(byte[] bytes, int p, int end) {
        return this.mbnMbcToCode(bytes, p, end);
    }

    public int codeToMbcLength(int code) {
        if (code < 256) {
            return SjisEncLen[code] == 1 ? 1 : 0;
        }
        if (code <= 65535) {
            return 2;
        }
        throw new InternalException("invalid code point value");
    }

    public int codeToMbc(int code, byte[] bytes, int p) {
        int p_ = p;
        if ((code & 0xFF00) != 0) {
            bytes[p_++] = (byte)(code >> 8 & 0xFF);
        }
        bytes[p_++] = (byte)(code & 0xFF);
        return p_ - p;
    }

    public int mbcCaseFold(int flag, byte[] bytes, IntHolder pp, int end, byte[] lower) {
        return this.mbnMbcCaseFold(flag, bytes, pp, end, lower);
    }

    private static boolean isSjisMbFirst(int b) {
        return SjisEncLen[b] > 1;
    }

    private static boolean isSjisMbTrail(int b) {
        return SJIS_CAN_BE_TRAIL_TABLE[b];
    }

    public int leftAdjustCharHead(byte[] bytes, int p, int end) {
        int len;
        if (end <= p) {
            return end;
        }
        int p_ = end;
        if (SJISEncoding.isSjisMbTrail(bytes[p_] & 0xFF)) {
            while (p_ > p) {
                if (SJISEncoding.isSjisMbFirst(bytes[--p_] & 0xFF)) continue;
                ++p_;
                break;
            }
        }
        if (p_ + (len = this.length(bytes[p_])) > end) {
            return p_;
        }
        return (p_ += len) + (end - p_ & 0xFFFFFFFE);
    }

    public boolean isReverseMatchAllowed(byte[] bytes, int p, int end) {
        int c = bytes[p] & 0xFF;
        return SJISEncoding.isSjisMbTrail(c);
    }

    public int propertyNameToCType(byte[] bytes, int p, int end) {
        Integer ctype = CTypeNameHash.get(bytes, p, end);
        if (ctype == null) {
            return super.propertyNameToCType(bytes, p, end);
        }
        return ctype;
    }

    public boolean isCodeCType(int code, int ctype) {
        if (ctype <= 14) {
            if (code < 128) {
                return this.isCodeCTypeInternal(code, ctype);
            }
            if (SJISEncoding.isWordGraphPrint(ctype)) {
                return this.codeToMbcLength(code) > 1;
            }
        } else {
            if ((ctype -= 15) >= PropertyList.length) {
                throw new InternalException("undefined type (bug)");
            }
            return CodeRangeBuffer.isInCodeRange(PropertyList[ctype], code);
        }
        return false;
    }

    public int[] ctypeCodeRange(int ctype, IntHolder sbOut) {
        if (ctype <= 14) {
            return null;
        }
        sbOut.value = 128;
        if ((ctype -= 15) >= PropertyList.length) {
            throw new InternalException("undefined type (bug)");
        }
        return PropertyList[ctype];
    }

    static {
        CTypeNameHash.put("Hiragana".getBytes(), 15);
        CTypeNameHash.put("Katakana".getBytes(), 16);
        SjisEncLen = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1};
        INSTANCE = new SJISEncoding();
    }
}

