/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import javax.swing.table.DefaultTableModel;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.table.ResultSetJXTable;
import org.netbeans.modules.db.dataview.util.DBReadWriteHelper;
import org.netbeans.modules.db.dataview.util.DataViewUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class ResultSetTableModel
extends DefaultTableModel {
    private Class[] collumnClasses;
    protected ResultSetJXTable table;

    public static Class getTypeClass(DBColumn col) {
        int colType = col.getJdbcType();
        if (colType == -7 && col.getPrecision() <= 1) {
            colType = 16;
        }
        switch (colType) {
            case 16: {
                return Boolean.class;
            }
            case 92: {
                return Time.class;
            }
            case 91: {
                return Date.class;
            }
            case -100: 
            case 93: {
                return Timestamp.class;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return Number.class;
            }
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
        }
        return Object.class;
    }

    public ResultSetTableModel(ResultSetJXTable table) {
        this.table = table;
        this.collumnClasses = new Class[table.getRSColumnCount()];
        int I = table.getRSColumnCount();
        for (int i = 0; i < I; ++i) {
            this.collumnClasses[i] = ResultSetTableModel.getTypeClass(table.getDBColumn(i));
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (this.table.dView.getDataViewDBTable() == null) {
            return;
        }
        Object oldVal = this.getValueAt(row, col);
        if (this.noUpdateRequired(oldVal, value)) {
            return;
        }
        try {
            if (!DataViewUtils.isSQLConstantString(value)) {
                value = DBReadWriteHelper.validate(value, this.table.getDBColumn(col));
            }
            super.setValueAt(value, row, col);
            this.handleColumnUpdated(row, col, value);
            this.fireTableDataChanged();
        }
        catch (Exception dbe) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)dbe.getMessage(), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
        this.table.revalidate();
        this.table.repaint();
    }

    public Class getColumnClass(int columnIndex) {
        if (this.collumnClasses[columnIndex] == null) {
            return super.getColumnClass(columnIndex);
        }
        return this.collumnClasses[columnIndex];
    }

    protected boolean noUpdateRequired(Object oldVal, Object value) {
        return oldVal != null && oldVal.toString().equals(value == null ? "" : value.toString()) || oldVal == null && value == null;
    }

    protected void handleColumnUpdated(int row, int col, Object value) {
    }
}

