/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.spi.model.services.CsmExpressionEvaluatorProvider;
import org.openide.util.Lookup;

public class CsmExpressionEvaluator {
    private static final CsmExpressionEvaluatorProvider EMPTY_PROVIDER = new EmptyExpressionEvaluator();
    private static CsmExpressionEvaluatorProvider defaultProvider;

    private CsmExpressionEvaluator() {
    }

    private static synchronized CsmExpressionEvaluatorProvider getProvider() {
        if (defaultProvider != null) {
            return defaultProvider;
        }
        defaultProvider = (CsmExpressionEvaluatorProvider)Lookup.getDefault().lookup(CsmExpressionEvaluatorProvider.class);
        return defaultProvider == null ? EMPTY_PROVIDER : defaultProvider;
    }

    public static Object eval(String expr) {
        return CsmExpressionEvaluator.getProvider().eval(expr);
    }

    public static Object eval(String expr, CsmInstantiation inst) {
        return CsmExpressionEvaluator.getProvider().eval(expr, inst);
    }

    public static Object eval(String expr, CsmOffsetableDeclaration decl, Map<CsmTemplateParameter, CsmSpecializationParameter> mapping) {
        return CsmExpressionEvaluator.getProvider().eval(expr, decl, mapping);
    }

    private static final class EmptyExpressionEvaluator
    implements CsmExpressionEvaluatorProvider {
        EmptyExpressionEvaluator() {
        }

        @Override
        public Object eval(String expr) {
            return expr;
        }

        @Override
        public Object eval(String expr, CsmInstantiation inst) {
            return expr;
        }

        @Override
        public Object eval(String expr, CsmOffsetableDeclaration decl, Map<CsmTemplateParameter, CsmSpecializationParameter> mapping) {
            return expr;
        }
    }
}

