/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.options;

import java.beans.PropertyChangeListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.groovy.support.options.TabbedPanelModel;
import org.netbeans.spi.options.AdvancedOption;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class Model
extends TabbedPanelModel {
    private Map<String, AdvancedOption> categoryToOption = new HashMap<String, AdvancedOption>();
    private Map<String, JComponent> categoryToPanel = new HashMap<String, JComponent>();
    private Map<String, OptionsPanelController> categoryToController = new HashMap<String, OptionsPanelController>();
    private Lookup masterLookup;
    private LookupListener lkpListener;
    private Lookup.Result<AdvancedOption> lkpResult;
    private boolean initialized = false;

    public Model(LookupListener listener) {
        this.lkpListener = listener;
    }

    @Override
    public List getCategories() {
        this.init();
        ArrayList<String> l = new ArrayList<String>(this.categoryToOption.keySet());
        Collections.sort(l, Collator.getInstance());
        return l;
    }

    @Override
    public String getToolTip(String category) {
        AdvancedOption option = this.categoryToOption.get(category);
        return option.getTooltip();
    }

    @Override
    public JComponent getPanel(String category) {
        this.init();
        JComponent panel = this.categoryToPanel.get(category);
        if (panel != null) {
            return panel;
        }
        AdvancedOption option = this.categoryToOption.get(category);
        DelegatingController controller = new DelegatingController(option.create());
        this.categoryToController.put(category, controller);
        panel = controller.getComponent(this.masterLookup);
        this.categoryToPanel.put(category, panel);
        Border b = panel.getBorder();
        b = b != null ? new CompoundBorder(new EmptyBorder(6, 16, 6, 6), b) : new EmptyBorder(6, 16, 6, 6);
        panel.setBorder(b);
        panel.setMaximumSize(panel.getPreferredSize());
        return panel;
    }

    void update(String category) {
        OptionsPanelController controller = this.categoryToController.get(category);
        if (controller != null) {
            controller.update();
        }
    }

    void applyChanges() {
        Iterator<OptionsPanelController> it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            it.next().applyChanges();
        }
    }

    void cancel() {
        Iterator<OptionsPanelController> it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            it.next().cancel();
        }
    }

    boolean isValid() {
        Iterator<OptionsPanelController> it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            if (it.next().isValid()) continue;
            return false;
        }
        return true;
    }

    boolean isChanged() {
        Iterator<OptionsPanelController> it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            if (!it.next().isChanged()) continue;
            return true;
        }
        return false;
    }

    Lookup getLookup() {
        ArrayList<Lookup> lookups = new ArrayList<Lookup>();
        Iterator<OptionsPanelController> it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            lookups.add(it.next().getLookup());
        }
        return new ProxyLookup(lookups.toArray(new Lookup[lookups.size()]));
    }

    HelpCtx getHelpCtx(JComponent panel) {
        for (String category : this.categoryToPanel.keySet()) {
            OptionsPanelController controller;
            if (panel != null && panel != this.categoryToPanel.get(category) || (controller = this.categoryToController.get(category)) == null) continue;
            return controller.getHelpCtx();
        }
        return new HelpCtx("netbeans.optionsDialog.advanced");
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        Lookup lookup = Lookups.forPath((String)"OptionsDialog/Groovy");
        this.lkpResult = lookup.lookup(new Lookup.Template(AdvancedOption.class));
        this.lkpResult.addLookupListener(this.lkpListener);
        this.lkpListener = null;
        for (AdvancedOption option : this.lkpResult.allInstances()) {
            this.categoryToOption.put(option.getDisplayName(), option);
        }
    }

    void setLoookup(Lookup masterLookup) {
        this.masterLookup = masterLookup;
    }

    private static final class DelegatingController
    extends OptionsPanelController {
        private OptionsPanelController delegate;
        private boolean isUpdated;

        private DelegatingController(OptionsPanelController delegate) {
            this.delegate = delegate;
        }

        public void update() {
            if (!this.isUpdated) {
                this.isUpdated = true;
                this.delegate.update();
            }
        }

        public void applyChanges() {
            this.isUpdated = false;
            this.delegate.applyChanges();
        }

        public void cancel() {
            this.isUpdated = false;
            this.delegate.cancel();
        }

        public boolean isValid() {
            return this.delegate.isValid();
        }

        public boolean isChanged() {
            return this.delegate.isChanged();
        }

        public JComponent getComponent(Lookup masterLookup) {
            return this.delegate.getComponent(masterLookup);
        }

        public HelpCtx getHelpCtx() {
            return this.delegate.getHelpCtx();
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.delegate.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.delegate.removePropertyChangeListener(l);
        }
    }
}

