/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.expr;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.Value;
import com.sun.source.tree.Tree;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.modules.debugger.jpda.jdi.ArrayReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ValueWrapper;
import org.openide.util.NbBundle;

public class EvaluationException
extends RuntimeException {
    private Tree node;
    private String reason;
    private Object[] params;
    private String message;

    public EvaluationException(Tree node, String reason, Object[] params) {
        this.node = node;
        this.reason = reason;
        this.params = params;
    }

    @Override
    public String getMessage() {
        try {
            return this.getMessageImpl();
        }
        catch (Exception e) {
            this.message = this.formatMessage("CTL_EvalError_unknownInternalError", new String[]{e.getMessage()});
            return this.message;
        }
    }

    public String getMessageImpl() {
        if (this.message != null) {
            return this.message;
        }
        String[] msgParams = null;
        try {
            if (this.reason.equals("internalError")) {
                msgParams = new String[]{null};
            } else if (this.reason.equals("invalidArrayInitializer")) {
                msgParams = new String[]{this.params[0] == null ? null : this.params[0].toString()};
            } else if (this.reason.equals("arraySizeBadType")) {
                msgParams = new String[]{this.params[0] == null ? null : this.params[0].toString()};
            } else if (this.reason.equals("notArrayType")) {
                msgParams = new String[]{this.params[0] == null ? null : this.params[0].toString()};
            } else if (this.reason.equals("arrayCreateError")) {
                msgParams = new String[]{this.params[0] == null ? null : this.params[0].toString()};
            } else if (this.reason.equals("instantiateInterface")) {
                msgParams = new String[]{this.params[0] == null ? null : this.params[0].toString()};
            } else if (this.reason.equals("castToBooleanRequired")) {
                msgParams = new String[]{this.params[0].toString()};
            } else if (this.reason.equals("castFromBooleanRequired")) {
                msgParams = new String[]{this.params[0].toString()};
            } else if (this.reason.equals("castError")) {
                msgParams = new String[]{this.params[0].toString(), this.params[1].toString()};
            } else if (this.reason.equals("badOperandForPostfixOperator")) {
                msgParams = new String[]{this.params[0].toString()};
            } else if (this.reason.equals("postfixOperatorEvaluationError")) {
                msgParams = new String[]{this.params[1].toString()};
            } else if (this.reason.equals("badOperandForPrefixOperator")) {
                msgParams = new String[]{this.params[0].toString()};
            } else if (this.reason.equals("prefixOperatorEvaluationError")) {
                msgParams = new String[]{this.params[1].toString()};
            } else if (this.reason.equals("badOperandForUnaryOperator")) {
                msgParams = new String[]{this.params[0].toString()};
            } else if (this.reason.equals("unaryOperatorEvaluationError")) {
                msgParams = new String[]{this.params[1].toString()};
            } else if (this.reason.equals("unknownType")) {
                msgParams = new String[]{this.params[0].toString()};
            } else if (this.reason.equals("internalErrorResolvingType")) {
                msgParams = new String[]{this.params[0].toString()};
            } else if (this.reason.equals("instanceOfLeftOperandNotAReference")) {
                msgParams = new String[]{TypeWrapper.name(ValueWrapper.type((Value)this.params[0]))};
            } else if (this.reason.equals("conditionalOrAndBooleanOperandRequired")) {
                msgParams = new String[]{TypeWrapper.name(ValueWrapper.type((Value)this.params[0]))};
            } else if (this.reason.equals("conditionalQuestionMarkBooleanOperandRequired")) {
                msgParams = new String[]{TypeWrapper.name(ValueWrapper.type((Value)this.params[0]))};
            } else if (this.reason.equals("thisObjectUnavailable")) {
                msgParams = null;
            } else if (this.reason.equals("objectReferenceRequiredOnDereference")) {
                msgParams = new String[]{TypeWrapper.name(ValueWrapper.type((Value)this.params[0]))};
            } else if (this.reason.equals("badArgument")) {
                msgParams = new String[]{this.params[0].toString()};
            } else if (this.reason.equals("argumentsBadSyntax")) {
                msgParams = new String[]{this.params[0].toString()};
            } else if (this.reason.equals("ambigousMethod")) {
                msgParams = new String[]{this.params[0].toString(), this.params[1].toString()};
            } else if (this.reason.equals("noSuchMethod")) {
                msgParams = new String[]{(String)this.params[0], (String)this.params[1]};
            } else if (this.reason.equals("noSuchMethodWithArgs")) {
                msgParams = new String[]{(String)this.params[0], (String)this.params[1], (String)this.params[2]};
            } else if (this.reason.equals("noSuchConstructorWithArgs")) {
                msgParams = new String[]{(String)this.params[0], (String)this.params[1]};
            } else if (this.reason.equals("callException")) {
                msgParams = new String[]{this.params[1].toString(), this.params[0].toString()};
            } else if (this.reason.equals("calleeException")) {
                msgParams = new String[]{null, null, ((Exception)this.params[0]).getLocalizedMessage()};
            } else if (this.reason.equals("identifierNotAReference")) {
                msgParams = new String[]{TypeWrapper.name(ValueWrapper.type((Value)this.params[0]))};
            } else if (this.reason.equals("notarray")) {
                msgParams = new String[]{this.params[0].toString()};
            } else if (this.reason.equals("arrayIndexNAN")) {
                msgParams = new String[]{this.params[1].toString()};
            } else if (this.reason.equals("arrayIndexOutOfBounds")) {
                msgParams = new String[]{this.params[1].toString(), Integer.toString(ArrayReferenceWrapper.length0((ArrayReference)this.params[0]) - 1)};
            } else if (this.reason.equals("unknownVariable")) {
                msgParams = new String[]{this.params[0].toString()};
            } else if (this.reason.equals("integerLiteralTooBig")) {
                msgParams = new String[]{this.params[0].toString()};
            } else if (this.reason.equals("badFormatOfIntegerLiteral")) {
                msgParams = new String[]{this.params[0].toString()};
            } else if (this.reason.equals("unknownLiteralType")) {
                msgParams = new String[]{this.params[0].toString()};
            } else if (this.reason.equals("evaluateError")) {
                msgParams = new String[]{this.params[1].toString(), this.params[0].toString(), this.params[2].toString()};
            } else if (this.reason.equals("evaluateErrorUnary")) {
                msgParams = new String[]{this.params[0].toString(), this.params[1].toString()};
            } else if (this.reason.equals("notEnclosingType")) {
                msgParams = new String[]{this.params[0].toString()};
            } else if (this.reason.equals("accessInstanceVariableFromStaticContext")) {
                msgParams = new String[]{this.params[0].toString()};
            } else if (this.reason.equals("invokeInstanceMethodAsStatic")) {
                msgParams = new String[]{this.params[0].toString()};
            } else if (this.reason.equals("methodCallOnNull")) {
                msgParams = new String[]{this.params[0].toString()};
            } else if (this.reason.equals("fieldOnNull")) {
                msgParams = new String[]{this.params[0].toString()};
            } else if (this.reason.equals("cannotApplyOperator")) {
                msgParams = new String[]{this.params[0].toString()};
            } else if (this.reason.equals("invalidMemberReference")) {
                msgParams = new String[]{this.params[0].toString()};
            } else if (this.reason.equals("arrayIsNull")) {
                msgParams = new String[]{this.params[0].toString()};
            } else if (this.reason.equals("unsupported")) {
                msgParams = new String[]{this.node.toString()};
            } else if (this.reason.equals("errorneous")) {
                msgParams = new String[]{this.node.toString()};
            } else if (this.reason.equals("unknownField")) {
                msgParams = new String[]{this.params[0].toString()};
            } else if (this.reason.equals("unknownOuterClass")) {
                msgParams = new String[]{this.params[0].toString()};
            } else if (this.reason.equals("notExpression")) {
                msgParams = new String[]{};
            } else if (this.reason.equals("methOnArray")) {
                msgParams = new String[]{};
            } else if (this.reason.equals("forEachNotApplicable")) {
                msgParams = new String[]{};
            } else if (this.reason.equals("localVariableAlreadyDefined")) {
                msgParams = new String[]{this.params[0].toString()};
            } else if (this.reason.equals("unsupportedStringCreation")) {
                msgParams = new String[]{};
            } else if (this.reason.equals("canNotInvokeMethods")) {
                msgParams = new String[]{};
            } else if (this.reason.equals("notABoolean")) {
                msgParams = new String[]{this.params[0].toString(), this.params[1].toString(), this.params[2].toString()};
            } else if (this.reason.equals("noNewClassWithBody")) {
                msgParams = new String[]{};
            } else {
                msgParams = new String[]{this.reason};
                this.reason = "unknownInternalError";
            }
        }
        catch (InternalExceptionWrapper e) {
            msgParams = new String[]{e.getLocalizedMessage()};
            this.reason = "unknownInternalError";
        }
        catch (VMDisconnectedExceptionWrapper e) {
            msgParams = new String[]{e.getLocalizedMessage()};
        }
        catch (ObjectCollectedExceptionWrapper e) {
            msgParams = new String[]{e.getLocalizedMessage()};
        }
        this.message = this.formatMessage("CTL_EvalError_" + this.reason, msgParams);
        return this.message;
    }

    private String formatMessage(String msg, String[] params) {
        ResourceBundle bundle = NbBundle.getBundle(EvaluationException.class);
        msg = bundle.getString(msg);
        return MessageFormat.format(msg, params);
    }
}

