/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.core.ui.top;

import java.awt.BorderLayout;
import java.awt.Color;
import java.io.Serializable;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.netbeans.modules.cnd.asm.core.dataobjects.AsmDataObject;
import org.netbeans.modules.cnd.asm.core.dataobjects.AsmObjectUtilities;
import org.netbeans.modules.cnd.asm.core.ui.top.RegisterUsagesPanel;
import org.netbeans.modules.cnd.asm.model.AsmModel;
import org.openide.ErrorManager;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class NavigatorTopComponent
extends TopComponent
implements LookupListener {
    private static NavigatorTopComponent instance;
    static final String ICON_PATH = "org/netbeans/modules/cnd/asm/core/resources/asm_icon.png";
    private static final String PREFERRED_ID = "NavigatorTopComponent";
    private final RegisterUsagesPanel regUsagePanel;
    private final JLabel notAvailLbl = new JLabel(NbBundle.getMessage(NavigatorTopComponent.class, (String)"MSG_NotAvailable"));
    private Lookup.Result<AsmDataObject> lookupResult;

    private NavigatorTopComponent() {
        this.initComponents();
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.setName(NbBundle.getMessage(NavigatorTopComponent.class, (String)"CTL_NavigatorTopComponent"));
        this.regUsagePanel = RegisterUsagesPanel.getInstance();
        this.notAvailLbl.setHorizontalAlignment(0);
        this.notAvailLbl.setEnabled(false);
        Color usualWindowBkg = UIManager.getColor("window");
        this.notAvailLbl.setBackground(usualWindowBkg != null ? usualWindowBkg : Color.white);
        this.notAvailLbl.setOpaque(true);
        this.showPanel(false);
    }

    private void showPanel(boolean show) {
        if (show) {
            this.remove(this.notAvailLbl);
            this.add(this.regUsagePanel, "Center");
        } else {
            if (this.notAvailLbl.isShowing()) {
                return;
            }
            this.remove(this.regUsagePanel);
            this.add(this.notAvailLbl, "Center");
        }
        this.revalidate();
        this.repaint();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static synchronized NavigatorTopComponent getDefault() {
        if (instance == null) {
            instance = new NavigatorTopComponent();
        }
        return instance;
    }

    public static synchronized NavigatorTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            ErrorManager.getDefault().log(16, "Cannot find Navigator component. It will not be located properly in the window system.");
            return NavigatorTopComponent.getDefault();
        }
        if (win instanceof NavigatorTopComponent) {
            return (NavigatorTopComponent)win;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'NavigatorTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return NavigatorTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    protected void componentClosed() {
        super.componentClosed();
        this.regUsagePanel.closed();
    }

    protected void componentOpened() {
        super.componentOpened();
        this.regUsagePanel.opened();
    }

    public void componentShowing() {
        this.lookupResult = Utilities.actionsGlobalContext().lookup(new Lookup.Template(AsmDataObject.class));
        this.lookupResult.addLookupListener((LookupListener)this);
        this.resultChanged(null);
    }

    public void componentHidden() {
        this.lookupResult.removeLookupListener((LookupListener)this);
        this.showPanel(false);
        this.lookupResult = null;
        this.setActivatedNodes(new Node[0]);
    }

    public void resultChanged(LookupEvent lookupEvent) {
        DataObject dob;
        Collection objs = this.lookupResult.allInstances();
        DataObject dataObject = dob = objs.isEmpty() ? null : (DataObject)objs.iterator().next();
        if (dob == null) {
            this.setActivatedNodes(new Node[0]);
            this.showPanel(false);
            return;
        }
        this.setActivatedNodes(new Node[]{dob.getNodeDelegate()});
        AsmModel model = AsmObjectUtilities.getModel(dob);
        if (model != null) {
            this.addPanelsForModel(dob);
        }
    }

    private void addPanelsForModel(DataObject dob) {
        this.showPanel(true);
        this.regUsagePanel.setDocument(dob);
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    public String preferredID() {
        return PREFERRED_ID;
    }

    static class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return NavigatorTopComponent.getDefault();
        }
    }
}

